/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;

public class RequisicaoPorOrcamento
extends FrmGraficoPadrao
implements ConsultarGraficoListener {
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"contagem", "realizados", "solicitados"});

    public RequisicaoPorOrcamento() {
        this.montaBarraDescricao("Or\u00e7amentos solicitados", "Gr\u00e1fico de or\u00e7amentos solicitados e realizados", "consultas/orcamento_solicitado.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(RequisicaoPorOrcamento.getModuloConfigurar());
        this.setModuloAcesso(RequisicaoPorOrcamento.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void consultarGrafico() {
        int total = 0;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        try {
            String[] usuario;
            StringBuilder buf = new StringBuilder();
            buf.append(" select count(a.orc_codigo) as contagem  ");
            buf.append("   from orcamento a ");
            buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append("  and cast(a.orc_datahora as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append("  and cast(a.orc_datahora as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                buf.append(" and a.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    buf.append("'");
                    buf.append(usuario[i]);
                    buf.append("'");
                    if (i >= usuario.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            StringBuilder buf2 = new StringBuilder();
            buf2.append(" select count(distinct(a.orc_codigo)) as contagem  ");
            buf2.append("   from orcamento a join requisicao b on a.fil_codigo = b.fil_codigo and a.orc_codigo = b.orc_codigo ");
            buf2.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf2.append("    and b.orc_codigo is not null ");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf2.append("  and cast(a.orc_datahora as date) >= '");
                buf2.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf2.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf2.append("  and cast(a.orc_datahora as date) <= '");
                buf2.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf2.append("'");
            }
            if (usuario != null) {
                buf2.append(" and a.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    buf2.append("'");
                    buf2.append(usuario[i]);
                    buf2.append("'");
                    if (i >= usuario.length - 1) continue;
                    buf2.append(", ");
                }
                buf2.append(")");
            }
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                boolean qtdeTotal = false;
                if (rs.next()) {
                    do {
                        total += rs.getInt("contagem");
                    } while (rs.next());
                    int outros = 0;
                    ResultSet rr = Conexao.executeQuery(st2, buf2.toString());
                    if (rr.next()) {
                        outros = rr.getInt(1);
                    }
                    DefaultPieDataset pie = new DefaultPieDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    rs.first();
                    pie.setValue((Comparable)((Object)"Realizados"), (double)outros);
                    pie.setValue((Comparable)((Object)"Solicitados"), (double)(total - outros));
                    Object[] o = new Object[campos.length];
                    buf2.setLength(0);
                    buf2.append("select ").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf2.append(" from filiais_postocoleta filial ");
                    buf2.append("left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo ");
                    buf2.append("left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    buf2.append(" where filial.fil_codigo = ").append(Variaveis.filialPadrao);
                    rr = Conexao.executeQuery(st2, buf2.toString());
                    if (rr.next()) {
                        for (int i = 0; i < campos.length; ++i) {
                            try {
                                if (rr.findColumn(campos[i]) <= -1) continue;
                                o[modelo.findColumn((String)RequisicaoPorOrcamento.campos[i])] = rr.getObject(campos[i]);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    o[modelo.findColumn((String)"contagem")] = total;
                    o[modelo.findColumn((String)"realizados")] = outros;
                    o[modelo.findColumn((String)"solicitados")] = total - outros;
                    modelo.addLine(o);
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    NumberFormat nfp = NumberFormat.getPercentInstance();
                    nfp.setMinimumFractionDigits(0);
                    nfp.setMaximumFractionDigits(2);
                    PiePlot plot = new PiePlot((PieDataset)pie);
                    StandardPieItemLabelGenerator labels = new StandardPieItemLabelGenerator("{0}: ({1}) {2}", nf, nfp);
                    plot.setLabelGenerator((PieSectionLabelGenerator)labels);
                    plot.setLabelFont(this.getFonteLegenda());
                    JFreeChart chart = new JFreeChart("Or\u00e7amentos solicitados", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                    TextTitle subtitulo = new TextTitle("Total de or\u00e7amentos: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    if (usuario != null && usuario.length > 0) {
                        var.put("filtroUsuario", usuario);
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    }
                    Paint bgColor = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    chart.setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RequisicaoPorOrcamento.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RequisicaoPorOrcamento.this.panelCentro.removeAll();
                                RequisicaoPorOrcamento.this.panelCentro.repaint();
                                RequisicaoPorOrcamento.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoPorOrcamento");
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoPorOrcamento");
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700502100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700502101");
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }
}

