/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;

public class RequisicaoPorDia
extends FrmGraficoPadrao
implements ConsultarGraficoListener {
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    private final String FILTRO_REALIZADOS = "filtroRealizados";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"contagem", "Data"});

    public RequisicaoPorDia() {
        this.adicionaConsultaListener(this);
        this.montaBarraDescricao("Requisi\u00e7\u00f5es por Dia", "Gr\u00e1fico de requisi\u00e7\u00f5es adicionadas por dia", "consultas/cons_grafico_req_dia.jpg");
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Destino"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Coleta"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", "", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Usu\u00e1rio"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCheck("filtroRealizados", "Somente realizados", false);
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(RequisicaoPorDia.getModuloConfigurar());
        this.setModuloAcesso(RequisicaoPorDia.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void consultarGrafico() {
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "Campo Data Inicial deve ser preenchido.", 2);
            this.habilitaBotaoConsultar(true);
            return;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "Campo Data Final deve ser preenchido.", 2);
            this.habilitaBotaoConsultar(true);
            return;
        }
        int total = 0;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        try {
            String[] coletas;
            String[] destinos;
            String[] usuarios;
            String[] estacoes;
            String[] convenios;
            StringBuilder buf = new StringBuilder("select count(distinct a.req_codigo) as contagem, a.req_data as data, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from requisicao a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.req_excluida = false ");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" and a.req_data >= '");
                buf.append(Funcoes.formataData("yyyy/MM/dd", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" and a.req_data <= '");
                buf.append(Funcoes.formataData("yyyy/MM/dd", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if (this.getFiltroCheck("filtroRealizados")) {
                buf.append(" and b.exr_situacao not in ('");
                buf.append("T");
                buf.append("', '");
                buf.append("A");
                buf.append("', '");
                buf.append("F");
                buf.append("', '").append("R");
                buf.append("', '', ' ') and b.exr_situacao is not null ");
            }
            if ((convenios = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and a.con_codigo in (");
                for (int i = 0; i < convenios.length; ++i) {
                    buf.append(convenios[i]);
                    if (i >= convenios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((estacoes = this.getSelecionadosFiltro("filtroEstacao", 0)) != null) {
                buf.append(" and a.est_codigo in (");
                for (int i = 0; i < estacoes.length; ++i) {
                    buf.append(estacoes[i]);
                    if (i >= estacoes.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((usuarios = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                buf.append(" and a.usr_codabertura in (");
                for (int i = 0; i < usuarios.length; ++i) {
                    buf.append("'");
                    buf.append(usuarios[i]);
                    buf.append("'");
                    if (i >= usuarios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                buf.append(" and a.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    buf.append("'");
                    buf.append(StringUtil.textoDB(destinos[i]));
                    buf.append("'");
                    if (i >= destinos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and a.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    buf.append("'");
                    buf.append(StringUtil.textoDB(coletas[i]));
                    buf.append("'");
                    if (i >= coletas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(" group by a.req_data,  ").append(StringUtil.arrayParaString(Constantes.CAMPOS_FILIAL));
            buf.append(" order by a.req_data ");
            Statement st = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    DefaultCategoryDataset category = new DefaultCategoryDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    do {
                        String data = Funcoes.formataData(rs.getDate("data"));
                        category.addValue((double)rs.getInt("contagem"), (Comparable)((Object)"Requisi\u00e7\u00f5es"), (Comparable)((Object)data));
                        Object[] o = new Object[campos.length];
                        for (int i2 = 0; i2 < campos.length; ++i2) {
                            o[i2] = rs.getObject(campos[i2]);
                        }
                        modelo.addLine(o);
                        total += rs.getInt("contagem");
                    } while (rs.next());
                    JFreeChart chart = ChartFactory.createBarChart((String)"Requisi\u00e7\u00f5es por Dia", (String)"Data", (String)"Requisi\u00e7\u00f5es", (CategoryDataset)category, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                    TextTitle subtitulo = new TextTitle("Total de requisi\u00e7\u00f5es: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    CategoryPlot plot = (CategoryPlot)chart.getPlot();
                    plot.getRenderer().setBaseItemLabelsVisible(true);
                    plot.getRenderer().setLabelGenerator((CategoryLabelGenerator)new StandardCategoryLabelGenerator());
                    plot.getRenderer().setItemLabelFont(this.getFonteLegenda());
                    plot.getDomainAxis().setTickLabelFont(plot.getDomainAxis().getTickLabelFont().deriveFont(7.0f));
                    plot.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    }
                    var.put("filtroRealizados", this.getFiltroCheck("filtroRealizados") ? "Sim" : "N\u00e3o");
                    if (convenios != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroConvenio", buf.toString());
                    }
                    if (estacoes != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < estacoes.length; ++i) {
                            buf.append(estacoes[i]);
                            if (i >= estacoes.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroEstacao", buf.toString());
                    }
                    if (usuarios != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < usuarios.length; ++i) {
                            buf.append(usuarios[i]);
                            if (i >= usuarios.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroUsuario", buf.toString());
                    }
                    if (destinos != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroDestino", buf.toString());
                    }
                    if (coletas != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroColeta", buf.toString());
                    }
                    Paint bgColor = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    chart.setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RequisicaoPorDia.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RequisicaoPorDia.this.panelCentro.removeAll();
                                RequisicaoPorDia.this.panelCentro.repaint();
                                RequisicaoPorDia.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.panelCentro.repaint();
                    this.habilitaBotaoConsultar(true);
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoPorDia");
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoPorDia");
        }
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700501300");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700501301");
    }
}

