/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.model.bean.cadastro.FilialBean;
import jalis.relatorio.Gerador;
import jalis.service.cadastro.FilialService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;

public class RelatorioQuantidadeExamePorRequisicao
extends FrmGraficoPadrao
implements ConsultarGraficoListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    private final String FILTRO_AGRUPAR_ABAIXO_UM = "filtroAgruparAbaixoUm";
    protected static final String[] campos = new String[]{"quantidadeExame", "quantidadeRequisicao", "descricaoFilial", "percentualRequisicao"};
    private ModeloGridTable modelo = null;

    public RelatorioQuantidadeExamePorRequisicao() {
        this.montaBarraDescricao("Quantidade de exames por requisi\u00e7\u00f5es", "Quantidade de exames por requisi\u00e7\u00f5es", "consultas/quantidade_requisicao.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Destino"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCheck("filtroAgruparAbaixoUm", "Agrupar abaixo de 1%", true);
        this.montaTela();
        this.setModuloConfigurar(RelatorioQuantidadeExamePorRequisicao.getModuloConfigurar());
        this.setModuloAcesso(RelatorioQuantidadeExamePorRequisicao.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void consultarGrafico() {
        ResultSet rs;
        Statement st;
        block25: {
            String[] filiais;
            String[] destino;
            String[] medicos;
            String[] convenios;
            DefaultPieDataset pie;
            FilialBean filialBean;
            int outros;
            ArrayList<Object[]> objects;
            HashMap<String, Object> variaveis;
            Long numeroExameTemp;
            int totalRequisicao;
            block24: {
                if (!this.validarDados()) return;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.habilitaBotaoConsultar(false);
                st = Conexao.getStatement();
                rs = null;
                totalRequisicao = 0;
                numeroExameTemp = 0L;
                variaveis = new HashMap<String, Object>();
                FilialService filialService = new FilialService();
                objects = new ArrayList<Object[]>();
                this.modelo = new ModeloGridTable(campos);
                outros = 0;
                boolean totalExame = false;
                try {
                    filialBean = (FilialBean)filialService.get(Variaveis.filialPadrao);
                    pie = new DefaultPieDataset();
                    convenios = this.getSelecionadosFiltro("filtroConvenio", 0);
                    medicos = this.getSelecionadosFiltro("filtroMedico", 0);
                    destino = this.getSelecionadosFiltro("filtroDestino", 0);
                    filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                    this.panelAbas.removeAll();
                    this.panelCentro.removeAll();
                    StringBuilder sql = new StringBuilder();
                    sql.append(" select x.qtdExames as quantidadeExame, count(x.requisicao) as quantidadeRequisicao from ( ");
                    sql.append(" \t\tselect req.req_codigo as requisicao,count( a.exa_codigo) as qtdExames ");
                    sql.append(" from examerequisicao  a ");
                    sql.append(" \t\tleft join requisicao req on a.fil_codigo =  req.fil_codigo and a.req_codigo =  req.req_codigo ");
                    if (convenios != null) {
                        sql.append(" left join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
                    }
                    if (medicos != null) {
                        sql.append(" left join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm and req.med_conselho = med.med_conselho and req.med_uf = med.med_uf  ");
                    }
                    if (destino != null) {
                        sql.append(" left join destino des on req.fil_codigo = des.fil_codigo and req.des_codigo = des.des_codigo ");
                    }
                    sql.append(" where req.req_data between ").append(this.getDataFormatada(this.getFiltroData("filtroDataInicial"), "yyyy-MM-dd")).append(" and ").append(this.getDataFormatada(this.getFiltroData("filtroDataFinal"), "yyyy-MM-dd"));
                    sql.append(" and req.req_excluida = false and  a.exr_excluido = false ");
                    this.geraFiltroFilial(sql);
                    this.geraFiltroConvenio(sql);
                    this.geraFiltroMedico(sql);
                    this.geraFiltroDestino(sql);
                    sql.append(" group by req.req_codigo ");
                    sql.append(" ) as x group by qtdExames order by x.qtdexames ");
                    rs = Conexao.executeQuery(st, sql.toString());
                    if (rs.next()) {
                        do {
                            totalRequisicao = (int)((double)totalRequisicao + rs.getDouble("quantidadeRequisicao"));
                        } while (rs.next());
                        rs.first();
                        break block24;
                    }
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                    break block25;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                            ErrorLogger.mostraMensagem(this, e2.getMessage(), e2.getStackTrace());
                        }
                        this.setCursor(Cursor.getDefaultCursor());
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                        ErrorLogger.mostraMensagem(this, e3.getMessage(), e3.getStackTrace());
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
            do {
                if (this.getFiltroCheck("filtroAgruparAbaixoUm") && rs.getDouble("quantidadeRequisicao") * 100.0 / (double)totalRequisicao < 1.0) {
                    outros += rs.getInt("quantidadeRequisicao");
                } else {
                    pie.setValue((Comparable)((Object)rs.getString("quantidadeExame")), (double)rs.getInt("quantidadeRequisicao"));
                }
                Object[] objRegistro = new Object[campos.length];
                for (int i = 0; i < campos.length; ++i) {
                    objRegistro[i] = campos[i].equalsIgnoreCase("descricaoFilial") ? filialBean.getDescricao() : (campos[i].equalsIgnoreCase("percentualRequisicao") ? Double.valueOf(rs.getDouble("quantidadeRequisicao") * 100.0 / (double)totalRequisicao) : rs.getObject(campos[i]));
                }
                this.modelo.addLine(objRegistro);
            } while (rs.next());
            if (this.getFiltroCheck("filtroAgruparAbaixoUm") && outros > 0) {
                pie.setValue((Comparable)((Object)"Outros"), (double)outros);
            }
            this.addRegistroSequenciaFaltante(numeroExameTemp, objects, filialBean, this.modelo);
            NumberFormat nf = NumberFormat.getNumberInstance();
            NumberFormat nfp = NumberFormat.getPercentInstance();
            nfp.setMinimumFractionDigits(0);
            nfp.setMaximumFractionDigits(2);
            PiePlot plot = new PiePlot((PieDataset)pie);
            StandardPieItemLabelGenerator labels = new StandardPieItemLabelGenerator("{0}: ({1}) {2}", nf, nfp);
            plot.setLabelGenerator((PieSectionLabelGenerator)labels);
            plot.setLabelFont(this.getFonteLegenda());
            JFreeChart chart = new JFreeChart("Quantidade de exames por requisi\u00e7\u00e3o", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            TextTitle subtitulo = new TextTitle("Total de requisi\u00e7\u00f5es: " + totalRequisicao, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
            chart.addSubtitle((Title)subtitulo);
            variaveis.put("filtroFilial", this.getFiltroReport(filiais) == null ? Variaveis.filialPadrao : this.getFiltroReport(filiais));
            variaveis.put("filtroConvenio", this.getFiltroReport(convenios));
            variaveis.put("filtroMedico", this.getFiltroReport(medicos));
            variaveis.put("filtroDestino", this.getFiltroReport(destino));
            variaveis.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
            variaveis.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
            Paint bgColor = chart.getBackgroundPaint();
            chart.setBackgroundPaint((Paint)Color.WHITE);
            variaveis.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
            chart.setBackgroundPaint(bgColor);
            this.panelCentro.setLayout(new BorderLayout());
            this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
            this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
            this.panelCentro.add((Component)this.panelAbas, "Center");
            StringBuilder report = new StringBuilder();
            report.append("select rel_xml from relatoriosistema where rel_codigo = ");
            report.append(RelatorioQuantidadeExamePorRequisicao.getModuloAcesso());
            rs = Conexao.executeQuery(st, report.toString());
            if (rs.next()) {
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioQuantidadeExamePorRequisicao.this.panelCentro.removeAll();
                        RelatorioQuantidadeExamePorRequisicao.this.panelCentro.repaint();
                        RelatorioQuantidadeExamePorRequisicao.this.habilitaBotaoConsultar(true);
                    }
                });
                gerador.executar(rs.getString("rel_xml"), (TableModel)this.modelo, variaveis);
                this.panelAbas.repaint();
                this.panelAbas.revalidate();
                this.panelCentro.repaint();
                this.panelCentro.revalidate();
            }
        }
        Conexao.fecharStatement(st);
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void addRegistroSequenciaFaltante(Long numeroExameTemp, List<Object[]> objects, FilialBean filialBean, ModeloGridTable modelo) {
        int posicaoColuna = modelo.findColumn("quantidadeExame");
        for (int i = 0; i < modelo.getRowCount(); ++i) {
            if (numeroExameTemp + 1L != (Long)modelo.getValueAt(i, posicaoColuna)) {
                long valorAtual = (Long)modelo.getValueAt(i, posicaoColuna);
                long diferenca = valorAtual - numeroExameTemp - 1L;
                int d = 0;
                while ((long)d < diferenca) {
                    Object[] objRegistro = new Object[campos.length];
                    for (int c = 0; c < campos.length; ++c) {
                        if (campos[c].equals("quantidadeExame")) {
                            objRegistro[c] = numeroExameTemp + (long)(d + 1);
                            continue;
                        }
                        if (!campos[c].equals("quantidadeRequisicao")) continue;
                        objRegistro[c] = 0L;
                    }
                    objects.add(objRegistro);
                    ++d;
                }
            }
            numeroExameTemp = (Long)modelo.getValueAt(i, posicaoColuna);
        }
        for (Object[] ob : objects) {
            modelo.addLine(ob);
        }
        modelo.ordenarColuna(modelo.findColumn("quantidadeExame"), 1, false);
    }

    private String getFiltroReport(String[] selecionados) {
        StringBuilder filtros = new StringBuilder();
        if (selecionados != null) {
            for (int i = 0; i < selecionados.length; ++i) {
                filtros.append(selecionados[i]);
                if (i >= selecionados.length - 1) continue;
                filtros.append(", ");
            }
        } else {
            return null;
        }
        return filtros.toString();
    }

    private void geraFiltroDestino(StringBuilder sql) {
        String[] destino = this.getSelecionadosFiltro("filtroDestino", 0);
        if (destino != null) {
            sql.append(" and req.des_codigo in (");
            for (int i = 0; i < destino.length; ++i) {
                sql.append("'");
                sql.append(destino[i]);
                sql.append("'");
                if (i >= destino.length - 1) continue;
                sql.append(", ");
            }
            sql.append(")");
        }
    }

    private void geraFiltroMedico(StringBuilder sql) {
        String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
        String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
        String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
        if (conselho != null && crm != null && uf != null) {
            sql.append(" and (");
            for (int i = 0; i < crm.length; ++i) {
                sql.append("(req.med_conselho = '");
                sql.append(conselho[i]);
                sql.append("' and req.med_crm = '");
                sql.append(crm[i]);
                sql.append("' and req.med_uf = '");
                sql.append(uf[i]);
                sql.append("')");
                if (i >= crm.length - 1) continue;
                sql.append(" or ");
            }
            sql.append(")");
        }
    }

    private void geraFiltroConvenio(StringBuilder sql) {
        String[] convenios = this.getSelecionadosFiltro("filtroConvenio", 0);
        if (convenios != null) {
            sql.append(" and con.con_codigo in (");
            for (int i = 0; i < convenios.length; ++i) {
                sql.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                sql.append(", ");
            }
            sql.append(")");
        }
    }

    private void geraFiltroFilial(StringBuilder sql) {
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        sql.append(" and a.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            sql.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            sql.append(", ");
        }
        sql.append(") ");
    }

    private String getDataFormatada(String filtroData, String formatoDate) {
        StringBuilder date = new StringBuilder();
        date.append("'");
        date.append(Funcoes.formataData(formatoDate, filtroData));
        date.append("'");
        return date.toString();
    }

    private boolean validarDados() {
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "Informa o campo data inicial.", 2);
            this.habilitaBotaoConsultar(true);
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "Informa o campo data final.", 2);
            this.habilitaBotaoConsultar(true);
            return false;
        }
        return true;
    }

    @Override
    public void novo() {
        this.modelo.clear();
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700501500");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700501501");
    }
}

