/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.consultas.graficos.CampoLegenda;
import jalis.laboratorio.consultas.graficos.DialogoConfigurarLegenda;
import jalis.laboratorio.consultas.graficos.QuantidadeRespostas;
import jalis.laboratorio.digitacao.Resultado;
import jalis.model.bean.cadastro.FilialBean;
import jalis.relatorio.Gerador;
import jalis.service.cadastro.FilialService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;

public class PesquisaFornecedor
extends FrmGraficoPadrao
implements ConsultarGraficoListener,
ActionListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_FORNECEDOR = "filtroFornecedor";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    protected static final String[] campos = new String[]{"campoPesquisa", "respostaPesquisa", "contagem", "percentual", "descricaoFilial", "ocultar", "codigoFilial"};
    private ModeloGridTable modelo = new ModeloGridTable(campos);
    private ModeloGridTable modeloOriginal = new ModeloGridTable(campos);
    private JComboBox comboCampos = new JComboBox();
    private int totalPesquisas = 0;
    private HashMap<String, Map<String, Integer>> contagem = new HashMap();
    private QuantidadeRespostas quantidadeResposta = new QuantidadeRespostas();
    private JButton buttonConfigurarLegenda = ComponenteFactory.novoJButton("Configurar t\u00edtulos", this);
    private String legendas = "";

    public PesquisaFornecedor() {
        this.montaBarraDescricao("Pesquisa de fornecedores", "Gr\u00e1fico com indicativos da pesquisa de fornecedores", "consultas/pesquisa_fornecedor.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroFornecedor", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "F" + "'", 1, new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.montaTela();
        this.setModuloConfigurar(PesquisaFornecedor.getModuloConfigurar());
        this.setModuloAcesso(PesquisaFornecedor.getModuloAcesso());
        if (Acesso.getAcesso(PesquisaFornecedor.getModuloConfigurar())) {
            this.getPanelBotoesEsquerdo().add(this.buttonConfigurarLegenda);
        }
        this.setCamposConfigurador(campos);
        this.comboCampos.addItem("Todos");
        this.comboCampos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String valorCombo = PesquisaFornecedor.this.comboCampos.getSelectedItem().toString();
                PesquisaFornecedor.this.filtrarModelo();
                PesquisaFornecedor.this.consultar(true);
                PesquisaFornecedor.this.comboCampos.setSelectedItem(valorCombo);
            }
        });
    }

    private void filtrarModelo() {
        String valorCombo = this.comboCampos.getSelectedItem().toString();
        if (valorCombo.equals("Todos")) {
            this.modelo.clear();
            this.modelo = new ModeloGridTable(campos);
            for (int posicao = 0; posicao < this.modeloOriginal.getRowCount(); ++posicao) {
                HashMap<String, Object> linha = this.modeloOriginal.getLine(posicao);
                this.copiarLinhaModelo(linha);
            }
        } else {
            this.modelo.clear();
            this.modelo = new ModeloGridTable(campos);
            for (int posicao = 0; posicao < this.modeloOriginal.getRowCount(); ++posicao) {
                String valorLegenda = String.valueOf(this.modeloOriginal.getValueAt(posicao, this.modeloOriginal.findColumn("campoPesquisa")));
                if (!valorLegenda.equalsIgnoreCase(valorCombo)) continue;
                HashMap<String, Object> linha = this.modeloOriginal.getLine(posicao);
                this.copiarLinhaModelo(linha);
            }
        }
    }

    private void copiarLinhaModelo(HashMap<String, Object> linha) {
        if (!Boolean.valueOf(linha.get("ocultar").toString()).booleanValue()) {
            Object[] registro = new Object[campos.length];
            for (int i = 0; i < campos.length; ++i) {
                if (campos[i].equalsIgnoreCase("campoPesquisa")) {
                    registro[i] = linha.get("campoPesquisa");
                    continue;
                }
                if (campos[i].equalsIgnoreCase("respostaPesquisa")) {
                    registro[i] = linha.get("respostaPesquisa");
                    continue;
                }
                if (campos[i].equalsIgnoreCase("contagem")) {
                    registro[i] = linha.get("contagem");
                    continue;
                }
                if (campos[i].equalsIgnoreCase("percentual")) {
                    registro[i] = linha.get("percentual");
                    continue;
                }
                if (campos[i].equalsIgnoreCase("descricaoFilial")) {
                    registro[i] = linha.get("descricaoFilial");
                    continue;
                }
                if (campos[i].equalsIgnoreCase("ocultar")) {
                    registro[i] = linha.get("ocultar");
                    continue;
                }
                if (!campos[i].equalsIgnoreCase("codigoFilial")) continue;
                registro[i] = linha.get("codigoFilial");
            }
            this.modelo.addLine(registro);
        }
    }

    @Override
    public void consultarGrafico() {
        this.totalPesquisas = 0;
        ActionListener actionListenerTemp = null;
        ActionListener[] actionListenerArray = this.comboCampos.getActionListeners();
        int n = actionListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ActionListener actionListener;
            actionListenerTemp = actionListener = actionListenerArray[i];
            this.comboCampos.removeActionListener(actionListener);
        }
        this.modelo.clear();
        this.modelo = new ModeloGridTable(campos);
        this.modeloOriginal.clear();
        this.contagem.clear();
        this.consultar(false);
        this.comboCampos.addActionListener(actionListenerTemp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void consultar(boolean filtroLegendaExecuta) {
        block68: {
            block67: {
                block66: {
                    if (!this.validarDados()) break block68;
                    filiaisHash = new HashMap<Object, String>();
                    this.quantidadeResposta = new QuantidadeRespostas();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.habilitaBotaoConsultar(false);
                    st = Conexao.getStatement();
                    rs = null;
                    variaveis = new HashMap<String, Object>();
                    filialService = new FilialService();
                    pie = new DefaultPieDataset();
                    bar = new DefaultCategoryDataset();
                    isGraficoBarra = this.comboCampos.getSelectedItem().toString().equalsIgnoreCase("Todos");
                    filialBean = (FilialBean)filialService.get(Variaveis.filialPadrao);
                    fornecedor = this.getSelecionadosFiltro("filtroFornecedor", 0);
                    filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                    this.panelAbas.removeAll();
                    this.panelCentro.removeAll();
                    sql = new StringBuilder();
                    if (!filtroLegendaExecuta) {
                        sql.append(" select nfi_pesquisafornecedor, nfi.fil_codigo from notafiscal nfi ");
                        if (fornecedor != null) {
                            sql.append(" left join entidade ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
                        }
                        sql.append(" where nfi.nfi_dataemissao between ").append(this.getDataFormatada(this.getFiltroData("filtroDataInicial"), "yyyy-MM-dd")).append(" and ").append(this.getDataFormatada(this.getFiltroData("filtroDataFinal"), "yyyy-MM-dd"));
                        sql.append(" and nfi.nfi_datahoracancelada is null and nfi.nfi_pesquisafornecedor is not null ");
                        sql.append(" and nfi.nfi_tipo = '").append("E").append("' ");
                        this.geraFiltroFilial(sql);
                        this.geraFiltroEntidade(sql);
                        rs = Conexao.executeQuery(st, sql.toString());
                    }
                    if ((rs == null || !rs.next()) && !filtroLegendaExecuta) ** GOTO lbl278
                    if (!filtroLegendaExecuta) {
                        do {
                            ++this.totalPesquisas;
                        } while (rs.next());
                        rs.first();
                        do {
                            campos = Resultado.getCamposResultado(rs.getString("nfi_pesquisafornecedor"), true);
                            for (Object chave : campos.keySet()) {
                                contador = 1;
                                tmp = new HashMap<String, Integer>();
                                if (this.contagem.containsKey(chave)) {
                                    tmp = this.contagem.get(chave);
                                    if (tmp.containsKey(campos.get(chave).toString())) {
                                        contador = (Integer)tmp.get(campos.get(chave).toString());
                                        contador = contador + 1;
                                        tmp.put(campos.get(chave).toString().toUpperCase(), contador);
                                        continue;
                                    }
                                    tmp.put(campos.get(chave).toString().toUpperCase(), 1);
                                    continue;
                                }
                                tmp.put(campos.get(chave).toString().toUpperCase(), contador);
                                this.contagem.put((String)chave, tmp);
                                filiaisHash.put(chave, rs.getString("fil_codigo"));
                            }
                        } while (rs.next());
                    }
                    this.legendas = this.carregarXMLLegendas();
                    camposCombo = StringUtil.getValores(StringUtil.getValor(this.legendas, "config-legendas"), "campo");
                    camposLegenda = new HashMap<String, CampoLegenda>();
                    if (camposCombo != null && camposCombo.length > 0) {
                        for (Iterator<String> c : camposCombo) {
                            legenda = StringUtil.getValor((String)c, "texto");
                            campo = StringUtil.getValor(c, "id");
                            oculto = StringUtil.getBoolean(c, "oculto");
                            camposLegenda.put(campo.toLowerCase(), new CampoLegenda(campo, legenda, oculto));
                        }
                    }
                    for (String campo : this.contagem.keySet()) {
                        valoresDosCampos = this.contagem.get(campo);
                        for (String valor : valoresDosCampos.keySet()) {
                            v0 = textoLegenda = camposLegenda.containsKey(campo.toLowerCase()) != false ? (CampoLegenda)camposLegenda.get(campo.toLowerCase()) : new CampoLegenda(campo, campo, false);
                            if (textoLegenda.ocultar) continue;
                            for (i = 0; i < PesquisaFornecedor.campos.length; ++i) {
                                if (filtroLegendaExecuta) {
                                    if (PesquisaFornecedor.campos[i].equalsIgnoreCase("contagem") && textoLegenda.legenda.equals(this.comboCampos.getSelectedItem().toString())) {
                                        this.quantidadeResposta.addResposta(campo, valoresDosCampos.get(valor).intValue());
                                        continue;
                                    }
                                    if (!this.comboCampos.getSelectedItem().toString().equalsIgnoreCase("Todos") || !PesquisaFornecedor.campos[i].equalsIgnoreCase("contagem")) continue;
                                    this.quantidadeResposta.addResposta(campo, valoresDosCampos.get(valor).intValue());
                                    continue;
                                }
                                if (!PesquisaFornecedor.campos[i].equalsIgnoreCase("contagem")) continue;
                                if (isGraficoBarra) {
                                    this.quantidadeResposta.addResposta(textoLegenda.legenda, valoresDosCampos.get(valor).intValue());
                                    continue;
                                }
                                this.quantidadeResposta.addResposta(campo, valoresDosCampos.get(valor).intValue());
                            }
                        }
                    }
                    if (this.quantidadeResposta.getQuantidadeTotal() != 0.0) break block66;
                    Funcoes.mensagem(this, "Quantidade de respostas da pesquisa \u00e9 inv\u00e1lida.", 2);
                    Conexao.fecharStatement(new Statement[]{st});
                    try {
                        if (!filtroLegendaExecuta) {
                            rs.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                for (String campo : this.contagem.keySet()) {
                    valoresDosCampos = this.contagem.get(campo);
                    for (String valor : valoresDosCampos.keySet()) {
                        v1 = textoLegenda = camposLegenda.containsKey(campo.toLowerCase()) != false ? (CampoLegenda)camposLegenda.get(campo.toLowerCase()) : new CampoLegenda(campo, campo, false);
                        if (textoLegenda.ocultar) continue;
                        if (filtroLegendaExecuta) {
                            if (textoLegenda.legenda.equalsIgnoreCase(this.comboCampos.getSelectedItem().toString()) || this.comboCampos.getSelectedItem().toString().equalsIgnoreCase("Todos")) {
                                if (isGraficoBarra) {
                                    bar.addValue((Number)valoresDosCampos.get(valor), (Comparable)valor, (Comparable)campo);
                                } else {
                                    pie.setValue((Comparable)(textoLegenda.legenda + " [" + valor + "]"), (Number)valoresDosCampos.get(valor));
                                }
                            }
                        } else if (isGraficoBarra) {
                            bar.addValue((Number)valoresDosCampos.get(valor), (Comparable)valor, (Comparable)textoLegenda.legenda);
                        } else {
                            pie.setValue((Comparable)(textoLegenda.legenda + " [" + valor + "]"), (Number)valoresDosCampos.get(valor));
                        }
                        if (filtroLegendaExecuta) continue;
                        registro = new Object[PesquisaFornecedor.campos.length];
                        for (i = 0; i < PesquisaFornecedor.campos.length; ++i) {
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("campoPesquisa")) {
                                registro[i] = textoLegenda.legenda;
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("respostaPesquisa")) {
                                registro[i] = valor;
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("contagem")) {
                                registro[i] = valoresDosCampos.get(valor);
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("percentual")) {
                                if (isGraficoBarra) {
                                    registro[i] = BigDecimal.valueOf(100.0 / (this.quantidadeResposta.getQuantidadeCampo(textoLegenda.legenda) == 0.0 ? 1.0 : this.quantidadeResposta.getQuantidadeCampo(textoLegenda.legenda)) * (double)valoresDosCampos.get(valor).intValue()).setScale(2, RoundingMode.HALF_UP);
                                    continue;
                                }
                                registro[i] = BigDecimal.valueOf(100.0 / (this.quantidadeResposta.getQuantidadeTotal() == 0.0 ? 1.0 : this.quantidadeResposta.getQuantidadeTotal()) * (double)valoresDosCampos.get(valor).intValue()).setScale(2, RoundingMode.HALF_UP);
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("descricaoFilial")) {
                                registro[i] = filialBean.getDescricao();
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("ocultar")) {
                                registro[i] = textoLegenda.ocultar;
                                continue;
                            }
                            if (!PesquisaFornecedor.campos[i].equalsIgnoreCase("codigoFilial")) continue;
                            registro[i] = filiaisHash.get(campo);
                        }
                        if (textoLegenda.ocultar) continue;
                        this.modelo.addLine(registro);
                        this.modeloOriginal.addLine(registro);
                    }
                }
                modeloFiltro = new ModeloGridTable(PesquisaFornecedor.campos);
                if (filtroLegendaExecuta) {
                    qtde = this.modelo.getRowCount();
                    for (x = 0; x < qtde; ++x) {
                        contagem = (Integer)this.modelo.getValueAt(x, this.modelo.findColumn("contagem"));
                        linha = this.modelo.getLine(x);
                        registro = new Object[PesquisaFornecedor.campos.length];
                        for (i = 0; i < PesquisaFornecedor.campos.length; ++i) {
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("campoPesquisa")) {
                                registro[i] = linha.get("campoPesquisa");
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("respostaPesquisa")) {
                                registro[i] = linha.get("respostaPesquisa");
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("contagem")) {
                                registro[i] = linha.get("contagem");
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("percentual")) {
                                if (isGraficoBarra) {
                                    registro[i] = BigDecimal.valueOf(100.0 / (this.quantidadeResposta.getQuantidadeCampo(linha.get("campoPesquisa").toString()) == 0.0 ? 1.0 : this.quantidadeResposta.getQuantidadeCampo(linha.get("campoPesquisa").toString())) * Double.parseDouble(linha.get("contagem").toString())).setScale(2, RoundingMode.HALF_UP);
                                    continue;
                                }
                                registro[i] = BigDecimal.valueOf(100.0 / (this.quantidadeResposta.getQuantidadeTotal() == 0.0 ? 1.0 : this.quantidadeResposta.getQuantidadeTotal()) * Double.parseDouble(linha.get("contagem").toString())).setScale(2, RoundingMode.HALF_UP);
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("descricaoFilial")) {
                                registro[i] = linha.get("descricaoFilial");
                                continue;
                            }
                            if (PesquisaFornecedor.campos[i].equalsIgnoreCase("ocultar")) {
                                registro[i] = linha.get("ocultar");
                                continue;
                            }
                            if (!PesquisaFornecedor.campos[i].equalsIgnoreCase("codigoFilial")) continue;
                            registro[i] = linha.get("codigoFilial");
                        }
                        if (Boolean.valueOf(linha.get("ocultar").toString()).booleanValue()) continue;
                        modeloFiltro.addLine(registro);
                    }
                    this.modelo.clear();
                    this.modelo = modeloFiltro;
                }
                plot = null;
                if (isGraficoBarra) {
                    eixoDominio = new CategoryAxis("Perguntas");
                    eixoImagem = new NumberAxis("Respostas");
                    eixoImagem.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                    renderer = new BarRenderer();
                    renderer.setDrawBarOutline(true);
                    renderer.setItemLabelsVisible(true);
                    renderer.setBaseToolTipGenerator(new CategoryToolTipGenerator(){

                        public String generateToolTip(CategoryDataset arg0, int arg1, int arg2) {
                            return Funcoes.formataDecimal(100.0 * arg0.getValue(arg1, arg2).doubleValue() / PesquisaFornecedor.this.quantidadeResposta.getQuantidadeCampo(arg0.getColumnKey(arg2).toString())) + "%";
                        }
                    });
                    plot = new CategoryPlot((CategoryDataset)bar, eixoDominio, (ValueAxis)eixoImagem, (CategoryItemRenderer)renderer);
                } else {
                    nf = NumberFormat.getNumberInstance();
                    nfp = NumberFormat.getPercentInstance();
                    nfp.setMinimumFractionDigits(0);
                    nfp.setMaximumFractionDigits(2);
                    plot = new PiePlot((PieDataset)pie);
                    labels = new StandardPieItemLabelGenerator("{0}: {2}", nf, nfp);
                    plot.setLabelGenerator((PieSectionLabelGenerator)labels);
                    plot.setLabelFont(this.getFonteLegenda());
                }
                chart = new JFreeChart("Pesquisa de fornecedores", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                subtitulo = new TextTitle("Total de pesquisas: " + this.totalPesquisas, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                chart.addSubtitle((Title)subtitulo);
                variaveis.put("filtroFilial", this.getFiltroReport(filiais) == null ? Variaveis.filialPadrao : this.getFiltroReport(filiais));
                variaveis.put("filtroFornecedor", this.getFiltroReport(fornecedor));
                variaveis.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                variaveis.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                bgColor = chart.getBackgroundPaint();
                chart.setBackgroundPaint((Paint)Color.WHITE);
                variaveis.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                chart.setBackgroundPaint(bgColor);
                this.panelCentro.setLayout(new BorderLayout());
                panelCampos = new JPanel(new BorderLayout());
                panel = new JPanel(new GridBagLayout());
                g = new GridBagConstraints();
                g.gridx = 0;
                g.gridy = 0;
                g.weightx = 0.0;
                g.fill = 0;
                g.anchor = 17;
                label = new JLabel("Filtro de legendas:");
                this.comboCampos.setPreferredSize(new Dimension(100, 20));
                this.comboCampos.setMinimumSize(new Dimension(100, 20));
                panel.add((Component)label, g);
                ++g.gridx;
                g.weightx = 1.0;
                g.fill = 2;
                panel.add((Component)this.comboCampos, g);
                for (i = this.comboCampos.getItemCount(); i > 0; --i) {
                    if (i - 1 <= 0) continue;
                    this.comboCampos.removeItemAt(i - 1);
                }
                if (camposLegenda != null && camposLegenda.size() > 0) {
                    for (String c : camposLegenda.keySet()) {
                        l = (CampoLegenda)camposLegenda.get(c);
                        if (l.ocultar) continue;
                        titulo = ((CampoLegenda)camposLegenda.get((Object)c)).legenda;
                        this.comboCampos.addItem(titulo);
                    }
                }
                this.panelCentro.add((Component)panel, "North");
                this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                this.panelCentro.add((Component)this.panelAbas, "Center");
                modeloRelatorio = this.carregarXMLModelo();
                if (modeloRelatorio != null && !Funcoes.textoVazio(modeloRelatorio)) {
                    gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            PesquisaFornecedor.this.panelCentro.removeAll();
                            PesquisaFornecedor.this.panelCentro.repaint();
                            PesquisaFornecedor.this.habilitaBotaoConsultar(true);
                        }
                    });
                    gerador.executar(modeloRelatorio, (TableModel)this.modelo, variaveis);
                    this.panelAbas.repaint();
                    this.panelAbas.revalidate();
                    this.panelCentro.repaint();
                    this.panelCentro.revalidate();
                }
                break block67;
lbl278:
                // 1 sources

                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoConsultar(true);
                this.panelCentro.repaint();
            }
            Conexao.fecharStatement(new Statement[]{st});
            try {
                if (!filtroLegendaExecuta) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            this.setCursor(Cursor.getDefaultCursor());
            break block68;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable var29_51) {
                    Conexao.fecharStatement(new Statement[]{st});
                    try {
                        if (!filtroLegendaExecuta) {
                            rs.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    throw var29_51;
                }
                Conexao.fecharStatement(new Statement[]{st});
                try {
                    if (!filtroLegendaExecuta) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private String getFiltroReport(String[] selecionados) {
        StringBuilder filtros = new StringBuilder();
        if (selecionados != null) {
            for (int i = 0; i < selecionados.length; ++i) {
                filtros.append(selecionados[i]);
                if (i >= selecionados.length - 1) continue;
                filtros.append(", ");
            }
        } else {
            return null;
        }
        return filtros.toString();
    }

    private void geraFiltroEntidade(StringBuilder sql) {
        String[] entidades = this.getSelecionadosFiltro("filtroFornecedor", 0);
        if (entidades != null) {
            sql.append(" and ent.ent_codigo in (");
            for (int i = 0; i < entidades.length; ++i) {
                sql.append(entidades[i]);
                if (i >= entidades.length - 1) continue;
                sql.append(", ");
            }
            sql.append(")");
        }
    }

    private void geraFiltroFilial(StringBuilder sql) {
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        sql.append(" and nfi.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            sql.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            sql.append(", ");
        }
        sql.append(") ");
    }

    private String getDataFormatada(String filtroData, String formatoDate) {
        StringBuilder date = new StringBuilder();
        date.append("'");
        date.append(Funcoes.formataData(formatoDate, filtroData));
        date.append("'");
        return date.toString();
    }

    private boolean validarDados() {
        if (this.getSelecionadosFiltro("filtroFornecedor", 0) == null || this.getSelecionadosFiltro("filtroFornecedor", 0).length == 0) {
            Funcoes.mensagem(this, "O fornecedor deve ser selecionado.", 2);
            this.habilitaBotaoConsultar(true);
            return false;
        }
        if (this.getSelecionadosFiltro("filtroFornecedor", 0) != null && this.getSelecionadosFiltro("filtroFornecedor", 0).length > 1) {
            Funcoes.mensagem(this, "Apenas um fornecedor pode ser selecionado.", 2);
            this.habilitaBotaoConsultar(true);
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "A data inicial deve ser informada.", 2);
            this.habilitaBotaoConsultar(true);
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "A data final deve ser informada.", 2);
            this.habilitaBotaoConsultar(true);
            return false;
        }
        return true;
    }

    @Override
    public void novo() {
        this.modelo.clear();
        this.modelo = new ModeloGridTable(campos);
        this.modeloOriginal.clear();
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700501600");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700501601");
    }

    @Override
    public String getAtributosEditor(String modelo) {
        StringBuilder buf = new StringBuilder();
        buf.append("<config-legendas>");
        buf.append(StringUtil.getValor(this.legendas, "config-legendas"));
        buf.append("</config-legendas>");
        buf.append("<modelo-relatorio>");
        buf.append(modelo);
        buf.append("</modelo-relatorio>");
        return StringUtil.textoDB(buf.toString());
    }

    public String carregarXMLLegendas() {
        String modelo = "";
        try {
            modelo = super.carregarXMLModelo();
            if (modelo != null && !Funcoes.textoVazio(modelo) && !Funcoes.textoVazio(StringUtil.getValor(modelo, "config-legenda"))) {
                modelo = StringUtil.getValor(modelo, "config-legenda");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar as legendas da consulta.\n", e.getStackTrace(), "PesquisaFornecedor(439)");
        }
        return modelo;
    }

    @Override
    public String carregarXMLModelo() {
        String modelo = "";
        try {
            modelo = super.carregarXMLModelo();
            if (modelo != null && !Funcoes.textoVazio(modelo) && !Funcoes.textoVazio(StringUtil.getValor(modelo, "modelo-relatorio"))) {
                modelo = StringUtil.getValor(modelo, "modelo-relatorio");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar o modelo de consulta.\n", e.getStackTrace(), "PesquisaFornecedor(399)");
        }
        return modelo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonConfigurarLegenda) {
            this.configurarLegenda();
        } else {
            super.actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurarLegenda() {
        block12: {
            block14: {
                String modelo;
                Statement st;
                DialogoConfigurarLegenda dialogo;
                block11: {
                    dialogo = new DialogoConfigurarLegenda((Frame)Laboratorio.getInstancia(), "Configurar legendas");
                    if (dialogo == null) break block12;
                    st = Conexao.getStatement();
                    modelo = "";
                    try {
                        StringBuilder b = new StringBuilder();
                        b.append("select lay_pesquisafornecedor from layout ");
                        b.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                        b.append("  and lay_codigo = ").append(ParametrosGerais.getLayCodigo());
                        ResultSet rs = Conexao.executeQuery(st, b);
                        if (!rs.next()) break block11;
                        modelo = rs.getString(1);
                    }
                    catch (Exception e) {
                        try {
                            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PesquisaFornecedor(486)");
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                    }
                }
                Conexao.fecharStatement(st);
                if (Funcoes.textoVazio(modelo)) break block14;
                String[] tmp = DialogoConfigurador.getCamposResultado(modelo.toString());
                ArrayList<String> campos = new ArrayList<String>();
                for (String s : tmp) {
                    campos.add(s);
                }
                dialogo.setXML(this.carregarXMLLegendas());
                dialogo.setCampos(campos);
                dialogo.setVisible(true);
                if (!dialogo.getOK()) break block12;
                this.legendas = dialogo.getXML();
                Statement st2 = Conexao.getStatement();
                try {
                    this.salvarAtributos(st2, PesquisaFornecedor.getModuloAcesso(), this.getAtributosEditor(this.carregarXMLModelo()));
                    Conexao.arquivaSQL();
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PesquisaFornecedor(519)");
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st2);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st2);
                    break block12;
                }
                Conexao.fecharStatement(st2);
                break block12;
            }
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 um modelo de pesquisa configurado", 2);
        }
    }
}

