/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;

public class PercentualExameRealizado
extends FrmGraficoPadrao
implements ConsultarGraficoListener {
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_AGRUPAR_ABAIXO_UM = "filtroAgruparAbaixoUm";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    public static final int TIPO_REALIZADOS = 1;
    public static final int TIPO_SOLICITADOS = 2;
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"contagem", "codigoExame", "codigoMaterialColeta", "descricaoExame", "abreviaturaMaterialColeta"});
    private int tipoRelatorio = 1;

    public PercentualExameRealizado(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("Percentual de exames realizados", "Gr\u00e1fico com percentual de exames realizados", "consultas/percentual_exames_realizados.jpg");
        } else {
            this.montaBarraDescricao("Percentual de exames solicitados", "Gr\u00e1fico com percentual de exames solicitados", "consultas/percentual_exames_solicitados.jpg");
        }
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCheck("filtroAgruparAbaixoUm", "Agrupar abaixo de 1%", true);
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(PercentualExameRealizado.getModuloConfigurar(this.tipoRelatorio));
        this.setModuloAcesso(PercentualExameRealizado.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(campos);
    }

    @Override
    public void consultarGrafico() {
        int total = 0;
        if (this.getSelecionadosFiltro("filtroExame", 0) == null && this.getSelecionadosFiltro("filtroSetor", 0) == null) {
            Funcoes.mensagem(this, "O filtro deve conter ao menos dois exames ou um setor para sele\u00e7\u00e3o", 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        try {
            String[] setores;
            String[] coletas;
            String[] estacoes;
            String[] convenios;
            StringBuilder buf = new StringBuilder("select count(a.req_codigo) as contagem, ");
            buf.append("a.exa_codigo as codigoExame, ");
            buf.append("a.mco_codigo as codigoMaterialColeta, ");
            buf.append("c.exa_descricao as descricaoExame, ");
            buf.append("d.mco_abreviatura as abreviaturaMaterialColeta, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from examerequisicao a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("left join requisicao req on a.fil_codigo = req.fil_codigo and a.req_codigo = req.req_codigo ");
            buf.append("left join convenios b on req.fil_codigo = b.fil_codigo and req.con_codigo = b.con_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("left join examesetor exmsetor on a.fil_codigo = exmsetor.fil_codigo and a.exa_codigo = exmsetor.exa_codigo and exmsetor.ese_default = true ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.exr_excluido = false and req.req_excluida = false ");
            String[] exames = this.getSelecionadosFiltro("filtroExame", 0);
            if (exames != null) {
                buf.append(" and a.exa_codigo in (");
                for (int i = 0; i < exames.length; ++i) {
                    buf.append("'");
                    buf.append(exames[i]);
                    buf.append("'");
                    if (i >= exames.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" and req.req_data >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" and req.req_data <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if ((convenios = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and b.con_codigo in (");
                for (int i = 0; i < convenios.length; ++i) {
                    buf.append(convenios[i]);
                    if (i >= convenios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((estacoes = this.getSelecionadosFiltro("filtroEstacao", 0)) != null) {
                buf.append(" and req.est_codigo in (");
                for (int i = 0; i < estacoes.length; ++i) {
                    buf.append(estacoes[i]);
                    if (i >= estacoes.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and req.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    buf.append("'");
                    buf.append(coletas[i]);
                    buf.append("'");
                    if (i >= coletas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((setores = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and exmsetor.set_codigo in (");
                for (int i = 0; i < setores.length; ++i) {
                    buf.append(setores[i]);
                    if (i >= setores.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (this.tipoRelatorio == 1) {
                buf.append(" and a.exr_situacao not in ('");
                buf.append("T");
                buf.append("', '");
                buf.append("A");
                buf.append("', '");
                buf.append("F");
                buf.append("', '").append("R");
                buf.append("', '', ' ') and a.exr_situacao is not null ");
            }
            buf.append(" group by a.exa_codigo, a.mco_codigo, c.exa_descricao, d.mco_abreviatura, ").append(StringUtil.arrayParaString(Constantes.CAMPOS_FILIAL));
            buf.append(" order by a.exa_codigo ");
            Statement st = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    DefaultPieDataset pie = new DefaultPieDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    do {
                        total += rs.getInt("contagem");
                    } while (rs.next());
                    int outros = 0;
                    rs.first();
                    do {
                        if (this.getFiltroCheck("filtroAgruparAbaixoUm") && rs.getInt("contagem") * 100 / total < 1) {
                            outros += rs.getInt("contagem");
                        } else {
                            pie.setValue((Comparable)((Object)(rs.getString("codigoExame") + " [" + rs.getString("abreviaturaMaterialColeta") + "] ")), (double)rs.getInt("contagem"));
                        }
                        Object[] o = new Object[campos.length];
                        for (int i2 = 0; i2 < campos.length; ++i2) {
                            o[i2] = rs.getObject(campos[i2]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (this.getFiltroCheck("filtroAgruparAbaixoUm") && outros > 0) {
                        pie.setValue((Comparable)((Object)"Outros"), (double)outros);
                    }
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    NumberFormat nfp = NumberFormat.getPercentInstance();
                    nfp.setMinimumFractionDigits(0);
                    nfp.setMaximumFractionDigits(2);
                    PiePlot plot = new PiePlot((PieDataset)pie);
                    StandardPieItemLabelGenerator labels = new StandardPieItemLabelGenerator("{0}: ({1}) {2}", nf, nfp);
                    plot.setLabelGenerator((PieSectionLabelGenerator)labels);
                    plot.setLabelFont(this.getFonteLegenda());
                    JFreeChart chart = new JFreeChart("Percentual de exames " + (this.tipoRelatorio == 1 ? "realizados" : "solicitados"), JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                    TextTitle subtitulo = new TextTitle("Total de exames: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    }
                    if (exames != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < exames.length; ++i) {
                            buf.append(exames[i]);
                            if (i >= exames.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroExame", buf.toString());
                    }
                    if (convenios != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroConvenio", buf.toString());
                    }
                    if (setores != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < setores.length; ++i) {
                            buf.append(setores[i]);
                            if (i >= setores.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroSetor", buf.toString());
                    }
                    if (estacoes != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < estacoes.length; ++i) {
                            buf.append(estacoes[i]);
                            if (i >= estacoes.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroEstacao", buf.toString());
                    }
                    if (coletas != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroColeta", buf.toString());
                    }
                    Paint bgColor = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    chart.setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(PercentualExameRealizado.getModuloAcesso(this.tipoRelatorio));
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                PercentualExameRealizado.this.panelCentro.removeAll();
                                PercentualExameRealizado.this.panelCentro.repaint();
                                PercentualExameRealizado.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PercentualExameRealizado (275)");
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PercentualExameRealizado (281)");
        }
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0700500400");
        }
        return Long.parseLong("0700500500");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0700500401");
        }
        return Long.parseLong("0700500501");
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }
}

