/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.model.vo.consultas.PacientesPorCidadeVO;
import jalis.relatorio.Gerador;
import jalis.service.consultas.PacientesPorCidadeService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;

public class PacientesPorCidade
extends FrmGraficoPadrao {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    protected static final String[] campos = new String[]{"codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "CNESFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "contagem", "codigoCidade", "nomeCidade"};

    public PacientesPorCidade() {
        this.montaBarraDescricao("Pacientes por cidade", "Gr\u00e1fico de pacientes por cidade", "consultas/grafico_pac_cidade.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome", "cid_uf"}, new String[]{"C\u00f3digo", "Nome", "UF"}, new int[]{70, 0, 30});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(PacientesPorCidade.getModuloConfigurar());
        this.setModuloAcesso(PacientesPorCidade.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700502200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700502201");
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }

    @Override
    public void consultarGrafico() {
        if (this.getSelecionadosFiltro("filtroCidade", 0) == null) {
            Funcoes.mensagem(this, "Nenhuma cidade foi selecionada.", 2);
            return;
        }
        if (this.getFiltroData("filtroDataInicial").isEmpty()) {
            Funcoes.mensagem(this, "Data inicial n\u00e3o informada.", 2);
            return;
        }
        if (this.getFiltroData("filtroDataFinal").isEmpty()) {
            Funcoes.mensagem(this, "Data final n\u00e3o informada.", 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        ArrayList listaPacientesPorCidadesVO = null;
        try {
            String[] filtroFilial = this.getSelecionadosFiltro("filtroFilial", 0);
            if (this.filtroNulo(filtroFilial)) {
                filtroFilial = new String[]{Variaveis.filialPadrao};
            }
            PacientesPorCidadeVO pacientesPorCidadeVO = new PacientesPorCidadeVO();
            pacientesPorCidadeVO.setFiliais(filtroFilial);
            pacientesPorCidadeVO.setCidades(this.getSelecionadosFiltro("filtroCidade", 0));
            pacientesPorCidadeVO.setExames(this.getSelecionadosFiltro("filtroExame", 0));
            pacientesPorCidadeVO.setSetores(this.getSelecionadosFiltro("filtroSetor", 0));
            pacientesPorCidadeVO.setConvenios(this.getSelecionadosFiltro("filtroConvenio", 0));
            pacientesPorCidadeVO.setDataInicial(this.getFiltroData("filtroDataInicial"));
            pacientesPorCidadeVO.setDataFinal(this.getFiltroData("filtroDataFinal"));
            listaPacientesPorCidadesVO = new PacientesPorCidadeService().consultarPacientes(pacientesPorCidadeVO);
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            if (!listaPacientesPorCidadesVO.isEmpty()) {
                int total = 0;
                DefaultPieDataset pie = new DefaultPieDataset();
                ModeloGridTable modelo = new ModeloGridTable(new String[]{"codigoFilial", "descricaoFilial", "cnpjFilial", "enderecoFilial", "complementoFilial", "cepFilial", "CNESFilial", "foneFilial", "faxFilial", "razaoSocialFilial", "codigoCidadeFilial", "descricaoCidadeFilial", "estadoCidadeFilial", "codigoBairroFilial", "descricaoBairroFilial", "contagem", "codigoCidade", "nomeCidade"});
                double valorPaciente = 0.0;
                for (PacientesPorCidadeVO pacientesPorCidadeVOToTable : listaPacientesPorCidadesVO) {
                    int posicao = pie.getIndex((Comparable)((Object)pacientesPorCidadeVOToTable.getNomeCidade()));
                    if (this.cidadeAdicionada(posicao)) {
                        int valor = Integer.parseInt(modelo.getValueAt(posicao, 15).toString()) + pacientesPorCidadeVOToTable.getContagem();
                        valorPaciente = (Double)pie.getValue(pie.getIndex((Comparable)((Object)pacientesPorCidadeVOToTable.getNomeCidade()))) + (double)pacientesPorCidadeVOToTable.getContagem();
                        pie.setValue((Comparable)((Object)pacientesPorCidadeVOToTable.getNomeCidade()), valorPaciente);
                    } else {
                        pie.setValue((Comparable)((Object)pacientesPorCidadeVOToTable.getNomeCidade()), (double)pacientesPorCidadeVOToTable.getContagem());
                    }
                    Object[] o = new Object[]{pacientesPorCidadeVOToTable.getCodigoFilial(), pacientesPorCidadeVOToTable.getDescricaoFilial(), pacientesPorCidadeVOToTable.getCnpjFilial(), pacientesPorCidadeVOToTable.getEnderecoFilial(), pacientesPorCidadeVOToTable.getComplementoFilial(), pacientesPorCidadeVOToTable.getCepFilial(), pacientesPorCidadeVOToTable.getCnesFilial(), pacientesPorCidadeVOToTable.getFoneFilial(), pacientesPorCidadeVOToTable.getFaxFilial(), pacientesPorCidadeVOToTable.getRazaoSocialFilial(), pacientesPorCidadeVOToTable.getCodigoCidadeFilial(), pacientesPorCidadeVOToTable.getDescricaoCidadeFilial(), pacientesPorCidadeVOToTable.getEstadoCidadeFilial(), pacientesPorCidadeVOToTable.getCodigoBairroFilial(), pacientesPorCidadeVOToTable.getDescricaoBairroFilial(), pacientesPorCidadeVOToTable.getContagem(), pacientesPorCidadeVOToTable.getCodigoCidade(), pacientesPorCidadeVOToTable.getNomeCidade()};
                    modelo.addLine(o);
                    total += pacientesPorCidadeVOToTable.getContagem();
                }
                HashMap<String, Object> var = new HashMap<String, Object>();
                if (!pacientesPorCidadeVO.isFiliaisVazio()) {
                    var.put("filtroFilial", pacientesPorCidadeVO.getFiliaisToString());
                }
                if (!pacientesPorCidadeVO.isCidadesVazio()) {
                    var.put("filtroCidade", pacientesPorCidadeVO.getCidadesToString());
                }
                if (!pacientesPorCidadeVO.isExamesVazio()) {
                    var.put("filtroExame", pacientesPorCidadeVO.getExamesRelatorio());
                }
                if (!pacientesPorCidadeVO.isSetoresVazio()) {
                    var.put("filtroSetor", pacientesPorCidadeVO.getSetoresToString());
                }
                if (!pacientesPorCidadeVO.isConveniosVazio()) {
                    var.put("filtroConvenio", pacientesPorCidadeVO.getConveniosToString());
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                }
                NumberFormat nf = NumberFormat.getNumberInstance();
                NumberFormat nfp = NumberFormat.getPercentInstance();
                nfp.setMinimumFractionDigits(0);
                nfp.setMaximumFractionDigits(2);
                PiePlot plot = new PiePlot((PieDataset)pie);
                plot.setLabelFont(this.getFonteLegenda());
                StandardPieItemLabelGenerator labels = new StandardPieItemLabelGenerator("{0}: ({1}) {2}", nf, nfp);
                plot.setLabelGenerator((PieSectionLabelGenerator)labels);
                JFreeChart chart = new JFreeChart("Pacientes por Cidade", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                TextTitle subtitulo = new TextTitle("Total de pacientes: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                chart.addSubtitle((Title)subtitulo);
                Paint bgColor = chart.getBackgroundPaint();
                chart.setBackgroundPaint((Paint)Color.WHITE);
                var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                chart.setBackgroundPaint(bgColor);
                this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                this.panelCentro.setLayout(new BorderLayout());
                this.panelCentro.add((Component)this.panelAbas, "Center");
                String modeloRelatorio = new PacientesPorCidadeService().consultaRelatorio(PacientesPorCidade.getModuloAcesso());
                if (!modeloRelatorio.isEmpty()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            PacientesPorCidade.this.panelCentro.removeAll();
                            PacientesPorCidade.this.panelCentro.repaint();
                            PacientesPorCidade.this.habilitaBotaoConsultar(true);
                        }
                    });
                    gerador.executar(modeloRelatorio, (TableModel)modelo, var);
                }
                this.panelAbas.repaint();
                this.panelAbas.revalidate();
                this.panelCentro.repaint();
                this.panelCentro.revalidate();
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoConsultar(true);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PacientesPorBairro");
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean cidadeAdicionada(int posicao) {
        return posicao != -1;
    }

    public boolean filtroNulo(String[] filtro) {
        return filtro == null;
    }
}

