/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;

public class PacientesPorBairro
extends FrmGraficoPadrao {
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_BAIRRO = "filtroBairro";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_AGRUPAR_ABAIXO_UM = "filtroAgruparAbaixoUm";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"contagem", "codigoCidade", "bairroCodigo", "nomeCidade", "descricaoBairro"});

    public PacientesPorBairro() {
        this.montaBarraDescricao("Pacientes por bairro", "Gr\u00e1fico de pacientes por bairro", "consultas/grafico_pac_bairro.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroBairro", "Bairro", "bairro", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"bai_codigo", "bai_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCheck("filtroAgruparAbaixoUm", "Agrupar abaixo de 1%", true);
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(PacientesPorBairro.getModuloConfigurar());
        this.setModuloAcesso(PacientesPorBairro.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700500600");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700500601");
    }

    @Override
    public void consultarGrafico() {
        int total = 0;
        if (this.getSelecionadosFiltro("filtroCidade", 0) == null) {
            Funcoes.mensagem(this, "Selecione ao menos uma cidade", 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        try {
            String[] bairros;
            String[] cidades;
            StringBuilder buf = new StringBuilder("select count(pac_codigo) as contagem, a.cid_codigo as codigoCidade, a.bai_codigo as bairroCodigo, b.cid_nome as nomeCidade, c.bai_descricao as descricaoBairro, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from paciente a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo ");
            buf.append(" left join bairro c on a.fil_codigo = c.fil_codigo and a.bai_codigo = c.bai_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" and pac_datahora >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" and pac_datahora <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if ((cidades = this.getSelecionadosFiltro("filtroCidade", 0)) != null) {
                buf.append(" and a.cid_codigo in (");
                for (int i = 0; i < cidades.length; ++i) {
                    buf.append(cidades[i]);
                    if (i >= cidades.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((bairros = this.getSelecionadosFiltro("filtroBairro", 0)) != null) {
                buf.append(" and a.bai_codigo in (");
                for (int i = 0; i < bairros.length; ++i) {
                    buf.append("'").append(bairros[i]).append("'");
                    if (i >= bairros.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(" and a.bai_codigo is not null group by a.cid_codigo, a.bai_codigo, b.cid_nome, c.bai_descricao,  ").append(StringUtil.arrayParaString(Constantes.CAMPOS_FILIAL));
            buf.append(" order by c.bai_descricao, a.cid_codigo, a.bai_codigo, b.cid_nome ");
            Statement st = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                boolean qtdeTotal = false;
                if (rs.next()) {
                    int i;
                    do {
                        total += rs.getInt("contagem");
                    } while (rs.next());
                    DefaultPieDataset pie = new DefaultPieDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    int outros = 0;
                    rs.first();
                    do {
                        if (this.getFiltroCheck("filtroAgruparAbaixoUm") && rs.getInt("contagem") * 100 / total < 1) {
                            outros += rs.getInt("contagem");
                        } else {
                            pie.setValue((Comparable)((Object)rs.getString("descricaoBairro")), (double)rs.getInt("contagem"));
                        }
                        Object[] o = new Object[campos.length];
                        for (int i2 = 0; i2 < campos.length; ++i2) {
                            o[i2] = rs.getObject(campos[i2]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (this.getFiltroCheck("filtroAgruparAbaixoUm") && outros > 0) {
                        pie.setValue((Comparable)((Object)"Outros"), (double)outros);
                    }
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    NumberFormat nfp = NumberFormat.getPercentInstance();
                    nfp.setMinimumFractionDigits(0);
                    nfp.setMaximumFractionDigits(2);
                    PiePlot plot = new PiePlot((PieDataset)pie);
                    plot.setLabelFont(this.getFonteLegenda());
                    StandardPieItemLabelGenerator labels = new StandardPieItemLabelGenerator("{0}: ({1}) {2}", nf, nfp);
                    plot.setLabelGenerator((PieSectionLabelGenerator)labels);
                    JFreeChart chart = new JFreeChart("Pacientes por Bairro", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                    TextTitle subtitulo = new TextTitle("Total de pacientes: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    }
                    if (cidades != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < cidades.length; ++i) {
                            buf.append(cidades[i]);
                            if (i >= cidades.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroCidade", buf.toString());
                    }
                    if (bairros != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < bairros.length; ++i) {
                            buf.append(bairros[i]);
                            if (i >= bairros.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroBairro", buf.toString());
                    }
                    Paint bgColor = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    chart.setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(PacientesPorBairro.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                PacientesPorBairro.this.panelCentro.removeAll();
                                PacientesPorBairro.this.panelCentro.repaint();
                                PacientesPorBairro.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PacientesPorBairro");
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PacientesPorBairro");
        }
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }
}

