/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class Filtro
extends JDialog
implements DisposeListener {
    JPanel panelCentro = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonOK = new JButton("OK");
    JButton buttonCancelar = new JButton("Cancelar");
    JLabel labelFilial = new JLabel("Filial:");
    TTextField txtFilial = new TTextField(20, 11);
    JButton buttonBuscaFilial = new JButton();
    boolean ok = false;

    public Filtro(Frame owner) {
        super(owner, "Filtro");
        try {
            if (owner instanceof Laboratorio) {
                ((Laboratorio)owner).addDisposeListener(this);
            }
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace(), "TotalPorRecebido");
        }
    }

    public void jbInit() throws Exception {
        this.setModal(true);
        this.setSize(170, 100);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelCentro, "West");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        this.txtFilial.setPreferredSize(new Dimension(50, 20));
        this.buttonBuscaFilial.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.panelCentro.add((Component)this.labelFilial, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        this.panelCentro.add((Component)this.txtFilial, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.panelCentro.add((Component)this.buttonBuscaFilial, gridBagConstraints);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.imagemPesquisa(this.buttonBuscaFilial);
        this.buttonBuscaFilial.setFocusable(false);
        this.txtFilial.setText(Variaveis.filialPadrao);
        this.buttonBuscaFilial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filtro.this.buscaFilial();
            }
        });
        this.txtFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Filtro.this.buscaFilial();
                }
            }
        });
        this.buttonOK.setMnemonic('O');
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filtro.this.ok = true;
                Filtro.this.setVisible(false);
            }
        });
        this.buttonCancelar.setMnemonic('C');
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filtro.this.ok = false;
                Filtro.this.setVisible(false);
            }
        });
    }

    public String getFilial() {
        if (Funcoes.textoVazio(this.txtFilial.getText())) {
            return Variaveis.filialPadrao;
        }
        return this.txtFilial.getText();
    }

    public boolean isOK() {
        return this.ok;
    }

    private void buscaFilial() {
        boolean retorno;
        Hashtable resultado = Pesquisas.filial(this, true);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            String t = this.txtFilial.getText();
            if (!Funcoes.textoVazio(t)) {
                t = t + ",";
            }
            this.txtFilial.setText(t + resultado.get("fil_codigo").toString());
        }
        this.txtFilial.requestFocus();
    }
}

