/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;

public class ExamesRecoleta
extends FrmGraficoPadrao {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private final String FILTRO_MOSTRARRECOLETASREALIZADAS = "filtroMostrarRecoletasRealizadas";
    private final String FILTRO_MOSTRARDADOSMENSAIS = "filtroMostrarDadosMensais";
    private final String FILTRO_LEGENDA = "filtroLegendaGrafico";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    private final String TOTAL_EXAMES = "totalExames";
    private static final String PARAMETRO_MEDICO = "medico";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"qtdeExamesMarcadosRecoleta", "qtdeExamesRecoletados", "qtdeRequisicoes", "dataExameSituacao", "estacao"});

    public ExamesRecoleta() {
        this.montaBarraDescricao("Exames com recoleta", "Gr\u00e1fico dos exames com recoleta", "consultas/grafico_acumulado_recoleta.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", PARAMETRO_MEDICO, "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCheck("filtroIntervaloHora", "Intervalo de hora", false);
        this.adicionaFiltroCheck("filtroMostrarRecoletasRealizadas", "Mostrar recoletas realizadas", false);
        this.adicionaFiltroCheck("filtroMostrarDadosMensais", "Mostrar dados mensais", false);
        this.adicionaFiltroCheck("filtroLegendaGrafico", "Exibe legenda no gr\u00e1fico", false);
        this.adicionaNomeVariavel("imagemGrafico");
        this.adicionaNomeVariavel("totalExames");
        this.montaTela();
        this.setModuloConfigurar(ExamesRecoleta.getModuloConfigurar());
        this.setModuloAcesso(ExamesRecoleta.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700501900");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700501901");
    }

    public ArrayList<String> retornaExames() {
        boolean totalExamesRecoleta = false;
        ArrayList<String> arrayExames = new ArrayList<String>();
        try {
            String[] setores;
            String[] materiais;
            String[] exames;
            String[] coletas;
            String[] convenio;
            String[] destinos;
            StringBuilder buf = new StringBuilder("SELECT count(a.ers_codigo) as qtdeExamesMarcadosRecoleta, count(distinct a.req_codigo) as qtdeRequisicoes,");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append(" ,cast(a.ers_datahora as date) as dataExameSituacao ");
            buf.append("FROM examerequisicaosituacoes as a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" join requisicao req ON req.fil_codigo = a.fil_codigo AND req.req_codigo = a.req_codigo");
            buf.append("   join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("   join examesetor exmsetor on a.fil_codigo = exmsetor.fil_codigo and a.exa_codigo = exmsetor.exa_codigo and exmsetor.ese_default = true ");
            buf.append("   join setores setor on  exmsetor.set_codigo = setor.set_codigo and a.fil_codigo = setor.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            buf.append(" AND a.ers_situacao = '").append("R").append("'");
            if (!this.getFiltroCheck("filtroIntervaloHora")) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append("  and cast(ers_datahora as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append("  and cast(ers_datahora as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and date_trunc('minute',cast(ers_datahora as time)) >= '");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and date_trunc('minute',cast(ers_datahora as time)) <= '");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append("  and cast(ers_datahora as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial"))).append(" ");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append("  and cast(ers_datahora as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal"))).append(" ");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                buf.append(" and req.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    buf.append("'");
                    buf.append(destinos[i]);
                    buf.append("'");
                    if (i >= destinos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((convenio = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and req.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and req.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(coletas[i]));
                    if (i >= coletas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((exames = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                buf.append(" and a.exa_codigo in (");
                for (int i = 0; i < exames.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(exames[i]));
                    if (i >= exames.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((materiais = this.getSelecionadosFiltro("filtroMaterial", 0)) != null) {
                buf.append(" and a.mco_codigo in (");
                for (int i = 0; i < materiais.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(materiais[i]));
                    if (i >= materiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((setores = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and setor.set_codigo in (");
                for (int i = 0; i < setores.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(setores[i]));
                    if (i >= setores.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    buf.append("(req.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and req.med_crm = '");
                    buf.append(crm[i]);
                    buf.append("' and req.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= crm.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(")");
            }
            buf.append(" GROUP BY cast(ers_datahora as date),");
            buf.append(" filial.fil_descricao,filial.fil_codigo,cidadefilial.cid_codigo,cidadefilial.cid_nome,cidadefilial.cid_uf,bairrofilial.bai_codigo,");
            buf.append("bairrofilial.bai_descricao ORDER BY ");
            buf.append(" cast(ers_datahora as date)");
            Statement st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    do {
                        arrayExames.add(rs.getString("dataExameSituacao"));
                    } while (rs.next());
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoPorConvenio");
            }
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        return arrayExames;
    }

    @Override
    public void consultarGrafico() {
        int totalExamesRecoleta = 0;
        if (this.getFiltroCheck("filtroIntervaloHora") && (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial")) || Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial")) || Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) || Funcoes.textoVazio(this.getFiltroHora("filtroHoraFinal")))) {
            Funcoes.mensagem(this, "Os campos de Data e Hora devem ser preenchidos.", 2);
            this.habilitaBotaoConsultar(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        try {
            String[] setores;
            String[] materiais;
            String[] exames;
            String[] coletas;
            String[] convenio;
            String[] destinos;
            StringBuilder buf = new StringBuilder("SELECT count(a.ers_codigo) as qtdeExamesMarcadosRecoleta, count(distinct a.req_codigo) as qtdeRequisicoes,");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            if (!this.getFiltroCheck("filtroMostrarDadosMensais")) {
                buf.append(" ,cast(a.ers_datahora as date) as dataExameSituacao ");
            } else {
                buf.append(" ,to_char(ers_datahora,'MM') || '/' || to_char(ers_datahora,'yyyy') AS dataExameSituacao ");
            }
            buf.append("FROM examerequisicaosituacoes as a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" join requisicao req ON req.fil_codigo = a.fil_codigo AND req.req_codigo = a.req_codigo");
            buf.append("   join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("   join examesetor exmsetor on a.fil_codigo = exmsetor.fil_codigo and a.exa_codigo = exmsetor.exa_codigo and exmsetor.ese_default = true ");
            buf.append("   join setores setor on  exmsetor.set_codigo = setor.set_codigo and a.fil_codigo = setor.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            buf.append(" AND a.ers_situacao = '").append("R").append("'");
            if (!this.getFiltroCheck("filtroIntervaloHora")) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append("  and cast(ers_datahora as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append("  and cast(ers_datahora as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and date_trunc('minute',cast(ers_datahora as time)) >= '");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and date_trunc('minute',cast(ers_datahora as time)) <= '");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append("  and cast(ers_datahora as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial"))).append(" ");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append("  and cast(ers_datahora as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal"))).append(" ");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                buf.append(" and req.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    buf.append("'");
                    buf.append(destinos[i]);
                    buf.append("'");
                    if (i >= destinos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((convenio = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and req.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and req.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(coletas[i]));
                    if (i >= coletas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((exames = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                buf.append(" and a.exa_codigo in (");
                for (int i = 0; i < exames.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(exames[i]));
                    if (i >= exames.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((materiais = this.getSelecionadosFiltro("filtroMaterial", 0)) != null) {
                buf.append(" and a.mco_codigo in (");
                for (int i = 0; i < materiais.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(materiais[i]));
                    if (i >= materiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((setores = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and setor.set_codigo in (");
                for (int i = 0; i < setores.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(setores[i]));
                    if (i >= setores.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    buf.append("(req.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and req.med_crm = '");
                    buf.append(crm[i]);
                    buf.append("' and req.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= crm.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(")");
            }
            if (!this.getFiltroCheck("filtroMostrarDadosMensais")) {
                buf.append(" GROUP BY cast(ers_datahora as date),");
            } else {
                buf.append(" GROUP BY to_char(ers_datahora,'MM'),to_char(ers_datahora,'yyyy'),");
            }
            buf.append(" filial.fil_descricao,filial.fil_codigo,cidadefilial.cid_codigo,cidadefilial.cid_nome,cidadefilial.cid_uf,bairrofilial.bai_codigo,");
            buf.append("bairrofilial.bai_descricao ORDER BY ");
            if (!this.getFiltroCheck("filtroMostrarDadosMensais")) {
                buf.append(" cast(ers_datahora as date)");
            } else {
                buf.append(" To_char(ers_datahora, 'MM'),To_char(ers_datahora, 'yyyy')");
            }
            Statement st = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                ArrayList<Object> arrayExames = new ArrayList();
                Map<Object, Object> mapExamesrecoletas = new HashMap();
                if (this.getFiltroCheck("filtroMostrarRecoletasRealizadas")) {
                    mapExamesrecoletas = this.retornaqtdeExamesRecoletados();
                }
                if (this.getFiltroCheck("filtroMostrarDadosMensais")) {
                    arrayExames = this.retornaExames();
                }
                if (rs.next()) {
                    DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    String recoletasMarcadas = "Recoletas marcadas";
                    String recoletasRealizadas = "Recoletas realizadas";
                    do {
                        String data = "";
                        data = this.getFiltroCheck("filtroMostrarDadosMensais") ? rs.getString("dataExameSituacao") : Funcoes.formataData("dd/MM", rs.getDate("dataExameSituacao"));
                        dataset.addValue((double)rs.getInt("qtdeExamesMarcadosRecoleta"), (Comparable)((Object)recoletasMarcadas), (Comparable)((Object)data));
                        int somaExames = 0;
                        if (this.getFiltroCheck("filtroMostrarRecoletasRealizadas")) {
                            if (this.getFiltroCheck("filtroMostrarDadosMensais")) {
                                for (Map.Entry<Object, Object> entrada : mapExamesrecoletas.entrySet()) {
                                    String mes = rs.getString("dataExameSituacao").substring(0, 2);
                                    String mes2 = ((String)entrada.getKey()).toString();
                                    if (!mes.equals(mes2 = mes2.substring(5, 7))) continue;
                                    for (String string : arrayExames) {
                                        if (!((String)entrada.getKey()).toString().equals(string)) continue;
                                        somaExames += ((Integer)entrada.getValue()).intValue();
                                    }
                                }
                                if (somaExames > 0) {
                                    dataset.addValue((double)somaExames, (Comparable)((Object)recoletasRealizadas), (Comparable)((Object)data));
                                }
                            } else {
                                dataset.addValue((Number)mapExamesrecoletas.get(rs.getString("dataExameSituacao")), (Comparable)((Object)recoletasRealizadas), (Comparable)((Object)data));
                            }
                        }
                        totalExamesRecoleta += rs.getInt("qtdeExamesMarcadosRecoleta");
                        Object[] o = new Object[campos.length];
                        for (int i = 0; i < campos.length; ++i) {
                            if (campos[i] == "qtdeExamesRecoletados") {
                                if (!this.getFiltroCheck("filtroMostrarDadosMensais")) {
                                    o[i] = mapExamesrecoletas.containsKey(rs.getString("dataExameSituacao")) ? mapExamesrecoletas.get(rs.getString("dataExameSituacao")) : Integer.valueOf(0);
                                    continue;
                                }
                                o[i] = somaExames;
                                continue;
                            }
                            o[i] = campos[i] == "estacao" ? Variaveis.codigoEstacao : rs.getObject(campos[i]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    JFreeChart chart = ChartFactory.createBarChart((String)"Exames com recoleta", (String)"Data", (String)"Exames", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.getFiltroCheck("filtroLegendaGrafico"), (boolean)true, (boolean)true);
                    CategoryPlot plot = (CategoryPlot)chart.getPlot();
                    plot.getRenderer().setBaseItemLabelsVisible(true);
                    plot.getRenderer().setLabelGenerator((CategoryLabelGenerator)new StandardCategoryLabelGenerator());
                    plot.getRenderer().setItemLabelFont(this.getFonteLegenda());
                    plot.getDomainAxis().setTickLabelFont(plot.getDomainAxis().getTickLabelFont().deriveFont(7.0f));
                    TextTitle subtitulo = new TextTitle("Total de exames com recoleta: " + totalExamesRecoleta, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    }
                    if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                        var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    }
                    if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                        var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    }
                    var.put("filtroFilial", this.getSelecionadosFiltro("filtroFilial", 0));
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (int i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (int i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    if (coletas != null) {
                        buf.delete(0, buf.length());
                        for (int i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroColeta", buf.toString());
                    }
                    if (exames != null) {
                        buf.delete(0, buf.length());
                        for (int i = 0; i < exames.length; ++i) {
                            buf.append(exames[i]);
                            if (i >= exames.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroExame", buf.toString());
                    }
                    if (materiais != null) {
                        buf.delete(0, buf.length());
                        for (int i = 0; i < materiais.length; ++i) {
                            buf.append(materiais[i]);
                            if (i >= materiais.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroMaterial", buf.toString());
                    }
                    if (setores != null) {
                        buf.delete(0, buf.length());
                        for (int i = 0; i < setores.length; ++i) {
                            buf.append(setores[i]);
                            if (i >= setores.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroSetor", buf.toString());
                    }
                    buf.delete(0, buf.length());
                    if (conselho != null && crm != null && uf != null) {
                        for (int i = 0; i < crm.length; ++i) {
                            buf.append(conselho[i]).append(": ");
                            buf.append(crm[i]);
                            buf.append("(");
                            buf.append(uf[i]);
                            buf.append(")");
                            if (i >= crm.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    Paint bgColor = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    var.put("totalExames", totalExamesRecoleta);
                    var.put("filtroMostrarRecoletasRealizadas", this.getFiltroCheck("filtroMostrarRecoletasRealizadas"));
                    chart.setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(ExamesRecoleta.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                ExamesRecoleta.this.panelCentro.removeAll();
                                ExamesRecoleta.this.panelCentro.repaint();
                                ExamesRecoleta.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoPorConvenio");
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private Map<String, Integer> retornaqtdeExamesRecoletados() {
        try {
            String[] setores;
            String[] materiais;
            String[] exames;
            String[] coletas;
            String[] convenio;
            String[] destinos;
            HashMap<String, Integer> mapExamesRecoletados = new HashMap<String, Integer>();
            StringBuilder buf = new StringBuilder("SELECT count(a.ers_codigo) qtdeExamesRecoletados,");
            buf.append(" cast(a.ers_datahora as date) as dataExame, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("FROM examerequisicaosituacoes a");
            buf.append(" JOIN requisicao req ON req.fil_codigo = a.fil_codigo AND req.req_codigo = a.req_codigo");
            buf.append("   join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("   join examesetor exmsetor on a.fil_codigo = exmsetor.fil_codigo and a.exa_codigo = exmsetor.exa_codigo and exmsetor.ese_default = true ");
            buf.append("   join setores setor on  exmsetor.set_codigo = setor.set_codigo and a.fil_codigo = setor.fil_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" where a.fil_codigo in (");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            buf.append(" AND a.ers_situacao = '").append("C").append("'");
            buf.append(" AND a.exa_codigo IN( SELECT exa_codigo FROM examerequisicaosituacoes e WHERE e.fil_codigo = a.fil_codigo AND");
            buf.append(" e.exa_codigo = a.exa_codigo AND");
            buf.append(" e.ers_situacao = '").append("R").append("')");
            if (!this.getFiltroCheck("filtroIntervaloHora")) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append("  and cast(ers_datahora as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append("  and cast(ers_datahora as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and date_trunc('minute',cast(ers_datahora as time)) >= '");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and date_trunc('minute',cast(ers_datahora as time)) <= '");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append("  and cast(ers_datahora as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")) + " " + this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append("  and cast(ers_datahora as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")) + " " + this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                buf.append(" and req.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    buf.append("'");
                    buf.append(destinos[i]);
                    buf.append("'");
                    if (i >= destinos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((convenio = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and req.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and req.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(coletas[i]));
                    if (i >= coletas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((exames = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                buf.append(" and a.exa_codigo in (");
                for (int i = 0; i < exames.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(exames[i]));
                    if (i >= exames.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((materiais = this.getSelecionadosFiltro("filtroMaterial", 0)) != null) {
                buf.append(" and a.mco_codigo in (");
                for (int i = 0; i < materiais.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(materiais[i]));
                    if (i >= materiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((setores = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and setor.set_codigo in (");
                for (int i = 0; i < setores.length; ++i) {
                    buf.append(StringUtil.textoDBEscape(setores[i]));
                    if (i >= setores.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] conselho = this.getSelecionadosFiltro("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltro("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltro("filtroMedico", 2);
            if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    buf.append("(req.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and req.med_crm = '");
                    buf.append(crm[i]);
                    buf.append("' and req.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= crm.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(")");
            }
            buf.append(" GROUP BY cast(ers_datahora as date)");
            buf.append(",filial.fil_descricao,filial.fil_codigo,cidadefilial.cid_codigo,cidadefilial.cid_nome,cidadefilial.cid_uf,bairrofilial.bai_codigo,");
            buf.append("bairrofilial.bai_descricao ");
            buf.append("ORDER BY ");
            buf.append(" cast(ers_datahora as date)");
            Statement st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    do {
                        mapExamesRecoletados.put(rs.getString("dataExame"), rs.getInt("qtdeExamesRecoletados"));
                    } while (rs.next());
                }
                rs.close();
                return mapExamesRecoletados;
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                Conexao.fecharStatement(st);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        return null;
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }
}

