/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;

public class ExamesRealizadosAtraso
extends FrmGraficoPadrao
implements ConsultarGraficoListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_EXAMES = "filtroExames";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_MATERIAL_COLETADO = "filtroMaterialColetado";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DATA = "filtroOpcaoData";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private final String FILTRO_APENAS_CONFERIDO = "apenasConferido";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    private final Boolean AVISAR_ENTREGA = false;
    private final String FILTRO_ALA = "filtroAla";
    private final String FILTRO_QUARTO = "filtroQuarto";
    private final String FILTRO_LEITO = "filtroLeito";
    private final String FILTRO_PRONTUARIO = "filtroProntuario";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"contagem", "contagemExamesRealizados", "codigoExame", "descricaoExame", "codigoMaterial", "descricaoMaterial"});
    public static final String[] camposData = new String[]{"a.exr_datadigita", "a.exr_dataassina", "a.exr_dataentregaprev", "a.exr_datamaterial"};
    public static final String[] opcaoData = new String[]{"Digita\u00e7\u00e3o", "Confer\u00eancia", "Prevista", "Coleta"};
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Qtde. Atrasados"};

    public ExamesRealizadosAtraso() {
        this.montaBarraDescricao("Exames Realizados em Atraso", "Gr\u00e1fico de Exames realizados em atraso", "consultas/cons_grafico_atraso.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExames", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterialColetado", "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroAla", "Ala", "alahospital", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ala_codigo", "ala_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroTexto("filtroQuarto", "Quarto:", 5);
        this.adicionaFiltroTexto("filtroLeito", "Leito:", 5);
        this.adicionaFiltroTexto("filtroProntuario", "Prontu\u00e1rio:", 120);
        this.adicionaFiltroCombo("filtroOpcaoData", "Campo data:", opcaoData, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroIntervaloHora", "Intervalo de hora", false);
        this.adicionaFiltroCheck("apenasConferido", "Apenas conferidos", false);
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(ExamesRealizadosAtraso.getModuloConfigurar());
        this.setModuloAcesso(ExamesRealizadosAtraso.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void consultarGrafico() {
        if (this.getFiltroCheck("filtroIntervaloHora") && (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial")) || Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial")) || Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) || Funcoes.textoVazio(this.getFiltroHora("filtroHoraFinal")))) {
            Funcoes.mensagem(this, "Os campos de Data e Hora devem ser preenchidos.", 2);
            this.habilitaBotaoConsultar(true);
            return;
        }
        int total = 0;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        try {
            String[] coletas;
            String[] alas;
            String[] setores;
            String[] convenios;
            String[] destinos;
            String[] filtroColetas;
            String[] exame;
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT TAB.contagem, ");
            buf.append("       TAB.contagemExamesRealizados as contagemExamesRealizados, ");
            buf.append("       TAB.codigoExame,");
            buf.append("       TAB.descricaoExame,");
            buf.append("       TAB.codigoMaterial,");
            buf.append("       TAB.descricaoMaterial,");
            buf.append("       TAB.codigoFilial,");
            buf.append("       TAB.descricaoFilial,");
            buf.append("       TAB.cnpjFilial,");
            buf.append("       TAB.enderecoFilial,");
            buf.append("       TAB.complementoFilial,");
            buf.append("       TAB.cepFilial,");
            buf.append("       TAB.foneFilial,");
            buf.append("       TAB.faxFilial,");
            buf.append("       TAB.razaoSocialFilial,");
            buf.append("       TAB.CNESFilial,");
            buf.append("       TAB.codigoCidadeFilial,");
            buf.append("       TAB.descricaoCidadeFilial,");
            buf.append("       TAB.estadoCidadeFilial,");
            buf.append("       TAB.codigoBairroFilial,");
            buf.append("       TAB.descricaoBairroFilial");
            buf.append(" FROM (");
            buf.append(" select count(DISTINCT (cast(ab.fil_codigo AS text)||ab.req_codigo||exa.exa_codigo||mco.mco_codigo)) AS contagem, ");
            buf.append(" \t\tcount(a.exa_codigo) AS contagemExamesRealizados, ");
            buf.append(" \t\texa.exa_codigo as codigoExame, exa.exa_descricao as descricaoExame, ");
            buf.append(" \t\tmco.mco_codigo as codigoMaterial, mco.mco_descricao as descricaoMaterial, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append(" FROM examerequisicao a ");
            buf.append("    left join examerequisicao ab on ab.fil_codigo = a.fil_codigo and ab.req_codigo = a.req_codigo and ab.exa_codigo = a.exa_codigo AND (a.exr_dataentregaprev < a.exr_datadigita OR a.exr_dataentregaprev < a.exr_dataassina)");
            buf.append("    left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("\t\t\t\t join exames exa on a.fil_codigo = exa.fil_codigo and a.exa_codigo = exa.exa_codigo ");
            buf.append("\t\tleft join materialcoleta mco on a.fil_codigo = mco.fil_codigo and a.mco_codigo = mco.mco_codigo ");
            buf.append("    left join examesetor es on ab.fil_codigo = es.fil_codigo and ab.exa_codigo = es.exa_codigo and es.ese_default ");
            buf.append("    left join setores st on es.fil_codigo = st.fil_codigo and es.set_codigo = st.set_codigo ");
            buf.append("    left join alahospital ala on b.fil_codigo = ala.fil_codigo and b.ala_codigo = ala.ala_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            if (this.getFiltroCheck("apenasConferido")) {
                buf.append(" and ab.exr_situacao = 'C' ");
            }
            if (!this.getFiltroCheck("filtroIntervaloHora")) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append("  and cast(").append(camposData[this.getFiltroComboIndice("filtroOpcaoData")]).append(" as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append("  and cast(").append(camposData[this.getFiltroComboIndice("filtroOpcaoData")]).append(" as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and date_trunc('minute',cast(").append(camposData[this.getFiltroComboIndice("filtroOpcaoData")]).append(" as time)) >= '");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and date_trunc('minute',cast(").append(camposData[this.getFiltroComboIndice("filtroOpcaoData")]).append(" as time)) <= '");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append("  and cast(").append(camposData[this.getFiltroComboIndice("filtroOpcaoData")]).append(" as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")) + " " + this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append("  and cast(").append(camposData[this.getFiltroComboIndice("filtroOpcaoData")]).append(" as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")) + " " + this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
            }
            if ((exame = this.getSelecionadosFiltro("filtroExames", 0)) != null) {
                buf.append(" and exa.exa_codigo in (");
                for (int i = 0; i < exame.length; ++i) {
                    buf.append("'");
                    buf.append(exame[i]);
                    buf.append("'");
                    if (i >= exame.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((filtroColetas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and b.col_codigo in (");
                for (int i = 0; i < filtroColetas.length; ++i) {
                    buf.append("'");
                    buf.append(filtroColetas[i]);
                    buf.append("'");
                    if (i >= filtroColetas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                buf.append(" and b.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    buf.append("'");
                    buf.append(destinos[i]);
                    buf.append("'");
                    if (i >= destinos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((convenios = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and b.con_codigo in (");
                for (int i = 0; i < convenios.length; ++i) {
                    buf.append(convenios[i]);
                    if (i >= convenios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((setores = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and st.set_codigo in (");
                for (int i = 0; i < setores.length; ++i) {
                    buf.append(setores[i]);
                    if (i >= setores.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((alas = this.getSelecionadosFiltro("filtroAla", 0)) != null) {
                buf.append(" and ala.ala_codigo in (");
                for (int i = 0; i < alas.length; ++i) {
                    buf.append("'");
                    buf.append(alas[i]);
                    buf.append("'");
                    if (i >= alas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (!Funcoes.textoVazio(this.getFiltroTexto("filtroQuarto"))) {
                buf.append(" and b.req_quarto ilike '");
                buf.append(this.getFiltroTexto("filtroQuarto"));
                buf.append("'");
            }
            if (!Funcoes.textoVazio(this.getFiltroTexto("filtroLeito"))) {
                buf.append(" and b.req_leito ilike '");
                buf.append(this.getFiltroTexto("filtroLeito"));
                buf.append("'");
            }
            if (!Funcoes.textoVazio(this.getFiltroTexto("filtroProntuario"))) {
                buf.append(" and b.req_prontuario ilike '");
                buf.append(this.getFiltroTexto("filtroProntuario"));
                buf.append("'");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroMaterialColetado", 0)) != null) {
                buf.append(" and mco.mco_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    buf.append(coletas[i]);
                    if (i >= coletas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(" and not a.exr_excluido ");
            buf.append(" and coalesce(a.exr_avisarentrega, false) = ").append(this.AVISAR_ENTREGA);
            buf.append(" group by a.exa_codigo, ");
            buf.append(" \t\texa.exa_codigo, exa.exa_descricao, ");
            buf.append(" \t\tmco.mco_codigo,   mco.mco_descricao, ");
            buf.append(StringUtil.arrayParaString(Constantes.CAMPOS_FILIAL));
            buf.append(" order by filial.fil_codigo ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[0])) {
                buf.append(" ,a.exa_codigo asc ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append(" ,upper(to_ascii(exa.exa_descricao)) asc ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append(" ,contagem asc ");
            }
            buf.append(" )AS TAB WHERE TAB.CONTAGEM > 0");
            Statement st = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                boolean qtdeTotal = false;
                if (rs.next()) {
                    int i;
                    do {
                        total += rs.getInt("contagem");
                    } while (rs.next());
                    DefaultPieDataset pie = new DefaultPieDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    rs.first();
                    do {
                        if (this.existeRegistros(pie.getIndex((Comparable)((Object)rs.getString("codigoExame"))))) {
                            pie.setValue((Comparable)((Object)rs.getString("codigoExame")), (double)(pie.getValue((Comparable)((Object)rs.getString("codigoExame"))).intValue() + rs.getInt("contagem")));
                        } else {
                            pie.setValue((Comparable)((Object)rs.getString("codigoExame")), (double)rs.getInt("contagem"));
                        }
                        Object[] o = new Object[campos.length];
                        for (int i2 = 0; i2 < campos.length; ++i2) {
                            o[i2] = rs.getObject(campos[i2]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    NumberFormat nfp = NumberFormat.getPercentInstance();
                    nfp.setMinimumFractionDigits(0);
                    nfp.setMaximumFractionDigits(2);
                    PiePlot plot = new PiePlot((PieDataset)pie);
                    StandardPieItemLabelGenerator labels = new StandardPieItemLabelGenerator("{0}: ({1}) {2}", nf, nfp);
                    plot.setLabelGenerator((PieSectionLabelGenerator)labels);
                    plot.setLabelFont(this.getFonteLegenda());
                    JFreeChart chart = new JFreeChart("Exames Realizados em atraso", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                    TextTitle subtitulo = new TextTitle("Total de exames: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroOpcaoData", this.getFiltroCombo("filtroOpcaoData"));
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    }
                    buf.delete(0, buf.length());
                    if (alas != null) {
                        for (i = 0; i < alas.length; ++i) {
                            buf.append(alas[i]);
                            if (i >= alas.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroAla", buf.toString());
                    var.put("filtroQuarto", this.getFiltroTexto("filtroQuarto"));
                    var.put("filtroLeito", this.getFiltroTexto("filtroLeito"));
                    var.put("filtroProntuario", this.getFiltroTexto("filtroProntuario"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (exame != null) {
                        for (i = 0; i < exame.length; ++i) {
                            buf.append(exame[i]);
                            if (i >= exame.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroExames", buf.toString());
                    buf.delete(0, buf.length());
                    if (filtroColetas != null) {
                        for (i = 0; i < filtroColetas.length; ++i) {
                            buf.append(filtroColetas[i]);
                            if (i >= filtroColetas.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenios != null) {
                        for (i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (setores != null) {
                        for (i = 0; i < setores.length; ++i) {
                            buf.append(setores[i]);
                            if (i >= setores.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroMaterialColetado", buf.toString());
                    Paint bgColor = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    chart.setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(ExamesRealizadosAtraso.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                ExamesRealizadosAtraso.this.panelCentro.removeAll();
                                ExamesRealizadosAtraso.this.panelCentro.repaint();
                                ExamesRealizadosAtraso.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoPorConvenio");
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoPorConvenio");
        }
    }

    private boolean existeRegistros(int quantidade) {
        return quantidade >= 0;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700501200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700501201");
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }
}

