/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;

public class ExamesPorMedico
extends FrmGraficoPadrao
implements ConsultarGraficoListener {
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_LEGENDA = "filtroLegendaGrafico";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    private final String FILTRO_REALIZADOS = "filtroRealizados";
    private final String FILTRO_AGRUPAR_ABAIXO_UM = "filtroAgruparAbaixoUm";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"contagem", "codigoMedico", "nomeMedico", "conselhoMedico", "ufMedico", "crmMedico"});

    public ExamesPorMedico() {
        this.montaBarraDescricao("Exames por m\u00e9dico", "Gr\u00e1fico de exames por m\u00e9dico", "consultas/cons_exames_por_medico.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCheck("filtroRealizados", "Somente realizados", false);
        this.adicionaFiltroCheck("filtroLegendaGrafico", "Exibe legenda no gr\u00e1fico", false);
        this.adicionaFiltroCheck("filtroAgruparAbaixoUm", "Agrupar abaixo de 1%", true);
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(ExamesPorMedico.getModuloConfigurar());
        this.setModuloAcesso(ExamesPorMedico.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void consultarGrafico() {
        int total = 0;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        try {
            String[] coletas;
            String[] estacoes;
            StringBuilder buf = new StringBuilder("select count(distinct (cast(a.fil_codigo as text)||a.req_codigo||c.exa_codigo||c.mco_codigo)) as contagem, a.med_conselho ||a.med_crm|| a.med_uf as codigoMedico, b.med_nome as nomeMedico, ");
            buf.append("a.med_conselho as conselhoMedico,");
            buf.append("a.med_crm as crmMedico, ");
            buf.append("a.med_uf as ufMedico, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from requisicao a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("left join medico b on a.fil_codigo = b.fil_codigo and a.med_crm = b.med_crm and a.med_conselho = b.med_conselho and a.med_uf = b.med_uf ");
            buf.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.req_excluida = false ");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" and a.req_data >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" and a.req_data <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if (this.getFiltroCheck("filtroRealizados")) {
                buf.append(" and c.exr_situacao not in ('");
                buf.append("T");
                buf.append("', '");
                buf.append("A");
                buf.append("', '");
                buf.append("F");
                buf.append("', '").append("R");
                buf.append("', '', ' ') and c.exr_situacao is not null ");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    buf.append("(a.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and a.med_crm = '");
                    buf.append(crm[i]);
                    buf.append("' and a.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= crm.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(")");
            }
            if ((estacoes = this.getSelecionadosFiltro("filtroEstacao", 0)) != null) {
                buf.append(" and a.est_codigo in (");
                for (int i = 0; i < estacoes.length; ++i) {
                    buf.append(estacoes[i]);
                    if (i >= estacoes.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and a.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    buf.append("'");
                    buf.append(coletas[i]);
                    buf.append("'");
                    if (i >= coletas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(" group by codigoMedico, a.med_conselho,a.med_crm,a.med_uf, b.med_nome,  ").append(StringUtil.arrayParaString(Constantes.CAMPOS_FILIAL));
            buf.append(" order by b.med_nome ");
            Statement st = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                boolean qtdeTotal = false;
                if (rs.next()) {
                    int i;
                    DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    do {
                        total += rs.getInt("contagem");
                    } while (rs.next());
                    int outros = 0;
                    rs.first();
                    do {
                        if (this.getFiltroCheck("filtroAgruparAbaixoUm") && rs.getInt("contagem") * 100 / total < 1) {
                            outros += rs.getInt("contagem");
                        } else if (this.getFiltroCheck("filtroLegendaGrafico")) {
                            dataset.addValue((double)rs.getInt("contagem"), (Comparable)((Object)rs.getString("nomeMedico")), (Comparable)((Object)""));
                        } else {
                            dataset.addValue((double)rs.getInt("contagem"), (Comparable)((Object)""), (Comparable)((Object)rs.getString("nomeMedico")));
                        }
                        Object[] o = new Object[campos.length];
                        for (int i2 = 0; i2 < campos.length; ++i2) {
                            o[i2] = rs.getObject(campos[i2]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (this.getFiltroCheck("filtroAgruparAbaixoUm") && outros > 0) {
                        if (this.getFiltroCheck("filtroLegendaGrafico")) {
                            dataset.addValue((double)outros, (Comparable)((Object)"Outros"), (Comparable)((Object)""));
                        } else {
                            dataset.addValue((double)outros, (Comparable)((Object)""), (Comparable)((Object)"Outros"));
                        }
                    }
                    JFreeChart chart = ChartFactory.createBarChart((String)"Exames por m\u00e9dico", (String)"M\u00e9dicos", (String)"Exames", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.getFiltroCheck("filtroLegendaGrafico"), (boolean)true, (boolean)true);
                    CategoryPlot plot = (CategoryPlot)chart.getPlot();
                    plot.getRenderer().setBaseItemLabelsVisible(true);
                    plot.getRenderer().setLabelGenerator((CategoryLabelGenerator)new StandardCategoryLabelGenerator());
                    plot.getRenderer().setItemLabelFont(this.getFonteLegenda());
                    plot.getDomainAxis().setTickLabelFont(plot.getDomainAxis().getTickLabelFont().deriveFont(7.0f));
                    TextTitle subtitulo = new TextTitle("Total de exames: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    }
                    var.put("filtroRealizados", this.getFiltroCheck("filtroRealizados"));
                    buf.delete(0, buf.length());
                    if (conselho != null && crm != null && uf != null) {
                        for (i = 0; i < crm.length; ++i) {
                            buf.append(conselho[i]).append(": ");
                            buf.append(crm[i]);
                            buf.append("(");
                            buf.append(uf[i]);
                            buf.append(")");
                            if (i >= crm.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    if (estacoes != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < estacoes.length; ++i) {
                            buf.append(estacoes[i]);
                            if (i >= estacoes.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroEstacao", buf.toString());
                    }
                    if (coletas != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroColeta", buf.toString());
                    }
                    Paint bgColor = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    chart.setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(ExamesPorMedico.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                ExamesPorMedico.this.panelCentro.removeAll();
                                ExamesPorMedico.this.panelCentro.repaint();
                                ExamesPorMedico.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ExamesPorMedico");
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ExamesPorMedico");
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700500900");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700500901");
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }
}

