/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.consultas.graficos.CampoLegenda;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DialogoConfigurarLegenda
extends AbstractDialogoOKCancelar
implements ActionListener,
FocusListener {
    private JCheckBox checkOcultar = ComponenteFactory.novoJCheckBox("Ocultar campo/legenda", this);
    private JComboBox comboCampos = new JComboBox();
    private TTextField textLegenda = new TTextField(50);

    public DialogoConfigurarLegenda(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(400, 140));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.textLegenda.addFocusListener(this);
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        panelCentral.add((Component)new JLabel("Campo:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.comboCampos.setPreferredSize(new Dimension(100, 20));
        this.comboCampos.setMinimumSize(new Dimension(100, 20));
        panelCentral.add((Component)this.comboCampos, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        panelCentral.add((Component)new JLabel("Legenda:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textLegenda.setPreferredSize(new Dimension(100, 20));
        this.textLegenda.setMinimumSize(new Dimension(100, 20));
        panelCentral.add((Component)this.textLegenda, c);
        ++c.gridy;
        panelCentral.add((Component)this.checkOcultar, c);
        this.comboCampos.addActionListener(this);
        this.textLegenda.addActionListener(this);
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    @Override
    public boolean acaoOk() {
        return true;
    }

    public void setCampos(ArrayList<String> campos) {
        ArrayList<CampoLegenda> temp = new ArrayList<CampoLegenda>();
        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
            CampoLegenda c = (CampoLegenda)this.comboCampos.getItemAt(i);
            temp.add(c);
        }
        for (String campo : campos) {
            CampoLegenda l = new CampoLegenda(campo, "", false);
            if (this.campoJaInserido(l, temp)) continue;
            temp.add(l);
        }
        this.comboCampos.removeAllItems();
        for (CampoLegenda c : temp) {
            this.comboCampos.addItem(c);
        }
    }

    private boolean campoJaInserido(CampoLegenda campo, ArrayList<CampoLegenda> campos) {
        if (campo == null) {
            return true;
        }
        for (CampoLegenda c : campos) {
            if (c.campo == null || !c.campo.equalsIgnoreCase(campo.campo)) continue;
            return true;
        }
        return false;
    }

    public void setXML(String xml) {
        if (xml == null || Funcoes.textoVazio(StringUtil.getValor(xml, "config-legendas"))) {
            return;
        }
        ArrayList<CampoLegenda> temp = new ArrayList<CampoLegenda>();
        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
            CampoLegenda c = (CampoLegenda)this.comboCampos.getItemAt(i);
            temp.add(c);
        }
        String[] campos = StringUtil.getValores(xml, "campo");
        for (String c : campos) {
            boolean ocultar;
            String legenda;
            String id = StringUtil.getValor(c, "id");
            CampoLegenda l = new CampoLegenda(id, legenda = StringUtil.getValor(c, "texto"), ocultar = StringUtil.getBoolean(c, "oculto"));
            if (this.campoJaInserido(l, temp)) continue;
            temp.add(l);
        }
        this.comboCampos.removeAllItems();
        for (CampoLegenda c : temp) {
            this.comboCampos.addItem(c);
        }
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<config-legendas>");
        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
            CampoLegenda c = (CampoLegenda)this.comboCampos.getItemAt(i);
            buf.append("<campo>");
            buf.append("<id>").append(c.campo).append("</id>");
            buf.append("<texto>").append(c.legenda).append("</texto>");
            buf.append("<oculto>").append(c.ocultar ? "true" : "false").append("</oculto>");
            buf.append("</campo>");
        }
        buf.append("</config-legendas>");
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboCampos) {
            this.campoSelecionado();
        } else if (e.getSource() == this.checkOcultar) {
            this.ocultarSelecionado();
        } else if (e.getSource() == this.textLegenda) {
            this.configurarLegenda();
        } else {
            if (e.getSource().equals(this.buttonOK)) {
                this.configurarLegenda();
            }
            super.actionPerformed(e);
        }
    }

    private void configurarLegenda() {
        if (this.comboCampos.getItemCount() > 0 && this.comboCampos.getSelectedItem() != null) {
            ((CampoLegenda)this.comboCampos.getSelectedItem()).legenda = this.textLegenda.getText();
        }
    }

    private void campoSelecionado() {
        if (this.comboCampos.getSelectedIndex() > -1 && this.comboCampos.getItemCount() > 0 && this.comboCampos.getSelectedItem() != null) {
            CampoLegenda l = (CampoLegenda)this.comboCampos.getSelectedItem();
            this.textLegenda.setText(l.legenda);
            this.checkOcultar.setSelected(l.ocultar);
        }
    }

    private void ocultarSelecionado() {
        this.textLegenda.setEnabled(this.checkOcultar.isSelected());
        if (this.comboCampos.getItemCount() > 0 && this.comboCampos.getSelectedItem() != null) {
            ((CampoLegenda)this.comboCampos.getSelectedItem()).ocultar = this.checkOcultar.isSelected();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.configurarLegenda();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.configurarLegenda();
    }
}

