/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

class Atualiza
extends Thread {
    boolean stop = false;
    int tempo = 1;
    Statement st;
    TimeSeries total;
    TimeSeries recebido;
    JFreeChart chart;
    TextTitle subtitulo1 = new TextTitle("Filial: ");
    TextTitle subtitulo2 = new TextTitle("Data: ");
    String filial = Variaveis.filialPadrao;
    Date data = new Date();

    public Atualiza(TimeSeries total, TimeSeries recebido, JFreeChart chart) {
        super("graficos - jalis");
        this.st = Conexao.getStatement();
        this.total = total;
        this.recebido = recebido;
        this.chart = chart;
        this.chart.setTitle("Total requisi\u00e7\u00e3o por total recebido");
        if (chart.getSubtitleCount() <= 1) {
            chart.addSubtitle((Title)this.subtitulo1);
            chart.addSubtitle((Title)this.subtitulo2);
        }
    }

    @Override
    public void run() {
        while (!this.stop) {
            this.buscaDados(this.filial, this.data, true);
        }
    }

    private void buscaDados(String filial, Date data, boolean sleep) {
        int casas = ParametrosGerais.getCasasPrecoExame();
        StringBuffer buf = new StringBuffer("select round(sum(req_total), " + casas + ") as totalRequisicao, round(sum(req_totpago), " + casas + ") as totalPago ");
        buf.append("from requisicao ");
        buf.append("where fil_codigo ");
        if (filial.indexOf(",") > 0) {
            buf.append(" in (");
            buf.append(filial);
            buf.append(")");
        } else {
            buf.append("= ");
            buf.append(filial);
        }
        if (data == null) {
            buf.append(" and req_data = current_date");
        } else {
            buf.append(" and req_data = '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", data));
            buf.append("'");
        }
        buf.append(" and req_excluida = false ");
        this.subtitulo1.setText("Filial: " + Variaveis.descricaoFilialPadrao + " (" + Variaveis.filialPadrao + ")");
        this.subtitulo2.setText("Data: " + Funcoes.formataData(new Date()));
        try {
            ResultSet rs = Conexao.executeQuery(this.st, buf.toString());
            while (rs.next()) {
                this.total.addOrUpdate((RegularTimePeriod)new Minute(new Date()), rs.getDouble("totalRequisicao"));
                this.recebido.addOrUpdate((RegularTimePeriod)new Minute(new Date()), rs.getDouble("totalPago"));
            }
            rs.close();
            if (sleep) {
                Atualiza.sleep(60000 * this.tempo);
            }
        }
        catch (SQLException exsql) {
            ErrorLogger.mostraMensagem(null, exsql.getMessage(), exsql.getStackTrace(), "TotalPorRecebido");
        }
        catch (InterruptedException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "TotalPorRecebido");
        }
    }

    public void parar() {
        this.stop = true;
    }

    public void atualizar() {
        this.buscaDados(this.filial, this.data, false);
    }

    public void setFilial(String filial) {
        this.filial = filial;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public void finalize() {
        if (this.st != null) {
            try {
                this.st.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "TotalPorRecebido");
            }
        }
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }
}

