/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.consultas.graficos.DadosGrafico;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.DefaultCategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.TextAnchor;

public class AcumuladoColetaExame
extends FrmGraficoPadrao {
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MES_INICIAL = "filtroMesInicial";
    private final String FILTRO_ANO_INICIAL = "filtroAnoInicial";
    private final String FILTRO_MES_FINAL = "filtroMesFinal";
    private final String FILTRO_ANO_FINAL = "filtroAnoFinal";
    private final String FILTRO_REALIZADOS = "filtroRealizados";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"qtdeRequisicoes", "qtdeExames", "codigoColeta", "descricaoColeta", "ano", "mes"});

    public AcumuladoColetaExame() {
        this.montaBarraDescricao("Exames por coleta", "Gr\u00e1fico dos exames acumulados agrupados por coleta", "consultas/grafico_acumulado_coleta.jpg");
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroMesInicial", "M\u00eas inicial:", ConstantesGerais.MESES_ANO, 0);
        this.adicionaFiltroNumero("filtroAnoInicial", "Ano inicial:", 4);
        this.adicionaFiltroCombo("filtroMesFinal", "M\u00eas final:", ConstantesGerais.MESES_ANO, 0);
        this.adicionaFiltroNumero("filtroAnoFinal", "Ano final:", 4);
        this.adicionaFiltroCheck("filtroRealizados", "Somente realizados", false);
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(AcumuladoColetaExame.getModuloConfigurar());
        this.setModuloAcesso(AcumuladoColetaExame.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void consultarGrafico() {
        int total = 0;
        if (this.getSelecionadosFiltro("filtroColeta", 0) == null && this.getSelecionadosFiltro("filtroConvenio", 0) == null) {
            Funcoes.mensagem(this, "O filtro deve conter ao menos uma coleta e um conv\u00eanio", 2);
            return;
        }
        if (Funcoes.textoVazio(this.getFiltroNumero("filtroAnoInicial"))) {
            Funcoes.mensagem(this, "O ano inicial deve ser informado.", 2);
            return;
        }
        if (Funcoes.textoVazio(this.getFiltroNumero("filtroAnoFinal"))) {
            Funcoes.mensagem(this, "O ano final deve ser informado.", 2);
            return;
        }
        if (Integer.parseInt(this.getFiltroNumero("filtroAnoInicial")) > Integer.parseInt(this.getFiltroNumero("filtroAnoFinal"))) {
            Funcoes.mensagem(this, "A data inicial \u00e9 posterior \u00e0 data final.", 2);
            return;
        }
        if (Integer.parseInt(this.getFiltroNumero("filtroAnoInicial")) == Integer.parseInt(this.getFiltroNumero("filtroAnoFinal"))) {
            if (ArraysUtil.indice((Object[])ConstantesGerais.MESES_ANO, this.getFiltroCombo("filtroMesInicial")) > ArraysUtil.indice((Object[])ConstantesGerais.MESES_ANO, this.getFiltroCombo("filtroMesFinal"))) {
                Funcoes.mensagem(this, "A data inicial \u00e9 posterior \u00e0 data final.", 2);
                return;
            }
            if (ArraysUtil.indice((Object[])ConstantesGerais.MESES_ANO, this.getFiltroCombo("filtroMesInicial")) == ArraysUtil.indice((Object[])ConstantesGerais.MESES_ANO, this.getFiltroCombo("filtroMesFinal"))) {
                Funcoes.mensagem(this, "A data inicial \u00e9 igual \u00e0 data final.", 2);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        try {
            String[] coletas;
            String[] convenios;
            StringBuilder buf = new StringBuilder("");
            buf.append(" select count(distinct a.req_codigo) as qtdeRequisicoes ");
            buf.append("       ,count(b.exa_codigo) as qtdeExames ");
            buf.append("       ,a.col_codigo as codigoColeta ");
            buf.append("       ,c.col_descricao as descricaoColeta ");
            buf.append("       ,extract(year from a.req_data) as ano ");
            buf.append("       ,extract(month from a.req_data) as mes ");
            buf.append(" , ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("   from requisicao a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("   join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("   join coletas c on a.fil_codigo = c.fil_codigo and a.col_codigo = c.col_codigo ");
            buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and a.req_data >= '").append(this.getFiltroNumero("filtroAnoInicial")).append("-").append(ArraysUtil.indice((Object[])ConstantesGerais.MESES_ANO, this.getFiltroCombo("filtroMesInicial")) + 1).append("-01'");
            buf.append("    and a.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", Funcoes.lastDayMonth(Funcoes.getData("dd/MM/yyyy", "01/" + (ArraysUtil.indice((Object[])ConstantesGerais.MESES_ANO, this.getFiltroCombo("filtroMesFinal")) + 1) + "/" + this.getFiltroNumero("filtroAnoFinal"))))).append("'");
            if (this.getFiltroCheck("filtroRealizados")) {
                buf.append("  and b.exr_situacao not in ('");
                buf.append("T");
                buf.append("', '");
                buf.append("A");
                buf.append("', '");
                buf.append("F");
                buf.append("', '").append("R");
                buf.append("', '', ' ') and b.exr_situacao is not null ");
            }
            if ((convenios = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and a.con_codigo in (");
                for (int i = 0; i < convenios.length; ++i) {
                    buf.append(convenios[i]);
                    if (i >= convenios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and a.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    buf.append("'");
                    buf.append(coletas[i]);
                    buf.append("'");
                    if (i >= coletas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append("  and not a.req_excluida ");
            buf.append("  and not b.exr_excluido ");
            buf.append(" group by ");
            buf.append(" a.col_codigo, c.col_descricao, ano, mes, ").append(StringUtil.arrayParaString(Constantes.CAMPOS_FILIAL));
            buf.append(" order by c.col_descricao ");
            Statement st = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    do {
                        total += rs.getInt("qtdeRequisicoes");
                    } while (rs.next());
                    ArrayList<DadosGrafico> dados = new ArrayList<DadosGrafico>();
                    DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    rs.first();
                    do {
                        DadosGrafico linha = new DadosGrafico();
                        linha.ano = rs.getInt("ano");
                        linha.mes = rs.getInt("mes");
                        linha.qtdeRequisicoes = rs.getInt("qtdeRequisicoes");
                        linha.descricaoColeta = rs.getString("descricaoColeta");
                        dados.add(linha);
                        Object[] o = new Object[campos.length];
                        for (int i2 = 0; i2 < campos.length; ++i2) {
                            o[i2] = rs.getObject(campos[i2]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    Collections.sort(dados, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (o1 instanceof DadosGrafico && o2 instanceof DadosGrafico) {
                                if (((DadosGrafico)o1).ano > ((DadosGrafico)o2).ano) {
                                    return 1;
                                }
                                if (((DadosGrafico)o1).ano.equals(((DadosGrafico)o2).ano)) {
                                    if (((DadosGrafico)o1).mes > ((DadosGrafico)o2).mes) {
                                        return 1;
                                    }
                                    if (((DadosGrafico)o1).mes.equals(((DadosGrafico)o2).mes)) {
                                        return 0;
                                    }
                                    return -1;
                                }
                                return -1;
                            }
                            return 0;
                        }
                    });
                    for (DadosGrafico linha : dados) {
                        dataset.addValue((double)linha.qtdeRequisicoes, (Comparable)((Object)linha.descricaoColeta), (Comparable)((Object)linha.toString()));
                    }
                    JFreeChart chart = ChartFactory.createLineChart((String)"Exames Acumulados por Coleta", (String)"Unidades", (String)"Requisi\u00e7\u00f5es", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                    chart.setBackgroundPaint((Paint)Color.white);
                    TextTitle subtitulo = new TextTitle("Total de requisi\u00e7\u00f5es: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    DefaultCategoryItemRenderer render = new DefaultCategoryItemRenderer();
                    for (int i3 = 0; i3 < dataset.getRowCount(); ++i3) {
                        render.setSeriesShape(i3, (Shape)new Rectangle(-3, -3, 6, 6));
                        render.setSeriesItemLabelFont(i3, TextTitle.DEFAULT_FONT.deriveFont(8.0f));
                        render.setSeriesPositiveItemLabelPosition(i3, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.HALF_ASCENT_LEFT));
                    }
                    CategoryPlot plot = chart.getCategoryPlot();
                    plot.setRenderer((CategoryItemRenderer)render);
                    plot.setBackgroundPaint((Paint)Color.lightGray);
                    plot.setRangeGridlinePaint((Paint)Color.white);
                    plot.getRenderer().setBaseItemLabelsVisible(true);
                    plot.getRenderer().setLabelGenerator((CategoryLabelGenerator)new StandardCategoryLabelGenerator("{2}", NumberFormat.getNumberInstance()));
                    plot.getRenderer().setItemLabelFont(this.getFonteLegenda());
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroMesInicial", this.getFiltroCombo("filtroMesInicial"));
                    var.put("filtroAnoInicial", this.getFiltroNumero("filtroAnoInicial"));
                    var.put("filtroMesFinal", this.getFiltroCombo("filtroMesFinal"));
                    var.put("filtroAnoFinal", this.getFiltroNumero("filtroAnoFinal"));
                    var.put("filtroRealizados", this.getFiltroCheck("filtroRealizados"));
                    if (convenios != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroConvenio", buf.toString());
                    }
                    if (coletas != null) {
                        buf.delete(0, buf.length());
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroColeta", buf.toString());
                    }
                    Paint bgColor = chart.getCategoryPlot().getBackgroundPaint();
                    chart.getCategoryPlot().setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    chart.getCategoryPlot().setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(AcumuladoColetaExame.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                AcumuladoColetaExame.this.panelCentro.removeAll();
                                AcumuladoColetaExame.this.panelCentro.repaint();
                                AcumuladoColetaExame.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PercentualExameRealizado (275)");
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PercentualExameRealizado (281)");
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700500700");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0700500701");
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }
}

