/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.faturamento;

import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.EstornoCancelamentoNota;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NotaFiscalConsulta
extends FrmPadrao
implements ActionListener {
    private final int STATUS_NONE = 0;
    private final int STATUS_NOTANOTSEL = 1;
    private final int STATUS_NOTASEL = 2;
    private final int STATUS_SERIESEL = 3;
    private int status = 0;
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JPanel painelCentral = new JPanel(new GridBagLayout());
    private JLabel labelNotaFiscal = new JLabel("C\u00f3digo Nota Fiscal:");
    private TTextField textNotaFiscal = new TTextField(8, 3);
    private JButton buttonBuscaNotaFiscal = ComponenteFactory.novoJButton(this, true);
    private JButton buttonCarregarCadastro = ComponenteFactory.novoJButton("Carregar", this);
    private EstornoCancelamentoNota painelNota = null;
    private NotaFiscalBean notaFiscalBean = null;

    public NotaFiscalConsulta() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.painelCentral, "Center");
        Funcoes.montaEnter((JComponent)this.painelCentral);
        this.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonNovo, this.buttonFechar), "South");
        Funcoes.criaBarraDescricao(this, "Nota Fiscal de Sa\u00edda", "Visualiza\u00e7\u00e3o das Notas Fiscais", "consultas/consulta_fat_nf.jpg");
        this.painelCentral.setLayout(new GridBagLayout());
        this.painelNota = new EstornoCancelamentoNota("", "", false, false, "", 0.8f, true);
        this.painelNota.setBorder(BorderFactory.createEtchedBorder());
        this.painelNota.controlaCampos();
        JPanel painelPesquisa = new JPanel();
        painelPesquisa.setPreferredSize(new Dimension(100, 100));
        painelPesquisa.setLayout(new GridBagLayout());
        this.textNotaFiscal.setPreferredSize(new Dimension(100, 20));
        this.textNotaFiscal.setMinimumSize(new Dimension(100, 20));
        this.textNotaFiscal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalConsulta.this.buttonBuscaNotaFiscal.doClick();
                }
            }
        });
        this.buttonBuscaNotaFiscal.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaNotaFiscal.setMinimumSize(new Dimension(20, 20));
        this.buttonCarregarCadastro.setPreferredSize(new Dimension(80, 20));
        this.buttonCarregarCadastro.setMinimumSize(new Dimension(80, 20));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        painelPesquisa.add((Component)this.labelNotaFiscal, c);
        ++c.gridx;
        painelPesquisa.add((Component)this.textNotaFiscal, c);
        ++c.gridx;
        painelPesquisa.add((Component)this.buttonBuscaNotaFiscal, c);
        ++c.gridx;
        painelPesquisa.add((Component)this.buttonCarregarCadastro, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        painelPesquisa.add((Component)new JLabel(""), c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(4, 4, 4, 4);
        this.painelCentral.add((Component)painelPesquisa, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(4, 4, 4, 4);
        this.painelCentral.add((Component)this.painelNota, c);
        this.controlaCampos();
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotaFiscalConsulta.this.textNotaFiscal.isFocusable()) {
                    NotaFiscalConsulta.this.status = 1;
                    NotaFiscalConsulta.this.controlaCampos();
                    NotaFiscalConsulta.this.limparDados();
                    NotaFiscalConsulta.this.painelNota.limparCampos();
                    ScreenUtil.requisitarFoco(NotaFiscalConsulta.this.textNotaFiscal);
                }
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotaFiscalConsulta.this.fechar();
            }
        });
        this.buttonBuscaNotaFiscal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotaFiscalService notaService = new NotaFiscalService();
                NotaFiscalVO auxVO = new NotaFiscalVO();
                auxVO = (NotaFiscalVO)notaService.pesquisaVO(Laboratorio.getInstancia(), auxVO, "Pesquisa de Nota Fiscal", true);
                if (auxVO != null) {
                    NotaFiscalConsulta.this.textNotaFiscal.setText(auxVO.getCodigo().toString());
                    NotaFiscalConsulta.this.status = 3;
                    if (NotaFiscalConsulta.this.buttonCarregarCadastro.isFocusable()) {
                        ScreenUtil.requisitarFoco(NotaFiscalConsulta.this.buttonCarregarCadastro);
                    }
                }
                NotaFiscalConsulta.this.controlaCampos();
            }
        });
        this.textNotaFiscal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(NotaFiscalConsulta.this.textNotaFiscal)) {
                    return;
                }
                try {
                    NotaFiscalVO auxVO = (NotaFiscalVO)new NotaFiscalService().getVO(Variaveis.filialPadrao, NotaFiscalConsulta.this.textNotaFiscal.getText());
                    if (auxVO != null) {
                        NotaFiscalConsulta.this.textNotaFiscal.setText(auxVO.getCodigo().toString());
                        NotaFiscalConsulta.this.status = 3;
                        if (NotaFiscalConsulta.this.buttonCarregarCadastro.isFocusable()) {
                            ScreenUtil.requisitarFoco(NotaFiscalConsulta.this.buttonCarregarCadastro);
                        }
                    }
                    NotaFiscalConsulta.this.controlaCampos();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(NotaFiscalConsulta.this, "N\u00e3o foi poss\u00edvel carregar os dados da nota fiscal.\n" + e1.getMessage(), e1.getStackTrace());
                }
            }
        });
        this.buttonCarregarCadastro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotaFiscalConsulta.this.textNotaFiscal.getText().equals("")) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Informe o n\u00famero da nota.", 2);
                    NotaFiscalConsulta.this.status = 1;
                    NotaFiscalConsulta.this.controlaCampos();
                    ScreenUtil.requisitarFoco(NotaFiscalConsulta.this.textNotaFiscal);
                    return;
                }
                NotaFiscalService service = new NotaFiscalService();
                try {
                    NotaFiscalConsulta.this.notaFiscalBean = (NotaFiscalBean)service.get(Variaveis.filialPadrao, NotaFiscalConsulta.this.textNotaFiscal.getText());
                }
                catch (Exception ex) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "A nota n\u00e3o foi encontrada.", 2);
                    return;
                }
                if (NotaFiscalConsulta.this.notaFiscalBean != null) {
                    NotaFiscalConsulta.this.preencheDadosNotaFiscal(NotaFiscalConsulta.this.notaFiscalBean);
                    NotaFiscalConsulta.this.buttonBuscaNotaFiscal.setEnabled(false);
                    NotaFiscalConsulta.this.buttonCarregarCadastro.setEnabled(false);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "A nota n\u00e3o foi encontrada.", 2);
                }
            }
        });
    }

    private void limparDados() {
        this.textNotaFiscal.setText("");
    }

    private void preencheDadosNotaFiscal(NotaFiscalBean bean) {
        this.painelNota.novo(bean, null, true);
    }

    private void cancelar(boolean pularMensagem) {
        this.status = 0;
        this.painelNota.limparCampos();
        this.painelNota.setStatus(1);
        this.painelNota.controlaCampos();
        this.limparDados();
        this.controlaCampos();
    }

    private void controlaCampos() {
        this.buttonFechar.setEnabled(true);
        this.buttonNovo.setEnabled(true);
        if (this.status == 0) {
            this.buttonBuscaNotaFiscal.setEnabled(false);
            this.buttonCarregarCadastro.setEnabled(false);
            this.textNotaFiscal.setEnabled(false);
        } else if (this.status == 1) {
            this.buttonBuscaNotaFiscal.setEnabled(true);
            this.buttonCarregarCadastro.setEnabled(false);
            this.textNotaFiscal.setEnabled(true);
        } else if (this.status == 2) {
            this.buttonBuscaNotaFiscal.setEnabled(true);
            this.buttonCarregarCadastro.setEnabled(false);
            this.textNotaFiscal.setEnabled(true);
        } else if (this.status == 3) {
            this.buttonBuscaNotaFiscal.setEnabled(true);
            this.buttonCarregarCadastro.setEnabled(true);
            this.textNotaFiscal.setEnabled(true);
        }
    }

    private void fechar() {
        this.painelNota.cancelar(true);
        this.painelNota.fechar();
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700100700");
    }
}

