/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.faturamento;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.consultas.faturamento.ListaNotasRenderer;
import jalis.laboratorio.financeiro.faturamento.EstornoCancelamentoNota;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.service.cadastro.CadastroService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NotaFiscalCadastro
extends FrmPadrao
implements ActionListener,
ListSelectionListener {
    private final int STATUS_NONE = 0;
    private final int STATUS_CADNOTSEL = 1;
    private final int STATUS_CADSEL = 2;
    private int status = 0;
    private boolean limpandoDados = false;
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JPanel painelCentral = new JPanel(new GridBagLayout());
    private JLabel labelCadastro = new JLabel("Cadastro:");
    private JComboBox comboCadastro = new JComboBox<String>(new String[]{Tipos.tipoCadastro("O"), Tipos.tipoCadastro("P"), "Entidade"});
    private TTextField textCodigoCadastro = new TTextField(8, 1);
    private JButton buttonBuscaCadastro = ComponenteFactory.novoJButton(this, true);
    private JLabel labelFantasiaCadastro = new JLabel();
    private JButton buttonCarregarCadastro = ComponenteFactory.novoJButton("Carregar", this);
    private EstornoCancelamentoNota painelNota = null;
    private ArrayList<Object[]> listaNotas = null;
    private ModeloGridTable modeloListaNotas = new ModeloGridTable(new String[]{"Nota Fiscal"});
    private JTable tableListaNotas = new JTable(this.modeloListaNotas);

    public void preencheDadosCadastro(AbstractThreadVO auxVO) {
        if (auxVO != null) {
            this.status = 2;
            this.controlaCampos();
            if (auxVO instanceof PacienteVO) {
                this.textCodigoCadastro.setText(String.valueOf(((PacienteVO)auxVO).getCodigo()));
                this.labelFantasiaCadastro.setText(((PacienteVO)auxVO).getNome());
            } else if (auxVO instanceof ConvenioVO) {
                this.textCodigoCadastro.setText(String.valueOf(((ConvenioVO)auxVO).getCodigo()));
                this.labelFantasiaCadastro.setText(((ConvenioVO)auxVO).getFantasia());
            } else if (auxVO instanceof EntidadeVO) {
                this.textCodigoCadastro.setText(String.valueOf(((EntidadeVO)auxVO).getCodigo()));
                this.labelFantasiaCadastro.setText(((EntidadeVO)auxVO).getFantasia());
            }
        }
    }

    public NotaFiscalCadastro() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.painelCentral, "Center");
        Funcoes.montaEnter((JComponent)this.painelCentral);
        this.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonNovo, this.buttonFechar), "South");
        Funcoes.criaBarraDescricao(this, "Notas Fiscais de Sa\u00edda por Cadastro", "Visualiza\u00e7\u00e3o das Notas Fiscais de sa\u00edda para Conv\u00eanios/Pacientes/Entidades", "consultas/consulta_nf_por_cadastro.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelFantasiaCadastro}, new TitledBorder(""));
        this.painelCentral.setLayout(new GridBagLayout());
        this.painelNota = new EstornoCancelamentoNota("", "", false, false, "", 0.8f, true);
        this.painelNota.setBorder(BorderFactory.createEtchedBorder());
        this.painelNota.controlaCampos();
        JPanel painelPesquisa = new JPanel();
        painelPesquisa.setPreferredSize(new Dimension(100, 100));
        painelPesquisa.setLayout(new GridBagLayout());
        this.comboCadastro.setPreferredSize(new Dimension(120, 20));
        this.comboCadastro.setMinimumSize(new Dimension(120, 20));
        this.textCodigoCadastro.setPreferredSize(new Dimension(100, 20));
        this.textCodigoCadastro.setMinimumSize(new Dimension(100, 20));
        this.textCodigoCadastro.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                CadastroService cadService = new CadastroService();
                AbstractThreadVO auxVO = null;
                auxVO = NotaFiscalCadastro.this.comboCadastro.getSelectedItem().equals(Tipos.tipoCadastro("P")) ? new PacienteVO() : (NotaFiscalCadastro.this.comboCadastro.getSelectedItem().equals(Tipos.tipoCadastro("O")) ? new ConvenioVO() : new EntidadeVO());
                if (e.getKeyCode() == 113) {
                    auxVO = cadService.pesquisaVO(Laboratorio.getInstancia(), auxVO, "Pesquisa de Cadastro", true);
                    NotaFiscalCadastro.this.preencheDadosCadastro(auxVO);
                } else if (e.getKeyCode() == 10) {
                    try {
                        if (!Funcoes.textoVazio(NotaFiscalCadastro.this.textCodigoCadastro)) {
                            auxVO = cadService.pesquisaVO(auxVO, Variaveis.filialPadrao, NotaFiscalCadastro.this.textCodigoCadastro.getText());
                        }
                    }
                    catch (ThreadDaoException e1) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Cadastro n\u00e3o localizado.", 2);
                    }
                    NotaFiscalCadastro.this.preencheDadosCadastro(auxVO);
                }
            }
        });
        this.buttonBuscaCadastro.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaCadastro.setMinimumSize(new Dimension(20, 20));
        this.labelFantasiaCadastro.setPreferredSize(new Dimension(300, 20));
        this.labelFantasiaCadastro.setMinimumSize(new Dimension(200, 20));
        this.buttonCarregarCadastro.setPreferredSize(new Dimension(80, 20));
        this.buttonCarregarCadastro.setMinimumSize(new Dimension(80, 20));
        this.tableListaNotas.getSelectionModel().setSelectionMode(0);
        this.tableListaNotas.setDefaultRenderer(Object.class, new ListaNotasRenderer());
        this.tableListaNotas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int aux = NotaFiscalCadastro.this.tableListaNotas.getSelectedRow();
                if (aux < 0) {
                    return;
                }
                try {
                    if (!NotaFiscalCadastro.this.limpandoDados) {
                        NotaFiscalCadastro.this.preencheDadosNotaFiscal(Variaveis.filialPadrao, ((Object[])NotaFiscalCadastro.this.listaNotas.get(aux))[3].toString());
                    }
                }
                catch (ArrayIndexOutOfBoundsException aob) {
                    ErrorLogger.mostraMensagem(NotaFiscalCadastro.this, aob.getMessage(), aob.getStackTrace(), "NotaFiscalCadastro:183");
                }
            }
        });
        JScrollPane scrollListaNotas = new JScrollPane(this.tableListaNotas);
        scrollListaNotas.setPreferredSize(new Dimension(100, 100));
        scrollListaNotas.setMinimumSize(new Dimension(100, 100));
        scrollListaNotas.setVerticalScrollBarPolicy(20);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        painelPesquisa.add((Component)this.labelCadastro, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 1);
        painelPesquisa.add((Component)this.comboCadastro, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 0);
        painelPesquisa.add((Component)this.textCodigoCadastro, c);
        ++c.gridx;
        painelPesquisa.add((Component)this.buttonBuscaCadastro, c);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 1.0;
        painelPesquisa.add((Component)this.labelFantasiaCadastro, c);
        c.fill = 0;
        ++c.gridx;
        c.weightx = 0.0;
        painelPesquisa.add((Component)this.buttonCarregarCadastro, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(4, 4, 4, 4);
        this.painelCentral.add((Component)painelPesquisa, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 3;
        c.insets = new Insets(4, 1, 1, 1);
        this.painelCentral.add((Component)scrollListaNotas, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(4, 1, 1, 1);
        this.painelCentral.add((Component)this.painelNota, c);
        this.controlaCampos();
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotaFiscalCadastro.this.comboCadastro.isFocusable()) {
                    NotaFiscalCadastro.this.status = 1;
                    NotaFiscalCadastro.this.controlaCampos();
                    NotaFiscalCadastro.this.limparDados();
                    NotaFiscalCadastro.this.painelNota.limparCampos();
                    NotaFiscalCadastro.this.comboCadastro.grabFocus();
                }
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotaFiscalCadastro.this.fechar();
            }
        });
        this.buttonBuscaCadastro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CadastroService cadService = new CadastroService();
                AbstractThreadVO auxVO = null;
                auxVO = NotaFiscalCadastro.this.comboCadastro.getSelectedItem().equals(Tipos.tipoCadastro("P")) ? new PacienteVO() : (NotaFiscalCadastro.this.comboCadastro.getSelectedItem().equals(Tipos.tipoCadastro("O")) ? new ConvenioVO() : new EntidadeVO());
                auxVO = cadService.pesquisaVO(Laboratorio.getInstancia(), auxVO, "Pesquisa de Cadastro", false);
                NotaFiscalCadastro.this.preencheDadosCadastro(auxVO);
            }
        });
        this.buttonCarregarCadastro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotaFiscalService service = new NotaFiscalService();
                ArrayList<Object[]> auxLista = null;
                String tipoCadastro = NotaFiscalCadastro.this.comboCadastro.getSelectedItem().toString().toLowerCase();
                if (!Funcoes.textoVazio(NotaFiscalCadastro.this.textCodigoCadastro)) {
                    try {
                        auxLista = service.buscaNotasFiscaisCadastro(Variaveis.filialPadrao, NotaFiscalCadastro.this.textCodigoCadastro.getText(), NotaFiscalCadastro.this.comboCadastro.getSelectedItem().toString(), Conexao.getStatement());
                    }
                    catch (SQLException sqle) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Cadastro n\u00e3o localizado.", 2);
                    }
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "C\u00f3digo do " + tipoCadastro + " n\u00e3o informado.", 2);
                    NotaFiscalCadastro.this.cancelar(false);
                    NotaFiscalCadastro.this.buttonNovo.doClick();
                    return;
                }
                if (auxLista == null || auxLista.size() == 0) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "O " + tipoCadastro + " n\u00e3o possui nenhuma nota fiscal.", 2);
                    NotaFiscalCadastro.this.cancelar(false);
                    NotaFiscalCadastro.this.buttonNovo.doClick();
                } else {
                    NotaFiscalCadastro.this.preencheListaNotas(auxLista);
                }
            }
        });
    }

    private void limparDados() {
        this.modeloListaNotas.clear();
        this.textCodigoCadastro.setText("");
        this.labelFantasiaCadastro.setText("");
    }

    private void preencheListaNotas(ArrayList<Object[]> lista) {
        this.limpandoDados = true;
        this.modeloListaNotas.clear();
        this.limpandoDados = false;
        if (lista != null) {
            this.listaNotas = lista;
            for (int i = 0; i < lista.size(); ++i) {
                String numero = "<b>N\u00fam.: </b> " + this.listaNotas.get(i)[0].toString();
                String data = "<b>Dt. Emiss\u00e3o: <br> </b> " + Funcoes.formataData((Date)this.listaNotas.get(i)[2]);
                String valor = "<b>Vl. L\u00edquido: <br> </b> " + Funcoes.formataDecimal((Double)this.listaNotas.get(i)[1]);
                String auxValor = this.montarHTML(numero, data, valor);
                this.modeloListaNotas.addLine(new Object[]{auxValor});
            }
        }
    }

    private void preencheDadosNotaFiscal(String filial, String codNotaFiscal) {
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ").append(filial).append(" and nfi_codigo = ").append(codNotaFiscal).append(" ");
        this.painelNota.novo(buf.toString(), false, true);
    }

    private void cancelar(boolean pularMensagem) {
        this.status = 0;
        this.limpandoDados = true;
        this.listaNotas = null;
        this.painelNota.limparCampos();
        this.painelNota.controlaCampos();
        this.limparDados();
        this.limpandoDados = false;
        this.controlaCampos();
    }

    private void controlaCampos() {
        this.buttonFechar.setEnabled(true);
        this.buttonNovo.setEnabled(true);
        this.buttonBuscaCadastro.setEnabled(true);
        this.comboCadastro.setEnabled(true);
        this.textCodigoCadastro.setEnabled(true);
        if (this.status == 0) {
            this.buttonCarregarCadastro.setEnabled(false);
        } else if (this.status == 1) {
            this.buttonCarregarCadastro.setEnabled(false);
        } else if (this.status == 2) {
            this.buttonCarregarCadastro.setEnabled(true);
        }
    }

    private void fechar() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700100600");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    private String montarHTML(String ... strs) {
        StringBuilder bui = new StringBuilder("<html><body align=left>");
        for (int i = 0; i < strs.length; ++i) {
            if (i > 0) {
                bui.append("<br>");
            }
            bui.append(strs[i]);
        }
        return bui.append("</body></html>").toString();
    }
}

