/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.detalhes.Detalhes;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.consultas.faturamento.ListaNotasRenderer;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.model.bean.estoque.ConferenciaEntradaBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.cadastro.CadastroService;
import jalis.service.estoque.MaterialService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConsultaNotaFiscalEntradaFornecedor
extends FrmCadPadrao {
    private final int STATUS_NONE = 0;
    private final int STATUS_CADNOTSEL = 1;
    private final int STATUS_CADSEL = 2;
    private static final int DADOS_NOTA_NUMERO = 0;
    private static final int DADOS_NOTA_VALOR = 1;
    private static final int DADOS_NOTA_EMISSAO = 2;
    private static final int DADOS_NOTA_CODIGO = 3;
    private static final int COLUNA_MATERIAL = 0;
    private static final int COLUNA_VALOR_UNITARIO = 1;
    private static final int COLUNA_QUANTIDADE = 2;
    private static final int COLUNA_VALOR_IPI = 3;
    private static final int COLUNA_VALOR_ICMS = 4;
    private static final int COLUNA_VALOR_LIQUIDO = 5;
    private static final int COLUNA_OBJETO = 6;
    private JButton buttonBuscaFornecedor = new JButton("");
    private JButton buttonCarregarFornecedor = new JButton("Carregar");
    private JLabel labelFornecedor = new JLabel("Fornecedor:");
    private JLabel labelNumero = new JLabel("N\u00famero:");
    private JLabel labelEmissao = new JLabel("Emiss\u00e3o:");
    private JLabel labelSerie = new JLabel("S\u00e9rie:");
    private JLabel labelFormaPgto = new JLabel("Forma Pgto.:");
    private JLabel labelValor = new JLabel("Valor Bruto:");
    private JLabel labelImpostos = new JLabel("Impostos:");
    private JLabel labelTotal = new JLabel("Valor L\u00edquido:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelFantasiaFornecedor = new JLabel();
    private JLabel labelSituacaoNota = new JLabel();
    private TTextField textCodigoFornecedor = new TTextField(8, 1);
    private TTextField textNumero = new TTextField();
    private TTextField textImpostos = new TTextField(15, 2);
    private TTextField textEmissao = new TTextField(10, 4);
    private TTextField textValor = new TTextField(15, 2);
    private TTextField textTotal = new TTextField(15, 2);
    private TTextField textCodSerie = new TTextField();
    private TTextField textCodFormaPgto = new TTextField();
    private TTextField textDescSerie = new TTextField();
    private TTextField textDescFormaPgto = new TTextField();
    private TTextField textUsuario = new TTextField();
    private ArrayList<Object[]> listaNotas = null;
    private ModeloGridTable modeloListaNotas = new ModeloGridTable(new String[]{"Nota Fiscal"});
    private JTable tableListaNotas = new JTable(this.modeloListaNotas);
    private JScrollPane scrollListaNotas = new JScrollPane(this.tableListaNotas);
    private ModeloGridTable modeloMateriais = new ModeloGridTable(new String[]{"Material", "Vl. Unit\u00e1rio", "Qtde.", "Vl. IPI", "Vl. ICMS", "Vl. L\u00edquido"});
    private JTable tableMateriais = new JTable(this.modeloMateriais);
    private JScrollPane scrollMateriais = new JScrollPane(this.tableMateriais);
    private ModeloGridTable modeloParcelas = new ModeloGridTable(new String[]{"Parcela", "Vencimento", "Vl. Total"});
    private JTable tableParcelas = new JTable(this.modeloParcelas);
    private JScrollPane scrollParcelas = new JScrollPane(this.tableParcelas);
    private JTextArea areaObservacao = new JTextArea(new TTextAreaDocument(500));
    private JScrollPane scrollObservacao = new JScrollPane(this.areaObservacao);
    private DetalhesImpostos detalhesImpostos = new DetalhesImpostos();
    private NotaFiscalBean notaFiscalBean = null;

    public void preencheDadosFornecedor(EntidadeVO entidadeVO) {
        if (entidadeVO != null) {
            this.setStatus(2);
            this.controlaCampos();
            this.textCodigoFornecedor.setText(entidadeVO.getCodigo().toString());
            this.labelFantasiaFornecedor.setText(entidadeVO.getFantasia());
        }
    }

    public ConsultaNotaFiscalEntradaFornecedor() {
        this.montaTela();
        this.novo();
    }

    private void montaTela() {
        Funcoes.criaBarraDescricao(this, "Notas fiscais de entrada por fornecedor", "Visualiza\u00e7\u00e3o das notas fiscais de entrada de fornecedores", "consultas/consulta_nf_entrada.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelFantasiaFornecedor, this.labelSituacaoNota}, new TitledBorder(""));
        Dimension d = null;
        this.scrollListaNotas.setVerticalScrollBarPolicy(20);
        d = new Dimension(85, 100);
        this.scrollListaNotas.setPreferredSize(d);
        this.scrollListaNotas.setMinimumSize(d);
        this.tableListaNotas.getSelectionModel().setSelectionMode(0);
        this.tableListaNotas.setDefaultRenderer(Object.class, new ListaNotasRenderer());
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(1, 1, 0, 1);
        this.painelCentral.add((Component)this.montaPainelPesquisa(), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.fill = 3;
        c.insets = new Insets(0, 1, 1, 0);
        this.painelCentral.add((Component)this.scrollListaNotas, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 1, 1);
        this.painelCentral.add((Component)this.montaPainelNotaEntrada(), c);
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setVisible(false);
        this.montaListeners();
        Funcoes.montaEnter((JComponent)this.painelCentral);
        this.controlaCampos();
    }

    private JPanel montaPainelPesquisa() {
        JPanel painelPesquisa = new JPanel(new GridBagLayout());
        painelPesquisa.setMinimumSize(new Dimension(20, 30));
        painelPesquisa.setPreferredSize(new Dimension(20, 30));
        Dimension d = null;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        painelPesquisa.add((Component)this.labelFornecedor, c);
        ++c.gridx;
        d = new Dimension(100, 20);
        this.textCodigoFornecedor.setPreferredSize(d);
        this.textCodigoFornecedor.setMinimumSize(d);
        painelPesquisa.add((Component)this.textCodigoFornecedor, c);
        ++c.gridx;
        Funcoes.imagemPesquisa(this.buttonBuscaFornecedor);
        this.buttonBuscaFornecedor.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonBuscaFornecedor.setPreferredSize(d);
        this.buttonBuscaFornecedor.setMinimumSize(d);
        painelPesquisa.add((Component)this.buttonBuscaFornecedor, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        d = new Dimension(300, 20);
        this.labelFantasiaFornecedor.setPreferredSize(d);
        this.labelFantasiaFornecedor.setMinimumSize(d);
        painelPesquisa.add((Component)this.labelFantasiaFornecedor, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonCarregarFornecedor.setMargin(new Insets(1, 1, 1, 1));
        d = new Dimension(80, 20);
        this.buttonCarregarFornecedor.setPreferredSize(d);
        this.buttonCarregarFornecedor.setMinimumSize(d);
        painelPesquisa.add((Component)this.buttonCarregarFornecedor, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        painelPesquisa.add((Component)new JLabel(), c);
        return painelPesquisa;
    }

    private JPanel montaPainelNotaEntrada() {
        this.modeloMateriais.setColumnSize(new int[]{0, 80, 60, 80, 80, 80}, this.tableMateriais);
        this.modeloParcelas.setColumnSize(new int[]{70, 100, 100}, this.tableParcelas);
        this.modeloMateriais.ordenarColuna(0);
        this.modeloParcelas.ordenarColuna(0);
        Dimension d = null;
        d = new Dimension(120, 20);
        this.textNumero.setPreferredSize(d);
        this.textNumero.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.textEmissao.setPreferredSize(d);
        this.textEmissao.setMinimumSize(d);
        this.textImpostos.setPreferredSize(d);
        this.textImpostos.setMinimumSize(d);
        this.textValor.setPreferredSize(d);
        this.textValor.setMinimumSize(d);
        this.textTotal.setPreferredSize(d);
        this.textTotal.setMinimumSize(d);
        d = new Dimension(40, 20);
        this.textCodSerie.setPreferredSize(d);
        this.textCodSerie.setMinimumSize(d);
        this.textCodFormaPgto.setPreferredSize(d);
        this.textCodFormaPgto.setMinimumSize(d);
        d = new Dimension(20, 20);
        this.textDescSerie.setPreferredSize(d);
        this.textDescSerie.setMinimumSize(d);
        this.textDescFormaPgto.setPreferredSize(d);
        this.textDescFormaPgto.setMinimumSize(d);
        this.textUsuario.setPreferredSize(d);
        this.textUsuario.setMinimumSize(d);
        this.labelSituacaoNota.setHorizontalAlignment(4);
        this.labelSituacaoNota.setPreferredSize(d);
        this.labelSituacaoNota.setMinimumSize(d);
        this.scrollObservacao.setVerticalScrollBarPolicy(20);
        d = new Dimension(20, 30);
        this.scrollObservacao.setPreferredSize(d);
        this.scrollObservacao.setMinimumSize(d);
        Insets insetsNormal = new Insets(0, 1, 0, 0);
        Insets insetsEspacamento = new Insets(0, 20, 0, 0);
        JPanel panelNota = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = insetsNormal;
        panelNota.add((Component)this.labelNumero, c);
        ++c.gridx;
        c.gridwidth = 2;
        panelNota.add((Component)this.textNumero, c);
        c.gridx += 3;
        c.gridwidth = 5;
        c.fill = 2;
        c.weightx = 2.0;
        if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("C")) {
            panelNota.add((Component)this.labelSituacaoNota, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        panelNota.add((Component)this.labelEmissao, c);
        ++c.gridx;
        c.gridwidth = 2;
        panelNota.add((Component)this.textEmissao, c);
        c.gridx += 2;
        c.gridwidth = 1;
        panelNota.add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        panelNota.add((Component)this.textUsuario, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        panelNota.add((Component)this.labelSerie, c);
        ++c.gridx;
        c.gridwidth = 1;
        panelNota.add((Component)this.textCodSerie, c);
        ++c.gridx;
        c.gridwidth = 7;
        c.fill = 2;
        c.weightx = 1.0;
        panelNota.add((Component)this.textDescSerie, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        panelNota.add((Component)this.labelFormaPgto, c);
        ++c.gridx;
        c.gridwidth = 1;
        panelNota.add((Component)this.textCodFormaPgto, c);
        ++c.gridx;
        c.gridwidth = 7;
        c.fill = 2;
        c.weightx = 1.0;
        panelNota.add((Component)this.textDescFormaPgto, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        panelNota.add((Component)this.labelValor, c);
        ++c.gridx;
        c.gridwidth = 2;
        panelNota.add((Component)this.textValor, c);
        c.gridx += 2;
        c.gridwidth = 1;
        panelNota.add((Component)this.labelImpostos, c);
        ++c.gridx;
        panelNota.add((Component)this.textImpostos, c);
        ++c.gridx;
        c.insets = insetsEspacamento;
        panelNota.add((Component)this.labelTotal, c);
        ++c.gridx;
        c.insets = insetsNormal;
        panelNota.add((Component)this.textTotal, c);
        ++c.gridx;
        c.weightx = 1.0;
        panelNota.add((Component)new JLabel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 9;
        c.weightx = 1.0;
        c.fill = 2;
        panelNota.add((Component)this.detalhesImpostos, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        panelNota.add((Component)this.montaPainelMateriais(), c);
        ++c.gridy;
        panelNota.add((Component)this.montaPainelParcelasObservacao(), c);
        return panelNota;
    }

    private JPanel montaPainelMateriais() {
        this.scrollMateriais.setVerticalScrollBarPolicy(20);
        this.scrollMateriais.setPreferredSize(new Dimension(20, 20));
        this.scrollMateriais.setMinimumSize(new Dimension(20, 20));
        JPanel panelMateriais = new JPanel(new BorderLayout());
        panelMateriais.setBorder(new TitledBorder("Materiais"));
        panelMateriais.add((Component)this.scrollMateriais, "Center");
        return panelMateriais;
    }

    private JPanel montaPainelParcelasObservacao() {
        JPanel panelParcelasObservacao = new JPanel(new BorderLayout());
        panelParcelasObservacao.add((Component)this.montaPanelParcelas(), "West");
        panelParcelasObservacao.add((Component)this.montaPanelObservacao(), "Center");
        return panelParcelasObservacao;
    }

    private JPanel montaPanelParcelas() {
        this.scrollParcelas.setVerticalScrollBarPolicy(20);
        this.scrollParcelas.setPreferredSize(new Dimension(270, 20));
        this.scrollParcelas.setMinimumSize(new Dimension(270, 20));
        JPanel panelParcelas = new JPanel(new BorderLayout());
        panelParcelas.setBorder(new TitledBorder("Parcelas"));
        panelParcelas.add((Component)this.scrollParcelas, "Center");
        return panelParcelas;
    }

    private JPanel montaPanelObservacao() {
        JPanel panelObservacao = new JPanel(new BorderLayout());
        panelObservacao.setBorder(new TitledBorder("Observa\u00e7\u00e3o"));
        panelObservacao.add((Component)this.scrollObservacao, "Center");
        return panelObservacao;
    }

    private void montaListeners() {
        this.textCodigoFornecedor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                CadastroService cadService = new CadastroService();
                if (e.getKeyCode() == 113) {
                    EntidadeVO entidadeVO = (EntidadeVO)cadService.pesquisaVO(Laboratorio.getInstancia(), new EntidadeVO(), "Pesquisando Fornecedores", true);
                    ConsultaNotaFiscalEntradaFornecedor.this.preencheDadosFornecedor(entidadeVO);
                } else if (e.getKeyCode() == 10) {
                    EntidadeVO entidadeVO = null;
                    try {
                        if (!Funcoes.textoVazio(ConsultaNotaFiscalEntradaFornecedor.this.textCodigoFornecedor)) {
                            entidadeVO = (EntidadeVO)cadService.pesquisaVO(new EntidadeVO(), Variaveis.filialPadrao, ConsultaNotaFiscalEntradaFornecedor.this.textCodigoFornecedor.getText());
                            ConsultaNotaFiscalEntradaFornecedor.this.preencheDadosFornecedor(entidadeVO);
                            ScreenUtil.requisitarFoco(ConsultaNotaFiscalEntradaFornecedor.this.buttonCarregarFornecedor);
                        }
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(ConsultaNotaFiscalEntradaFornecedor.this, "N\u00e3o foi poss\u00edvel carregar os dados do fornecedor.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
            }
        });
        this.tableListaNotas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ConsultaNotaFiscalEntradaFornecedor.this.limpaDadosNota();
                int aux = ConsultaNotaFiscalEntradaFornecedor.this.tableListaNotas.getSelectedRow();
                if (aux < 0) {
                    return;
                }
                SplashMensagem splash = new SplashMensagem();
                try {
                    splash.mostrar("Aguarde... carregando dados");
                    ConsultaNotaFiscalEntradaFornecedor.this.preencheDadosNotaFiscal(Variaveis.filialPadrao, ((Object[])ConsultaNotaFiscalEntradaFornecedor.this.listaNotas.get(aux))[3].toString());
                }
                catch (ArrayIndexOutOfBoundsException aob) {
                    ErrorLogger.mostraMensagem(ConsultaNotaFiscalEntradaFornecedor.this, "N\u00e3o foi poss\u00edvel preencher os dados da nota fiscal.\n" + aob.getMessage(), aob.getStackTrace());
                }
                finally {
                    splash.apagar();
                }
            }
        });
        this.buttonBuscaFornecedor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CadastroService cadService = new CadastroService();
                EntidadeVO entidadeVO = (EntidadeVO)cadService.pesquisaVO(Laboratorio.getInstancia(), new EntidadeVO(), "Pesquisa de Cadastro", false);
                ConsultaNotaFiscalEntradaFornecedor.this.preencheDadosFornecedor(entidadeVO);
            }
        });
        this.buttonCarregarFornecedor.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Object[]> auxLista;
                block6: {
                    block7: {
                        NotaFiscalService service = new NotaFiscalService();
                        auxLista = null;
                        if (Funcoes.textoVazio(ConsultaNotaFiscalEntradaFornecedor.this.textCodigoFornecedor)) break block7;
                        Statement st = Conexao.getStatement();
                        try {
                            auxLista = service.buscaNotasFiscaisCadastroFornecedor(Variaveis.filialPadrao, ConsultaNotaFiscalEntradaFornecedor.this.textCodigoFornecedor.getText(), "F", st, true);
                        }
                        catch (SQLException sqle) {
                            try {
                                Funcoes.mensagem(ConsultaNotaFiscalEntradaFornecedor.this, "N\u00e3o foi poss\u00edvel carregar os dados das notas do fornecedor.\n" + sqle.getMessage(), 2);
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                            break block6;
                        }
                        Conexao.fecharStatement(st);
                        break block6;
                    }
                    Funcoes.mensagem(Laboratorio.getInstancia(), "C\u00f3digo do fornecedor n\u00e3o informado.", 2);
                    ConsultaNotaFiscalEntradaFornecedor.this.novo();
                    return;
                }
                if (auxLista == null || auxLista.size() == 0) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "O fornecedor n\u00e3o possui nenhuma nota fiscal.", 2);
                    ConsultaNotaFiscalEntradaFornecedor.this.novo();
                } else {
                    ConsultaNotaFiscalEntradaFornecedor.this.preencheListaNotas(auxLista);
                }
                ConsultaNotaFiscalEntradaFornecedor.this.controlaCampos();
            }
        });
        this.tableMateriais.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    int row = ConsultaNotaFiscalEntradaFornecedor.this.tableMateriais.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    MaterialVO material = (MaterialVO)ConsultaNotaFiscalEntradaFornecedor.this.modeloMateriais.getValueAt(row, 6);
                    if (material == null) {
                        return;
                    }
                    try {
                        new MaterialService().carregarDadosLotesNotaEntrada(material, (NotaFiscalVO)ConsultaNotaFiscalEntradaFornecedor.this.notaFiscalBean.toVO());
                    }
                    catch (ThreadDaoException e1) {
                        ErrorLogger.mostraMensagem(ConsultaNotaFiscalEntradaFornecedor.this, "N\u00e3o foi poss\u00edvel buscar os lotes do material.\n" + e1.getMessage(), e1.getStackTrace());
                        return;
                    }
                    SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), material.getCodigo(), material.getDescricao(), material.getUnidadeMedida().getDescricao(), false, material.getLotes(), 2, 0.0, 0.0, 0.0, 0.0, null, null, false);
                    lote.setVisible(true);
                }
            }
        });
    }

    private void limpaDadosFornecedor() {
        this.modeloListaNotas.clear();
        this.textCodigoFornecedor.setText("");
        this.labelFantasiaFornecedor.setText("");
    }

    private void limpaDadosNota() {
        this.textNumero.clear();
        this.labelSituacaoNota.setText("");
        this.textEmissao.clear();
        this.textUsuario.clear();
        this.textCodSerie.clear();
        this.textDescSerie.clear();
        this.textCodFormaPgto.clear();
        this.textDescFormaPgto.clear();
        this.textValor.clear();
        this.textImpostos.clear();
        this.textTotal.clear();
        this.detalhesImpostos.setValores(null, null, null, null);
        this.detalhesImpostos.montaReduzido();
        this.areaObservacao.setText("");
        this.modeloMateriais.clear();
        this.modeloParcelas.clear();
    }

    private void preencheListaNotas(ArrayList<Object[]> lista) {
        this.modeloListaNotas.clear();
        if (lista != null) {
            this.listaNotas = lista;
            for (int i = 0; i < lista.size(); ++i) {
                String numero = "<b>N\u00fam.: </b> " + this.listaNotas.get(i)[0].toString();
                String data = "<b>Dt. Emiss\u00e3o: <br> </b> " + Funcoes.formataData((Date)this.listaNotas.get(i)[2]);
                String valor = "<b>Vl. L\u00edquido: <br> </b> " + Funcoes.formataDecimal((Double)this.listaNotas.get(i)[1]);
                String auxValor = this.montaHTML(numero, data, valor);
                this.modeloListaNotas.addLine(new Object[]{auxValor});
            }
        }
    }

    private void preencheDadosNotaFiscal(String filial, String codigoNota) {
        Set parcelas;
        this.notaFiscalBean = this.carregaNotaFiscal(filial, codigoNota);
        if (this.notaFiscalBean == null) {
            return;
        }
        BigDecimal valorImpostos = new BigDecimal(this.notaFiscalBean.getValorIcms() == null ? "0" : this.notaFiscalBean.getValorIcms().toString());
        valorImpostos = valorImpostos.add(new BigDecimal(this.notaFiscalBean.getValorIpi() == null ? "0" : this.notaFiscalBean.getValorIpi().toString()));
        if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("C")) {
            ConferenciaEntradaBean conferencia = null;
            try {
                conferencia = new NotaFiscalService().getConferenciaEntradaNotaFiscalEntrada(this.notaFiscalBean.getFilial().getCodigo().toString(), this.notaFiscalBean.getCodigo().toString());
                if (conferencia != null) {
                    this.labelSituacaoNota.setText("Confer\u00eancia de entrada em " + Funcoes.formataData("dd/MM/yyyy HH:mm:ss", conferencia.getDataHora()) + ".");
                } else {
                    this.labelSituacaoNota.setText("Confer\u00eancia de entrada n\u00e3o realizada.");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar a confer\u00eancia de entrada.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        this.textNumero.setText(this.notaFiscalBean.getNumero().toString());
        this.textEmissao.setText(Funcoes.formataData("dd/MM/yyyy", this.notaFiscalBean.getDataEmissao()));
        this.textUsuario.setText(this.notaFiscalBean.getUsuario().getDescricao());
        this.textCodSerie.setText(this.notaFiscalBean.getSerie().getCodigo());
        this.textDescSerie.setText(this.notaFiscalBean.getSerie().getDescricao());
        this.textCodFormaPgto.setText(this.notaFiscalBean.getFormaPagamento().getCodigo().toString());
        this.textDescFormaPgto.setText(this.notaFiscalBean.getFormaPagamento().getDescricao());
        this.textValor.setText(Funcoes.formataDecimal(this.notaFiscalBean.getValorLiquido().doubleValue()));
        this.textImpostos.setText(Funcoes.formataDecimal(valorImpostos.doubleValue()));
        this.textTotal.setText(Funcoes.formataDecimal(this.notaFiscalBean.getValor()));
        this.detalhesImpostos.setValores(this.notaFiscalBean.getValorIpi(), this.notaFiscalBean.getValorIcms(), this.notaFiscalBean.getPercentualIpi(), this.notaFiscalBean.getPercentualIcms());
        this.detalhesImpostos.montaExpandido();
        this.areaObservacao.setText(this.notaFiscalBean.getObservacao());
        ArrayList<NotaFiscalMaterialBean> materiais = this.notaFiscalBean.getMateriais();
        if (materiais != null) {
            for (NotaFiscalMaterialBean material : materiais) {
                MaterialVO materialVO = material.getMaterial();
                this.modeloMateriais.addLine(new Object[]{materialVO.getDescricao(), Funcoes.formataDecimal(material.getValorUnitario()), Funcoes.formataDecimal(material.getQuantidade()), Funcoes.formataDecimal(material.getValorIpi()), Funcoes.formataDecimal(material.getValorIcms()), Funcoes.formataDecimal(material.getValorTotal()), materialVO});
            }
        }
        if ((parcelas = this.notaFiscalBean.getParcelas()) != null) {
            for (ReceberPagarBean parcela : parcelas) {
                this.modeloParcelas.addLine(new Object[]{parcela.getParcela(), Funcoes.formataData("dd/MM/yyyy", parcela.getDataVencimento()), Funcoes.formataDecimal(parcela.getValorTotal())});
            }
        }
    }

    private NotaFiscalBean carregaNotaFiscal(String filial, String codigoNota) {
        NotaFiscalBean notaBean = null;
        try {
            notaBean = (NotaFiscalBean)new NotaFiscalService().get(filial, codigoNota);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da nota fiscal.\n" + e.getMessage(), e.getStackTrace());
        }
        return notaBean;
    }

    @Override
    public void cancelar() {
        this.setStatus(0);
        this.listaNotas = null;
        this.limpaDadosFornecedor();
        this.limpaDadosNota();
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.botaoNovo);
    }

    private void controlaCampos() {
        this.botaoFechar.setEnabled(true);
        this.botaoNovo.setEnabled(this.getStatus() != 1 && this.getStatus() != 2);
        this.botaoCancelar.setEnabled(this.getStatus() == 1 || this.getStatus() == 2);
        this.buttonBuscaFornecedor.setEnabled(this.getStatus() != 0);
        this.textCodigoFornecedor.setEnabled(this.getStatus() != 0);
        this.textNumero.setEnabled(false);
        this.textEmissao.setEnabled(false);
        this.textUsuario.setEnabled(false);
        this.textCodSerie.setEnabled(false);
        this.textDescSerie.setEnabled(false);
        this.textCodFormaPgto.setEnabled(false);
        this.textDescFormaPgto.setEnabled(false);
        this.textValor.setEnabled(false);
        this.textImpostos.setEnabled(false);
        this.textTotal.setEnabled(false);
        this.areaObservacao.setEnabled(false);
        int status = this.getStatus();
        if (status == 0) {
            this.buttonCarregarFornecedor.setEnabled(false);
        } else if (status == 1) {
            this.buttonCarregarFornecedor.setEnabled(false);
        } else if (status == 2) {
            this.buttonCarregarFornecedor.setEnabled(true);
        }
    }

    @Override
    public void fechar() {
        this.limpaDadosFornecedor();
        this.limpaDadosNota();
        this.setVisible(false);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700800300");
    }

    private String montaHTML(String ... strs) {
        StringBuilder bui = new StringBuilder();
        bui.append("<html><body align=left>");
        for (int i = 0; i < strs.length; ++i) {
            if (i > 0) {
                bui.append("<br>");
            }
            bui.append(strs[i]);
        }
        return bui.append("</body></html>").toString();
    }

    @Override
    public void novo() {
        this.cancelar();
        this.setStatus(1);
        this.controlaCampos();
        this.limpaDadosFornecedor();
        ScreenUtil.requisitarFoco(this.textCodigoFornecedor);
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class DetalhesImpostos
    extends Detalhes {
        private Double valorIPI;
        private Double valorICMS;
        private Double percIPI;
        private Double percICMS;

        public DetalhesImpostos() {
            super(1);
            this.valorIPI = new Double(0.0);
            this.valorICMS = new Double(0.0);
            this.percIPI = new Double(0.0);
            this.percICMS = new Double(0.0);
            this.setBotaoExpandirVisible(false);
            this.montaExpandido();
            this.valorIPI = new Double(0.0);
            this.valorICMS = new Double(0.0);
            this.percIPI = new Double(0.0);
            this.percICMS = new Double(0.0);
            this.setFont(this.getFont().deriveFont(11.0f));
        }

        @Override
        public void montaExpandido() {
            this.setPreferredSize(new Dimension(10, 20));
            super.montaExpandido();
        }

        @Override
        public void montaReduzido() {
        }

        public void setValores(Double valorIPI, Double valorICMS, Double percIPI, Double percICMS) {
            this.valorIPI = valorIPI;
            this.valorICMS = valorICMS;
            this.percIPI = percIPI;
            this.percICMS = percICMS;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append("<table>");
            html.append("<font size=20>");
            html.append("<tr>");
            html.append("<td><b>Detalhes dos Impostos").append("</b></td>");
            html.append("<td width=40></td>");
            html.append("<td><b>IPI: ").append("</b></td>");
            html.append("<td align=\"right\" width=40>").append(this.valorIPI == null ? "" : Funcoes.formataDecimal("0.00", this.valorIPI)).append("</td>");
            html.append("<td width=10>-</td>");
            html.append("<td align=\"right\" width=35>").append(this.percIPI == null ? "" : Funcoes.formataDecimal("0.00", this.percIPI)).append("%</td>");
            html.append("<td width=20>-</td>");
            html.append("<td><b>ICMS: ").append("</b></td>");
            html.append("<td align=\"right\" width=40>").append(this.valorICMS == null ? "" : Funcoes.formataDecimal("0.00", this.valorICMS)).append("</td>");
            html.append("<td width=10>-</td>");
            html.append("<td align=\"right\" width=35>").append(this.percICMS == null ? "" : Funcoes.formataDecimal("0.00", this.percICMS)).append("%</td>");
            html.append("</tr>");
            html.append("</font>");
            html.append("</table>");
            html.append("</html>");
            this.setDetalhes(html.toString());
            this.repaint();
        }
    }
}

