/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.faturamento;

import jalis.comum.Pesquisas;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.util.faturamento.BuscaFatura;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConsultaFaturamento
extends FrmPadrao
implements ThreadFinalizadaListener {
    private JPanel panelEsquerdo = new JPanel(new GridBagLayout());
    private JPanel panelDireito = new JPanel();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonConsultar = new JButton("Consultar");
    private JLabel labelFatura = new JLabel("Fatura:");
    private TTextField txtFatura = new TTextField(5, 1);
    private JButton buttonFatura = new JButton();
    private boolean isConsultando = false;

    public ConsultaFaturamento() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConsultaFaturamento");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelEsquerdo.setPreferredSize(new Dimension(150, 100));
        Funcoes.criaBarraDescricao(this, "Faturamento", "Consulta aos exames faturados", "consultas/cons_req_faturadas.jpg");
        this.panelBotoes.add(this.buttonFechar);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.fill = 2;
        cons.anchor = 17;
        this.panelEsquerdo.add((Component)this.labelFatura, cons);
        cons.gridx = 1;
        cons.anchor = 13;
        cons.weightx = 0.0;
        cons.fill = 0;
        this.txtFatura.setPreferredSize(new Dimension(70, 20));
        this.txtFatura.setMinimumSize(new Dimension(70, 20));
        this.panelEsquerdo.add((Component)this.txtFatura, cons);
        cons.gridx = 2;
        this.buttonFatura.setPreferredSize(new Dimension(20, 20));
        this.buttonFatura.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonFatura, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 3;
        cons.anchor = 13;
        this.panelEsquerdo.add((Component)this.buttonConsultar, cons);
        cons.gridy = 2;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.gridwidth = 3;
        this.panelEsquerdo.add((Component)new JPanel(), cons);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('t');
        Funcoes.imagemPesquisa(this.buttonFatura);
        this.buttonFatura.setFocusable(false);
        this.buttonConsultar.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaFaturamento.this.setVisible(false);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaFaturamento.this.pesquisaFaturamento();
            }
        });
        this.buttonFatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaFaturamento.this.pesquisaFatura();
            }
        });
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0700100300");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtFatura.hasFocus()) {
            this.buttonFatura.doClick();
        }
    }

    private void pesquisaFaturamento() {
        if (!Funcoes.isNumeric(this.txtFatura.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo da fatura n\u00e3o informado", 1);
            this.txtFatura.grabFocus();
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireito.removeAll();
        this.panelDireito.setLayout(null);
        BuscaFatura consulta = new BuscaFatura((Frame)this.getTopLevelAncestor(), this.panelDireito, this.buttonConsultar, false, true, false, this);
        consulta.setPararSeConferida(false);
        consulta.setCodigoFatura(this.txtFatura.getText());
        consulta.start();
    }

    private void pesquisaFatura() {
        Hashtable resultado = Pesquisas.fatura(this.getTopLevelAncestor());
        if (resultado != null) {
            this.txtFatura.setText(resultado.get("fat_codigo").toString());
        }
        this.txtFatura.requestFocus();
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isConsultando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isConsultando = false;
        this.controlaCampos();
    }

    private void controlaCampos() {
        this.buttonFechar.setEnabled(!this.isConsultando);
        this.buttonConsultar.setEnabled(!this.isConsultando);
        this.txtFatura.setEnabled(!this.isConsultando);
        this.buttonFatura.setEnabled(!this.isConsultando);
    }
}

