/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.faturamento;

import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.util.faturamento.BuscaRequisicoes;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConsultaFaturaExames
extends FrmPadrao {
    private JPanel panelEsquerdo = new JPanel(new GridBagLayout());
    private JPanel panelDireito = new JPanel();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonConsultar = new JButton("Consultar");
    private JLabel labelDataInicio = new JLabel("Data in\u00edcio:");
    private JLabel labelHoraInicio = new JLabel("Hora in\u00edcio:");
    private JLabel labelDataFim = new JLabel("Data final:");
    private JLabel labelHoraFim = new JLabel("Hora final:");
    private TTextField txtDataInicio = new TTextField(10, 4);
    private TTextField txtDataFim = new TTextField(10, 4);
    private TTextField txtHoraInicio = new TTextField(5, 6);
    private TTextField txtHoraFim = new TTextField(5, 6);
    private JButton buttonDataInicio = new JButton();
    private JButton buttonDataFim = new JButton();
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemEstacao;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemSetor;
    private CheckItemFiltro itemGrupo;
    private CheckItemFiltro itemMedico;
    private CheckItemFiltro itemSituacao;

    public ConsultaFaturaExames() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConsultaFaturaExames");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        Funcoes.criaBarraDescricao(this, "Exames", "Consulta aos exames a serem faturados", "consultas/cons_fat_exm.jpg");
        this.panelBotoes.add(this.buttonFechar);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemEstacao = new CheckItemFiltro("Esta\u00e7\u00e3o", "Filtrar", "Filtrando esta\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemEstacao.setDados("estacoes", new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemEstacao.setColunaHint(1);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemGrupo = new CheckItemFiltro("Grupo", "Filtrar", "Filtrando grupos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemGrupo.setDados("grupo", new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemGrupo.setColunaHint(1);
        this.itemMedico = new CheckItemFiltro("M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0}, 4, false, true, false);
        this.itemMedico.setColunaHint(3);
        this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSituacao.setDados("situacao", new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setColunaHint(1);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('t');
        Funcoes.imagemPesquisa(this.buttonDataInicio);
        Funcoes.imagemPesquisa(this.buttonDataFim);
        this.buttonDataInicio.setFocusable(false);
        this.buttonDataFim.setFocusable(false);
        Dimension dimensaoItem = new Dimension(190, 20);
        Dimension dimensaoData = new Dimension(90, 20);
        Dimension dimensaoBotaoData = new Dimension(20, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 0, 0);
        c.gridwidth = 3;
        this.itemColeta.setPreferredSize(dimensaoItem);
        this.itemColeta.setMinimumSize(dimensaoItem);
        this.panelEsquerdo.add((Component)this.itemColeta, c);
        ++c.gridy;
        this.itemDestino.setPreferredSize(dimensaoItem);
        this.itemDestino.setMinimumSize(dimensaoItem);
        this.panelEsquerdo.add((Component)this.itemDestino, c);
        ++c.gridy;
        this.itemEstacao.setPreferredSize(dimensaoItem);
        this.itemEstacao.setMinimumSize(dimensaoItem);
        this.panelEsquerdo.add((Component)this.itemEstacao, c);
        ++c.gridy;
        this.itemConvenio.setPreferredSize(dimensaoItem);
        this.itemConvenio.setMinimumSize(dimensaoItem);
        this.panelEsquerdo.add((Component)this.itemConvenio, c);
        ++c.gridy;
        this.itemSetor.setPreferredSize(dimensaoItem);
        this.itemSetor.setMinimumSize(dimensaoItem);
        this.panelEsquerdo.add((Component)this.itemSetor, c);
        ++c.gridy;
        this.itemGrupo.setPreferredSize(dimensaoItem);
        this.itemGrupo.setMinimumSize(dimensaoItem);
        this.panelEsquerdo.add((Component)this.itemGrupo, c);
        ++c.gridy;
        this.itemMedico.setPreferredSize(dimensaoItem);
        this.itemMedico.setMinimumSize(dimensaoItem);
        this.panelEsquerdo.add((Component)this.itemMedico, c);
        ++c.gridy;
        this.itemSituacao.setPreferredSize(dimensaoItem);
        this.itemSituacao.setMinimumSize(dimensaoItem);
        this.panelEsquerdo.add((Component)this.itemSituacao, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 0, 0);
        this.panelEsquerdo.add((Component)this.labelDataInicio, c);
        ++c.gridx;
        this.txtDataInicio.setPreferredSize(dimensaoData);
        this.txtDataInicio.setMinimumSize(dimensaoData);
        this.panelEsquerdo.add((Component)this.txtDataInicio, c);
        ++c.gridx;
        this.buttonDataInicio.setFocusable(false);
        this.buttonDataInicio.setPreferredSize(dimensaoBotaoData);
        this.buttonDataInicio.setMinimumSize(dimensaoBotaoData);
        this.panelEsquerdo.add((Component)this.buttonDataInicio, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelEsquerdo.add((Component)this.labelDataFim, c);
        ++c.gridx;
        this.txtDataFim.setPreferredSize(dimensaoData);
        this.txtDataFim.setMinimumSize(dimensaoData);
        this.panelEsquerdo.add((Component)this.txtDataFim, c);
        ++c.gridx;
        this.buttonDataFim.setFocusable(false);
        this.buttonDataFim.setPreferredSize(dimensaoBotaoData);
        this.buttonDataFim.setMinimumSize(dimensaoBotaoData);
        this.panelEsquerdo.add((Component)this.buttonDataFim, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelEsquerdo.add((Component)new JLabel(), c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.anchor = 13;
        this.panelEsquerdo.add((Component)this.buttonConsultar, c);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaFaturaExames.this.setVisible(false);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaFaturaExames.this.pesquisaFaturamento();
            }
        });
        this.buttonDataInicio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaFaturaExames.this.txtDataInicio, ConsultaFaturaExames.this.buttonDataInicio, ConsultaFaturaExames.this.panelEsquerdo, true);
            }
        });
        this.buttonDataFim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaFaturaExames.this.txtDataFim, ConsultaFaturaExames.this.buttonDataFim, ConsultaFaturaExames.this.panelEsquerdo, true);
            }
        });
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0700100100");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtDataInicio.hasFocus()) {
            Funcoes.mostraData(this.txtDataInicio, this.buttonDataInicio, this.panelEsquerdo, true);
        } else if (this.txtDataFim.hasFocus()) {
            Funcoes.mostraData(this.txtDataFim, this.buttonDataFim, this.panelEsquerdo, true);
        }
    }

    private void pesquisaFaturamento() {
        if (!Funcoes.verificaData(this.txtDataInicio.getText()) || !Funcoes.verificaData(this.txtDataFim.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida para consulta", 1);
            this.txtDataInicio.grabFocus();
            return;
        }
        if (!Funcoes.textoVazio(this.txtHoraInicio.getText()) && !Funcoes.verificaHora(this.txtHoraInicio.getText()) || !Funcoes.textoVazio(this.txtHoraFim.getText()) && !Funcoes.verificaHora(this.txtHoraFim.getText())) {
            Funcoes.mensagem(this, "Hora inv\u00e1lida para consulta", 1);
            this.txtHoraInicio.grabFocus();
            return;
        }
        if (!this.itemConvenio.isSelected() || this.itemConvenio.isSelected() && (this.itemConvenio.getSelecionados(0) == null || this.itemConvenio.getSelecionados(0).length <= 0)) {
            Funcoes.mensagem(this, "Nenhum conv\u00eanio foi selecionado", 1);
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireito.removeAll();
        this.panelDireito.setLayout(null);
        BuscaRequisicoes consulta = new BuscaRequisicoes((Frame)this.getTopLevelAncestor(), this.panelDireito, this.buttonConsultar, false, false, false);
        if (this.itemColeta.isSelected()) {
            consulta.setFiltroColeta(this.itemColeta.getSelecionados(0));
        }
        if (this.itemDestino.isSelected()) {
            consulta.setFiltroDestino(this.itemDestino.getSelecionados(0));
        }
        if (this.itemEstacao.isSelected()) {
            consulta.setFiltroEstacao(this.itemEstacao.getSelecionados(0));
        }
        if (this.itemConvenio.isSelected()) {
            consulta.setFiltroConvenio(this.itemConvenio.getSelecionados(0));
        }
        if (this.itemSetor.isSelected()) {
            consulta.setFiltroSetor(this.itemSetor.getSelecionados(0));
        }
        if (this.itemGrupo.isSelected()) {
            consulta.setFiltroGrupo(this.itemGrupo.getSelecionados(0));
        }
        if (this.itemMedico.isSelected()) {
            consulta.setFiltroMedicoConselho(this.itemMedico.getSelecionadosAvancado(0));
            consulta.setFiltroMedicoCrm(this.itemMedico.getSelecionadosAvancado(1));
            consulta.setFiltroMedicoUF(this.itemMedico.getSelecionadosAvancado(2));
        }
        if (this.itemSituacao.isSelected()) {
            consulta.setFiltroSituacao(this.itemSituacao.getSelecionados(0));
        }
        consulta.setDataInicio(this.txtDataInicio.getText());
        consulta.setDataFim(this.txtDataFim.getText());
        consulta.setHoraInicio(this.txtHoraInicio.getText());
        consulta.setHoraFim(this.txtHoraFim.getText());
        consulta.start();
    }
}

