/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.estoque;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.cotacao.SolicitarCotacao;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.SaldoEstoqueBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.service.estoque.SaldoEstoqueService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class VerificacaoEstoque
extends FrmCadPadrao {
    private static final Color COR_ABAIXO_PONTO_REPOSICAO = ScreenUtil.clarearCor(Color.RED, 125);
    private static final Color COR_MATERIAL_INATIVO = Color.GRAY;
    private JButton buttonBuscaMaterial = new JButton();
    private JButton buttonOk = new JButton("OK");
    private JButton buttonSolicitarCotacao = new JButton("Solicitar Cota\u00e7\u00e3o");
    private JButton buttonSelecionarTodos = new JButton("Selecionar Todos");
    private JButton buttonLimparSelecao = new JButton("Limpar Sele\u00e7\u00e3o");
    private JButton buttonInverterSelecao = new JButton("Inverter Sele\u00e7\u00e3o");
    private JButton buttonSelecionarReposicaoAtingida = new JButton("Selecionar Estoque em Falta");
    private JLabel labelDescricaoMaterial = new JLabel();
    private JLabel labelMaterial = new JLabel();
    private JPanel panelBusca = new JPanel();
    private JPanel panelDetalhamento = new JPanel();
    private JPanel panelMateriais = new JPanel();
    private JPanel panelLegenda = new JPanel(new GridBagLayout());
    private JPanel panelBotoesTabela = new JPanel(new FlowLayout(0));
    private JScrollPane scrollCelulaMateriais;
    private JScrollPane scrollMateriais;
    private JTable tableCelulaMateriais;
    private JTable tableMateriais;
    private ModeloGridTable modeloCelulaMateriais;
    private ModeloGridTable modeloMateriais;
    private TTextField textMaterial = new TTextField(8, 1);
    private MaterialBean materialAux = null;
    private static long ACESSO_SOLICITAR_ESTOQUE = Long.parseLong("1200100100");

    public VerificacaoEstoque() {
        Funcoes.criaBarraDescricao(this, "Verifica\u00e7\u00e3o de Estoque", "Verifica\u00e7\u00e3o do estoque e detalhamento por c\u00e9lula", "consultas/consulta-verificacao_estoque.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelDescricaoMaterial}, new TitledBorder(""));
        this.painelBotoes.removeAll();
        this.painelBotoes.add(this.botaoNovo);
        this.painelBotoes.add(this.botaoCancelar);
        this.painelBotoes.add(this.buttonSolicitarCotacao);
        this.painelBotoes.add(this.botaoFechar);
        this.painelCentral.setLayout(new GridBagLayout());
        this.panelBusca.setLayout(new GridBagLayout());
        this.labelMaterial.setText("Material:");
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.textMaterial);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelBusca.add((Component)this.labelMaterial, gridBagConstraints);
        this.textMaterial.setMinimumSize(new Dimension(70, 20));
        this.textMaterial.setPreferredSize(new Dimension(70, 20));
        this.panelBusca.add((Component)this.textMaterial, new GridBagConstraints());
        this.buttonBuscaMaterial.setFocusable(false);
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonBuscaMaterial);
        this.panelBusca.add((Component)this.buttonBuscaMaterial, new GridBagConstraints());
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(20, 20));
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(20, 20));
        this.labelDescricaoMaterial.setRequestFocusEnabled(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelBusca.add((Component)this.labelDescricaoMaterial, gridBagConstraints);
        this.buttonOk.setMnemonic('o');
        this.buttonOk.setMinimumSize(new Dimension(30, 20));
        this.buttonOk.setPreferredSize(new Dimension(30, 20));
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.panelBusca.add((Component)this.buttonOk, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelBusca, gridBagConstraints);
        this.panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelMateriais.setLayout(new GridBagLayout());
        this.buttonSelecionarTodos.setMnemonic('T');
        this.buttonSelecionarTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < VerificacaoEstoque.this.modeloMateriais.getRowCount(); ++i) {
                    MaterialBean bean = (MaterialBean)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Objeto"));
                    if (bean == null || bean.getInativo().booleanValue()) continue;
                    VerificacaoEstoque.this.modeloMateriais.setValueAt(true, i, VerificacaoEstoque.this.modeloMateriais.findColumn("Sel"));
                }
            }
        });
        this.buttonLimparSelecao.setMnemonic('L');
        this.buttonLimparSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < VerificacaoEstoque.this.modeloMateriais.getRowCount(); ++i) {
                    VerificacaoEstoque.this.modeloMateriais.setValueAt(false, i, VerificacaoEstoque.this.modeloMateriais.findColumn("Sel"));
                }
            }
        });
        this.buttonInverterSelecao.setMnemonic('I');
        this.buttonInverterSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < VerificacaoEstoque.this.modeloMateriais.getRowCount(); ++i) {
                    MaterialBean bean = (MaterialBean)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Objeto"));
                    if (bean == null || bean.getInativo().booleanValue()) continue;
                    VerificacaoEstoque.this.modeloMateriais.setValueAt((Boolean)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("sel")) == false, i, VerificacaoEstoque.this.modeloMateriais.findColumn("Sel"));
                }
            }
        });
        this.buttonSelecionarReposicaoAtingida.setMnemonic('E');
        this.buttonSelecionarReposicaoAtingida.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < VerificacaoEstoque.this.modeloMateriais.getRowCount(); ++i) {
                    MaterialBean bean = (MaterialBean)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Objeto"));
                    if (bean == null || bean.getInativo().booleanValue() || VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Ponto Reposi\u00e7\u00e3o")) == null || VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Tot. Estoque")) == null) continue;
                    Double pontoRep = Double.parseDouble(Funcoes.limpaDecimal((String)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Ponto Reposi\u00e7\u00e3o"))));
                    Double saldo = Double.parseDouble(Funcoes.limpaDecimal((String)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Tot. Estoque"))));
                    if (saldo <= pontoRep) {
                        VerificacaoEstoque.this.modeloMateriais.setValueAt(true, i, VerificacaoEstoque.this.modeloMateriais.findColumn("Sel"));
                        continue;
                    }
                    VerificacaoEstoque.this.modeloMateriais.setValueAt(false, i, VerificacaoEstoque.this.modeloMateriais.findColumn("Sel"));
                }
            }
        });
        this.buttonSolicitarCotacao.setMnemonic('S');
        this.buttonSolicitarCotacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Acesso.getAcesso(ACESSO_SOLICITAR_ESTOQUE)) {
                    if (VerificacaoEstoque.this.modeloMateriais.getRowCount() > 0) {
                        ArrayList<Object[]> materiais = new ArrayList<Object[]>();
                        for (int i = 0; i < VerificacaoEstoque.this.modeloMateriais.getRowCount(); ++i) {
                            if (!((Boolean)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Sel"))).booleanValue()) continue;
                            Object[] obj = new Object[2];
                            Double quantidade = 0.0;
                            quantidade = Double.parseDouble(Funcoes.limpaDecimal((String)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Ponto Reposi\u00e7\u00e3o")))) - Double.parseDouble(Funcoes.limpaDecimal((String)VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Tot. Estoque"))));
                            obj[0] = VerificacaoEstoque.this.modeloMateriais.getValueAt(i, VerificacaoEstoque.this.modeloMateriais.findColumn("Material"));
                            obj[1] = quantidade <= 0.0 ? 1.0 : quantidade + 1.0;
                            materiais.add(obj);
                        }
                        if (materiais.size() <= 0) {
                            Funcoes.mensagem(VerificacaoEstoque.this, "Nenhum material selecionado.", 2);
                            return;
                        }
                        SolicitarCotacao.novaInstanciaDialog(Laboratorio.getInstancia(), materiais);
                    } else {
                        Funcoes.mensagem(VerificacaoEstoque.this, "N\u00e3o h\u00e1 materiais.", 2);
                    }
                } else {
                    Funcoes.mensagem(VerificacaoEstoque.this, "Voc\u00ea n\u00e3o possui acesso suficiente para realizar a opera\u00e7\u00e3o.", 2);
                }
            }
        });
        this.textMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (VerificacaoEstoque.this.textMaterial.getText().isEmpty()) {
                    return;
                }
                MaterialBean bean = null;
                try {
                    bean = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, VerificacaoEstoque.this.textMaterial.getText(), null, null);
                }
                catch (Exception e1) {
                    VerificacaoEstoque.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    VerificacaoEstoque.this.materialAux = null;
                    return;
                }
                if (bean != null) {
                    VerificacaoEstoque.this.labelDescricaoMaterial.setText(bean.getDescricao());
                    VerificacaoEstoque.this.materialAux = bean;
                    if (VerificacaoEstoque.this.buttonOk.isEnabled() && VerificacaoEstoque.this.buttonOk.isFocusable()) {
                        VerificacaoEstoque.this.buttonOk.grabFocus();
                    }
                } else {
                    VerificacaoEstoque.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    VerificacaoEstoque.this.materialAux = null;
                }
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VerificacaoEstoque.this.materialAux != null) {
                    VerificacaoEstoque.this.adicionarMaterial(VerificacaoEstoque.this.materialAux);
                }
                VerificacaoEstoque.this.textMaterial.setText("");
                VerificacaoEstoque.this.labelDescricaoMaterial.setText("");
                VerificacaoEstoque.this.materialAux = null;
                if (VerificacaoEstoque.this.textMaterial.isEnabled() && VerificacaoEstoque.this.textMaterial.isFocusable()) {
                    VerificacaoEstoque.this.textMaterial.grabFocus();
                }
            }
        });
        this.buttonBuscaMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerificacaoEstoque.this.buscaMateriais();
            }
        });
        this.modeloMateriais = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Dt. \u00dalt. Compra", "Vlr. \u00dalt. Compra", "Tot. Estoque", "Ponto Reposi\u00e7\u00e3o", "Sel", "Objeto", "Obj Celula"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (VerificacaoEstoque.this.modeloMateriais.findColumn("Sel") == columnIndex && rowIndex >= 0) {
                    MaterialBean aux = (MaterialBean)VerificacaoEstoque.this.modeloMateriais.getValueAt(rowIndex, VerificacaoEstoque.this.modeloMateriais.findColumn("Objeto"));
                    if (aux == null) {
                        return false;
                    }
                    return aux.getInativo() == false;
                }
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, Date.class, Double.class, Double.class, Double.class, Boolean.class, MaterialBean.class, SaldoEstoqueCelulaBean.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (VerificacaoEstoque.this.tableMateriais != null) {
                        VerificacaoEstoque.this.tableMateriais.removeColumn(VerificacaoEstoque.this.tableMateriais.getColumn("Objeto"));
                        VerificacaoEstoque.this.tableMateriais.removeColumn(VerificacaoEstoque.this.tableMateriais.getColumn("Obj Celula"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    VerificacaoEstoque.this.tableMateriais.removeColumn(VerificacaoEstoque.this.tableMateriais.getColumn("Objeto"));
                    VerificacaoEstoque.this.tableMateriais.removeColumn(VerificacaoEstoque.this.tableMateriais.getColumn("Obj Celula"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableMateriais = new JTable(this.modeloMateriais);
        this.tableMateriais.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MaterialBean bean;
                int row;
                if (e.getKeyCode() == 127) {
                    VerificacaoEstoque.this.removerMaterialSelecionado();
                }
                int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                boolean colunaSelecionada = false;
                for (int i = 0; i < colunas.length; ++i) {
                    if (colunas[i] != ((JTable)e.getSource()).getColumnCount() - 1) continue;
                    colunaSelecionada = true;
                    break;
                }
                if (e.getKeyCode() == 32 && !colunaSelecionada && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (bean = (MaterialBean)VerificacaoEstoque.this.modeloMateriais.getValueAt(row, VerificacaoEstoque.this.modeloMateriais.findColumn("Objeto"))) != null && !bean.getInativo().booleanValue()) {
                    Boolean valor = (Boolean)VerificacaoEstoque.this.modeloMateriais.getValueAt(row, VerificacaoEstoque.this.modeloMateriais.findColumn("Sel"));
                    VerificacaoEstoque.this.modeloMateriais.setValueAt(valor == false, row, VerificacaoEstoque.this.modeloMateriais.findColumn("Sel"));
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (VerificacaoEstoque.this.tableMateriais.getSelectedRow() < 0) {
                    return;
                }
                ArrayList detalhes = (ArrayList)VerificacaoEstoque.this.modeloMateriais.getValueAt(VerificacaoEstoque.this.tableMateriais.getSelectedRow(), VerificacaoEstoque.this.modeloMateriais.findColumn("Obj Celula"));
                VerificacaoEstoque.this.mostrarDetalhesCelulas(detalhes);
            }
        });
        this.tableMateriais.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tableMateriais.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ArrayList detalhes = (ArrayList)VerificacaoEstoque.this.modeloMateriais.getValueAt(VerificacaoEstoque.this.tableMateriais.getSelectedRow(), VerificacaoEstoque.this.modeloMateriais.findColumn("Obj Celula"));
                VerificacaoEstoque.this.mostrarDetalhesCelulas(detalhes);
            }
        });
        this.panelBotoesTabela.add(this.buttonSelecionarTodos);
        this.panelBotoesTabela.add(this.buttonLimparSelecao);
        this.panelBotoesTabela.add(this.buttonInverterSelecao);
        this.panelBotoesTabela.add(this.buttonSelecionarReposicaoAtingida);
        this.modeloMateriais.setColumnSize(new int[]{70, 0, 110, 115, 95, 120, 30, 0, 0}, this.tableMateriais);
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("Obj Celula"));
        EstoqueRenderer renderer = new EstoqueRenderer();
        this.tableMateriais.setDefaultRenderer(Integer.class, renderer);
        this.tableMateriais.setDefaultRenderer(String.class, renderer);
        this.tableMateriais.setDefaultRenderer(Date.class, renderer);
        this.tableMateriais.setDefaultRenderer(Double.class, renderer);
        this.scrollMateriais = new JScrollPane(this.tableMateriais);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelMateriais.add((Component)this.scrollMateriais, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.panelMateriais.add((Component)this.panelBotoesTabela, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelMateriais, gridBagConstraints);
        this.panelDetalhamento.setBorder(BorderFactory.createTitledBorder("Detalhamento por C\u00e9lula"));
        this.panelDetalhamento.setLayout(new GridBagLayout());
        this.modeloCelulaMateriais = new ModeloGridTable(new String[]{"C\u00f3digo", "C\u00e9lula", "Saldo", "Inativa?"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, String.class, Boolean.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tableCelulaMateriais = new JTable(this.modeloCelulaMateriais);
        this.tableCelulaMateriais.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.modeloCelulaMateriais.setColumnSize(new int[]{70, 0, 85, 75}, this.tableCelulaMateriais);
        this.tableCelulaMateriais.getTableHeader().addMouseListener(this.modeloCelulaMateriais);
        this.scrollCelulaMateriais = new JScrollPane(this.tableCelulaMateriais);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelDetalhamento.add((Component)this.scrollCelulaMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        this.painelCentral.add((Component)this.panelDetalhamento, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.painelCentral.add((Component)this.panelLegenda, gridBagConstraints);
        this.montaPainelLegenda();
        this.controlaCampos();
        this.modeloMateriais.ordenarColuna(this.modeloMateriais.findColumn("Material"));
        this.modeloCelulaMateriais.ordenarColuna(this.modeloCelulaMateriais.findColumn("C\u00e9lula"));
    }

    private void montaPainelLegenda() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_ABAIXO_PONTO_REPOSICAO);
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Ponto de reposi\u00e7\u00e3o atingido");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 1);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_MATERIAL_INATIVO);
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        lblLegenda = new JLabel("Material Inativo");
        lblLegenda.setFont(font);
        this.panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelLegenda.add((Component)new JLabel(), c);
    }

    private void removerMaterialSelecionado() {
        if (this.modeloMateriais.getRowCount() <= 0 || this.tableMateriais.getSelectedRow() < 0) {
            return;
        }
        this.modeloMateriais.removeLine(this.tableMateriais.getSelectedRow());
        this.modeloCelulaMateriais.clear();
        this.controlaCampos();
    }

    private void mostrarDetalhesCelulas(ArrayList<SaldoEstoqueCelulaBean> detalhes) {
        this.modeloCelulaMateriais.clear();
        if (detalhes != null) {
            for (SaldoEstoqueCelulaBean saldo : detalhes) {
                this.modeloCelulaMateriais.addLine(new Object[]{saldo.getCelula().getCodigo(), saldo.getCelula().getDescricao(), Funcoes.formataDecimal(saldo.getSaldo()), saldo.getCelula().getInativa()});
                if (this.modeloCelulaMateriais.getColunaOrdenacao() != -1) {
                    this.modeloCelulaMateriais.ordenarColunaSemTrocarSentido(this.modeloCelulaMateriais.getColunaOrdenacao());
                    continue;
                }
                this.modeloCelulaMateriais.ordenarColunaSemTrocarSentido(this.modeloCelulaMateriais.findColumn("C\u00e9lula"));
            }
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textMaterial.hasFocus()) {
            this.buttonBuscaMaterial.doClick();
        }
    }

    private void adicionarMaterial(MaterialBean bean) {
        if (bean != null) {
            for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
                if (bean.getCodigo().intValue() != ((Integer)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("C\u00f3digo"))).intValue()) continue;
                return;
            }
            SaldoEstoqueBean saldo = null;
            try {
                saldo = (SaldoEstoqueBean)new SaldoEstoqueService().getSaldoAtualEstoqueMaterial(String.valueOf(bean.getFilial().getCodigo()), String.valueOf(bean.getCodigo()));
            }
            catch (SQLException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar o saldo do estoque do material.", 2);
            }
            catch (ThreadDaoException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar o saldo do estoque do material.", 2);
            }
            ArrayList<SaldoEstoqueCelulaBean> saldoCelulas = null;
            try {
                saldoCelulas = new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterial(String.valueOf(bean.getFilial().getCodigo()), String.valueOf(bean.getCodigo()));
            }
            catch (SQLException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar o saldo do material nas c\u00e9lulas.", 2);
            }
            catch (ThreadDaoException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar o saldo do material nas c\u00e9lulas.", 2);
            }
            this.modeloMateriais.addLine(new Object[]{bean.getCodigo(), bean, Funcoes.formataData(bean.getDataUltimaCompra()), Funcoes.formataDecimal(bean.getValorUltimaCompra()), Funcoes.formataDecimal(saldo == null ? 0.0 : saldo.getSaldo()), Funcoes.formataDecimal(bean.getPontoReposicao()), false, bean, saldoCelulas});
            if (this.modeloMateriais.getColunaOrdenacao() != -1) {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
            } else {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.findColumn("Material"));
            }
        }
        this.controlaCampos();
    }

    private void limparCampos() {
        this.textMaterial.setText("");
        this.labelDescricaoMaterial.setText("");
        this.modeloMateriais.clear();
        this.modeloCelulaMateriais.clear();
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2;
        this.textMaterial.setEnabled(habilitar);
        this.buttonBuscaMaterial.setEnabled(habilitar);
        this.buttonOk.setEnabled(habilitar);
        this.buttonSolicitarCotacao.setEnabled(Acesso.getAcesso(ACESSO_SOLICITAR_ESTOQUE) && habilitar && this.modeloMateriais.getRowCount() > 0);
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (this.textMaterial.isEnabled() && this.textMaterial.isFocusable()) {
            this.textMaterial.grabFocus();
        }
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700800100");
    }

    private void buscaMateriais() {
        try {
            List<HashMap<String, Object>> materiais = null;
            DialogoFiltroMateriais diag = new DialogoFiltroMateriais(Laboratorio.getInstancia());
            diag.setVisible(true);
            if (diag.getOk() && (materiais = diag.getMateriaisSelecionados()) != null) {
                Iterator<HashMap<String, Object>> it = materiais.iterator();
                if (!materiais.isEmpty()) {
                    SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
                    janelaEspera.mostrar("Adicionando materiais");
                    int i = 0;
                    int qtde = materiais.size();
                    while (it.hasNext()) {
                        HashMap<String, Object> reg = it.next();
                        janelaEspera.setText("Adicionando materiais - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
                        MaterialBean material = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, String.valueOf(reg.get("C\u00f3digo")), null, null);
                        if (material == null) continue;
                        this.adicionarMaterial(material);
                    }
                    janelaEspera.apagar();
                }
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel adicionar materiais.", 2);
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class DialogoFiltroMateriais
    extends JDialog
    implements ActionListener {
        private JButton buttonConsultar;
        private JButton buttonDesmarcarTodos;
        private JButton buttonMarcarTodos;
        private JButton buttonOK;
        private JButton buttonCancelar;
        private TTextField textDescricao;
        private CheckItemFiltro itemTipoMaterial;
        private ModeloGridTable modMat;
        private boolean ok;

        public DialogoFiltroMateriais(Frame pai) {
            super(pai, "Pesquisando Materiais", true);
            this.buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
            this.buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
            this.buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.textDescricao = new TTextField(40, 3);
            this.itemTipoMaterial = new CheckItemFiltro("Tipo Material", "Filtrar", "Filtrando Tipo de Material", "fil_codigo = " + Variaveis.filialPadrao);
            this.modMat = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o Material", "Sel"}){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == this.getColumnCount() - 1;
                }

                public Class getColumnClass(int c) {
                    if (c == this.getColumnCount() - 1) {
                        return Boolean.class;
                    }
                    return super.getColumnClass(c);
                }
            };
            this.iniciar();
        }

        public DialogoFiltroMateriais(Dialog pai) {
            super(pai, "Pesquisando Materiais", true);
            this.buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
            this.buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
            this.buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.textDescricao = new TTextField(40, 3);
            this.itemTipoMaterial = new CheckItemFiltro("Tipo Material", "Filtrar", "Filtrando Tipo de Material", "fil_codigo = " + Variaveis.filialPadrao);
            this.modMat = new /* invalid duplicate definition of identical inner class */;
            this.iniciar();
        }

        public boolean getOk() {
            return this.ok;
        }

        public List<HashMap<String, Object>> getMateriaisSelecionados() {
            ArrayList<HashMap<String, Object>> sel = new ArrayList<HashMap<String, Object>>();
            for (int i = 0; i < this.modMat.getRowCount(); ++i) {
                HashMap<String, Object> hash = this.modMat.getLine(i);
                if (!hash.get("Sel").equals(true)) continue;
                sel.add(hash);
            }
            return sel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.buttonOK || o == this.buttonCancelar) {
                this.ok = o == this.buttonOK;
                this.dispose();
            } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
                boolean marcar = o == this.buttonMarcarTodos;
                for (int i = 0; i < this.modMat.getRowCount(); ++i) {
                    this.modMat.setValueAt(marcar, i, this.modMat.findColumn("Sel"));
                }
                this.modMat.fireTableDataChanged();
            } else if (o == this.buttonConsultar) {
                this.consultarMateriais();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void consultarMateriais() {
            Statement st = Conexao.getStatement();
            if (st != null) {
                try {
                    this.buttonConsultar.setEnabled(false);
                    this.modMat.clear();
                    ResultSet res = Conexao.executeQuery(st, this.getSelect());
                    while (res.next()) {
                        Object[] obj = new Object[]{res.getInt("codigo"), res.getString("descricao"), new Boolean(false)};
                        this.modMat.addLine(obj);
                    }
                    this.modMat.fireTableDataChanged();
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                finally {
                    this.buttonConsultar.setEnabled(true);
                }
            }
        }

        private String getSelect() {
            String[] materiais;
            StringBuilder buf = new StringBuilder();
            buf.append(" select mat.mat_codigo as codigo ");
            buf.append("       ,mat.mat_descricao as descricao ");
            buf.append("   from material mat ");
            buf.append("   left join tipomaterial tpm on mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo ");
            buf.append("  where mat.fil_codigo = ").append(Variaveis.filialPadrao);
            if (!Funcoes.textoVazio(this.textDescricao)) {
                buf.append(" and mat_descricao ilike '%").append(this.textDescricao.getText()).append("%' ");
            }
            if ((materiais = this.itemTipoMaterial.getSelecionados()) != null && materiais.length > 0) {
                buf.append(" and tpm.tpm_codigo in (");
                for (int i = 0; i < materiais.length; ++i) {
                    if (i != materiais.length - 1) {
                        buf.append(materiais[i]).append(", ");
                        continue;
                    }
                    buf.append(materiais[i]);
                }
                buf.append(") ");
            }
            buf.append("  order by mat.mat_descricao ");
            return buf.toString();
        }

        private void iniciar() {
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel panelBotoes = new JPanel(new BorderLayout());
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
            JPanel panelTabela = new JPanel(new BorderLayout());
            panelTabela.setBorder(BorderFactory.createTitledBorder("Materiais"));
            JTable table = new JTable(this.modMat);
            this.modMat.setColumnSize(new int[]{60, 0, 20}, table);
            table.getTableHeader().addMouseListener(this.modMat);
            table.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int row;
                    int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                    boolean colunaSelecionada = false;
                    for (int i = 0; i < colunas.length; ++i) {
                        if (colunas[i] != ((JTable)e.getSource()).getColumnCount() - 1) continue;
                        colunaSelecionada = true;
                        break;
                    }
                    if (e.getKeyCode() == 32 && !colunaSelecionada && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                        Boolean valor = (Boolean)DialogoFiltroMateriais.this.modMat.getValueAt(row, DialogoFiltroMateriais.this.modMat.getColumnCount() - 1);
                        DialogoFiltroMateriais.this.modMat.setValueAt(valor == false, row, DialogoFiltroMateriais.this.modMat.getColumnCount() - 1);
                    }
                }
            });
            JScrollPane scroll = new JScrollPane(table);
            scroll.setPreferredSize(new Dimension(600, 200));
            panelTabela.add((Component)scroll, "Center");
            JPanel panelFiltros = new JPanel(new GridBagLayout());
            panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtros"));
            Dimension d = new Dimension(200, 20);
            this.textDescricao.setPreferredSize(d);
            this.textDescricao.setMinimumSize(d);
            this.itemTipoMaterial.setDados("tipomaterial", new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
            this.itemTipoMaterial.setColunaHint(1);
            d = new Dimension(180, 20);
            this.itemTipoMaterial.setPreferredSize(d);
            this.itemTipoMaterial.setMinimumSize(d);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(1, 1, 1, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 17;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 0;
            panelFiltros.add((Component)new JLabel("Descri\u00e7\u00e3o:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textDescricao, c);
            ++c.gridx;
            c.insets = new Insets(0, 20, 0, 0);
            panelFiltros.add((Component)this.itemTipoMaterial, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(0, 0, 0, 0);
            panelFiltros.add((Component)new JLabel(""), c);
            ++c.gridx;
            c.fill = 0;
            c.anchor = 12;
            panelFiltros.add((Component)this.buttonConsultar, c);
            Container panelPrinc = this.getContentPane();
            panelPrinc.setLayout(new GridBagLayout());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 1, 1);
            c.weightx = 0.0;
            c.weighty = 0.0;
            panelPrinc.add((Component)panelFiltros, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 1.0;
            c.fill = 1;
            panelPrinc.add((Component)panelTabela, c);
            ++c.gridy;
            panelPrinc.add((Component)panelBotoes, c);
            Funcoes.montaEnter((JComponent)this.getContentPane());
            this.modMat.ordenarColuna(this.modMat.findColumn("Descri\u00e7\u00e3o Material"));
            this.pack();
            d = new Dimension(250, 200);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setResizable(false);
            ScreenUtil.centralizar(this);
        }
    }

    class EstoqueRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            MaterialBean bean = (MaterialBean)VerificacaoEstoque.this.modeloMateriais.getValueAt(row, VerificacaoEstoque.this.modeloMateriais.findColumn("Objeto"));
            if (bean != null && bean.getInativo().booleanValue()) {
                c.setBackground(COR_MATERIAL_INATIVO);
            } else if (VerificacaoEstoque.this.modeloMateriais.getValueAt(row, VerificacaoEstoque.this.modeloMateriais.findColumn("Ponto Reposi\u00e7\u00e3o")) != null && VerificacaoEstoque.this.modeloMateriais.getValueAt(row, VerificacaoEstoque.this.modeloMateriais.findColumn("Tot. Estoque")) != null) {
                Double pontoRep = Double.parseDouble(Funcoes.limpaDecimal((String)VerificacaoEstoque.this.modeloMateriais.getValueAt(row, VerificacaoEstoque.this.modeloMateriais.findColumn("Ponto Reposi\u00e7\u00e3o"))));
                Double saldo = Double.parseDouble(Funcoes.limpaDecimal((String)VerificacaoEstoque.this.modeloMateriais.getValueAt(row, VerificacaoEstoque.this.modeloMateriais.findColumn("Tot. Estoque"))));
                if (saldo <= pontoRep) {
                    c.setBackground(COR_ABAIXO_PONTO_REPOSICAO);
                }
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

