/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.estoque;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.estoque.CotacaoMaterialBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.CotacaoMaterialService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HistoricoMaterial
extends FrmCadPadrao {
    private final int POS_TAB_DETALHAMENTO_CELULA = 0;
    private final int POS_TAB_MOVIMENTACAO = 1;
    private final int POS_TAB_PATRIMONIO = 2;
    private final int POS_TAB_COTACOES = 3;
    private final int POS_TAB_PEDIDOS = 0;
    private final int POS_TAB_NOTAS = 1;
    private final int LIMITE_BUSCA_INICIAL = 10;
    private final String MASCARA_DECIMAL = "########0.00##";
    private final String LOTE_TODOS = "TODOS";
    private final Color COR_CARREGAR_NORMAL = Color.BLACK;
    private final Color COR_CARREGAR_SOBRE = Color.BLUE;
    private JPanel panelBusca = new JPanel(new GridBagLayout());
    private JPanel panelLotes = new JPanel(new BorderLayout());
    private JPanel panelDetalhes = new JPanel(new GridBagLayout());
    private JPanel panelDetalhamentoCelula = new JPanel(new BorderLayout());
    private JPanel panelMovimentacao = new JPanel(new GridBagLayout());
    private JPanel panelPatrimonios = new JPanel(new BorderLayout());
    private JPanel panelPedidos = new JPanel(new GridBagLayout());
    private JPanel panelNotas = new JPanel(new GridBagLayout());
    private JPanel panelCotacoes = new JPanel(new GridBagLayout());
    private JPanel panelDetalhesUltimaCompra = new JPanel(new GridBagLayout());
    private JPanel panelDetalhesCustos = new JPanel(new GridBagLayout());
    private JPanel panelDetalhesOutros = new JPanel(new GridBagLayout());
    private JPanel panelChecks = new JPanel(new FlowLayout(0));
    private JLabel labelMaterialBusca = new JLabel("Material:");
    private JLabel labelDescricaoMaterialBusca = new JLabel();
    private JLabel labelDataUltimaCompra = new JLabel("Data:");
    private JLabel labelQuantidadeUltimaCompra = new JLabel("Qtde.:");
    private JLabel labelValorUltimaCompra = new JLabel("Valor:");
    private JLabel labelQuantidadeAtual = new JLabel("Qtde. Atual:");
    private JLabel labelPontoReposicao = new JLabel("Ponto Reposi\u00e7\u00e3o:");
    private JLabel labelResponsavel = new JLabel("Respons\u00e1vel:");
    private JLabel labelPeps = new JLabel("Peps (R$):");
    private JLabel labelUeps = new JLabel("Ueps (R$):");
    private JLabel labelCmc = new JLabel("Cmc (R$):");
    private TTextField textMaterialBusca = new TTextField(8, 1);
    private TTextField textDataUltimaCompra = new TTextField();
    private TTextField textQuantidadeUltimaCompra = new TTextField();
    private TTextField textValorUltimaCompra = new TTextField();
    private TTextField textQuantidadeAtual = new TTextField();
    private TTextField textPontoReposicao = new TTextField();
    private TTextField textResponsavel = new TTextField();
    private TTextField textPeps = new TTextField();
    private TTextField textUeps = new TTextField();
    private TTextField textCmc = new TTextField();
    private JButton buttonBuscaMaterial = new JButton();
    private JButton buttonCarregarMaterial = new JButton("Carregar");
    private JLabel labelCarregarTudoMovimentacao = new JLabel("Carregar toda a movimenta\u00e7\u00e3o");
    private JLabel labelCarregarTudoCotacao = new JLabel("Carregar todas as cota\u00e7\u00f5es");
    private JLabel labelCarregarTudoPedido = new JLabel("Carregar todos os pedidos de compra");
    private JLabel labelCarregarTudoNota = new JLabel("Carregar todas as notas fiscais de entrada");
    private JCheckBox checkInativo = new JCheckBox("Inativo");
    private JCheckBox checkImobilizado = new JCheckBox("Imobilizado");
    private JCheckBox checkReutilizavel = new JCheckBox("Reutiliz\u00e1vel");
    private JCheckBox checkSolicitaLote = new JCheckBox("Solic. lote");
    private JCheckBox checkSolicitaPatrimonio = new JCheckBox("Solic. patrim\u00f4nio");
    private JCheckBox checkCriarLoteKit = new JCheckBox("Criar lote no kit");
    private JTabbedPane paneMaterial = new JTabbedPane(1);
    private JTabbedPane paneLotes = new JTabbedPane(1);
    private ModeloGridTable modeloQuantidadeCelula;
    private ModeloGridTable modeloMovimentacao;
    private ModeloGridTable modeloPatrimonios;
    private ModeloGridTable modeloPedidos;
    private ModeloGridTable modeloNotas;
    private ModeloGridTable modeloCotacao;
    private JScrollPane scrollQuantidadeCelula;
    private JScrollPane scrollMovimentacao;
    private JScrollPane scrollPatrimonios;
    private JScrollPane scrollPedidos;
    private JScrollPane scrollNotas;
    private JScrollPane scrollCotacao;
    private JScrollPane scrollListaLotes;
    private JTable tableQuantidadeCelula;
    private JTable tableMovimentacao;
    private JTable tablePatrimonios;
    private JTable tablePedidos;
    private JTable tableNotas;
    private JTable tableCotacao;
    private DefaultListModel modeloListaLotes = new DefaultListModel();
    private JList listLotes = new JList(this.modeloListaLotes);
    private MaterialBean materialAux = null;

    public HistoricoMaterial() {
        this.controlaCampos();
        this.montaTela();
        this.montaAtalhos();
        this.novo();
    }

    private void montaAtalhos() {
        this.paneMaterial.setMnemonicAt(0, 68);
        this.paneMaterial.setMnemonicAt(1, 86);
        this.paneMaterial.setMnemonicAt(2, 84);
        this.paneMaterial.setMnemonicAt(3, 79);
        this.paneLotes.setMnemonicAt(0, 80);
        this.paneLotes.setMnemonicAt(1, 78);
    }

    private void montaTela() {
        EventoMouse eventoMouse = new EventoMouse();
        Funcoes.criaBarraDescricao(this, "Hist\u00f3rico de Material", "Detalhamento de informa\u00e7\u00f5es diversas de materiais", "consultas/historico_material.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelDescricaoMaterialBusca}, new TitledBorder(""));
        this.painelBotoes.removeAll();
        this.painelBotoes.add(this.botaoNovo);
        this.painelBotoes.add(this.botaoCancelar);
        this.painelBotoes.add(this.botaoFechar);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        this.labelMaterialBusca.setDisplayedMnemonic('M');
        this.labelMaterialBusca.setLabelFor(this.textMaterialBusca);
        this.panelBusca.add((Component)this.labelMaterialBusca, c);
        this.textMaterialBusca.setMinimumSize(new Dimension(70, 20));
        this.textMaterialBusca.setPreferredSize(new Dimension(70, 20));
        this.panelBusca.add((Component)this.textMaterialBusca, new GridBagConstraints());
        this.textMaterialBusca.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(HistoricoMaterial.this.textMaterialBusca)) {
                    HistoricoMaterial.this.labelDescricaoMaterialBusca.setText("");
                } else {
                    try {
                        MaterialVO material = (MaterialVO)new MaterialService().getTodosVO(Variaveis.filialPadrao.toString(), HistoricoMaterial.this.textMaterialBusca.getText());
                        if (material != null) {
                            HistoricoMaterial.this.labelDescricaoMaterialBusca.setText(material.getDescricao());
                        } else {
                            HistoricoMaterial.this.labelDescricaoMaterialBusca.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(HistoricoMaterial.this, "N\u00e3o foi poss\u00edvel buscar dados do material.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
            }
        });
        this.textMaterialBusca.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    HistoricoMaterial.this.pesquisaMaterial();
                }
            }
        });
        this.buttonBuscaMaterial.setFocusable(false);
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonBuscaMaterial);
        this.panelBusca.add((Component)this.buttonBuscaMaterial, new GridBagConstraints());
        this.buttonBuscaMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoricoMaterial.this.pesquisaMaterial();
            }
        });
        c.fill = 2;
        c.weightx = 1.0;
        this.labelDescricaoMaterialBusca.setPreferredSize(new Dimension(20, 20));
        this.labelDescricaoMaterialBusca.setMinimumSize(new Dimension(20, 20));
        this.labelDescricaoMaterialBusca.setRequestFocusEnabled(false);
        this.panelBusca.add((Component)this.labelDescricaoMaterialBusca, c);
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonCarregarMaterial.setMnemonic('a');
        this.buttonCarregarMaterial.setMinimumSize(new Dimension(80, 20));
        this.buttonCarregarMaterial.setMargin(new Insets(1, 1, 1, 1));
        this.panelBusca.add((Component)this.buttonCarregarMaterial, new GridBagConstraints());
        this.buttonCarregarMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(HistoricoMaterial.this.textMaterialBusca)) {
                    HistoricoMaterial.this.carregaDados(HistoricoMaterial.this.textMaterialBusca.getText());
                }
                HistoricoMaterial.this.controlaCampos();
            }
        });
        this.listLotes.setCellRenderer(new ListRenderer());
        this.listLotes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ObjetoLote lote = (ObjetoLote)HistoricoMaterial.this.listLotes.getSelectedValue();
                if (lote != null) {
                    HistoricoMaterial.this.buscaPedidos(lote, Variaveis.filialPadrao.toString(), HistoricoMaterial.this.materialAux.getCodigo().toString(), lote.todosPedidosCarregados ? null : Integer.valueOf(10));
                    HistoricoMaterial.this.buscaNotas(lote, Variaveis.filialPadrao.toString(), HistoricoMaterial.this.materialAux.getCodigo().toString(), lote.todasNotasCarregadas ? null : Integer.valueOf(10));
                }
            }
        });
        this.scrollListaLotes = new JScrollPane(this.listLotes);
        this.scrollListaLotes.setPreferredSize(new Dimension(120, 190));
        this.scrollListaLotes.setMinimumSize(new Dimension(120, 190));
        this.panelLotes.add((Component)this.scrollListaLotes, "West");
        this.panelLotes.add((Component)this.paneLotes, "Center");
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.panelDetalhes.add((Component)this.panelChecks, c);
        Dimension d = new Dimension(ScreenUtil.getTamanhoString((String)this.checkInativo.getText(), (Font)this.checkInativo.getFont()).width + 25, 15);
        this.checkInativo.setMinimumSize(d);
        this.checkInativo.setPreferredSize(d);
        d = new Dimension(ScreenUtil.getTamanhoString((String)this.checkSolicitaLote.getText(), (Font)this.checkSolicitaLote.getFont()).width + 25, 15);
        this.checkSolicitaLote.setMinimumSize(d);
        this.checkSolicitaLote.setPreferredSize(d);
        d = new Dimension(ScreenUtil.getTamanhoString((String)this.checkSolicitaPatrimonio.getText(), (Font)this.checkSolicitaPatrimonio.getFont()).width + 25, 15);
        this.checkSolicitaPatrimonio.setMinimumSize(d);
        this.checkSolicitaPatrimonio.setPreferredSize(d);
        d = new Dimension(ScreenUtil.getTamanhoString((String)this.checkImobilizado.getText(), (Font)this.checkImobilizado.getFont()).width + 25, 15);
        this.checkImobilizado.setMinimumSize(d);
        this.checkImobilizado.setPreferredSize(d);
        d = new Dimension(ScreenUtil.getTamanhoString((String)this.checkReutilizavel.getText(), (Font)this.checkReutilizavel.getFont()).width + 25, 15);
        this.checkReutilizavel.setMinimumSize(d);
        this.checkReutilizavel.setPreferredSize(d);
        d = new Dimension(ScreenUtil.getTamanhoString((String)this.checkCriarLoteKit.getText(), (Font)this.checkCriarLoteKit.getFont()).width + 25, 15);
        this.checkCriarLoteKit.setMinimumSize(d);
        this.checkCriarLoteKit.setPreferredSize(d);
        this.panelChecks.add(this.checkInativo);
        this.panelChecks.add(this.checkImobilizado);
        this.panelChecks.add(this.checkReutilizavel);
        this.panelChecks.add(this.checkSolicitaLote);
        this.panelChecks.add(this.checkSolicitaPatrimonio);
        this.panelChecks.add(this.checkCriarLoteKit);
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelDetalhes.add((Component)this.panelDetalhesUltimaCompra, c);
        ++c.gridx;
        this.panelDetalhes.add((Component)this.panelDetalhesCustos, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelDetalhes.add((Component)this.panelDetalhesOutros, c);
        this.panelDetalhesUltimaCompra.setBorder(new TitledBorder("\u00daltima Compra"));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 0;
        this.panelDetalhesUltimaCompra.add((Component)this.labelDataUltimaCompra, c);
        ++c.gridx;
        this.textDataUltimaCompra.setMinimumSize(new Dimension(90, 20));
        this.textDataUltimaCompra.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesUltimaCompra.add((Component)this.textDataUltimaCompra, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelDetalhesUltimaCompra.add((Component)this.labelQuantidadeUltimaCompra, c);
        ++c.gridx;
        this.textQuantidadeUltimaCompra.setMinimumSize(new Dimension(90, 20));
        this.textQuantidadeUltimaCompra.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesUltimaCompra.add((Component)this.textQuantidadeUltimaCompra, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelDetalhesUltimaCompra.add((Component)this.labelValorUltimaCompra, c);
        ++c.gridx;
        this.textValorUltimaCompra.setMinimumSize(new Dimension(90, 20));
        this.textValorUltimaCompra.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesUltimaCompra.add((Component)this.textValorUltimaCompra, c);
        this.panelDetalhesCustos.setBorder(new TitledBorder("Custos"));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 0;
        this.panelDetalhesCustos.add((Component)this.labelPeps, c);
        ++c.gridx;
        this.textPeps.setMinimumSize(new Dimension(90, 20));
        this.textPeps.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesCustos.add((Component)this.textPeps, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelDetalhesCustos.add((Component)this.labelUeps, c);
        ++c.gridx;
        this.textUeps.setMinimumSize(new Dimension(90, 20));
        this.textUeps.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesCustos.add((Component)this.textUeps, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelDetalhesCustos.add((Component)this.labelCmc, c);
        ++c.gridx;
        this.textCmc.setMinimumSize(new Dimension(90, 20));
        this.textCmc.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesCustos.add((Component)this.textCmc, c);
        this.panelDetalhesOutros.setBorder(new TitledBorder("Outras Informa\u00e7\u00f5es"));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 0;
        this.panelDetalhesOutros.add((Component)this.labelQuantidadeAtual, c);
        ++c.gridx;
        this.textQuantidadeAtual.setMinimumSize(new Dimension(90, 20));
        this.textQuantidadeAtual.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesOutros.add((Component)this.textQuantidadeAtual, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelDetalhesOutros.add((Component)this.labelPontoReposicao, c);
        ++c.gridx;
        this.textPontoReposicao.setMinimumSize(new Dimension(90, 20));
        this.textPontoReposicao.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesOutros.add((Component)this.textPontoReposicao, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelDetalhesOutros.add((Component)this.labelResponsavel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.textResponsavel.setMinimumSize(new Dimension(90, 20));
        this.textResponsavel.setPreferredSize(new Dimension(90, 20));
        this.panelDetalhesOutros.add((Component)this.textResponsavel, c);
        this.paneMaterial.addTab("Detalhamento por C\u00e9lula", this.panelDetalhamentoCelula);
        this.paneMaterial.addTab("Movimenta\u00e7\u00e3o", this.panelMovimentacao);
        this.paneMaterial.addTab("Patrim\u00f4nio", this.panelPatrimonios);
        this.paneMaterial.addTab("Cota\u00e7\u00f5es", this.panelCotacoes);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelDetalhes.add((Component)this.paneMaterial, c);
        this.modeloQuantidadeCelula = new ModeloGridTable(new String[]{"C\u00f3digo", "C\u00e9lula", "Quantidade"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, String.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tableQuantidadeCelula = new JTable(this.modeloQuantidadeCelula);
        this.modeloQuantidadeCelula.setColumnSize(new int[]{60, 0, 80}, this.tableQuantidadeCelula);
        this.tableQuantidadeCelula.getTableHeader().addMouseListener(this.modeloQuantidadeCelula);
        this.scrollQuantidadeCelula = new JScrollPane(this.tableQuantidadeCelula);
        this.panelDetalhamentoCelula.add((Component)this.scrollQuantidadeCelula, "Center");
        this.modeloMovimentacao = new ModeloGridTable(new String[]{"Data/Hora", "Usu\u00e1rio", "Tipo", "Vl. Unit\u00e1rio", "Qtde.", "Vl. Total", "Origem"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tableMovimentacao = new JTable(this.modeloMovimentacao);
        this.modeloMovimentacao.setColumnSize(new int[]{135, 0, 60, 80, 60, 80, 0}, this.tableMovimentacao);
        this.tableMovimentacao.getTableHeader().addMouseListener(this.modeloMovimentacao);
        this.scrollMovimentacao = new JScrollPane(this.tableMovimentacao);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelMovimentacao.add((Component)this.scrollMovimentacao, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelMovimentacao.add((Component)this.labelCarregarTudoMovimentacao, c);
        this.labelCarregarTudoMovimentacao.addMouseListener(eventoMouse);
        this.modeloPatrimonios = new ModeloGridTable(new String[]{"Patrim\u00f4nio", "N\u00famero NF.", "S\u00e9rie NF.", "Setor"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{String.class, Integer.class, String.class, String.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tablePatrimonios = new JTable(this.modeloPatrimonios);
        this.modeloPatrimonios.setColumnSize(new int[]{120, 90, 70, 0}, this.tablePatrimonios);
        this.tablePatrimonios.getTableHeader().addMouseListener(this.modeloPatrimonios);
        this.scrollPatrimonios = new JScrollPane(this.tablePatrimonios);
        this.panelPatrimonios.add((Component)this.scrollPatrimonios, "Center");
        this.modeloCotacao = new ModeloGridTable(new String[]{"C\u00f3digo", "Data", "Situa\u00e7\u00e3o", "Qtde. Original", "Observa\u00e7\u00e3o"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, String.class, String.class, String.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tableCotacao = new JTable(this.modeloCotacao);
        this.modeloCotacao.setColumnSize(new int[]{60, 90, 80, 90, 0}, this.tableCotacao);
        this.tableCotacao.getTableHeader().addMouseListener(this.modeloCotacao);
        this.scrollCotacao = new JScrollPane(this.tableCotacao);
        this.scrollCotacao.setPreferredSize(new Dimension(20, 100));
        this.scrollCotacao.setMinimumSize(new Dimension(20, 100));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelCotacoes.add((Component)this.scrollCotacao, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelCotacoes.add((Component)this.labelCarregarTudoCotacao, c);
        this.labelCarregarTudoCotacao.addMouseListener(eventoMouse);
        this.panelLotes.setBorder(new TitledBorder("Lotes"));
        this.paneLotes.addTab("Pedidos", this.panelPedidos);
        this.paneLotes.addTab("Notas", this.panelNotas);
        this.modeloPedidos = new ModeloGridTable(new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Data", "Valor Unit.", "Qtde.", "Total Mat."}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, String.class, String.class, String.class, String.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tablePedidos = new JTable(this.modeloPedidos);
        this.modeloPedidos.setColumnSize(new int[]{60, 0, 90, 80, 60, 80}, this.tablePedidos);
        this.tablePedidos.getTableHeader().addMouseListener(this.modeloPedidos);
        this.scrollPedidos = new JScrollPane(this.tablePedidos);
        this.scrollPedidos.setPreferredSize(new Dimension(20, 100));
        this.scrollPedidos.setMinimumSize(new Dimension(20, 100));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelPedidos.add((Component)this.scrollPedidos, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelPedidos.add((Component)this.labelCarregarTudoPedido, c);
        this.labelCarregarTudoPedido.addMouseListener(eventoMouse);
        this.modeloNotas = new ModeloGridTable(new String[]{"N\u00famero", "S\u00e9r.", "Raz\u00e3o Social", "Data", "Valor Unit.", "Qtde.", "Total Mat."}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tableNotas = new JTable(this.modeloNotas);
        this.modeloNotas.setColumnSize(new int[]{60, 40, 0, 90, 80, 60, 80}, this.tableNotas);
        this.tableNotas.getTableHeader().addMouseListener(this.modeloNotas);
        this.scrollNotas = new JScrollPane(this.tableNotas);
        this.scrollNotas.setPreferredSize(new Dimension(20, 100));
        this.scrollNotas.setMinimumSize(new Dimension(20, 100));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelNotas.add((Component)this.scrollNotas, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelNotas.add((Component)this.labelCarregarTudoNota, c);
        this.labelCarregarTudoNota.addMouseListener(eventoMouse);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.panelBusca, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 0.7;
        this.painelCentral.add((Component)this.panelDetalhes, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 0.3;
        this.painelCentral.add((Component)this.panelLotes, c);
    }

    private void carregaDados(String codigoMaterial) {
        String filial = Variaveis.filialPadrao.toString();
        try {
            this.materialAux = (MaterialBean)new MaterialService().getTodos(filial, codigoMaterial, null, null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material.\n" + e.getMessage(), e.getStackTrace());
        }
        if (this.materialAux != null) {
            this.checkInativo.setSelected(this.materialAux.getInativo());
            this.checkImobilizado.setSelected(this.materialAux.getImobilizado());
            this.checkReutilizavel.setSelected(this.materialAux.getReutilizavel());
            this.checkSolicitaLote.setSelected(this.materialAux.getSolicitarLote());
            this.checkSolicitaPatrimonio.setSelected(this.materialAux.getSolicitarPatrimonio());
            this.checkCriarLoteKit.setSelected(this.materialAux.getFichaTecnica());
            this.textDataUltimaCompra.setText(Funcoes.formataData("dd/MM/yyyy", this.materialAux.getDataUltimaCompra()));
            this.textQuantidadeUltimaCompra.setText(Funcoes.formataDecimal("########0.00##", this.materialAux.getQuantidadeUltimaCompra()));
            this.textValorUltimaCompra.setText(Funcoes.formataDecimal("########0.00##", this.materialAux.getValorTotalUltimaCompra()));
            this.textPontoReposicao.setText(Funcoes.formataDecimal(this.materialAux.getPontoReposicao()));
            if (this.materialAux.getUsuario() != null) {
                this.textResponsavel.setText(this.materialAux.getUsuario().toString());
            }
            this.buscaLotes(filial, codigoMaterial);
            this.buscaSaldoValoresAtuais(filial, codigoMaterial);
            this.buscaQuantidadesCelula(filial, codigoMaterial);
            this.buscaMovimentacao(filial, codigoMaterial, 10);
            this.buscaPatrimonios(this.materialAux.getPatrimonios());
            this.buscaCotacoes(filial, codigoMaterial, 10);
        }
    }

    private void buscaLotes(String codigoFilial, String codigoMaterial) {
        this.modeloListaLotes.removeAllElements();
        this.modeloListaLotes.addElement(new ObjetoLote("TODOS"));
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", codigoFilial);
        chaves.put("mat_codigo", codigoMaterial);
        try {
            ArrayList<MaterialLoteBean> listaLotes = new MaterialLoteService().getBeans(chaves, true);
            if (listaLotes != null) {
                Collections.sort(listaLotes);
            }
            for (int i = 0; i < listaLotes.size(); ++i) {
                MaterialLoteBean aux = listaLotes.get(i);
                this.modeloListaLotes.addElement(new ObjetoLote(aux.getLote(), aux.getLote(), aux.getDataLote(), aux.getValidadeLote(), aux.getQuantidade(), aux.getQuantidade() - aux.getQuantidadeConsumida()));
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar lotes do material.\n" + e.getMessage(), e.getStackTrace());
        }
        this.listLotes.setSelectionInterval(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaSaldoValoresAtuais(String codigoFilial, String codigoMaterial) {
        Statement st;
        block5: {
            StringBuilder buf = new StringBuilder();
            buf.append(" select sde_saldo as saldo ");
            buf.append("       ,sde_totalpeps as peps ");
            buf.append("       ,sde_totalueps as ueps ");
            buf.append("       ,sde_totalcmc as cmc ");
            buf.append("   from saldoestoque ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and mat_codigo = ").append(codigoMaterial);
            buf.append("  order by sde_saldo desc ");
            buf.append("  limit 1 ");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.textQuantidadeAtual.setText(Funcoes.formataDecimal(rs.getDouble("saldo")));
                    this.textPeps.setText(Funcoes.formataDecimal("########0.00##", rs.getDouble("peps")));
                    this.textUeps.setText(Funcoes.formataDecimal("########0.00##", rs.getDouble("ueps")));
                    this.textCmc.setText(Funcoes.formataDecimal("########0.00##", rs.getDouble("cmc")));
                    break block5;
                }
                this.textQuantidadeAtual.setText(Funcoes.formataDecimal(0));
                this.textPeps.setText(Funcoes.formataDecimal("########0.00##", 0));
                this.textUeps.setText(Funcoes.formataDecimal("########0.00##", 0));
                this.textCmc.setText(Funcoes.formataDecimal("########0.00##", 0));
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar saldo/valores atuais.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    private void buscaQuantidadesCelula(String codigoFilial, String codigoMaterial) {
        try {
            ArrayList<SaldoEstoqueCelulaBean> saldo = new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterial(codigoFilial, codigoMaterial);
            if (saldo != null) {
                for (SaldoEstoqueCelulaBean s : saldo) {
                    this.modeloQuantidadeCelula.addLine(new Object[]{s.getCelula().getCodigo(), s.getCelula().getDescricao(), Funcoes.formataDecimal("########0.00##", s.getSaldo())});
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar quantidades das c\u00e9lulas.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void buscaMovimentacao(String codigoFilial, String codigoMaterial, Integer limite) {
        this.modeloMovimentacao.clear();
        try {
            ArrayList<LancamentoEstoqueBean> lancamentos = new LancamentoEstoqueService().getLancamentosMaterial(codigoFilial, codigoMaterial, limite);
            if (lancamentos != null) {
                for (LancamentoEstoqueBean l : lancamentos) {
                    Object[] linha = new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", l.getDataHora()), l.getUsuario().getCodigo(), Tipos.tipoLancamentoEstoque(l.getTipo()), Funcoes.formataDecimal("########0.00##", l.getValorUnitario()), Funcoes.formataDecimal("########0.00##", l.getQuantidade()), Funcoes.formataDecimal("########0.00##", l.getValorTotal()), Tipos.tipoOrigemLancamentoEstoque(l.getTipoOrigem())};
                    this.modeloMovimentacao.addLine(linha);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar quantidades das c\u00e9lulas.\n" + e.getMessage(), e.getStackTrace());
        }
        this.labelCarregarTudoMovimentacao.setVisible(limite != null);
    }

    private void buscaPatrimonios(ArrayList<MaterialPatrimonioBean> patrimonios) {
        if (patrimonios != null) {
            for (MaterialPatrimonioBean aux : patrimonios) {
                this.modeloPatrimonios.addLine(new Object[]{aux.getPatrimonio(), aux.getNumeroNotaFiscal(), aux.getSerie(), aux.getSetor().getDescricao()});
            }
        }
    }

    private void buscaCotacoes(String codigoFilial, String codigoMaterial, Integer limite) {
        this.modeloCotacao.clear();
        try {
            ArrayList<CotacaoMaterialBean> cotacoes = new CotacaoMaterialService().getCotacoesMaterial(codigoFilial, codigoMaterial, limite);
            if (cotacoes != null) {
                for (CotacaoMaterialBean c : cotacoes) {
                    Object[] linha = new Object[]{c.getCotacao().getCodigo(), Funcoes.formataData("dd/MM/yyyy", c.getCotacao().getDataHora()), Tipos.tipoCotacao(c.getCotacao().getSituacao()), Funcoes.formataDecimal("########0.00##", c.getQuantidade()), c.getCotacao().getObservacao()};
                    this.modeloCotacao.addLine(linha);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar quantidades das c\u00e9lulas.\n" + e.getMessage(), e.getStackTrace());
        }
        this.labelCarregarTudoCotacao.setVisible(limite != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void buscaNotas(ObjetoLote objeto, String codigoFilial, String codigoMaterial, Integer limite) {
        block11: {
            Statement st;
            this.modeloNotas.clear();
            if (objeto != null && objeto.dadosNotas != null && (objeto.todasNotasCarregadas && limite == null || !objeto.todasNotasCarregadas && limite != null)) {
                ArrayList<Object[]> linhas = objeto.dadosNotas;
                for (Object[] linha : linhas) {
                    this.modeloNotas.addLine(linha);
                }
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append(" select nfi.nfi_numero as numero ");
                buf.append("       ,nfi.ser_codigo as serie ");
                buf.append("       ,ent.ent_razaosocial as razaosocial");
                buf.append("       ,nfi.nfi_datahora as datahora ");
                buf.append("       ,nfm.nfm_valorunitario as valorunitario");
                buf.append("       ,nfm.nfm_quantidade as quantidade");
                buf.append("       ,nfm.nfm_valortotal as valortotal");
                if (objeto.lote != null) {
                    buf.append("   from materiallote mll ");
                    buf.append("   join lanctoestoque lce on mll.fil_codigo = lce.fil_codigo and mll.lce_codigo = lce.lce_codigo ");
                    buf.append("   join notafiscallanctoestoque nle on lce.fil_codigo = nle.fil_codigo and lce.lce_codigo = nle.lce_codigo ");
                    buf.append("   join notafiscal nfi on nle.fil_codigo = nfi.fil_codigo and nle.nfi_codigo = nfi.nfi_codigo ");
                    buf.append("   join entidade ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
                    buf.append("   join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo and mll.mat_codigo = nfm.mat_codigo ");
                    buf.append("  where mll.fil_codigo = ").append(codigoFilial);
                    buf.append("    and mll.mat_codigo = ").append(codigoMaterial);
                    buf.append("    and mll.mll_lote = '").append(objeto.lote).append("' ");
                } else {
                    buf.append("   from notafiscal nfi ");
                    buf.append("   join entidade ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
                    buf.append("   join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo ");
                    buf.append("  where nfm.fil_codigo = ").append(codigoFilial);
                    buf.append("    and nfm.mat_codigo = ").append(codigoMaterial);
                }
                buf.append("    and nfi.usr_codcancelada IS NULL ");
                buf.append("  order by nfi.nfi_datahora desc ");
                if (limite != null) {
                    buf.append("  limit ").append(limite);
                }
                st = Conexao.getStatement();
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                ArrayList<Object[]> linhas = new ArrayList<Object[]>();
                while (rs.next()) {
                    Object[] linha = new Object[]{rs.getInt("numero"), rs.getString("serie"), rs.getString("razaosocial"), Funcoes.formataData("dd/MM/yyyy", rs.getDate("datahora")), Funcoes.formataDecimal("########0.00##", rs.getDouble("valorunitario")), Funcoes.formataDecimal("########0.00##", rs.getDouble("quantidade")), Funcoes.formataDecimal("########0.00##", rs.getDouble("valortotal"))};
                    this.modeloNotas.addLine(linha);
                    linhas.add(linha);
                }
                objeto.setDadosNotas(limite == null, linhas);
                Conexao.fecharStatement(st);
            }
            break block11;
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar notas fiscais.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        this.labelCarregarTudoNota.setVisible(limite != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void buscaPedidos(ObjetoLote objeto, String codigoFilial, String codigoMaterial, Integer limite) {
        block11: {
            Statement st;
            this.modeloPedidos.clear();
            if (objeto != null && objeto.dadosPedidos != null && (objeto.todosPedidosCarregados && limite == null || !objeto.todosPedidosCarregados && limite != null)) {
                ArrayList<Object[]> linhas = objeto.dadosPedidos;
                for (Object[] linha : linhas) {
                    this.modeloPedidos.addLine(linha);
                }
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append(" select ped.ped_codigo as codigo ");
                buf.append("       ,entped.ent_razaosocial as razaosocial");
                buf.append("       ,ped.ped_datahora as datahora ");
                buf.append("       ,pma.pma_valorunitario as valorunitario ");
                buf.append("       ,pma.pma_quantidade as quantidade ");
                buf.append("       ,pma.pma_total as valortotal ");
                if (objeto.lote != null) {
                    buf.append("   from materiallote mll ");
                    buf.append("   join lanctoestoque lce on mll.fil_codigo = lce.fil_codigo and mll.lce_codigo = lce.lce_codigo ");
                    buf.append("   join pedidolanctoestoque ple on lce.fil_codigo = ple.fil_codigo and lce.lce_codigo = ple.lce_codigo ");
                    buf.append("   join pedido ped on ple.fil_codigo = ped.fil_codigo and ple.ped_codigo = ped.ped_codigo ");
                    buf.append("   join entidade entped on ped.fil_codigo = entped.fil_codigo and ped.ent_codigo = entped.ent_codigo ");
                    buf.append("   join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo and mll.mat_codigo = pma.mat_codigo ");
                    buf.append("  where mll.fil_codigo = ").append(codigoFilial);
                    buf.append("    and mll.mat_codigo = ").append(codigoMaterial);
                    buf.append("    and mll.mll_lote = '").append(objeto.lote).append("' ");
                } else {
                    buf.append("   from pedido ped ");
                    buf.append("   join entidade entped on ped.fil_codigo = entped.fil_codigo and ped.ent_codigo = entped.ent_codigo ");
                    buf.append("   join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo ");
                    buf.append("  where pma.fil_codigo = ").append(codigoFilial);
                    buf.append("    and pma.mat_codigo = ").append(codigoMaterial);
                }
                buf.append("    and ped.ped_dataexclusao IS NULL ");
                buf.append("  order by ped.ped_datahora desc ");
                if (limite != null) {
                    buf.append("  limit ").append(limite);
                }
                st = Conexao.getStatement();
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                ArrayList<Object[]> linhas = new ArrayList<Object[]>();
                while (rs.next()) {
                    Object[] linha = new Object[]{rs.getInt("codigo"), rs.getString("razaosocial"), Funcoes.formataData("dd/MM/yyyy", rs.getDate("datahora")), Funcoes.formataDecimal("########0.00##", rs.getDouble("valorunitario")), Funcoes.formataDecimal("########0.00##", rs.getDouble("quantidade")), Funcoes.formataDecimal("########0.00##", rs.getDouble("valortotal"))};
                    this.modeloPedidos.addLine(linha);
                    linhas.add(linha);
                }
                objeto.setDadosPedidos(limite == null, linhas);
                Conexao.fecharStatement(st);
            }
            break block11;
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar pedidos de compra.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        this.labelCarregarTudoPedido.setVisible(limite != null);
    }

    private void pesquisaMaterial() {
        try {
            MaterialVO material = (MaterialVO)new MaterialService().pesquisaTodosVO(Laboratorio.getInstancia(), new MaterialVO(), "Pesquisando materiais", false);
            if (material != null) {
                this.textMaterialBusca.setText(material.getCodigo().toString());
                this.labelDescricaoMaterialBusca.setText(material.getDescricao());
            } else {
                this.labelDescricaoMaterialBusca.setText("");
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do material.\n" + e1.getMessage(), e1.getStackTrace());
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (this.textMaterialBusca.isEnabled() && this.textMaterialBusca.isFocusable()) {
            this.textMaterialBusca.grabFocus();
        }
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    public void cancelar() {
        this.limparCampos();
        this.setStatus(1);
        this.controlaCampos();
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700800200");
    }

    private void controlaCampos() {
        boolean insert = this.getStatus() == 2;
        boolean materialSelecionado = this.materialAux != null;
        this.textMaterialBusca.setEnabled(!materialSelecionado && insert);
        this.buttonBuscaMaterial.setEnabled(!materialSelecionado && insert);
        this.buttonCarregarMaterial.setEnabled(!materialSelecionado && insert);
        this.checkInativo.setEnabled(false);
        this.checkImobilizado.setEnabled(false);
        this.checkReutilizavel.setEnabled(false);
        this.checkSolicitaLote.setEnabled(false);
        this.checkSolicitaPatrimonio.setEnabled(false);
        this.checkCriarLoteKit.setEnabled(false);
        this.textDataUltimaCompra.setEnabled(false);
        this.textQuantidadeUltimaCompra.setEnabled(false);
        this.textValorUltimaCompra.setEnabled(false);
        this.textQuantidadeAtual.setEnabled(false);
        this.textPontoReposicao.setEnabled(false);
        this.textResponsavel.setEnabled(false);
        this.textPeps.setEnabled(false);
        this.textUeps.setEnabled(false);
        this.textCmc.setEnabled(false);
        if (!materialSelecionado) {
            this.labelCarregarTudoCotacao.setVisible(false);
            this.labelCarregarTudoMovimentacao.setVisible(false);
            this.labelCarregarTudoNota.setVisible(false);
            this.labelCarregarTudoPedido.setVisible(false);
        }
        if (this.scrollListaLotes != null) {
            this.scrollListaLotes.setVisible(this.modeloListaLotes != null && this.modeloListaLotes.size() > 1);
        }
    }

    private void limparCampos() {
        this.textMaterialBusca.clear();
        this.labelDescricaoMaterialBusca.setText("");
        this.checkInativo.setSelected(false);
        this.checkImobilizado.setSelected(false);
        this.checkReutilizavel.setSelected(false);
        this.checkSolicitaLote.setSelected(false);
        this.checkSolicitaPatrimonio.setSelected(false);
        this.checkCriarLoteKit.setSelected(false);
        this.textDataUltimaCompra.clear();
        this.textQuantidadeUltimaCompra.clear();
        this.textValorUltimaCompra.clear();
        this.textQuantidadeAtual.clear();
        this.textPontoReposicao.clear();
        this.textResponsavel.clear();
        this.textPeps.clear();
        this.textUeps.clear();
        this.textCmc.clear();
        this.modeloQuantidadeCelula.clear();
        this.modeloMovimentacao.clear();
        this.modeloPatrimonios.clear();
        this.modeloListaLotes.clear();
        this.modeloPedidos.clear();
        this.modeloNotas.clear();
        this.modeloCotacao.clear();
        this.materialAux = null;
    }

    class EventoMouse
    extends MouseAdapter {
        EventoMouse() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ((JLabel)e.getSource()).setForeground(HistoricoMaterial.this.COR_CARREGAR_SOBRE);
            HistoricoMaterial.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ((JLabel)e.getSource()).setForeground(HistoricoMaterial.this.COR_CARREGAR_NORMAL);
            HistoricoMaterial.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ObjetoLote lote = (ObjetoLote)HistoricoMaterial.this.listLotes.getSelectedValue();
            if (e.getSource() == HistoricoMaterial.this.labelCarregarTudoCotacao) {
                HistoricoMaterial.this.buscaCotacoes(Variaveis.filialPadrao.toString(), HistoricoMaterial.this.materialAux.getCodigo().toString(), null);
            } else if (e.getSource() == HistoricoMaterial.this.labelCarregarTudoMovimentacao) {
                HistoricoMaterial.this.buscaMovimentacao(Variaveis.filialPadrao.toString(), HistoricoMaterial.this.materialAux.getCodigo().toString(), null);
            } else if (e.getSource() == HistoricoMaterial.this.labelCarregarTudoPedido && lote != null) {
                HistoricoMaterial.this.buscaPedidos(lote, Variaveis.filialPadrao.toString(), HistoricoMaterial.this.materialAux.getCodigo().toString(), null);
            } else if (e.getSource() == HistoricoMaterial.this.labelCarregarTudoNota && lote != null) {
                HistoricoMaterial.this.buscaNotas(lote, Variaveis.filialPadrao.toString(), HistoricoMaterial.this.materialAux.getCodigo().toString(), null);
            }
        }
    }

    class ObjetoLote {
        String lote = null;
        String loteMostrar = null;
        Date data = null;
        Date validade = null;
        Double quantidade = null;
        Double restante = null;
        ArrayList<Object[]> dadosPedidos = null;
        ArrayList<Object[]> dadosNotas = null;
        boolean todosPedidosCarregados = false;
        boolean todasNotasCarregadas = false;

        public ObjetoLote(String lote, String loteMostrar, Date data, Date validade, Double quantidade, Double restante) {
            this.lote = lote;
            this.loteMostrar = loteMostrar;
            this.data = data;
            this.validade = validade;
            this.quantidade = quantidade;
            this.restante = restante;
        }

        public ObjetoLote(String loteMostrar) {
            this.loteMostrar = loteMostrar;
        }

        public void setDadosPedidos(boolean todosPedidosCarregados, ArrayList<Object[]> dadosPedidos) {
            this.todosPedidosCarregados = todosPedidosCarregados;
            this.dadosPedidos = dadosPedidos;
        }

        public void setDadosNotas(boolean todasNotasCarregadas, ArrayList<Object[]> dadosNotas) {
            this.todasNotasCarregadas = todasNotasCarregadas;
            this.dadosNotas = dadosNotas;
        }
    }

    class ListRenderer
    extends JLabel
    implements ListCellRenderer {
        ListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ObjetoLote aux = (ObjetoLote)value;
            this.setFont(new Font(this.getFont().getName(), 0, 11));
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 3, 1));
            StringBuffer buf = new StringBuffer("");
            buf.append("<html>");
            if (aux.loteMostrar != null) {
                buf.append("<b><i>").append(aux.loteMostrar).append("</i></b><br>");
            }
            if (aux.data != null) {
                buf.append("<b>Data:</b> ").append(Funcoes.formataData("dd/MM/yyyy", aux.data)).append("<br>");
            }
            if (aux.validade != null) {
                buf.append("<b>Val.:</b> ").append(Funcoes.formataData("dd/MM/yyyy", aux.validade)).append("<br>");
            }
            if (aux.quantidade != null) {
                buf.append("<b>Qtde.:</b> ").append(Funcoes.formataDecimal("########0.00##", aux.quantidade)).append("<br>");
            }
            if (aux.restante != null) {
                buf.append("<b>Restante:</b> ").append(Funcoes.formataDecimal("########0.00##", aux.restante)).append("<br>");
            }
            buf.append("</html>");
            this.setText(buf.toString());
            Color corBorda = Color.BLACK;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setOpaque(true);
            return this;
        }
    }
}

