/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.caixa;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.util.caixa.PesquisaCaixa;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConsultaCaixa
extends FrmPadrao {
    private String[] itensPagamento = new String[]{"Todos", Tipos.tipoPagamento("H"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("D"), Tipos.tipoPagamento("S"), Tipos.tipoPagamento("I"), Tipos.tipoPagamento("O"), Tipos.tipoPagamento("C"), Tipos.tipoPagamento("U"), Tipos.tipoPagamento("N"), Tipos.tipoPagamento("F"), Tipos.tipoPagamento("B"), Tipos.tipoPagamento("W"), Tipos.tipoPagamento("Y")};
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panelEsquerdo = new JPanel(this.grid);
    private JPanel panelDireito = new JPanel();
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesE = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonConsultar = new JButton("Consultar");
    private JLabel labelDataInicio = new JLabel("Data in\u00edcio:");
    private JLabel labelHoraInicio = new JLabel("Hora in\u00edcio:");
    private JLabel labelDataFim = new JLabel("Data final:");
    private JLabel labelHoraFim = new JLabel("Hora final:");
    private JLabel labelTipoPagto = new JLabel("Pagamento:");
    private TTextField txtDataInicio = new TTextField(10, 4);
    private TTextField txtDataFim = new TTextField(10, 4);
    private TTextField txtHoraInicio = new TTextField(5, 6);
    private TTextField txtHoraFim = new TTextField(5, 6);
    private JButton buttonDataInicio = new JButton();
    private JButton buttonDataFim = new JButton();
    private CheckItemFiltro itemEstacao = new CheckItemFiltro("Esta\u00e7\u00e3o", "Filtrar", "Filtrando esta\u00e7\u00f5es", "");
    private CheckItemFiltro itemUsuario = new CheckItemFiltro("Usu\u00e1rios", "Filtrar", "Filtrando usu\u00e1rios", "");
    private CheckItemFiltro itemConta = new CheckItemFiltro("Contas", "Filtrar", "Filtrando contas", "fil_codigo = " + Variaveis.filialPadrao + " and cco_tipo = '" + "X" + "'");
    private JComboBox comboTipoPagto = new JComboBox<String>(this.itensPagamento);

    public ConsultaCaixa() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConsultaCaixa");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelEsquerdo.setPreferredSize(new Dimension(210, 100));
        Funcoes.criaBarraDescricao(this, "Caixa", "Consulta ao caixa", "consultas/finan_caixa.jpg");
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonFechar);
        this.itemEstacao.setDados("estacoes", new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemEstacao.setColunaHint(1);
        this.itemUsuario.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{100, 0});
        this.itemUsuario.setColunaHint(1);
        this.itemConta.setDados("contacorrente", new String[]{"cco_reduzido", "cco_conta", "cco_titular"}, new String[]{"C\u00f3digo", "Conta", "Titular"}, new int[]{70, 100, 0});
        this.itemConta.setColunaHint(2);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('C');
        Funcoes.imagemPesquisa(this.buttonDataInicio);
        Funcoes.imagemPesquisa(this.buttonDataFim);
        this.buttonDataInicio.setFocusable(false);
        this.buttonDataFim.setFocusable(false);
        this.montaFiltros();
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaCaixa.this.setVisible(false);
            }
        });
        this.buttonDataInicio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaCaixa.this.txtDataInicio, ConsultaCaixa.this.buttonDataInicio, ConsultaCaixa.this.panelEsquerdo, true);
            }
        });
        this.buttonDataFim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaCaixa.this.txtDataFim, ConsultaCaixa.this.buttonDataFim, ConsultaCaixa.this.panelEsquerdo, true);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaCaixa.this.pesquisaCaixa();
            }
        });
    }

    public void montaFiltros() {
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.panelEsquerdo.add((Component)this.itemEstacao, this.constraints);
        this.constraints.gridy = 1;
        this.panelEsquerdo.add((Component)this.itemConta, this.constraints);
        this.constraints.gridy = 2;
        this.panelEsquerdo.add((Component)this.itemUsuario, this.constraints);
        this.constraints.gridy = 3;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 0.0;
        this.panelEsquerdo.add((Component)this.labelTipoPagto, this.constraints);
        this.constraints.gridy = 4;
        this.panelEsquerdo.add((Component)this.labelDataInicio, this.constraints);
        this.constraints.gridy = 5;
        this.panelEsquerdo.add((Component)this.labelDataFim, this.constraints);
        this.constraints.gridy = 6;
        this.panelEsquerdo.add((Component)this.labelHoraInicio, this.constraints);
        this.constraints.gridy = 7;
        this.panelEsquerdo.add((Component)this.labelHoraFim, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 4;
        this.buttonDataInicio.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicio.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonDataInicio, this.constraints);
        this.constraints.gridy = 5;
        this.buttonDataFim.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFim.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonDataFim, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 2;
        this.constraints.weightx = 1.0;
        this.comboTipoPagto.setPreferredSize(new Dimension(90, 20));
        this.comboTipoPagto.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.comboTipoPagto, this.constraints);
        this.constraints.gridy = 4;
        this.constraints.gridwidth = 1;
        this.txtDataInicio.setPreferredSize(new Dimension(90, 20));
        this.txtDataInicio.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtDataInicio, this.constraints);
        this.constraints.gridy = 5;
        this.txtDataFim.setPreferredSize(new Dimension(90, 20));
        this.txtDataFim.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtDataFim, this.constraints);
        this.constraints.gridy = 6;
        this.txtHoraInicio.setPreferredSize(new Dimension(90, 20));
        this.txtHoraInicio.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtHoraInicio, this.constraints);
        this.constraints.gridy = 7;
        this.txtHoraFim.setPreferredSize(new Dimension(90, 20));
        this.txtHoraFim.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtHoraFim, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 8;
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 0.0;
        this.buttonConsultar.setPreferredSize(new Dimension(100, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(100, 20));
        this.panelEsquerdo.add((Component)this.buttonConsultar, this.constraints);
        this.constraints.gridy = 9;
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.panelEsquerdo.add((Component)new JPanel(), this.constraints);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0700300100");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtDataInicio.hasFocus()) {
            Funcoes.mostraData(this.txtDataInicio, this.buttonDataInicio, this.panelEsquerdo, true);
        } else if (this.txtDataFim.hasFocus()) {
            Funcoes.mostraData(this.txtDataFim, this.buttonDataFim, this.panelEsquerdo, true);
        }
    }

    private void pesquisaCaixa() {
        if (!Funcoes.verificaData(this.txtDataInicio.getText()) || !Funcoes.verificaData(this.txtDataFim.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida para consulta", 1);
            this.txtDataInicio.grabFocus();
            return;
        }
        if (!Funcoes.textoVazio(this.txtHoraInicio.getText()) && !Funcoes.verificaHora(this.txtHoraInicio.getText()) || !Funcoes.textoVazio(this.txtHoraFim.getText()) && !Funcoes.verificaHora(this.txtHoraFim.getText())) {
            Funcoes.mensagem(this, "Hora inv\u00e1lida para consulta", 1);
            this.txtHoraInicio.grabFocus();
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireito.removeAll();
        PesquisaCaixa consulta = new PesquisaCaixa((Frame)this.getTopLevelAncestor(), this.panelDireito, this.buttonConsultar);
        if (this.itemEstacao.isSelected()) {
            consulta.setFiltroEstacao(this.itemEstacao.getSelecionados(0));
        }
        if (this.itemUsuario.isSelected()) {
            consulta.setFiltroUsuario(this.itemUsuario.getSelecionados(0));
        }
        if (this.itemConta.isSelected()) {
            consulta.setFiltroConta(this.itemConta.getSelecionados(0));
        }
        consulta.setDataInicio(this.txtDataInicio.getText());
        consulta.setDataFim(this.txtDataFim.getText());
        consulta.setHoraInicio(this.txtHoraInicio.getText());
        consulta.setHoraFim(this.txtHoraFim.getText());
        if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[1])) {
            consulta.setPagamento("H");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[2])) {
            consulta.setPagamento("P");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[3])) {
            consulta.setPagamento("A");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[4])) {
            consulta.setPagamento("D");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[5])) {
            consulta.setPagamento("S");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[6])) {
            consulta.setPagamento("I");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[7])) {
            consulta.setPagamento("O");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[8])) {
            consulta.setPagamento("C");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[9])) {
            consulta.setPagamento("U");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[10])) {
            consulta.setPagamento("N");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[11])) {
            consulta.setPagamento("F");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[12])) {
            consulta.setPagamento("B");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[13])) {
            consulta.setPagamento("W");
        } else if (this.comboTipoPagto.getSelectedItem().equals(this.itensPagamento[14])) {
            consulta.setPagamento("Y");
        }
        consulta.start();
    }
}

