/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.selecao;

import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Assinatura;
import jalis.laboratorio.configurador.componente.CodigoBarrasConf;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Forma;
import jalis.laboratorio.configurador.componente.Imagem;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.configurador.pagina.LinhaGuia;
import jalis.laboratorio.configurador.pagina.MensagensConfigurador;
import jalis.laboratorio.configurador.pagina.Pagina;
import jalis.laboratorio.configurador.pagina.Regua;
import jalis.laboratorio.configurador.selecao.PreSelecao;
import jalis.laboratorio.configurador.selecao.SelecaoListener;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;

public class Selecao
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final int SETA = 0;
    private static final int ARRASTE = 13;
    private static final int NORTE = 8;
    private static final int SUL = 9;
    private static final int LESTE = 11;
    private static final int OESTE = 10;
    private static final int NORDESTE = 7;
    private static final int NOROESTE = 6;
    private static final int SUDESTE = 5;
    private static final int SUDOESTE = 4;
    private static final int MAO = 12;
    private static final String OPERACAO_ALTERACAO_MOVIMENTO = "alterado";
    private static final String OPERACAO_ALTERACAO_EXCLUSAO = "excluido";
    private static final int PROX = 4;
    private static final int MARG = 15;
    private Color corSel = Color.blue;
    private ArrayList<Componente> itens;
    private ChangeEvent evento;
    private Pagina pagina;
    private Point ptOff;
    private Rectangle recOff;
    private JPopupMenu popupMenu;
    private boolean iniciou;
    private boolean arrastando;
    private boolean avisarOuvintes;
    private Rectangle area;
    private PreSelecao pre;
    private int local;
    private int margem;
    private int alturaOff;
    private LinhaGuia linhaGuia;
    private JMenuItem jMIMoverTopo;
    private JMenuItem jMIMoverCima;
    private JMenuItem jMIMoverBaixo;
    private JMenuItem jMIMoverBase;
    private JMenuItem jMIAlinharEsquerda;
    private JMenuItem jMIAlinharCentro;
    private JMenuItem jMIAlinharDireita;
    private JMenuItem jMIAlinharTopo;
    private JMenuItem jMIAlinharMeio;
    private JMenuItem jMIAlinharBase;
    private JMenuItem jMIDistHori;
    private JMenuItem jMIDistVert;
    private JMenuItem jMIMesmaLargura;
    private JMenuItem jMIMesmaAltura;
    private JMenuItem jMILigar;
    private JMenuItem jMIMesmaFonte;
    private JMenuItem jMIMesmaCorDaFonte;
    private JMenuItem jMIDuplicar;
    private JMenuItem jMIRemover;

    public Selecao(Pagina pagina, PreSelecao pre) {
        this.pagina = pagina;
        this.pre = pre;
        this.iniciou = false;
        this.arrastando = false;
        this.avisarOuvintes = true;
        this.itens = new ArrayList();
        this.local = -1;
        this.margem = -1;
        this.linhaGuia = null;
        this.definirTeclas();
        this.popupMenu = new JPopupMenu();
        this.jMIMoverTopo = new JMenuItem("Mover para o topo");
        this.jMIMoverTopo.addActionListener(this);
        this.popupMenu.add(this.jMIMoverTopo);
        this.jMIMoverCima = new JMenuItem("Mover para cima");
        this.jMIMoverCima.addActionListener(this);
        this.popupMenu.add(this.jMIMoverCima);
        this.jMIMoverBaixo = new JMenuItem("Mover para baixo");
        this.jMIMoverBaixo.addActionListener(this);
        this.popupMenu.add(this.jMIMoverBaixo);
        this.jMIMoverBase = new JMenuItem("Mover para a base");
        this.jMIMoverBase.addActionListener(this);
        this.popupMenu.add(this.jMIMoverBase);
        this.popupMenu.addSeparator();
        this.jMIAlinharEsquerda = new JMenuItem("Alinhar \u00e0 esquerda");
        this.jMIAlinharEsquerda.addActionListener(this);
        this.popupMenu.add(this.jMIAlinharEsquerda);
        this.jMIAlinharCentro = new JMenuItem("Alinhar ao centro");
        this.jMIAlinharCentro.addActionListener(this);
        this.popupMenu.add(this.jMIAlinharCentro);
        this.jMIAlinharDireita = new JMenuItem("Alinhar \u00e0 direita");
        this.jMIAlinharDireita.addActionListener(this);
        this.popupMenu.add(this.jMIAlinharDireita);
        this.popupMenu.addSeparator();
        this.jMIAlinharTopo = new JMenuItem("Alinhar ao topo");
        this.jMIAlinharTopo.addActionListener(this);
        this.popupMenu.add(this.jMIAlinharTopo);
        this.jMIAlinharMeio = new JMenuItem("Alinhar ao meio");
        this.jMIAlinharMeio.addActionListener(this);
        this.popupMenu.add(this.jMIAlinharMeio);
        this.jMIAlinharBase = new JMenuItem("Alinhar \u00e0 base");
        this.jMIAlinharBase.addActionListener(this);
        this.popupMenu.add(this.jMIAlinharBase);
        this.popupMenu.addSeparator();
        this.jMIDistHori = new JMenuItem("Distribuir horizontalmente");
        this.jMIDistHori.addActionListener(this);
        this.popupMenu.add(this.jMIDistHori);
        this.jMIDistVert = new JMenuItem("Distribuir verticalmente");
        this.jMIDistVert.addActionListener(this);
        this.popupMenu.add(this.jMIDistVert);
        this.popupMenu.addSeparator();
        this.jMIMesmaLargura = new JMenuItem("Mesma largura");
        this.jMIMesmaLargura.addActionListener(this);
        this.popupMenu.add(this.jMIMesmaLargura);
        this.jMIMesmaAltura = new JMenuItem("Mesma altura");
        this.jMIMesmaAltura.addActionListener(this);
        this.popupMenu.add(this.jMIMesmaAltura);
        this.popupMenu.addSeparator();
        this.jMILigar = new JMenuItem("Ligar");
        this.jMILigar.addActionListener(this);
        this.popupMenu.add(this.jMILigar);
        this.popupMenu.addSeparator();
        this.jMIMesmaFonte = new JMenuItem("Mesma fonte");
        this.jMIMesmaFonte.addActionListener(this);
        this.popupMenu.add(this.jMIMesmaFonte);
        this.jMIMesmaCorDaFonte = new JMenuItem("Mesma cor da fonte");
        this.jMIMesmaCorDaFonte.addActionListener(this);
        this.popupMenu.add(this.jMIMesmaCorDaFonte);
        this.popupMenu.addSeparator();
        this.jMIDuplicar = new JMenuItem("Duplicar");
        this.jMIDuplicar.addActionListener(this);
        this.popupMenu.add(this.jMIDuplicar);
        this.popupMenu.addSeparator();
        this.jMIRemover = new JMenuItem("Remover");
        this.jMIRemover.addActionListener(this);
        this.popupMenu.add(this.jMIRemover);
    }

    public void setAvisarOuvintes(boolean avisar) {
        this.avisarOuvintes = avisar;
        if (this.avisarOuvintes) {
            this.fireEventoSelecao();
        }
    }

    public void selecionar(Componente item) {
        if (!(item == null || this.itens.contains(item) || this.local != -1 && this.local != item.getLocal())) {
            if (this.itens.isEmpty()) {
                this.local = item.getLocal();
                this.area = this.pagina.retanguloArea(this.local);
            }
            item.setSelecao(this);
            this.itens.add(item);
            if (this.pagina.getCamposImportacao() != null && this.pagina.getProtocolo() == Protocolo.HPardini) {
                this.atualizarVersaoCampoImportacao(this.pagina.getCamposImportacao().toString());
            }
            this.armazenaAlteracoes(item, OPERACAO_ALTERACAO_MOVIMENTO);
            this.atualizarDimensoes();
            if (this.avisarOuvintes) {
                this.fireEventoSelecao();
            }
            this.habilitarDesabilitarPopupMenu();
        }
    }

    public void atualizarVersaoCampoImportacao(String versao) {
        boolean isAlterado = false;
        for (Componente item : this.itens) {
            Map<String, ProtocoloCampoImportacao> campos = item.getMapCamposImportacao();
            if (!campos.isEmpty()) {
                for (String key : campos.keySet()) {
                    if (!campos.get((Object)key).versao.equalsIgnoreCase(versao) && !campos.get((Object)key).versao.equalsIgnoreCase("0")) continue;
                    ProtocoloCampoImportacao campo = campos.get(key);
                    campo.setAlteracao(true);
                    isAlterado = true;
                    item.setCampoImportacao(campo);
                }
                continue;
            }
            isAlterado = true;
        }
        if (!isAlterado) {
            for (Componente item : this.itens) {
                item.setCampoImportacao(new ProtocoloCampoImportacao(null, ""));
            }
        }
        if (this.avisarOuvintes) {
            this.fireEventoSelecao();
        }
    }

    public void removerSelecao() {
        boolean avisar = !this.itens.isEmpty() && this.avisarOuvintes;
        this.setBounds(0, 0, 0, 0);
        for (Componente comp : this.itens) {
            comp.setEditando(false);
            comp.setSelecao(null);
        }
        this.itens.clear();
        this.local = -1;
        if (avisar) {
            this.fireEventoSelecao();
        }
    }

    public void removerSelecao(Componente item) {
        if (this.itens.contains(item)) {
            item.setSelecao(null);
            this.itens.remove(item);
            this.atualizarDimensoes();
            if (this.avisarOuvintes) {
                this.fireEventoSelecao();
            }
            if (this.itens.isEmpty()) {
                this.local = -1;
            }
            this.habilitarDesabilitarPopupMenu();
        }
    }

    public int getLocal() {
        return this.local;
    }

    public boolean vazio() {
        return this.itens.isEmpty();
    }

    public Iterator<Componente> iterator() {
        return this.itens.iterator();
    }

    public Componente[] paraArray() {
        return this.itens.toArray(new Componente[0]);
    }

    public void addSelecaoListener(SelecaoListener ouvinte) {
        this.listenerList.add(SelecaoListener.class, ouvinte);
    }

    public void removeSelecaoListener(SelecaoListener ouvinte) {
        this.listenerList.remove(SelecaoListener.class, ouvinte);
    }

    public Pagina getPagina() {
        return this.pagina;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.arrastando && !this.modoInterfaceamento()) {
            int pos;
            int x = e.getX();
            int y = e.getY();
            if (this.itens.size() == 1 && (pos = this.posCoordenada(x, y)) != -1) {
                this.setCursorIgual(new Cursor(pos));
                if (!this.pre.vazio()) {
                    this.pre.removerSelecao();
                }
            } else {
                Componente comp = this.pagina.componenteContemPonto(x, y);
                if (comp != null) {
                    if (this.itens.contains(comp)) {
                        this.pre.removerSelecao();
                        this.setCursorIgual(new Cursor(13));
                    } else if (!this.pre.contem(comp)) {
                        this.pre.removerSelecao();
                        this.pre.selecionar(comp);
                        if (this.getCursor().getType() != 0) {
                            this.setCursorIgual(new Cursor(0));
                        }
                    }
                } else if (this.pagina.getMargemNaPosicao(x, y, 4) != -1) {
                    this.setCursorIgual(new Cursor(8));
                } else if (this.pagina.mouseSobreMensagemConfigurador(x, y)) {
                    this.setCursorIgual(new Cursor(12));
                } else {
                    LinhaGuia linha = this.pagina.getLinhaNaPosicao(x, y, 4);
                    if (linha != null && this.pagina.getExibirLinhasGuias()) {
                        if (linha.getRedimensionar()) {
                            this.setCursorIgual(linha.horizontal() ? new Cursor(8) : new Cursor(11));
                        }
                    } else {
                        if (this.getCursor().getType() != 0) {
                            this.setCursorIgual(new Cursor(0));
                        }
                        if (!this.pre.vazio()) {
                            this.pre.removerSelecao();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.getButton() == 3 && !this.modoInterfaceamento()) {
            Componente comp = this.pagina.componenteContemPonto(x, y);
            if (comp != null) {
                if (!this.itens.contains(comp)) {
                    this.removerSelecao();
                    this.pre.removerSelecao();
                    this.selecionar(comp);
                }
                this.popupMenu.show(this.pagina, x, y);
            }
        } else if (e.getButton() == 1) {
            switch (this.getCursor().getType()) {
                case 8: {
                    if (this.posCoordenada(x, y) == 8) {
                        this.recOff = this.getBounds();
                    } else {
                        this.margem = this.pagina.getMargemNaPosicao(x, y, 4);
                        if (this.margem != -1) {
                            switch (this.margem) {
                                case 2: {
                                    this.alturaOff = this.pagina.getAlturaCabecalho();
                                    break;
                                }
                                case 4: {
                                    this.alturaOff = this.pagina.getAlturaSumario();
                                    break;
                                }
                                case 5: {
                                    this.alturaOff = this.pagina.getAlturaRodapeExame();
                                    break;
                                }
                                default: {
                                    this.alturaOff = this.pagina.getAlturaRodape();
                                    break;
                                }
                            }
                        } else {
                            this.linhaGuia = this.pagina.getLinhaNaPosicao(x, y, 4);
                            if (this.linhaGuia == null) break;
                            if (e.getClickCount() == 2) {
                                this.pagina.removerLinhaGuia(this.linhaGuia);
                                if (!this.linhaGuia.getRedimensionar()) break;
                                this.linhaGuia = null;
                                this.setCursorIgual(new Cursor(0));
                                break;
                            }
                        }
                    }
                    this.ptOff = e.getPoint();
                    this.iniciou = true;
                    break;
                }
                case 11: {
                    if (this.posCoordenada(x, y) == 11) {
                        this.recOff = this.getBounds();
                    } else {
                        this.linhaGuia = this.pagina.getLinhaNaPosicao(x, y, 4);
                        if (this.linhaGuia == null) break;
                        if (e.getClickCount() == 2) {
                            this.pagina.removerLinhaGuia(this.linhaGuia);
                            if (!this.linhaGuia.getRedimensionar()) break;
                            this.linhaGuia = null;
                            this.setCursorIgual(new Cursor(0));
                            break;
                        }
                    }
                    this.ptOff = e.getPoint();
                    this.iniciou = true;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 13: {
                    if (Selecao.shiftPressionado(e)) {
                        this.removerSelecao(this.pagina.componenteContemPonto(x, y));
                        this.setCursorIgual(new Cursor(0));
                        break;
                    }
                    if (e.getClickCount() >= 2) {
                        Componente comp = this.pagina.componenteContemPonto(x, y);
                        if (comp == null || !comp.editavel()) break;
                        this.removerSelecao();
                        this.selecionar(comp);
                        comp.setEditando(true);
                        break;
                    }
                    this.recOff = this.getBounds();
                    this.ptOff = e.getPoint();
                    this.iniciou = true;
                    break;
                }
                default: {
                    if (x < 15 && y > 15 && y < 15 + this.pagina.getAltura() && !this.modoInterfaceamento()) {
                        this.linhaGuia = new LinhaGuia(1);
                        this.linhaGuia.setPosicao(x);
                        this.pagina.adicionarLinhaGuia(this.linhaGuia);
                        this.setCursorIgual(new Cursor(11));
                        this.iniciou = true;
                        break;
                    }
                    if (y < 15 && x > 15 && x < 15 + this.pagina.getLargura() && !this.modoInterfaceamento()) {
                        this.linhaGuia = new LinhaGuia(0);
                        this.linhaGuia.setPosicao(y);
                        this.pagina.adicionarLinhaGuia(this.linhaGuia);
                        this.setCursorIgual(new Cursor(8));
                        this.iniciou = true;
                        break;
                    }
                    if (this.pagina.mouseSobreMensagemConfigurador(x, y)) {
                        this.pagina.removerUltimaMensagem();
                        break;
                    }
                    Componente comp = this.pagina.componenteContemPonto(x, y);
                    if (comp != null) {
                        if (!Selecao.shiftPressionado(e)) {
                            this.removerSelecao();
                        }
                        this.pre.removerSelecao();
                        this.selecionar(comp);
                        if (this.modoInterfaceamento()) break;
                        this.ptOff = e.getPoint();
                        this.recOff = this.getBounds();
                        this.iniciou = true;
                        this.setCursorIgual(new Cursor(13));
                        break;
                    }
                    if (!this.pagina.getDimensoes().contains(x, y)) break;
                    if (this.pagina.criandoComponente()) {
                        if (this.pagina.localPonto(e.getPoint()) == -1) break;
                        this.recOff = this.pagina.retanguloArea(this.pagina.localPonto(e.getPoint()));
                    }
                    this.removerSelecao();
                    this.ptOff = e.getPoint();
                    this.setBounds(x, y, 0, 0);
                    this.iniciou = true;
                    this.pagina.iniciaPreSelecao();
                }
            }
            if (this.local != -1) {
                this.area = this.pagina.retanguloArea(this.local);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.iniciou) {
            if (!this.arrastando) {
                this.arrastando = true;
            }
            switch (this.getCursor().getType()) {
                case 13: {
                    this.arrastar(this.recOff.x + e.getX() - this.ptOff.x, this.recOff.y + e.getY() - this.ptOff.y, this.recOff.width, this.recOff.height);
                    break;
                }
                case 8: {
                    if (this.margem == 2) {
                        int altNova = this.alturaOff + e.getY() - this.ptOff.y;
                        int altOcup = this.pagina.getAlturaOcupada(2);
                        this.pagina.setAlturaCabecalho(altNova < altOcup ? altOcup : altNova);
                        break;
                    }
                    if (this.margem == 4) {
                        int altNova = this.alturaOff - e.getY() + this.ptOff.y;
                        int altOcup = this.pagina.getAlturaOcupada(4);
                        this.pagina.setAlturaSumario(altNova < altOcup ? altOcup : altNova);
                        break;
                    }
                    if (this.margem == 5) {
                        int altNova = this.alturaOff - e.getY() + this.ptOff.y;
                        int altOcup = this.pagina.getAlturaOcupada(5);
                        this.pagina.setAlturaRodapeExame(altNova < altOcup ? altOcup : altNova);
                        break;
                    }
                    if (this.margem == 3) {
                        int altNova = this.alturaOff - e.getY() + this.ptOff.y;
                        int altOcup = this.pagina.getAlturaOcupada(3);
                        this.pagina.setAlturaRodape(altNova < altOcup ? altOcup : altNova);
                        break;
                    }
                    if (this.linhaGuia != null) {
                        if (!this.linhaGuia.getRedimensionar()) break;
                        this.linhaGuia.setPosicao(e.getY());
                        break;
                    }
                    this.setBounds(this.redimensionar(this.getBounds(), this.recOff.x, this.recOff.y + e.getY() - this.ptOff.y, this.recOff.width, this.recOff.height + (e.getY() - this.ptOff.y) * -1));
                    break;
                }
                case 9: {
                    this.setBounds(this.redimensionar(this.getBounds(), this.recOff.x, this.recOff.y, this.recOff.width, this.recOff.height - (e.getY() - this.ptOff.y) * -1));
                    break;
                }
                case 11: {
                    if (this.linhaGuia != null) {
                        if (!this.linhaGuia.getRedimensionar()) break;
                        this.linhaGuia.setPosicao(e.getX());
                        break;
                    }
                    this.setBounds(this.redimensionar(this.getBounds(), this.recOff.x, this.recOff.y, this.recOff.width - (e.getX() - this.ptOff.x) * -1, this.recOff.height));
                    break;
                }
                case 10: {
                    this.setBounds(this.redimensionar(this.getBounds(), this.recOff.x + e.getX() - this.ptOff.x, this.recOff.y, this.recOff.width + (e.getX() - this.ptOff.x) * -1, this.recOff.height));
                    break;
                }
                case 6: {
                    this.setBounds(this.redimensionar(this.getBounds(), this.recOff.x + e.getX() - this.ptOff.x, this.recOff.y + e.getY() - this.ptOff.y, this.recOff.width + (e.getX() - this.ptOff.x) * -1, this.recOff.height + (e.getY() - this.ptOff.y) * -1));
                    break;
                }
                case 7: {
                    this.setBounds(this.redimensionar(this.getBounds(), this.recOff.x, this.recOff.y + e.getY() - this.ptOff.y, this.recOff.width - (e.getX() - this.ptOff.x) * -1, this.recOff.height + (e.getY() - this.ptOff.y) * -1));
                    break;
                }
                case 4: {
                    this.setBounds(this.redimensionar(this.getBounds(), this.recOff.x + e.getX() - this.ptOff.x, this.recOff.y, this.recOff.width + (e.getX() - this.ptOff.x) * -1, this.recOff.height - (e.getY() - this.ptOff.y) * -1));
                    break;
                }
                case 5: {
                    this.setBounds(this.redimensionar(this.getBounds(), this.recOff.x, this.recOff.y, this.recOff.width - (e.getX() - this.ptOff.x) * -1, this.recOff.height - (e.getY() - this.ptOff.y) * -1));
                    break;
                }
                default: {
                    int h;
                    int y;
                    int w;
                    int x;
                    Rectangle rec;
                    Rectangle rectangle = rec = this.pagina.criandoComponente() ? this.recOff : new Rectangle(18, 18, this.pagina.getLargura() - 6, this.pagina.getAltura() - 6);
                    if (e.getX() < this.ptOff.x) {
                        x = Math.max(e.getX(), rec.x);
                        w = this.ptOff.x - x;
                    } else {
                        x = this.ptOff.x;
                        w = Math.min(e.getX(), rec.x + rec.width) - x + 1;
                    }
                    if (e.getY() < this.ptOff.y) {
                        y = Math.max(e.getY(), rec.y);
                        h = this.ptOff.y - y;
                    } else {
                        y = this.ptOff.y;
                        h = Math.min(e.getY(), rec.y + rec.height) - y + 1;
                    }
                    this.setBounds(x, y, w, h);
                    if (this.pagina.criandoComponente()) break;
                    this.pagina.preSelecionar(this.getBounds());
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.arrastando) {
            if (this.linhaGuia != null) {
                if (this.linhaGuia.getPosicao() < 15) {
                    this.pagina.removerLinhaGuia(this.linhaGuia);
                    this.setCursorIgual(new Cursor(0));
                }
            } else if (this.margem == -1) {
                if (this.itens.isEmpty()) {
                    if (this.pagina.criandoComponente()) {
                        this.selecionar(this.pagina.criarNovoComponente(this.getBounds()));
                    } else {
                        this.pagina.selecionar(this.getBounds());
                    }
                } else {
                    Rectangle rec = this.getBounds();
                    if (this.itens.size() == 1) {
                        Componente comp = this.itens.get(0);
                        comp.setDimensoes(rec.x + 2, rec.y + 2, rec.width - 4, rec.height - 4);
                    } else {
                        for (Componente comp : this.itens) {
                            Rectangle tmp = comp.getDimensoes();
                            comp.setDimensoes(tmp.x + rec.x - this.recOff.x, tmp.y + rec.y - this.recOff.y, tmp.width, tmp.height);
                        }
                    }
                    if (this.avisarOuvintes) {
                        this.fireDadosAlterados();
                    }
                }
            }
        } else if (this.pagina.criandoComponente()) {
            this.selecionar(this.pagina.criarNovoComponente(this.getBounds()));
        }
        this.linhaGuia = null;
        this.iniciou = false;
        this.arrastando = false;
        this.margem = -1;
        this.pagina.repaint();
        this.repaint();
    }

    public static boolean shiftPressionado(MouseEvent e) {
        return (e.getModifiersEx() & 0x40) != 0;
    }

    public Color getCorSelecao() {
        return this.corSel;
    }

    public void setCorSelecao(Color cor) {
        if (!this.corSel.equals(cor)) {
            this.corSel = cor;
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        Point pt = ((Component)((Object)this.itens.get(0))).getLocation();
        Dimension dm = ((Component)((Object)this.itens.get(0))).getSize();
        AbstractComponente[] tmp = this.itens.toArray(new AbstractComponente[0]);
        if (obj == this.jMIRemover) {
            this.removerComponentesSelecionados();
        } else if (obj == this.jMIDuplicar) {
            this.duplicarItensSelecionados();
        } else if (obj == this.jMILigar) {
            this.ligarComponentesSelecionados();
        } else if (obj == this.jMIMesmaFonte) {
            this.atribuirMesmaFonte();
        } else if (obj == this.jMIMesmaCorDaFonte) {
            this.atribuirMesmaCorDaFonte();
        } else if (obj == this.jMIMoverTopo) {
            this.pagina.moverTopo(this.itens.get(0));
        } else if (obj == this.jMIMoverCima) {
            this.pagina.moverAcima(this.itens.get(0));
        } else if (obj == this.jMIMoverBaixo) {
            this.pagina.moverAbaixo(this.itens.get(0));
        } else if (obj == this.jMIMoverBase) {
            this.pagina.moverBase(this.itens.get(0));
        } else if (obj == this.jMIAlinharEsquerda) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i].setLocation(pt.x, tmp[i].getY());
            }
        } else if (obj == this.jMIAlinharCentro) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i].setLocation(pt.x + (dm.width - tmp[i].getWidth()) / 2, tmp[i].getY());
            }
        } else if (obj == this.jMIAlinharDireita) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i].setLocation(pt.x + dm.width - tmp[i].getWidth(), tmp[i].getY());
            }
        } else if (obj == this.jMIAlinharTopo) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i].setLocation(tmp[i].getX(), pt.y);
            }
        } else if (obj == this.jMIAlinharMeio) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i].setLocation(tmp[i].getX(), pt.y + (dm.height - tmp[i].getHeight()) / 2);
            }
        } else if (obj == this.jMIAlinharBase) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i].setLocation(tmp[i].getX(), pt.y + dm.height - tmp[i].getHeight());
            }
        } else if (obj == this.jMIDistHori) {
            this.distribuirHorizontalmente();
        } else if (obj == this.jMIDistVert) {
            this.distribuirVerticalmente();
        } else if (obj == this.jMIMesmaLargura) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i].setSize(new Dimension(dm.width, tmp[i].getHeight()));
                tmp[i].atualizar();
            }
        } else if (obj == this.jMIMesmaAltura) {
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i].setSize(new Dimension(tmp[i].getWidth(), dm.height));
                tmp[i].atualizar();
            }
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    public void atualizarDimensoes() {
        Iterator<Componente> itr = this.itens.iterator();
        if (itr.hasNext()) {
            Rectangle rec = itr.next().getDimensoes();
            rec.setBounds(rec.x - 2, rec.y - 2, rec.width + 4, rec.height + 4);
            this.setBounds(rec);
            while (itr.hasNext()) {
                rec = itr.next().getDimensoes();
                rec.setBounds(rec.x - 2, rec.y - 2, rec.width + 4, rec.height + 4);
                Rectangle tmp = this.getBounds();
                tmp.add(rec);
                this.setBounds(tmp);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.arrastando && this.linhaGuia == null && this.margem == -1) {
            if (this.itens.isEmpty()) {
                if (this.pagina.criandoComponente()) {
                    g2d.setColor(Color.gray);
                    g2d.setStroke(Regua.SOLIDO);
                } else {
                    g2d.setColor(this.pre.getCor());
                    g2d.setStroke(Regua.TRACEJADO);
                }
                g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            } else {
                g2d.setStroke(Regua.TRACEJADO);
                if (this.itens.size() == 1) {
                    g2d.setColor(this.corSel);
                    g2d.drawRect(2, 2, this.getWidth() - 5, this.getHeight() - 5);
                } else {
                    Componente[] c = this.itens.toArray(new Componente[this.itens.size()]);
                    for (int i = 0; i < c.length; ++i) {
                        g2d.setColor(i == 0 ? this.corSel : Color.black);
                        Rectangle rec = c[i].getDimensoes();
                        g2d.drawRect(rec.x - this.recOff.x, rec.y - this.recOff.y, rec.width - 2, rec.height - 2);
                    }
                }
            }
        } else {
            g2d.setStroke(Regua.SOLIDO);
            Componente[] c = this.itens.toArray(new Componente[this.itens.size()]);
            for (int i = 0; i < c.length; ++i) {
                g2d.setColor(i == 0 ? this.corSel : Color.black);
                this.pintarRetangulo(g2d, this.caixa(7, c[i]));
                this.pintarRetangulo(g2d, this.caixa(6, c[i]));
                this.pintarRetangulo(g2d, this.caixa(5, c[i]));
                this.pintarRetangulo(g2d, this.caixa(4, c[i]));
                if (this.itens.size() != 1) continue;
                this.pintarRetangulo(g2d, this.caixa(8, c[i]));
                this.pintarRetangulo(g2d, this.caixa(9, c[i]));
                this.pintarRetangulo(g2d, this.caixa(11, c[i]));
                this.pintarRetangulo(g2d, this.caixa(10, c[i]));
            }
        }
    }

    private void duplicarItensSelecionados() {
        Componente[] c = this.itens.toArray(new Componente[this.itens.size()]);
        Arrays.sort(c, new Comparator(){

            public int compare(Object a, Object b) {
                int nb;
                int na = Selecao.this.pagina.getComponentZOrder((Component)a);
                return na > (nb = Selecao.this.pagina.getComponentZOrder((Component)b)) ? -1 : (na < nb ? 1 : 0);
            }
        });
        if (c.length > 0) {
            this.removerSelecao();
            for (int i = 0; i < c.length; ++i) {
                Rectangle rec = c[i].getDimensoes();
                this.pagina.setNovoComponente(c[i].getClass());
                Componente comp = this.pagina.criarNovoComponente(rec);
                if (comp == null) continue;
                comp.copiarAtributosDe(c[i]);
                comp.setDimensoes(rec.x + 10, rec.y - 10, rec.width, rec.height);
                if (i == 0) {
                    this.local = comp.getLocal();
                    this.area = this.pagina.retanguloArea(this.local);
                }
                comp.setSelecao(this);
                this.itens.add(comp);
            }
            this.atualizarDimensoes();
            if (this.avisarOuvintes) {
                this.fireEventoSelecao();
            }
            this.habilitarDesabilitarPopupMenu();
        }
    }

    private void habilitarDesabilitarPopupMenu() {
        boolean hab = this.itens.size() > 1;
        this.jMIAlinharBase.setEnabled(hab);
        this.jMIAlinharCentro.setEnabled(hab);
        this.jMIAlinharDireita.setEnabled(hab);
        this.jMIAlinharEsquerda.setEnabled(hab);
        this.jMIAlinharMeio.setEnabled(hab);
        this.jMIAlinharTopo.setEnabled(hab);
        this.jMIDistHori.setEnabled(hab);
        this.jMIDistVert.setEnabled(hab);
        this.jMIMesmaAltura.setEnabled(hab);
        this.jMIMesmaLargura.setEnabled(hab);
        this.jMIMoverBaixo.setEnabled(!hab);
        this.jMIMoverBase.setEnabled(!hab);
        this.jMIMoverCima.setEnabled(!hab);
        this.jMIMoverTopo.setEnabled(!hab);
        this.jMILigar.setEnabled(hab && this.validarComponentesParaLigar());
        this.jMIMesmaFonte.setEnabled(hab && !this.selecionouSemFonte());
        this.jMIMesmaCorDaFonte.setEnabled(this.jMIMesmaFonte.isEnabled());
    }

    private void setCursorIgual(Cursor cursor) {
        this.setCursor(cursor);
        this.pagina.setCursor(cursor);
    }

    private void arrastar(int x, int y, int largura, int altura) {
        int tmpX = x < this.area.x ? this.area.x - 2 : (x + largura > this.area.x + this.area.width ? this.area.x + this.area.width - largura + 3 : x);
        int tmpY = y < this.area.y ? this.area.y - 2 : (y + altura > this.area.y + this.area.height ? this.area.y + this.area.height - altura + 3 : y);
        this.setBounds(this.pagina.grudarRetangulo(new Rectangle(tmpX, tmpY, largura, altura)));
    }

    private Rectangle redimensionar(Rectangle velho, int x, int y, int largura, int altura) {
        int tmpH;
        int tmpY;
        int tmpW;
        int tmpX;
        if (x < this.area.x - 2) {
            tmpX = this.area.x - 2;
            tmpW = velho.x + velho.width - tmpX;
        } else if (x + largura > this.area.x + this.area.width + 3) {
            tmpX = velho.x;
            tmpW = this.area.x + this.area.width - tmpX + 3;
        } else if (largura < 5) {
            tmpX = x > velho.x ? velho.x + velho.width - 5 : velho.x;
            tmpW = 5;
        } else {
            tmpX = x;
            tmpW = largura;
        }
        if (y < this.area.y - 2) {
            tmpY = this.area.y - 2;
            tmpH = velho.y + velho.height - tmpY;
        } else if (y + altura > this.area.y + this.area.height + 3) {
            tmpY = velho.y;
            tmpH = this.area.y + this.area.height - tmpY + 3;
        } else if (altura < 5) {
            tmpY = y > velho.y ? velho.y + velho.height - 5 : velho.y;
            tmpH = 5;
        } else {
            tmpY = y;
            tmpH = altura;
        }
        return new Rectangle(tmpX, tmpY, tmpW, tmpH);
    }

    private void pintarRetangulo(Graphics g, Rectangle retangulo) {
        g.fillRect(retangulo.x, retangulo.y, retangulo.width, retangulo.height);
    }

    private int posCoordenada(int x, int y) {
        Rectangle rec = this.getBounds();
        if (x >= rec.x && x <= rec.x + 5) {
            if (y >= rec.y && y <= rec.y + 5) {
                return 6;
            }
            if (y >= rec.y + rec.height - 5 && y <= rec.y + rec.height) {
                return 4;
            }
            if (y >= rec.y + rec.height / 2 - 3 && y <= rec.y + rec.height / 2 + 2) {
                return 10;
            }
        } else if (x >= rec.x + rec.width - 5 && x <= rec.x + rec.width) {
            if (y >= rec.y && y <= rec.y + 5) {
                return 7;
            }
            if (y >= rec.y + rec.height - 5 && y <= rec.y + rec.height) {
                return 5;
            }
            if (y >= rec.y + rec.height / 2 - 3 && y <= rec.y + rec.height / 2 + 2) {
                return 11;
            }
        } else if (x >= rec.x + rec.width / 2 - 3 && x <= rec.x + rec.width / 2 + 2) {
            if (y >= rec.y && y <= rec.y + 5) {
                return 8;
            }
            if (y >= rec.y + rec.height - 5 && y <= rec.y + rec.height) {
                return 9;
            }
        }
        return -1;
    }

    private Rectangle caixa(int tipo, Componente componente) {
        Rectangle retorno = new Rectangle();
        Rectangle rec = this.getBounds();
        Rectangle tmp = componente.getDimensoes();
        tmp.setBounds(tmp.x - rec.x - 2, tmp.y - rec.y - 2, tmp.width + 4, tmp.height + 4);
        switch (tipo) {
            case 8: {
                retorno.setBounds(tmp.x + tmp.width / 2 - 3, tmp.y, 5, 5);
                break;
            }
            case 9: {
                retorno.setBounds(tmp.x + tmp.width / 2 - 3, tmp.y + tmp.height - 5, 5, 5);
                break;
            }
            case 11: {
                retorno.setBounds(tmp.x + tmp.width - 5, tmp.y + tmp.height / 2 - 3, 5, 5);
                break;
            }
            case 10: {
                retorno.setBounds(tmp.x, tmp.y + tmp.height / 2 - 3, 5, 5);
                break;
            }
            case 7: {
                retorno.setBounds(tmp.x + tmp.width - 5, tmp.y, 5, 5);
                break;
            }
            case 6: {
                retorno.setBounds(tmp.x, tmp.y, 5, 5);
                break;
            }
            case 5: {
                retorno.setBounds(tmp.x + tmp.width - 5, tmp.y + tmp.height - 5, 5, 5);
                break;
            }
            case 4: {
                retorno.setBounds(tmp.x, tmp.y + tmp.height - 5, 5, 5);
            }
        }
        return retorno;
    }

    private void definirTeclas() {
        if (this.pagina != null) {
            ActionMap mapaAcao = this.pagina.getActionMap();
            InputMap mapaUm = this.pagina.getInputMap(0);
            InputMap mapaDois = this.pagina.getInputMap(2);
            InputMap mapaTres = this.pagina.getInputMap(1);
            KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
            KeyStroke f2 = KeyStroke.getKeyStroke(113, 0);
            KeyStroke ctrlD = KeyStroke.getKeyStroke(68, 2);
            KeyStroke cima = KeyStroke.getKeyStroke(38, 0);
            KeyStroke baixo = KeyStroke.getKeyStroke(40, 0);
            KeyStroke direita = KeyStroke.getKeyStroke(39, 0);
            KeyStroke esquerda = KeyStroke.getKeyStroke(37, 0);
            KeyStroke ctrlCima = KeyStroke.getKeyStroke(38, 2);
            KeyStroke ctrlBaixo = KeyStroke.getKeyStroke(40, 2);
            KeyStroke ctrlDireita = KeyStroke.getKeyStroke(39, 2);
            KeyStroke ctrlEsquerda = KeyStroke.getKeyStroke(37, 2);
            KeyStroke shiftCima = KeyStroke.getKeyStroke(38, 1);
            KeyStroke shiftBaixo = KeyStroke.getKeyStroke(40, 1);
            KeyStroke shiftDireita = KeyStroke.getKeyStroke(39, 1);
            KeyStroke shiftEsquerda = KeyStroke.getKeyStroke(37, 1);
            KeyStroke ctrlShiftCima = KeyStroke.getKeyStroke(38, 3);
            KeyStroke ctrlShiftBaixo = KeyStroke.getKeyStroke(40, 3);
            KeyStroke ctrlShiftDireita = KeyStroke.getKeyStroke(39, 3);
            KeyStroke ctrlShiftEsquerda = KeyStroke.getKeyStroke(37, 3);
            KeyStroke ctrlC = KeyStroke.getKeyStroke(67, 2);
            KeyStroke ctrlX = KeyStroke.getKeyStroke(88, 2);
            KeyStroke ctrlV = KeyStroke.getKeyStroke(86, 2);
            KeyStroke ctrlZ = KeyStroke.getKeyStroke(90, 2);
            AbstractAction acaoDelete = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        Selecao.this.removerComponentesSelecionados();
                    }
                }
            };
            AbstractAction acaoF2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Componente comp;
                    if (Selecao.this.itens.size() == 1 && !Selecao.this.modoInterfaceamento() && (comp = (Componente)Selecao.this.itens.get(0)).editavel()) {
                        comp.setEditando(true);
                    }
                }
            };
            AbstractAction acaoCtrlD = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        Selecao.this.duplicarItensSelecionados();
                    }
                }
            };
            AbstractAction acaoCima = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        switch (e.getModifiers()) {
                            case 0: {
                                break;
                            }
                            case 2: {
                                Selecao.this.deslocarCima(1);
                                break;
                            }
                            case 1: {
                                Selecao.this.diminuirAltura();
                                break;
                            }
                            case 3: {
                                Selecao.this.deslocarCima(10);
                            }
                        }
                    }
                }
            };
            AbstractAction acaoBaixo = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        switch (e.getModifiers()) {
                            case 0: {
                                break;
                            }
                            case 2: {
                                Selecao.this.deslocarBaixo(1);
                                break;
                            }
                            case 1: {
                                Selecao.this.aumentarAltura();
                                break;
                            }
                            case 3: {
                                Selecao.this.deslocarBaixo(10);
                            }
                        }
                    }
                }
            };
            AbstractAction acaoDireita = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        switch (e.getModifiers()) {
                            case 0: {
                                break;
                            }
                            case 2: {
                                Selecao.this.deslocarDireita(1);
                                break;
                            }
                            case 1: {
                                Selecao.this.aumentarLargura();
                                break;
                            }
                            case 3: {
                                Selecao.this.deslocarDireita(10);
                            }
                        }
                    }
                }
            };
            AbstractAction acaoEsquerda = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        switch (e.getModifiers()) {
                            case 0: {
                                break;
                            }
                            case 2: {
                                Selecao.this.deslocarEsquerda(1);
                                break;
                            }
                            case 1: {
                                Selecao.this.diminuirLargura();
                                break;
                            }
                            case 3: {
                                Selecao.this.deslocarEsquerda(10);
                            }
                        }
                    }
                }
            };
            AbstractAction acaoCopiar = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        Selecao.this.copiar();
                    }
                }
            };
            AbstractAction acaoRecortar = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        Selecao.this.copiar();
                        Selecao.this.removerComponentesSelecionados();
                    }
                }
            };
            AbstractAction acaoColar = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        Selecao.this.colar();
                    }
                }
            };
            AbstractAction acaoVoltar = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Selecao.this.modoInterfaceamento()) {
                        Selecao.this.voltar();
                    }
                }
            };
            mapaUm.put(delete, "delete");
            mapaDois.put(delete, "delete");
            mapaTres.put(delete, "delete");
            mapaUm.put(f2, "f2");
            mapaDois.put(f2, "f2");
            mapaTres.put(f2, "f2");
            mapaUm.put(ctrlD, "ctrl+d");
            mapaDois.put(ctrlD, "ctrl+d");
            mapaTres.put(ctrlD, "ctrl+d");
            mapaUm.put(cima, "cima");
            mapaDois.put(cima, "cima");
            mapaTres.put(cima, "cima");
            mapaUm.put(shiftCima, "cima");
            mapaDois.put(shiftCima, "cima");
            mapaTres.put(shiftCima, "cima");
            mapaUm.put(ctrlCima, "cima");
            mapaDois.put(ctrlCima, "cima");
            mapaTres.put(ctrlCima, "cima");
            mapaUm.put(ctrlShiftCima, "cima");
            mapaDois.put(ctrlShiftCima, "cima");
            mapaTres.put(ctrlShiftCima, "cima");
            mapaUm.put(baixo, "baixo");
            mapaDois.put(baixo, "baixo");
            mapaTres.put(baixo, "baixo");
            mapaUm.put(shiftBaixo, "baixo");
            mapaDois.put(shiftBaixo, "baixo");
            mapaTres.put(shiftBaixo, "baixo");
            mapaUm.put(ctrlBaixo, "baixo");
            mapaDois.put(ctrlBaixo, "baixo");
            mapaTres.put(ctrlBaixo, "baixo");
            mapaUm.put(ctrlShiftBaixo, "baixo");
            mapaDois.put(ctrlShiftBaixo, "baixo");
            mapaTres.put(ctrlShiftBaixo, "baixo");
            mapaUm.put(direita, "direita");
            mapaDois.put(direita, "direita");
            mapaTres.put(direita, "direita");
            mapaUm.put(shiftDireita, "direita");
            mapaDois.put(shiftDireita, "direita");
            mapaTres.put(shiftDireita, "direita");
            mapaUm.put(ctrlDireita, "direita");
            mapaDois.put(ctrlDireita, "direita");
            mapaTres.put(ctrlDireita, "direita");
            mapaUm.put(ctrlShiftDireita, "direita");
            mapaDois.put(ctrlShiftDireita, "direita");
            mapaTres.put(ctrlShiftDireita, "direita");
            mapaUm.put(esquerda, "esquerda");
            mapaDois.put(esquerda, "esquerda");
            mapaTres.put(esquerda, "esquerda");
            mapaUm.put(shiftEsquerda, "esquerda");
            mapaDois.put(shiftEsquerda, "esquerda");
            mapaTres.put(shiftEsquerda, "esquerda");
            mapaUm.put(ctrlEsquerda, "esquerda");
            mapaDois.put(ctrlEsquerda, "esquerda");
            mapaTres.put(ctrlEsquerda, "esquerda");
            mapaUm.put(ctrlShiftEsquerda, "esquerda");
            mapaDois.put(ctrlShiftEsquerda, "esquerda");
            mapaTres.put(ctrlShiftEsquerda, "esquerda");
            mapaUm.put(ctrlC, "copiar");
            mapaDois.put(ctrlC, "copiar");
            mapaTres.put(ctrlC, "copiar");
            mapaUm.put(ctrlX, "recortar");
            mapaDois.put(ctrlX, "recortar");
            mapaTres.put(ctrlX, "recortar");
            mapaUm.put(ctrlV, "colar");
            mapaDois.put(ctrlV, "colar");
            mapaTres.put(ctrlV, "colar");
            mapaUm.put(ctrlZ, "voltar");
            mapaDois.put(ctrlZ, "voltar");
            mapaTres.put(ctrlZ, "voltar");
            mapaAcao.put("delete", acaoDelete);
            mapaAcao.put("f2", acaoF2);
            mapaAcao.put("ctrl+d", acaoCtrlD);
            mapaAcao.put("cima", acaoCima);
            mapaAcao.put("baixo", acaoBaixo);
            mapaAcao.put("direita", acaoDireita);
            mapaAcao.put("esquerda", acaoEsquerda);
            mapaAcao.put("copiar", acaoCopiar);
            mapaAcao.put("recortar", acaoRecortar);
            mapaAcao.put("colar", acaoColar);
            mapaAcao.put("voltar", acaoVoltar);
        }
    }

    public void fireEventoSelecao() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != SelecaoListener.class) continue;
            if (this.evento == null) {
                this.evento = new ChangeEvent(this);
            }
            ((SelecaoListener)ouvintes[i + 1]).eventoSelecao(this.evento);
        }
    }

    public void fireDadosAlterados() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != SelecaoListener.class) continue;
            if (this.evento == null) {
                this.evento = new ChangeEvent(this);
            }
            ((SelecaoListener)ouvintes[i + 1]).dadosAlterados(this.evento);
        }
    }

    private boolean validarComponentesParaLigar() {
        Iterator<Componente> itr = this.itens.iterator();
        Componente o = itr.next();
        if (o instanceof Rotulo || o instanceof Imagem || o instanceof Forma || o instanceof CodigoBarrasConf || o instanceof Assinatura) {
            return false;
        }
        while (itr.hasNext()) {
            if (!(itr.next() instanceof Assinatura)) continue;
            return false;
        }
        return true;
    }

    private boolean selecionouSemFonte() {
        for (Componente o : this.itens) {
            if (!(o instanceof Imagem) && !(o instanceof Assinatura) && !(o instanceof Forma) && !(o instanceof CodigoBarrasConf)) continue;
            return true;
        }
        return false;
    }

    private void ligarComponentesSelecionados() {
        if (this.itens.size() > 1) {
            ArrayList<String> lig = new ArrayList<String>();
            for (int i = 1; i < this.itens.size(); ++i) {
                lig.add(this.itens.get(i).getNome());
            }
            this.itens.get(0).setLigacoes(lig);
        }
    }

    private void atribuirMesmaFonte() {
        if (this.itens.size() > 1) {
            Componente[] tmp = this.itens.toArray(new Componente[this.itens.size()]);
            for (int i = 1; i < tmp.length; ++i) {
                tmp[i].setFonte(tmp[0].getFonte());
            }
        }
    }

    private void atribuirMesmaCorDaFonte() {
        if (this.itens.size() > -1) {
            Componente[] tmp = this.itens.toArray(new Componente[this.itens.size()]);
            for (int i = 1; i < tmp.length; ++i) {
                tmp[i].setCorDaFonte(tmp[0].getCorDaFonte());
            }
        }
    }

    private void distribuirHorizontalmente() {
        int i;
        Componente[] c = this.itens.toArray(new Componente[this.itens.size()]);
        Arrays.sort(c, new Comparator<Componente>(){

            @Override
            public int compare(Componente a, Componente b) {
                return a.getEsquerda() < b.getEsquerda() ? -1 : (a.getEsquerda() > b.getEsquerda() ? 1 : 0);
            }
        });
        int w = 0;
        for (i = 1; i < c.length; ++i) {
            w += c[i].getEsquerda() - c[i - 1].getEsquerda() - c[i - 1].getLargura();
        }
        w /= c.length - 1;
        for (i = 1; i < c.length - 1; ++i) {
            c[i].setEsquerda(c[i - 1].getEsquerda() + c[i - 1].getLargura() + w);
        }
    }

    private void distribuirVerticalmente() {
        int i;
        Componente[] c = this.itens.toArray(new Componente[this.itens.size()]);
        Arrays.sort(c, new Comparator<Componente>(){

            @Override
            public int compare(Componente a, Componente b) {
                return a.getTopo() < b.getTopo() ? -1 : (a.getTopo() > b.getTopo() ? 1 : 0);
            }
        });
        int h = 0;
        for (i = 1; i < c.length; ++i) {
            h += c[i].getTopo() - c[i - 1].getTopo() - c[i - 1].getAltura();
        }
        h /= c.length - 1;
        for (i = 1; i < c.length - 1; ++i) {
            c[i].setTopo(c[i - 1].getTopo() + c[i - 1].getAltura() + h);
        }
    }

    private void removerComponentesSelecionados() {
        Componente[] tmp = this.itens.toArray(new Componente[0]);
        this.removerSelecao();
        for (Componente comp : tmp) {
            if (!this.verificarConfiguracaoResultadoAnterior(comp)) {
                this.armazenaAlteracoes(comp, OPERACAO_ALTERACAO_EXCLUSAO);
                comp.prepararRemocao();
                this.pagina.removerComponente(comp);
                continue;
            }
            this.pagina.addMensagensUsuario(new MensagensConfigurador("O componente " + comp.getNome() + " n\u00e3o pode ser removido por ser um resultado anterior", 2));
        }
    }

    public boolean verificarConfiguracaoResultadoAnterior(Componente comp) {
        return comp.getResultadoAnterior();
    }

    private void diminuirAltura() {
        Component[] comp = this.itens.toArray(new Component[0]);
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof Componente)) continue;
            ((Componente)((Object)comp[i])).setTamanho(this.redimensionar(comp[i].getBounds(), comp[i].getX(), comp[i].getY(), comp[i].getWidth(), comp[i].getHeight() - 1).getSize());
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    private void diminuirLargura() {
        Component[] comp = this.itens.toArray(new Component[0]);
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof Componente)) continue;
            ((Componente)((Object)comp[i])).setTamanho(this.redimensionar(comp[i].getBounds(), comp[i].getX(), comp[i].getY(), comp[i].getWidth() - 1, comp[i].getHeight()).getSize());
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    private void aumentarAltura() {
        Component[] comp = this.itens.toArray(new Component[0]);
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof Componente)) continue;
            ((Componente)((Object)comp[i])).setTamanho(this.redimensionar(comp[i].getBounds(), comp[i].getX(), comp[i].getY(), comp[i].getWidth(), comp[i].getHeight() + 1).getSize());
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    private void aumentarLargura() {
        Component[] comp = this.itens.toArray(new Component[0]);
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof Componente)) continue;
            ((Componente)((Object)comp[i])).setTamanho(this.redimensionar(comp[i].getBounds(), comp[i].getX(), comp[i].getY(), comp[i].getWidth() + 1, comp[i].getHeight()).getSize());
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    private void deslocarCima(int uni) {
        Component[] comp = this.itens.toArray(new Component[0]);
        for (int i = 0; i < comp.length; ++i) {
            comp[i].setLocation(this.redimensionar(comp[i].getBounds(), comp[i].getX(), comp[i].getY() - uni, comp[i].getWidth(), comp[i].getHeight()).getLocation());
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    private void deslocarBaixo(int uni) {
        Component[] comp = this.itens.toArray(new Component[0]);
        for (int i = 0; i < comp.length; ++i) {
            comp[i].setLocation(this.redimensionar(comp[i].getBounds(), comp[i].getX(), comp[i].getY() + uni, comp[i].getWidth(), comp[i].getHeight()).getLocation());
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    private void deslocarDireita(int uni) {
        Component[] comp = this.itens.toArray(new Component[0]);
        for (int i = 0; i < comp.length; ++i) {
            comp[i].setLocation(this.redimensionar(comp[i].getBounds(), comp[i].getX() + uni, comp[i].getY(), comp[i].getWidth(), comp[i].getHeight()).getLocation());
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    private void deslocarEsquerda(int uni) {
        Component[] comp = this.itens.toArray(new Component[0]);
        for (int i = 0; i < comp.length; ++i) {
            comp[i].setLocation(this.redimensionar(comp[i].getBounds(), comp[i].getX() - uni, comp[i].getY(), comp[i].getWidth(), comp[i].getHeight()).getLocation());
        }
        this.atualizarDimensoes();
        this.fireDadosAlterados();
    }

    private void armazenaAlteracoes(Componente item, String operacao) {
        if (item != null && this.pagina != null) {
            StringBuilder bui = new StringBuilder(StringUtil.getTag("tipoConfigurador", String.valueOf(this.pagina.getTipoConfiguracao())));
            bui.append(StringUtil.getTag("itemAlterado", StringUtil.getTag("operacao", operacao) + StringUtil.getTag("tipo", item.getClass().getName()) + item.getAtributos()));
            String str = StringUtil.getTag("configurador", bui.toString());
            this.pagina.adicionaAlteracao(str);
        }
    }

    private void copiar() {
        if (this.itens.size() > 0) {
            Componente[] comp = this.itens.toArray(new Componente[this.itens.size()]);
            StringBuilder bui = new StringBuilder(StringUtil.getTag("tipoConfigurador", String.valueOf(this.pagina.getTipoConfiguracao())));
            for (int i = 0; i < comp.length; ++i) {
                bui.append(StringUtil.getTag("itemCopiado", StringUtil.getTag("tipo", comp[i].getClass().getName()) + comp[i].getAtributos()));
            }
            StringSelection str = new StringSelection(StringUtil.getTag("configurador", bui.toString()));
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(str, null);
        }
    }

    private void colar() {
        try {
            String tmp;
            Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor) && (tmp = StringUtil.getValor((String)contents.getTransferData(DataFlavor.stringFlavor), "configurador")).length() > 0 && StringUtil.getInt(tmp, "tipoConfigurador") == this.pagina.getTipoConfiguracao()) {
                this.removerSelecao();
                String[] str = StringUtil.getValores(tmp, "itemCopiado");
                for (int i = 0; i < str.length; ++i) {
                    Componente comp = (Componente)Class.forName(StringUtil.getValor(str[i], "tipo")).newInstance();
                    comp.setNome(this.pagina.gerarNome(comp.getNomeBase()));
                    comp.setPagina(this.pagina);
                    comp.copiarAtributosDe(str[i]);
                    comp.setContadorPagina(this.pagina.getPaginaSelecionada());
                    this.pagina.addComponente(comp);
                    if (i == 0) {
                        this.local = comp.getLocal();
                        this.area = this.pagina.retanguloArea(this.local);
                    }
                    comp.setSelecao(this);
                    this.itens.add(comp);
                }
                this.atualizarDimensoes();
                if (this.avisarOuvintes) {
                    this.fireEventoSelecao();
                }
                this.habilitarDesabilitarPopupMenu();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selecao: 1737");
        }
    }

    private void voltar() {
        if (this.pagina != null) {
            try {
                String tmp;
                String volta = this.pagina.pegaUltimaAlteracaoRealizada();
                if (volta != null && !Funcoes.textoVazio(volta) && (tmp = StringUtil.getValor(volta, "configurador")).length() > 0 && StringUtil.getInt(tmp, "tipoConfigurador") == this.pagina.getTipoConfiguracao()) {
                    Componente comp;
                    this.removerSelecao();
                    String[] str = StringUtil.getValores(tmp, "itemAlterado");
                    String operacao = StringUtil.getValor(tmp, "operacao");
                    String nome = StringUtil.getValor(tmp, "nome");
                    if (operacao.equals(OPERACAO_ALTERACAO_MOVIMENTO)) {
                        comp = this.pagina.getComponenteComNome(nome);
                    } else {
                        comp = (Componente)Class.forName(StringUtil.getValor(tmp, "tipo")).newInstance();
                        comp.setNome(nome);
                        comp.setPagina(this.pagina);
                        this.pagina.addComponente(comp);
                        this.local = comp.getLocal();
                        this.area = this.pagina.retanguloArea(this.local);
                    }
                    if (comp != null) {
                        for (int i = 0; i < str.length; ++i) {
                            comp.copiarAtributosDe(str[i]);
                        }
                    }
                    this.atualizarDimensoes();
                    if (this.avisarOuvintes) {
                        this.fireEventoSelecao();
                    }
                    this.habilitarDesabilitarPopupMenu();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selecao: 1812");
            }
        }
    }

    private boolean modoInterfaceamento() {
        return this.pagina != null && this.pagina.getInterfaceRelacionamento() != null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

