/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.selecao;

import jalis.laboratorio.configurador.componente.Componente;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;

public class PreSelecao
extends JComponent {
    private Color cor = Color.red;
    private ArrayList itens = new ArrayList();
    private boolean preSelecionando;
    private Componente primeiro;

    public PreSelecao() {
        this.setBounds(0, 0, 0, 0);
    }

    public void setCor(Color cor) {
        this.cor = cor;
    }

    public Color getCor() {
        return this.cor;
    }

    public Componente getPrimeiro() {
        return this.primeiro;
    }

    public void setPrimeiro(Componente comp) {
        if (comp != null) {
            this.primeiro = comp;
        }
    }

    public void selecionar(Componente item) {
        if (item != null && !this.itens.contains(item)) {
            Rectangle rec = item.getDimensoes();
            rec.setBounds(rec.x - 2, rec.y - 2, rec.width + 4, rec.height + 4);
            if (this.itens.isEmpty()) {
                this.primeiro = item;
                this.setBounds(rec);
            } else {
                Rectangle tmp = this.getBounds();
                tmp.add(rec);
                this.setBounds(tmp);
            }
            this.itens.add(item);
        }
    }

    public void removerSelecao() {
        this.setBounds(0, 0, 0, 0);
        this.itens.clear();
        this.primeiro = null;
    }

    public boolean vazio() {
        return this.itens.isEmpty();
    }

    public boolean contem(Componente item) {
        return this.itens.contains(item);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rec = this.getBounds();
        for (Componente comp : this.itens) {
            Rectangle tmp = comp.getDimensoes();
            tmp.setBounds(tmp.x - rec.x - 2, tmp.y - rec.y - 2, tmp.width + 4, tmp.height + 4);
            g.setColor(comp == this.primeiro ? this.cor : Color.gray);
            g.fillRect(tmp.x, tmp.y, 5, 5);
            g.fillRect(tmp.x, tmp.y + tmp.height - 5, 5, 5);
            g.fillRect(tmp.x + tmp.width - 5, tmp.y, 5, 5);
            g.fillRect(tmp.x + tmp.width - 5, tmp.y + tmp.height - 5, 5, 5);
        }
    }
}

