/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.util.StringUtil;

class ObjetoRotuloReferencia {
    String titulo;
    int valorInicial;
    int valorFinal;

    public ObjetoRotuloReferencia(String titulo) {
        this.titulo = titulo;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public int getValorInicial() {
        return this.valorInicial;
    }

    public void setValorInicial(int valorInicial) {
        this.valorInicial = valorInicial;
    }

    public int getValorFinal() {
        return this.valorFinal;
    }

    public void setValorFinal(int valorFinal) {
        this.valorFinal = valorFinal;
    }

    public String toString() {
        return this.titulo;
    }

    public static ObjetoRotuloReferencia newFromXML(String xml) {
        if (xml != null) {
            String titulo = StringUtil.getValor(xml, "titulo");
            String valorInicial = StringUtil.getValor(xml, "inicial");
            String valorFinal = StringUtil.getValor(xml, "final");
            if (titulo.trim().length() > 0 && valorInicial.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && valorFinal.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
                ObjetoRotuloReferencia ob = new ObjetoRotuloReferencia(titulo);
                ob.setValorInicial(Integer.parseInt(valorInicial));
                ob.setValorFinal(Integer.parseInt(valorFinal));
                return ob;
            }
        }
        return null;
    }
}

