/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.propriedade.TipoLinha;
import jalis.laboratorio.configurador.propriedade.TipoPonto;
import jalis.util.StringUtil;
import java.awt.Color;
import java.util.ArrayList;

class ObjetoLinhaFixa {
    private String titulo;
    private Color cor = Color.WHITE;
    private TipoLinha tipoLinha = TipoLinha.SOLIDO;
    private TipoPonto tipoPonto = TipoPonto.QUADRADO;
    private ArrayList<String> valores = new ArrayList();

    public ObjetoLinhaFixa(String titulo) {
        this.titulo = titulo;
        this.cor = Color.BLACK;
    }

    public void adicionarValor(String valor) {
        if (valor.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            this.valores.add(valor);
        }
    }

    public String toString() {
        return this.titulo;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public Color getCor() {
        return this.cor;
    }

    public void setCor(Color cor) {
        this.cor = cor;
    }

    public TipoLinha getTipoLinha() {
        return this.tipoLinha;
    }

    public void setTipoLinha(TipoLinha tipoLinha) {
        this.tipoLinha = tipoLinha;
    }

    public TipoPonto getTipoPonto() {
        return this.tipoPonto;
    }

    public void setTipoPonto(TipoPonto tipoPonto) {
        this.tipoPonto = tipoPonto;
    }

    public ArrayList<String> getValores() {
        return this.valores;
    }

    public void limparValores() {
        this.valores.clear();
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<linhafixa>");
        buf.append("<titulo>").append(this.titulo).append("</titulo>");
        buf.append("<cor>").append(this.cor.getRGB()).append("</cor>");
        buf.append("<tipoponto>").append(this.tipoPonto.getCodigo()).append("</tipoponto>");
        buf.append("<tipolinha>").append(this.tipoLinha.getCodigo()).append("</tipolinha>");
        buf.append("<valores>");
        for (String s : this.valores) {
            buf.append("<valor>").append(s).append("</valor>");
        }
        buf.append("</valores>");
        buf.append("</linhafixa>");
        return buf.toString();
    }

    public static ObjetoLinhaFixa newFromXML(String xml) {
        if (xml.indexOf("linhafixa") > -1) {
            ObjetoLinhaFixa o = new ObjetoLinhaFixa(StringUtil.getValor(xml, "titulo"));
            o.setCor(StringUtil.getColor(xml, "cor"));
            if (StringUtil.getValor(xml, "tipoponto").trim().length() > 0) {
                o.setTipoPonto(TipoPonto.getTipoLinha(StringUtil.getInt(xml, "tipoponto")));
            }
            if (StringUtil.getValor(xml, "tipolinha").trim().length() > 0) {
                o.setTipoLinha(TipoLinha.getTipoLinha(StringUtil.getInt(xml, "tipolinha")));
            }
            for (String v : StringUtil.getValores(xml, "valor")) {
                o.adicionarValor(v);
            }
            return o;
        }
        return null;
    }
}

