/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.util.Comparador;
import jalis.util.Funcoes;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

class ModeloEditorHistorico
extends DefaultTableModel
implements MouseListener {
    String[] cols = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    List<String[]> dados = new ArrayList<String[]>();
    int ultCol = -1;
    int ultSentido = 1;

    ModeloEditorHistorico() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)o;
            JTable tab = header.getTable();
            int col = header.getColumnModel().getColumnIndexAtX(e.getX());
            Rectangle rec = header.getHeaderRect(col);
            if (col == 0) {
                rec.width -= 3;
            } else {
                rec.grow(-3, 0);
            }
            int[] cols = Funcoes.getTamanhoColunas(tab.getColumnModel());
            if (rec.contains(e.getPoint())) {
                this.ordenar(col);
            }
            Funcoes.setTamanhoColunas(tab.getColumnModel(), cols);
        }
    }

    private void ordenar(int col) {
        if (col > -1 && col < this.cols.length) {
            if (col == this.ultCol) {
                this.ultSentido *= -1;
            } else {
                this.ultSentido = 1;
                this.ultCol = col;
            }
            String[][] tmp = (String[][])this.dados.toArray((T[])new String[this.dados.size()][]);
            Arrays.sort(tmp, new Comparador(this.ultCol, this.ultSentido));
            this.dados.clear();
            for (int i = 0; i < tmp.length; ++i) {
                this.dados.add(tmp[i]);
            }
            this.fireTableStructureChanged();
        }
    }

    public void adicionarHistoricos(Map<String, String> historicos) {
        if (historicos != null) {
            for (String cod : historicos.keySet()) {
                this.dados.add(new String[]{cod, historicos.get(cod)});
            }
        }
    }

    public Map<String, String> getHistoricos() {
        HashMap<String, String> his = new HashMap<String, String>();
        for (String[] tmp : this.dados) {
            his.put(tmp[0], tmp[1]);
        }
        return his;
    }

    public Map<String, String> getHistoricos(List<String> codigos) {
        HashMap<String, String> his = new HashMap<String, String>();
        if (codigos != null) {
            for (String[] tmp : this.dados) {
                if (!codigos.contains(tmp[0])) continue;
                his.put(tmp[0], tmp[1]);
            }
        }
        return his;
    }

    public List<String> getCodigoHistoricos() {
        ArrayList<String> codigos = new ArrayList<String>();
        for (String[] tmp : this.dados) {
            codigos.add(tmp[0]);
        }
        return codigos;
    }

    public Map<String, String> removerHistoricos(int[] linhas) {
        HashMap<String, String> his = new HashMap<String, String>();
        if (linhas != null && linhas.length > 0) {
            ArrayList<String[]> tmp = new ArrayList<String[]>();
            int pos = 0;
            for (String[] lin : this.dados) {
                if (this.contem(pos++, linhas)) {
                    his.put(lin[0], lin[1]);
                    continue;
                }
                tmp.add(lin);
            }
            this.dados.clear();
            this.dados = tmp;
        }
        return his;
    }

    public Map<String, String> removerHistoricos(List<String> codigos) {
        HashMap<String, String> his = new HashMap<String, String>();
        if (codigos != null) {
            ArrayList<String[]> tmp = new ArrayList<String[]>();
            for (String[] lin : this.dados) {
                if (codigos.contains(lin[0])) {
                    his.put(lin[0], lin[1]);
                    continue;
                }
                tmp.add(lin);
            }
            this.dados.clear();
            this.dados = tmp;
        }
        return his;
    }

    public Map<String, String> removerHistoricos() {
        HashMap<String, String> his = new HashMap<String, String>();
        for (String[] lin : this.dados) {
            his.put(lin[0], lin[1]);
        }
        this.dados.clear();
        return his;
    }

    public void limpar() {
        this.dados.clear();
    }

    @Override
    public String getColumnName(int col) {
        if (this.cols == null) {
            return "";
        }
        StringBuilder bui = new StringBuilder(this.cols[col]);
        if (col == this.ultCol) {
            bui.append(this.ultSentido == 1 ? "  \u25bc" : "  \u25b2");
        }
        return bui.toString();
    }

    @Override
    public int getColumnCount() {
        return this.cols == null ? 0 : this.cols.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.dados == null ? "" : this.dados.get(row)[col];
    }

    @Override
    public int getRowCount() {
        return this.dados == null ? 0 : this.dados.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public boolean contem(int valor, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != valor) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

