/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.propriedade.Editor;
import jalis.laboratorio.configurador.propriedade.EditorConferenciaAutomatica;
import jalis.laboratorio.configurador.propriedade.EditorOrigemGrafico;
import jalis.laboratorio.configurador.propriedade.EditorOrigemResultadoAnterior;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.configurador.selecao.Selecao;
import jalis.laboratorio.configurador.selecao.SelecaoListener;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class Gerenciador
extends AbstractTableModel
implements SelecaoListener {
    private String[] col = new String[]{"Propriedade", "Valor"};
    private Object[][] dados = new Object[0][2];
    private JTable tabProp;
    public Selecao sel;
    private EditorCelula editor = new EditorCelula();

    public Gerenciador(Selecao sel) {
        this.sel = sel;
        sel.addSelecaoListener(this);
        this.tabProp = new JTable(this);
        this.tabProp.setName("tabProp");
        this.tabProp.getTableHeader().setReorderingAllowed(false);
        this.tabProp.setBackground(new Color(246, 242, 246));
        this.tabProp.setRowHeight(20);
        this.tabProp.getColumnModel().getColumn(1).setCellEditor(this.editor);
        this.tabProp.setFocusable(false);
    }

    public JTable getTabelaPropriedades() {
        return this.tabProp;
    }

    @Override
    public void dadosAlterados(ChangeEvent e) {
        try {
            this.carregarValor();
            this.fireTableDataChanged();
            this.tabProp.getColumnModel().getColumn(1).setCellEditor(this.editor);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Gerenciador: 75");
        }
    }

    @Override
    public void eventoSelecao(ChangeEvent e) {
        try {
            this.carregarProp();
            this.carregarValor();
            boolean isConfiguraCamposResult = this.sel.getPagina().isResultadoCampo();
            for (Componente c : this.sel.paraArray()) {
                if (this.sel.verificarConfiguracaoResultadoAnterior(c)) {
                    this.desabilitarEdicaoPropriedade("nome", true);
                    continue;
                }
                this.desabilitarEdicaoPropriedade("nome", false);
            }
            if (isConfiguraCamposResult) {
                this.configuraEdicaoPropriedades();
            }
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
            this.tabProp.getColumnModel().getColumn(1).setCellEditor(this.editor);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Gerenciador: 93");
        }
    }

    private void configuraEdicaoPropriedades() {
        for (int i = 0; i < this.dados.length; ++i) {
            ((Editor)this.dados[i][1]).removeAll();
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        return colIndex == 1;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return this.col[column];
    }

    @Override
    public int getRowCount() {
        return this.dados.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return ((Editor)this.dados[rowIndex][columnIndex]).getValorUsuario();
        }
        return this.dados[rowIndex][columnIndex];
    }

    private void carregarProp() throws IllegalAccessException, InstantiationException {
        List<Propriedade> prop = this.getPropriedadesEmComum();
        this.ordenarPropriedades(prop);
        this.dados = new Object[prop.size()][2];
        for (int i = 0; i < prop.size(); ++i) {
            Propriedade p = prop.get(i);
            Editor etr = p.getEditor().newInstance();
            if (etr instanceof EditorTag && this.sel.paraArray().length == 1) {
                ((EditorTag)etr).setComponente((ComponenteEditor)((Object)this.sel.paraArray()[0]));
            }
            if (etr instanceof EditorOrigemResultadoAnterior && this.sel.paraArray().length == 1) {
                ((EditorOrigemResultadoAnterior)etr).setComponente((ComponenteEditor)((Object)this.sel.paraArray()[0]));
            }
            if (etr instanceof EditorConferenciaAutomatica && this.sel.paraArray().length == 1) {
                ((EditorConferenciaAutomatica)etr).setComponente((ComponenteEditor)((Object)this.sel.paraArray()[0]));
            }
            if (etr instanceof EditorOrigemGrafico && this.sel.paraArray().length == 1) {
                ((EditorOrigemGrafico)etr).setComponente((ComponenteEditor)((Object)this.sel.paraArray()[0]));
            }
            etr.setPropriedade(p.getNome());
            etr.setComponentes(this.sel.paraArray());
            etr.setPagina(this.sel.getPagina());
            etr.addChangeListener(changeEvent -> {
                this.editor.atribuirValor(((Editor)changeEvent.getSource()).getValor(), ((Editor)changeEvent.getSource()).getPropriedade());
                this.eventoSelecao(null);
            });
            this.dados[i][0] = p.getNome();
            this.dados[i][1] = etr;
        }
    }

    private void desabilitarEdicaoPropriedade(String propriedade, boolean desabilitar) {
        for (int i = 0; i < this.dados.length; ++i) {
            if (!((Editor)this.dados[i][1]).getPropriedade().equals(propriedade)) continue;
            ((Editor)this.dados[i][1]).setDesabilitarEditor(desabilitar);
        }
    }

    public void carregarValor() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        for (int i = 0; i < this.dados.length; ++i) {
            ((Editor)this.dados[i][1]).setValor(this.valorProp((String)this.dados[i][0]));
        }
    }

    private void ordenarPropriedades(List<Propriedade> list) {
        Collections.sort(list, new Comparator<Propriedade>(){

            @Override
            public int compare(Propriedade p1, Propriedade p2) {
                if (p1.getNome().equalsIgnoreCase("componente")) {
                    return -1;
                }
                if (p2.getNome().equalsIgnoreCase("componente")) {
                    return 1;
                }
                return p1.getNome().compareToIgnoreCase(p2.getNome());
            }
        });
    }

    private List<Propriedade> getPropriedadesEmComum() {
        ArrayList<Propriedade> comum = new ArrayList<Propriedade>();
        Iterator<Componente> itr = this.sel.iterator();
        if (itr.hasNext()) {
            comum.addAll(itr.next().getPropriedades());
            while (itr.hasNext()) {
                comum.retainAll(itr.next().getPropriedades());
            }
        }
        return comum;
    }

    public Object valorProp(String prop) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Object valor = null;
        Iterator<Componente> itr = this.sel.iterator();
        if (itr.hasNext()) {
            Componente obj = itr.next();
            Method met = obj.getClass().getMethod(this.nomeMetodo("get", prop), new Class[0]);
            valor = met.invoke((Object)obj, new Object[0]);
            while (itr.hasNext() && valor != null) {
                obj = itr.next();
                met = obj.getClass().getMethod(this.nomeMetodo("get", prop), new Class[0]);
                if (valor.equals(met.invoke((Object)obj, new Object[0]))) continue;
                return null;
            }
        }
        return valor;
    }

    private String nomeMetodo(String pre, String prop) {
        String retorno = null;
        if (prop != null && prop.length() > 0) {
            StringBuffer str = new StringBuffer();
            str.append(pre);
            boolean upper = true;
            char[] ch = prop.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                if (upper && ch[i] != ' ') {
                    str.append(Character.toUpperCase(StringUtil.removerAcento(ch[i])));
                    upper = false;
                    continue;
                }
                if (ch[i] == ' ') {
                    upper = true;
                    continue;
                }
                str.append(StringUtil.removerAcento(ch[i]));
            }
            return str.toString();
        }
        return retorno;
    }

    private class EditorCelula
    implements TableCellEditor {
        private int linha;
        private ChangeEvent evento;

        private EditorCelula() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.linha = row;
            return (Component)Gerenciador.this.dados[this.linha][1];
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return ((Editor)Gerenciador.this.dados[this.linha][1]).getValorUsuario();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            Gerenciador.this.listenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            Gerenciador.this.listenerList.remove(CellEditorListener.class, l);
        }

        protected void fireEditingStopped() {
            Object[] ouvintes = Gerenciador.this.listenerList.getListenerList();
            for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
                if (ouvintes[i] != CellEditorListener.class) continue;
                if (this.evento == null) {
                    this.evento = new ChangeEvent(this);
                }
                ((CellEditorListener)ouvintes[i + 1]).editingStopped(this.evento);
            }
        }

        protected void fireEditingCanceled() {
            Object[] ouvintes = Gerenciador.this.listenerList.getListenerList();
            for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
                if (ouvintes[i] != CellEditorListener.class) continue;
                if (this.evento == null) {
                    this.evento = new ChangeEvent(this);
                }
                ((CellEditorListener)ouvintes[i + 1]).editingCanceled(this.evento);
            }
        }

        private void atribuirValor(Object valor, String prop) {
            try {
                if (valor != null && prop != null) {
                    String nome = Gerenciador.this.nomeMetodo("set", prop);
                    Iterator<Componente> itr = Gerenciador.this.sel.iterator();
                    while (itr.hasNext()) {
                        Componente obj = itr.next();
                        Method met = this.metodo(obj.getClass(), nome);
                        if (met == null || met.getParameterTypes().length != 1) continue;
                        met.invoke((Object)obj, valor);
                    }
                    Gerenciador.this.sel.atualizarDimensoes();
                    Gerenciador.this.dadosAlterados(null);
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel atribuir valor a propriedade " + prop + "\n" + ex.getMessage(), ex.getStackTrace(), "Gerenciador: 430");
            }
        }

        private Method metodo(Class classe, String metodo) {
            Method[] met = classe.getMethods();
            int pos = -1;
            for (int i = 0; i < met.length; ++i) {
                if (!met[i].getName().equals(metodo)) continue;
                pos = i;
                break;
            }
            return pos < 0 ? null : met[pos];
        }
    }
}

