/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.configurador.propriedade.Editor;
import jalis.util.DocumentoMascara;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditorValorReferencia
extends Editor {
    private JLabel rotulo = new JLabel();
    private JButton botao = new JButton("...");
    private ValoresReferencia valores;

    public EditorValorReferencia() {
        this.add((Component)this.rotulo, "Center");
        this.add((Component)this.botao, "East");
        this.botao.setPreferredSize(new Dimension(20, 20));
        this.botao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorValorReferencia.this.componentes.length == 1 && (EditorValorReferencia.this.componentes[0] instanceof Campo || EditorValorReferencia.this.componentes[0] instanceof ReguaReferencial || EditorValorReferencia.this.componentes[0] instanceof Expressao)) {
                    int tipo;
                    int alin;
                    String mascara = EditorValorReferencia.this.componentes[0] instanceof Campo ? ((Campo)EditorValorReferencia.this.componentes[0]).getMascara() : (EditorValorReferencia.this.componentes[0] instanceof Expressao ? ((Expressao)EditorValorReferencia.this.componentes[0]).getMascara() : ((ReguaReferencial)EditorValorReferencia.this.componentes[0]).getMascara());
                    int n = alin = EditorValorReferencia.this.componentes[0] instanceof Campo ? ((Campo)EditorValorReferencia.this.componentes[0]).getAlinhamentoHorizontal() : 4;
                    int n2 = EditorValorReferencia.this.componentes[0] instanceof Campo ? ((Campo)EditorValorReferencia.this.componentes[0]).getTipo() : (tipo = EditorValorReferencia.this.componentes[0] instanceof Expressao ? 1 : ((ReguaReferencial)EditorValorReferencia.this.componentes[0]).getTipo());
                    if (!Funcoes.textoVazio(mascara)) {
                        DialogoValorReferencia dvr = DialogoValorReferencia.novaInstancia(EditorValorReferencia.this.getTopLevelAncestor(), "Valores de refer\u00eancia", mascara, tipo);
                        if (dvr != null) {
                            dvr.setAlinhamentoHorizontal(alin);
                            dvr.setValores(EditorValorReferencia.this.valores);
                            dvr.setVisible(true);
                            if (dvr.ok()) {
                                EditorValorReferencia.this.valores = dvr.getValores();
                                EditorValorReferencia.this.rotulo.setText(EditorValorReferencia.this.valores.toString());
                                EditorValorReferencia.this.fireChangeListener();
                            }
                        }
                    } else {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "A m\u00e1scara deve ser configurada.", 1);
                    }
                }
            }
        });
    }

    @Override
    public Object getValor() {
        return this.valores;
    }

    @Override
    public Object getValorUsuario() {
        if (this.valores != null) {
            return this.valores.zero() ? "Zero" : this.valores.toString();
        }
        return "";
    }

    @Override
    public void setValor(Object valor) {
        if (valor instanceof ValoresReferencia) {
            this.valores = (ValoresReferencia)valor;
            this.rotulo.setText((String)this.getValorUsuario());
        }
    }

    public static class DialogoValorReferencia
    extends JDialog
    implements ActionListener,
    DisposeListener {
        JPanel panelArea = new JPanel(new FlowLayout(0, 3, 3));
        JPanel panelBarra = new JPanel(new FlowLayout(2, 3, 3));
        JLabel labelMinAbs = new JLabel("M\u00ednimo Absurdo");
        JLabel labelMinNor = new JLabel("M\u00ednimo Normal");
        JLabel labelMaxNor = new JLabel("M\u00e1ximo Normal");
        JLabel labelMaxAbs = new JLabel("M\u00e1ximo Absurdo");
        JTextField[] texts = new JTextField[4];
        DocumentoMascara[] docs = new DocumentoMascara[4];
        JButton buttonOk = new JButton("OK");
        JButton buttonCancelar = new JButton("Cancelar");
        ValoresReferencia valores;
        int tipo;
        String masc;
        boolean ok = false;

        public static DialogoValorReferencia novaInstancia(Object pai, String titulo, String masc, int tipo) {
            if (masc != null && masc.trim().length() > 0 && (tipo == 1 || tipo == 3)) {
                if (pai instanceof Frame) {
                    return new DialogoValorReferencia((Frame)pai, titulo, masc, tipo);
                }
                if (pai instanceof Dialog) {
                    return new DialogoValorReferencia((Dialog)pai, titulo, masc, tipo);
                }
            }
            return null;
        }

        public DialogoValorReferencia(Frame pai, String titulo, String masc, int tipo) {
            super(pai, titulo, true);
            if (pai instanceof Laboratorio) {
                ((Laboratorio)pai).addDisposeListener(this);
            }
            this.iniciar(tipo, masc);
            ScreenUtil.centralizar(this);
        }

        public DialogoValorReferencia(Dialog pai, String titulo, String masc, int tipo) {
            super(pai, titulo, true);
            this.iniciar(tipo, masc);
            ScreenUtil.centralizar(this);
        }

        public void setValores(ValoresReferencia valores) {
            this.valores = valores;
            String[] tmp = valores.getValores();
            this.docs[0].setValor(tmp[0]);
            this.docs[1].setValor(tmp[1]);
            this.docs[2].setValor(tmp[2]);
            this.docs[3].setValor(tmp[3]);
        }

        public ValoresReferencia getValores() {
            return this.valores;
        }

        public void setAlinhamentoHorizontal(int alin) {
            for (int i = 0; i < this.texts.length; ++i) {
                this.texts[i].setHorizontalAlignment(alin);
            }
        }

        public boolean ok() {
            return this.ok;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.buttonOk) {
                ValoresReferencia val = ValoresReferencia.novaInstancia(this.tipo, this.masc);
                if (val != null) {
                    val.setValores(new String[]{this.docs[0].getValor(), this.docs[1].getValor(), this.docs[2].getValor(), this.docs[3].getValor()});
                    if (this.validar(val)) {
                        this.valores = val;
                        this.ok = true;
                        this.dispose();
                    }
                }
            } else if (o == this.buttonCancelar) {
                this.dispose();
            }
        }

        private boolean validar(ValoresReferencia vlr) {
            if (vlr.zero()) {
                return true;
            }
            switch (vlr.validar()) {
                case 7: {
                    Funcoes.mensagem(this, "M\u00ednimo normal deve ser maior ou igual ao m\u00ednimo absurdo.", 1);
                    ScreenUtil.requisitarFoco(this.texts[1]);
                    return false;
                }
                case 8: {
                    Funcoes.mensagem(this, "M\u00e1ximo normal deve ser maior que o m\u00ednimo normal.", 1);
                    ScreenUtil.requisitarFoco(this.texts[2]);
                    return false;
                }
                case 9: {
                    Funcoes.mensagem(this, "M\u00e1ximo absurdo deve ser maior ou igual ao m\u00e1ximo normal.", 1);
                    ScreenUtil.requisitarFoco(this.texts[3]);
                    return false;
                }
            }
            return true;
        }

        private void iniciar(int tipo, String masc) {
            this.tipo = tipo;
            this.masc = masc;
            Funcoes.montaEnter(this.getContentPane() instanceof JComponent ? (JComponent)this.getContentPane() : null);
            this.setSize(new Dimension(510, 127));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.panelArea, "Center");
            this.getContentPane().add((Component)this.panelBarra, "South");
            Dimension dim = new Dimension(120, 22);
            this.panelArea.add(this.labelMinAbs);
            this.panelArea.add(this.labelMinNor);
            this.panelArea.add(this.labelMaxNor);
            this.panelArea.add(this.labelMaxAbs);
            for (int i = 0; i < this.texts.length; ++i) {
                this.texts[i] = new JTextField();
                this.texts[i].setPreferredSize(dim);
                this.docs[i] = new DocumentoMascara(this.texts[i], masc);
                this.texts[i].setDocument(this.docs[i]);
                this.panelArea.add(this.texts[i]);
            }
            this.panelBarra.setBorder(BorderFactory.createEtchedBorder());
            this.panelBarra.add(this.buttonOk);
            this.panelBarra.add(this.buttonCancelar);
            this.labelMinAbs.setPreferredSize(dim);
            this.labelMinAbs.setHorizontalAlignment(0);
            this.labelMinNor.setPreferredSize(dim);
            this.labelMinNor.setHorizontalAlignment(0);
            this.labelMaxNor.setPreferredSize(dim);
            this.labelMaxNor.setHorizontalAlignment(0);
            this.labelMaxAbs.setPreferredSize(dim);
            this.labelMaxAbs.setHorizontalAlignment(0);
            this.buttonOk.addActionListener(this);
            this.buttonOk.setMnemonic('O');
            this.buttonCancelar.addActionListener(this);
            this.buttonCancelar.setMnemonic('C');
        }
    }
}

