/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.componente.Historico;
import jalis.laboratorio.configurador.historicos.DialogoHistorico;
import jalis.laboratorio.configurador.propriedade.DocumentoStyledHistorico;
import jalis.laboratorio.configurador.propriedade.Editor;
import jalis.laboratorio.configurador.propriedade.EditorKitNoWrap;
import jalis.util.Funcoes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class EditorValorPadraoHistorico
extends Editor {
    private final int NEGRITO = 1;
    private final int ITALICO = 2;
    private final int SUBLINHADO = 4;
    private JTextPane text = new JTextPane();
    private JButton button = new JButton("...");
    private DocumentoStyledHistorico documento = new DocumentoStyledHistorico();

    public EditorValorPadraoHistorico() {
        this.add((Component)this.text, "Center");
        this.add((Component)this.button, "East");
        this.text.setEditorKit(new EditorKitNoWrap());
        this.text.setDocument(this.documento);
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    EditorValorPadraoHistorico.this.setValor(EditorValorPadraoHistorico.this.text.getText());
                    EditorValorPadraoHistorico.this.fireChangeListener();
                }
            }
        });
        this.button.setPreferredSize(new Dimension(20, 20));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoHistorico dh = DialogoHistorico.novaInstancia(EditorValorPadraoHistorico.this.getTopLevelAncestor());
                if (dh != null) {
                    dh.setHistoricos(EditorValorPadraoHistorico.this.getHistoricos());
                    dh.setVisible(true);
                    if (dh.ok()) {
                        EditorValorPadraoHistorico.this.text.setText(dh.getDescricaoSelecionado());
                        EditorValorPadraoHistorico.this.fireChangeListener();
                    }
                }
            }
        });
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null) {
            this.text.setText(valor.toString());
        }
    }

    @Override
    public Object getValor() {
        try {
            return this.descricao2Texto(this.text);
        }
        catch (Exception e) {
            return this.text.getText();
        }
    }

    @Override
    public Object getValorUsuario() {
        return this.text.getText();
    }

    private Map<String, String> getHistoricos() {
        HashMap<String, String> retorno = new HashMap<String, String>();
        if (this.pagina != null && this.componentes != null && this.componentes.length == 1 && this.componentes[0] instanceof Historico) {
            List<String> cod = ((Historico)this.componentes[0]).getHistoricos();
            if (cod.isEmpty()) {
                return this.pagina.getHistoricos().get("historicoporcodigo");
            }
            Map<String, String> tmp = this.pagina.getHistoricos().get("historicoporcodigo");
            for (String chave : cod) {
                retorno.put(chave, tmp.get(chave));
            }
        }
        return retorno;
    }

    private String descricao2Texto(JTextPane editor) throws IOException, BadLocationException {
        StyledDocument doc = editor.getStyledDocument();
        ElementIterator it = new ElementIterator(doc.getDefaultRootElement());
        it.current();
        Element next = null;
        StringBuilder bui = new StringBuilder();
        boolean aplicouEstilo = false;
        int estilos = 0;
        while ((next = it.next()) != null) {
            String tmp = doc.getText(next.getStartOffset(), next.getEndOffset() - next.getStartOffset());
            if (!next.isLeaf() || tmp.equals("\n")) continue;
            AttributeSet a = next.getAttributes();
            if (StyleConstants.isBold(a) && (estilos < 1 || estilos % 2 == 0)) {
                bui.append("<b>");
                ++estilos;
                aplicouEstilo = true;
            }
            if (StyleConstants.isItalic(a) && estilos != 2 && estilos != 3 && estilos != 6 && estilos != 7) {
                bui.append("<i>");
                estilos += 2;
                aplicouEstilo = true;
            }
            if (StyleConstants.isUnderline(a) && estilos < 4) {
                bui.append("<u>");
                estilos += 4;
                aplicouEstilo = true;
            }
            if (StyleConstants.isSubscript(a)) {
                bui.append("<sub>");
                aplicouEstilo = true;
            }
            if (StyleConstants.isSuperscript(a)) {
                bui.append("<sup>");
                aplicouEstilo = true;
            }
            bui.append(tmp.replace("\n", ""));
            estilos = this.validaFecharEstilo(a, estilos, bui);
        }
        if (aplicouEstilo) {
            estilos = this.validaFecharEstilo(null, estilos, bui);
            bui.insert(0, "<html>");
            bui.append("</html>");
        }
        return bui.toString();
    }

    private int validaFecharEstilo(AttributeSet a, int estilos, StringBuilder bui) {
        if (!(a != null && StyleConstants.isUnderline(a) || estilos < 4)) {
            bui.append("</u>");
            estilos -= 4;
        }
        if (!(a != null && StyleConstants.isItalic(a) || estilos != 2 && estilos != 3 && estilos != 6 && estilos != 7)) {
            bui.append("</i>");
            estilos -= 2;
        }
        if (!(a != null && StyleConstants.isBold(a) || estilos != 1 && estilos != 3 && estilos != 5 && estilos != 7)) {
            bui.append("</b>");
            --estilos;
        }
        if (!Funcoes.objectIsNull(a) && bui.toString().contains("<sub>")) {
            bui.append("</sub>");
        }
        if (!Funcoes.objectIsNull(a) && bui.toString().contains("<sup>")) {
            bui.append("</sup>");
        }
        return estilos;
    }
}

