/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.propriedade.EditorString;
import jalis.util.DocumentoLimite;
import jalis.util.DocumentoMascara;

public class EditorValorPadraoCampo
extends EditorString {
    @Override
    public void setValor(Object valor) {
        if (valor instanceof String) {
            if (this.text.getDocument() instanceof DocumentoMascara) {
                ((DocumentoMascara)this.text.getDocument()).setValor((String)valor);
            } else {
                this.text.setText((String)valor);
            }
        }
    }

    @Override
    public void setComponentes(Componente[] comps) {
        super.setComponentes(comps);
        if (comps != null && comps.length == 1 && comps[0] instanceof Campo) {
            Campo campo = (Campo)comps[0];
            String masc = campo.getMascara();
            if (masc != null && masc.length() > 0) {
                this.text.setDocument(new DocumentoMascara(this.text, masc));
            } else {
                switch (campo.getTipo()) {
                    case 1: {
                        this.text.setDocument(new DocumentoLimite(this.text, campo.getLimite(), "[0-9|,|.]+"));
                        break;
                    }
                    case 2: {
                        this.text.setDocument(new DocumentoLimite(this.text, campo.getLimite(), "[0-9|/]+"));
                        break;
                    }
                    case 3: {
                        this.text.setDocument(new DocumentoLimite(this.text, campo.getLimite(), "[0-9|:]+"));
                    }
                }
            }
        }
    }
}

