/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.componente.ResultadoAnterior;
import jalis.laboratorio.configurador.pagina.Pagina;
import jalis.laboratorio.configurador.propriedade.Editor;
import jalis.util.Funcoes;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class EditorTag
extends Editor {
    public static final String TAG_RESULTADO = "tagResultado";
    private JComboBox combo = new JComboBox();
    private ComponenteEditor componente = null;

    public EditorTag() {
        this.add((Component)this.combo, "Center");
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "ok" && EditorTag.this.validarValor(EditorTag.this.combo.getSelectedItem())) {
                    EditorTag.this.fireChangeListener();
                }
            }
        });
    }

    public void setComponente(ComponenteEditor componente) {
        this.componente = componente;
    }

    public static String getDescricaoTag() {
        return "tag resultado";
    }

    @Override
    public void setPagina(Pagina pagina) {
        String[] tags;
        super.setPagina(pagina);
        if (Funcoes.textoVazio(pagina.getTags())) {
            pagina.setTags("");
        }
        for (String s : tags = pagina.getTags().split(";")) {
            if (this.combo.getItemCount() == 0 && !Funcoes.textoVazio(s)) {
                this.combo.addItem("");
            }
            this.combo.addItem(s);
        }
    }

    @Override
    protected boolean validarValor(Object valor) {
        boolean isEmUso = this.pagina.getTagsEmUso().containsKey(valor.toString());
        ComponenteEditor componente = this.pagina.getTagsEmUso().get(valor.toString());
        if (!(!isEmUso || componente == this.componente || this.componente instanceof ResultadoAnterior || this.componente instanceof Grafico && ((Grafico)this.componente).getTipoGrafico() == 0)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A tag de resultado selecionada est\u00e1 em uso.\nSelecione outra tag de resultado.", 2);
            return false;
        }
        return true;
    }

    @Override
    public void setValor(Object valor) {
        this.combo.setActionCommand("cancelado");
        this.combo.setSelectedItem(this.combo.isEditable() || ((DefaultComboBoxModel)this.combo.getModel()).getIndexOf(valor) > -1 ? valor : null);
        this.combo.setActionCommand("ok");
    }

    @Override
    public Object getValor() {
        return this.combo.getSelectedItem();
    }

    @Override
    public Object getValorUsuario() {
        Object tmp = this.combo.getSelectedItem();
        return tmp == null ? "" : tmp.toString();
    }
}

