/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.propriedade.DialogoRotulos;
import jalis.laboratorio.configurador.propriedade.Editor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;

public class EditorRotulosGrafico
extends Editor {
    private JLabel rotulo = new JLabel();
    private JButton button = new JButton("...");
    private List<String> itens = new ArrayList<String>();

    public EditorRotulosGrafico() {
        this.add((Component)this.rotulo, "Center");
        this.add((Component)this.button, "East");
        this.button.setPreferredSize(new Dimension(20, 20));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoRotulos di = DialogoRotulos.novaInstancia(EditorRotulosGrafico.this.getTopLevelAncestor());
                if (di != null) {
                    di.setCampos(EditorRotulosGrafico.this.getCampos());
                    di.setItens(EditorRotulosGrafico.this.itens);
                    di.setVisible(true);
                    if (di.ok()) {
                        EditorRotulosGrafico.this.setValor(di.getItens());
                        EditorRotulosGrafico.this.fireChangeListener();
                    }
                }
            }
        });
    }

    @Override
    public void setValor(Object valor) {
        if (valor instanceof List) {
            this.itens = (List)valor;
        } else if (valor instanceof String[]) {
            this.itens.clear();
            for (String item : (String[])valor) {
                this.itens.add(item);
            }
        }
        this.rotulo.setText((String)this.getValorUsuario());
    }

    @Override
    public Object getValor() {
        return this.itens;
    }

    @Override
    public Object getValorUsuario() {
        if (this.itens.isEmpty()) {
            return "Vazio";
        }
        StringBuilder bui = new StringBuilder(this.itens.get(0));
        for (int i = 1; i < this.itens.size(); ++i) {
            bui.append(", ").append(this.itens.get(i));
        }
        return bui.toString();
    }

    private List<String> getCampos() {
        if (this.componentes.length == 1 && this.componentes[0] instanceof Grafico) {
            return ((Grafico)this.componentes[0]).getCampos();
        }
        return null;
    }
}

