/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.propriedade.DialogoLinhasFixas;
import jalis.laboratorio.configurador.propriedade.Editor;
import jalis.laboratorio.configurador.propriedade.ObjetoLinhaFixa;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;

public class EditorLinhasFixas
extends Editor {
    private JLabel rotulo = new JLabel();
    private JButton button = new JButton("...");
    private List<String> itens = new ArrayList<String>();

    public EditorLinhasFixas() {
        this.add((Component)this.rotulo, "Center");
        this.add((Component)this.button, "East");
        this.button.setPreferredSize(new Dimension(20, 20));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoLinhasFixas di = DialogoLinhasFixas.novaInstancia(EditorLinhasFixas.this.getTopLevelAncestor());
                if (di != null) {
                    di.setRotulos(EditorLinhasFixas.this.getRotulos());
                    di.setItens(EditorLinhasFixas.this.itens);
                    di.setVisible(true);
                    if (di.ok()) {
                        EditorLinhasFixas.this.setValor(di.getItens());
                        EditorLinhasFixas.this.fireChangeListener();
                    }
                }
            }
        });
    }

    @Override
    public void setValor(Object valor) {
        this.itens.clear();
        if (valor instanceof List) {
            for (Object o : (ArrayList)valor) {
                String xml;
                ObjetoLinhaFixa ob;
                if (!(o instanceof String) || (ob = ObjetoLinhaFixa.newFromXML(xml = o.toString())) == null) continue;
                this.itens.add(xml);
            }
        }
        this.rotulo.setText((String)this.getValorUsuario());
    }

    @Override
    public Object getValor() {
        return this.itens;
    }

    @Override
    public Object getValorUsuario() {
        if (this.itens.isEmpty()) {
            return "Vazio";
        }
        StringBuilder bui = new StringBuilder(ObjetoLinhaFixa.newFromXML(this.itens.get(0)).getTitulo());
        for (int i = 1; i < this.itens.size(); ++i) {
            bui.append(", ").append(ObjetoLinhaFixa.newFromXML(this.itens.get(i)).getTitulo());
        }
        return bui.toString();
    }

    private List<String> getRotulos() {
        if (this.componentes.length == 1 && this.componentes[0] instanceof Grafico) {
            return ((Grafico)this.componentes[0]).getRotulos();
        }
        return null;
    }
}

