/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.propriedade.Editor;
import jalis.util.ImagemUtils;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.apache.commons.codec.binary.Base64;

public class EditorImagem
extends Editor {
    private JLabel label = new JLabel();
    private JButton button = new JButton("...");
    private ImageIcon imagem = null;

    public EditorImagem() {
        this.add((Component)this.label, "Center");
        this.add((Component)this.button, "East");
        this.button.setPreferredSize(new Dimension(20, 20));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = ComponenteFactory.novoJFileChooser();
                fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                if (fc.showOpenDialog(EditorImagem.this.getTopLevelAncestor()) == 0) {
                    byte[] img = ImagemUtils.carregarImagem(fc.getSelectedFile().getPath());
                    EditorImagem.this.imagem = new ImageIcon(img);
                    EditorImagem.this.label.setText("Imagem");
                    EditorImagem.this.fireChangeListener();
                }
            }
        });
    }

    @Override
    public void setValor(Object valor) {
        if (valor instanceof String && ((String)valor).length() > 0) {
            try {
                this.imagem = new ImageIcon(new Base64().decode((String)valor));
                this.label.setText("Imagem");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "EditorImagem: 54");
            }
        } else {
            this.imagem = null;
        }
    }

    @Override
    public Object getValor() {
        return this.imagem != null ? ImagemUtils.converterImagemParaBase64(this.imagem.getImage()) : "";
    }

    @Override
    public Object getValorUsuario() {
        return this.imagem == null ? "" : this.label.getText();
    }
}

