/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.configurador.AtributosReguaMedia;
import jalis.laboratorio.configurador.AtributosReguaMediaCores;
import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.propriedade.Editor;
import jalis.util.CorComboBox;
import jalis.util.DialogoCor;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ReguaMediaColumnRender;
import jalis.util.ScreenUtil;
import jalis.util.StrokeComboBoxRenderer;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class EditorAtributosReguaMedia
extends Editor {
    private JLabel label = new JLabel("[ ]");
    private JButton button = new JButton("...");
    private AtributosReguaMedia atributos;

    public EditorAtributosReguaMedia() {
        this.add((Component)this.label, "Center");
        this.add((Component)this.button, "East");
        this.button.setPreferredSize(new Dimension(20, 20));
        this.button.addActionListener(action -> {
            DialogoAtributos da = DialogoAtributos.novaInstancia(this.getTopLevelAncestor());
            da.setAtributos(this.atributos);
            if (da != null) {
                da.setVisible(true);
                if (da.ok()) {
                    this.atributos = da.getAtributos();
                    this.fireChangeListener();
                }
            }
        });
    }

    @Override
    public void setValor(Object valor) {
        if (valor instanceof AtributosReguaMedia) {
            this.atributos = (AtributosReguaMedia)valor;
        }
    }

    @Override
    public Object getValor() {
        return this.atributos;
    }

    @Override
    public Object getValorUsuario() {
        return this.label.getText();
    }

    private static class DialogoAtributos
    extends JDialog
    implements ActionListener,
    DisposeListener {
        private JComboBox comboTipoPreenchimento = new JComboBox<String>(new String[]{"Degrad\u00ea", "Fixo"});
        private JComboBox comboLinha = new JComboBox<Object>(new Object[]{Constantes.SOLIDO, Constantes.TRACEJADO, Constantes.PONTILHADO});
        private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
        private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
        private int selecao = -1;
        private JButton buttonCorDegrade = ComponenteFactory.novoJButton("...", '\u0000', this, null, new Dimension(20, 20));
        private JButton buttonCorOkDegrade = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
        private JButton buttonCor = ComponenteFactory.novoJButton("...", '\u0000', this, null, new Dimension(20, 20));
        private JButton buttonCorOkFixa = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
        private JPanel painelConfiguracao = new JPanel(new GridBagLayout());
        private JPanel aux1 = new JPanel(new BorderLayout());
        private CorComboBox comboCorMedia = new CorComboBox();
        private JPanel painelCores = new JPanel(new GridBagLayout());
        private JTable tableCoresDegrade = new JTable();
        private ModeloGridTable modeloCoresDegrade = new ModeloGridTable(new String[]{"Cor", "Nome da cor"});
        private CorComboBox comboCorDegrede = new CorComboBox();
        private JPanel auxCamposCoresDegrade = new JPanel(new GridBagLayout());
        private ModeloGridTable modeloCoresFixo = new ModeloGridTable(new String[]{"Posi\u00e7\u00e3o", "", "Cor", "Valor inicial", "Valor final"});
        private JTable tableCoresFixo = new JTable();
        private CorComboBox comboCorFixo = new CorComboBox();
        private JLabel labelPosicao = new JLabel("Posi\u00e7\u00e3o");
        private JLabel labelCor = new JLabel("Cor");
        private JLabel labelValorInicial = new JLabel("Valor inicial");
        private JLabel labelValorFinal = new JLabel("Valor final");
        private TTextField textPosicao = new TTextField(3, 1);
        private TTextField textValorInicial = new TTextField(8, 2, 4);
        private TTextField textValorFinal = new TTextField(8, 2, 4);
        private JPanel auxCamposCoresFixo = new JPanel(new GridBagLayout());
        private JScrollPane scrollpaneDegrade = new JScrollPane(this.tableCoresDegrade);
        private JScrollPane scrollpaneFixo = new JScrollPane(this.tableCoresFixo);
        private TTextField textMinimo = new TTextField(8, 2, 4);
        private TTextField textMaximo = new TTextField(8, 2, 4);
        private TTextField textLargura = new TTextField(4, 1);
        private int posicaoMax;
        private boolean ok;
        private String valorMinimo;
        private String valorMaximo;
        private boolean validandoValor;

        public static DialogoAtributos novaInstancia(Object pai) {
            if (pai instanceof Dialog) {
                return new DialogoAtributos((Dialog)pai);
            }
            if (pai instanceof Frame) {
                return new DialogoAtributos((Frame)pai);
            }
            return null;
        }

        public DialogoAtributos(Frame pai) {
            super(pai, "Atributos", true);
            this.iniciar();
        }

        public DialogoAtributos(Dialog pai) {
            super(pai, "Atributos", true);
            this.iniciar();
        }

        public void setAtributos(AtributosReguaMedia atributos) {
            if (atributos != null) {
                this.comboCorMedia.setCorSelecionada(atributos.getCorMedia());
                this.textLargura.setText(String.valueOf(atributos.getLarguraMedia()));
                this.textMaximo.setText(atributos.getMaximo() != null ? atributos.getMaximo().toString().replace(".", ",") : "0,0000");
                this.textMinimo.setText(atributos.getMinimo() != null ? atributos.getMinimo().toString().replace(".", ",") : "0,0000");
                this.valorMinimo = this.textMinimo.getText();
                this.valorMaximo = this.textMaximo.getText();
                if (!Funcoes.textoVazio(atributos.getTipoPreenchimento()) && atributos.getTipoPreenchimento().equalsIgnoreCase("Fixo")) {
                    this.comboTipoPreenchimento.setSelectedItem("Fixo");
                    atributos.getAtributosReguas().forEach(a -> {
                        this.modeloCoresFixo.addLine(new Object[]{a.getPosicao(), a.getCor(), a.getNome(), a.getValorInicial(), a.getValorFinal()});
                        this.tableCoresFixo.getColumnModel().getColumn(1).setCellRenderer(new ReguaMediaColumnRender());
                        this.textPosicao.setText(null);
                        this.posicaoMax = a.getPosicao() + 1;
                    });
                } else {
                    this.comboTipoPreenchimento.setSelectedItem("Degrad\u00ea");
                    atributos.getAtributosReguas().forEach(a -> {
                        this.modeloCoresDegrade.addLine(new Object[]{a.getCor(), a.getNome()});
                        this.tableCoresDegrade.getColumnModel().getColumn(0).setCellRenderer(new ReguaMediaColumnRender());
                    });
                }
            }
        }

        public AtributosReguaMedia getAtributos() {
            ArrayList<AtributosReguaMediaCores> atributosReguas = new ArrayList<AtributosReguaMediaCores>();
            int rowCount = this.comboTipoPreenchimento.getSelectedItem().toString().equalsIgnoreCase("Fixo") ? this.modeloCoresFixo.getRowCount() : this.modeloCoresDegrade.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                AtributosReguaMediaCores regua;
                if (this.comboTipoPreenchimento.getSelectedItem().toString().equalsIgnoreCase("Fixo")) {
                    regua = new AtributosReguaMediaCores(Constantes.SOLIDO, (Color)this.modeloCoresFixo.getValueAt(i, 1));
                    regua.setPosicao(Integer.valueOf(String.valueOf(this.modeloCoresFixo.getValueAt(i, 0))));
                    regua.setNome(String.valueOf(this.modeloCoresFixo.getValueAt(i, 2)));
                    regua.setValorInicial(String.valueOf(this.modeloCoresFixo.getValueAt(i, 3)));
                    regua.setValorFinal(String.valueOf(this.modeloCoresFixo.getValueAt(i, 4)));
                } else {
                    regua = new AtributosReguaMediaCores(Constantes.SOLIDO, (Color)this.modeloCoresDegrade.getValueAt(i, 0));
                    regua.setNome((String)this.modeloCoresDegrade.getValueAt(i, 1));
                }
                atributosReguas.add(regua);
            }
            return new AtributosReguaMedia(new BigDecimal(this.textMinimo.getText()).setScale(4), new BigDecimal(this.textMaximo.getText()).setScale(4), Integer.valueOf(this.textLargura.getText()), this.comboCorMedia.getCorSelecionada(), atributosReguas, this.comboTipoPreenchimento.getSelectedItem().toString());
        }

        public boolean ok() {
            return this.ok;
        }

        private boolean validaCampos() {
            if (this.textMinimo.getText().isEmpty() || this.textMaximo.getText().isEmpty()) {
                Funcoes.mensagem(null, "Os valores m\u00ednimo e m\u00e1ximo n\u00e3o podem ser vazios.", 2);
                return false;
            }
            if (new Float(this.textMinimo.getText()).equals(new Float(this.textMaximo.getText()))) {
                Funcoes.mensagem(null, "Os valores m\u00ednimo e m\u00e1ximo n\u00e3o podem ser iguais.", 2);
                return false;
            }
            if (this.textMinimo.getText().contains("-") || this.textMaximo.getText().contains("-")) {
                Funcoes.mensagem(null, "Os valores m\u00ednimo e m\u00e1ximo n\u00e3o podem ser negativos.", 2);
                return false;
            }
            if (this.textLargura.getText().isEmpty() || Integer.valueOf(this.textLargura.getText()) == 0) {
                Funcoes.mensagem(null, "Largura do cursor inv\u00e1lida.", 2);
                return false;
            }
            if (this.comboTipoPreenchimento.getSelectedItem().equals("Fixo") && this.modeloCoresFixo.getRowCount() < 1 || this.comboTipoPreenchimento.getSelectedItem().equals("Degrad\u00ea") && this.modeloCoresDegrade.getRowCount() < 1 || this.textMinimo.getText().isEmpty() || this.textMaximo.getText().isEmpty() || this.textLargura.getText().isEmpty()) {
                Funcoes.mensagem(null, "Todas informa\u00e7\u00f5es devem estar preenchidas.", 2);
                return false;
            }
            if (Float.valueOf(this.textMaximo.getText()).floatValue() < Float.valueOf(this.textMinimo.getText()).floatValue()) {
                Funcoes.mensagem(null, "O valor m\u00e1ximo n\u00e3o pode ser menor que o m\u00ednimo.", 2);
                return false;
            }
            if (this.comboTipoPreenchimento.getSelectedItem().equals("Fixo") && this.modeloCoresFixo.getRowCount() < 2 || this.comboTipoPreenchimento.getSelectedItem().equals("Degrad\u00ea") && this.modeloCoresDegrade.getRowCount() < 2) {
                Funcoes.mensagem(null, "Para utiliza\u00e7\u00e3o da r\u00e9gua m\u00e9dia \u00e9 necess\u00e1rio no m\u00ednimo duas cores.", 2);
                return false;
            }
            return this.validaValorMaximoMinimo();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.buttonOk || o == this.buttonCancelar) {
                boolean bl = this.ok = o == this.buttonOk;
                if (this.ok) {
                    if (this.validandoValor || !this.validaCampos()) {
                        return;
                    }
                    this.dispose();
                } else {
                    this.dispose();
                }
            } else if (o == this.buttonCorDegrade) {
                DialogoCor dc = DialogoCor.novaInstancia(this, "Configura\u00e7\u00e3o de Cor");
                if (dc != null) {
                    dc.setCor(this.comboCorDegrede.getCorSelecionada());
                    dc.setVisible(true);
                    if (dc.ok()) {
                        this.comboCorDegrede.setCorPersonalizada(dc.getCor());
                        this.comboCorDegrede.setCorSelecionada(dc.getCor());
                    }
                }
            } else if (o == this.buttonCor) {
                DialogoCor dc = DialogoCor.novaInstancia(this, "Configura\u00e7\u00e3o de Cor");
                if (dc != null) {
                    dc.setCor(this.comboCorFixo.getCorSelecionada());
                    dc.setVisible(true);
                    if (dc.ok()) {
                        this.comboCorFixo.setCorPersonalizada(dc.getCor());
                        this.comboCorFixo.setCorSelecionada(dc.getCor());
                    }
                }
            } else if (o == this.buttonCorOkDegrade) {
                if (this.selecao >= 0) {
                    this.modeloCoresDegrade.setValueAt(this.comboCorDegrede.getCorSelecionada(), this.tableCoresDegrade.getSelectedRow(), 0);
                    this.modeloCoresDegrade.setValueAt(this.comboCorDegrede.getNomeCorSelecionada(), this.tableCoresDegrade.getSelectedRow(), 1);
                    this.selecao = -1;
                } else {
                    this.modeloCoresDegrade.addLine(new Object[]{this.comboCorDegrede.getCorSelecionada(), this.comboCorDegrede.getNomeCorSelecionada()});
                }
                this.tableCoresDegrade.getColumnModel().getColumn(0).setCellRenderer(new ReguaMediaColumnRender());
            } else if (o == this.buttonCorOkFixa && !this.validandoValor && this.validarInserirCampoCor()) {
                if (this.selecao >= 0 && this.tableCoresFixo.getSelectedRow() >= 0) {
                    this.modeloCoresFixo.setValueAt(this.textPosicao.getText(), this.selecao, 0);
                    this.modeloCoresFixo.setValueAt(this.comboCorFixo.getCorSelecionada(), this.selecao, 1);
                    this.modeloCoresFixo.setValueAt(this.comboCorFixo.getNomeCorSelecionada(), this.selecao, 2);
                    this.modeloCoresFixo.setValueAt(this.textValorInicial.getText().replace(".", ","), this.selecao, 3);
                    this.modeloCoresFixo.setValueAt(this.textValorFinal.getText().replace(".", ","), this.selecao, 4);
                    this.selecao = -1;
                } else if (this.textPosicao.getText().isEmpty()) {
                    if (this.posicaoMax <= 0) {
                        this.posicaoMax = 1;
                    }
                    this.modeloCoresFixo.addLine(new Object[]{this.posicaoMax, this.comboCorFixo.getCorSelecionada(), this.comboCorFixo.getNomeCorSelecionada(), this.textValorInicial.getText().replace(".", ","), this.textValorFinal.getText().replace(".", ",")});
                    ++this.posicaoMax;
                }
                this.textPosicao.setText(null);
                this.textValorInicial.setText(null);
                this.textValorFinal.setText(null);
                this.tableCoresFixo.getColumnModel().getColumn(1).setCellRenderer(new ReguaMediaColumnRender());
                this.valorMinimo = this.textMinimo.getText();
                this.valorMaximo = this.textMaximo.getText();
                this.comboTipoPreenchimento.setEnabled(true);
            }
        }

        private boolean validarInserirCampoCor() {
            String valorFinal;
            String valorInicial;
            Boolean retorno;
            block11: {
                block10: {
                    retorno = true;
                    valorInicial = this.textValorInicial.getText();
                    valorFinal = this.textValorFinal.getText();
                    if (valorInicial.isEmpty() && valorFinal.isEmpty()) {
                        Funcoes.mensagem(null, "Os valores inicial e final n\u00e3o podem ser vazios.", 2);
                        return false;
                    }
                    if (valorInicial.isEmpty()) {
                        Funcoes.mensagem(null, "O valor inicial n\u00e3o foi informado.", 2);
                        return false;
                    }
                    if (valorFinal.isEmpty()) {
                        Funcoes.mensagem(null, "O valor final n\u00e3o foi informado.", 2);
                        return false;
                    }
                    if (this.textMinimo.getText().isEmpty() || this.textMaximo.getText().isEmpty()) {
                        Funcoes.mensagem(null, "Os valores m\u00ednimo e m\u00e1ximo devem estar preenchidos.", 2);
                        return false;
                    }
                    if (new Float(valorInicial).equals(new Float(valorFinal))) {
                        Funcoes.mensagem(null, "Os valores m\u00ednimo e m\u00e1ximo n\u00e3o podem ser iguais.", 2);
                        return false;
                    }
                    if (valorInicial.contains("-") || valorFinal.contains("-")) {
                        Funcoes.mensagem(null, "Os valores m\u00ednimo e m\u00e1ximo n\u00e3o podem ser negativos.", 2);
                        return false;
                    }
                    if (Float.valueOf(valorFinal).floatValue() < Float.valueOf(valorInicial).floatValue()) {
                        Funcoes.mensagem(null, "Valor inicial maior que valor final.", 2);
                        return false;
                    }
                    if (new Float(valorInicial).floatValue() < new Float(this.textMinimo.getText()).floatValue()) break block10;
                    Float f = new Float(valorFinal);
                    Float f2 = new Float(this.textMaximo.getText());
                    if (!(f.floatValue() > f2.floatValue())) break block11;
                }
                Funcoes.mensagem(null, "Valores inicial e final devem estar entre os valores m\u00ednimo e m\u00e1ximo.", 2);
                return false;
            }
            retorno = this.validaCamposTabelaFixo(valorInicial, valorFinal);
            return retorno;
        }

        private Boolean validaCamposTabelaFixo(String valorInicial, String valorFinal) {
            for (int i = 0; i < this.modeloCoresFixo.getRowCount(); ++i) {
                String inicio = String.valueOf(this.modeloCoresFixo.getValueAt(i, 3)).replace(".", "").replace(",", ".");
                String fim = String.valueOf(this.modeloCoresFixo.getValueAt(i, 4)).replace(".", "").replace(",", ".");
                BigDecimal valorInicialLinha = new BigDecimal(inicio).setScale(4);
                BigDecimal valorFinalLinha = new BigDecimal(fim).setScale(4);
                boolean isValorInicialLinhaBetween = this.isBetween(valorInicialLinha, new BigDecimal(valorInicial), new BigDecimal(valorFinal));
                boolean isValorFinalLinhaBetween = this.isBetween(valorFinalLinha, new BigDecimal(valorInicial), new BigDecimal(valorFinal));
                boolean isValorInicialBetween = this.isBetween(new BigDecimal(valorInicial), valorInicialLinha, valorFinalLinha);
                boolean isValorFinalBetween = this.isBetween(new BigDecimal(valorFinal), valorInicialLinha, valorFinalLinha);
                String posicaoLinha = String.valueOf(this.modeloCoresFixo.getValueAt(i, 0));
                if ((this.textPosicao.getText().isEmpty() || !Integer.valueOf(posicaoLinha).equals(Integer.valueOf(this.textPosicao.getText()))) && (isValorInicialLinhaBetween || isValorFinalLinhaBetween || isValorInicialBetween || isValorFinalBetween)) {
                    Funcoes.mensagem(null, "Valor j\u00e1 cadastrado na posi\u00e7\u00e3o " + this.modeloCoresFixo.getValueAt(i, 0), 2);
                    return false;
                }
                if (!this.textPosicao.getText().isEmpty() && Integer.valueOf(posicaoLinha).equals(Integer.valueOf(this.textPosicao.getText()) + 1) && new BigDecimal(valorFinal).compareTo(valorInicialLinha) >= 0) {
                    Funcoes.mensagem(null, "Valor final \u00e9 maior que o valor inicial inserido na pr\u00f3xima posi\u00e7\u00e3o", 2);
                    return false;
                }
                if (!this.textPosicao.getText().isEmpty() && Integer.valueOf(posicaoLinha).equals(Integer.valueOf(this.textPosicao.getText()) - 1) && new BigDecimal(valorInicial).compareTo(valorFinalLinha) <= 0) {
                    Funcoes.mensagem(null, "Valor inicial \u00e9 menor que o valor final inserido na posi\u00e7\u00e3o anterior", 2);
                    return false;
                }
                if (i != this.modeloCoresFixo.getRowCount() - 1 || !this.textPosicao.getText().isEmpty() || new BigDecimal(valorInicial).compareTo(valorFinalLinha) > 0) continue;
                Funcoes.mensagem(null, "Valor inicial \u00e9 menor que o \u00faltimo valor inserido", 2);
                return false;
            }
            return true;
        }

        private boolean validaValorMaximoMinimo() {
            if (this.comboTipoPreenchimento.getSelectedItem().equals("Fixo")) {
                String valorMinimoModelo = String.valueOf(this.modeloCoresFixo.getValueAt(0, 3)).replace(".", "").replace(",", ".");
                String valorMaximoModelo = String.valueOf(this.modeloCoresFixo.getValueAt(this.modeloCoresFixo.getRowCount() - 1, 4)).replace(".", "").replace(",", ".");
                if (new BigDecimal(valorMinimoModelo).compareTo(new BigDecimal(this.textMinimo.getText())) < 0) {
                    Funcoes.mensagem(null, "Valor minimo \u00e9 maior que o primeiro valor inicial inserido", 2);
                    return false;
                }
                if (new BigDecimal(valorMaximoModelo).compareTo(new BigDecimal(this.textMaximo.getText())) > 0) {
                    Funcoes.mensagem(null, "Valor M\u00e1ximo \u00e9 menor que o \u00faltimo valor final inserido", 2);
                    return false;
                }
            }
            return true;
        }

        boolean isBetween(BigDecimal value, BigDecimal min, BigDecimal max) {
            return value.compareTo(min) >= 0 && value.compareTo(max) <= 0;
        }

        private void iniciar() {
            this.setDefaultCloseOperation(0);
            this.setPreferredSize(new Dimension(490, 480));
            this.setSize(new Dimension(490, 480));
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.fill = 0;
            cons1.insets = new Insets(3, 1, 3, 1);
            cons1.anchor = 11;
            cons1.gridx = 0;
            cons1.gridy = 0;
            cons1.weightx = 0.0;
            cons1.weighty = 0.5;
            JPanel painelCursorMedia = new JPanel(new GridBagLayout());
            this.configurePainelCursorMedia(painelCursorMedia);
            JPanel painelInfoValor = new JPanel(new GridBagLayout());
            painelInfoValor.setSize(new Dimension(230, 70));
            painelInfoValor.setPreferredSize(new Dimension(230, 70));
            painelInfoValor.setMinimumSize(new Dimension(230, 70));
            painelInfoValor.setBorder(new TitledBorder("Valores"));
            this.configureInfoValor(painelInfoValor);
            cons1.gridy = 0;
            cons1.gridx = 2;
            JPanel painelInfo = new JPanel(new GridBagLayout());
            painelInfo.setSize(new Dimension(470, 70));
            painelInfo.setPreferredSize(new Dimension(470, 70));
            painelInfo.setMinimumSize(new Dimension(470, 70));
            cons1.gridx = 0;
            cons1.gridy = 0;
            cons1.gridwidth = 1;
            cons1.gridheight = 1;
            cons1.weightx = 0.0;
            cons1.weighty = 1.0;
            painelInfo.add((Component)painelInfoValor, cons1);
            cons1.gridx = 1;
            cons1.gridy = 0;
            painelInfo.add((Component)painelCursorMedia, cons1);
            cons1.gridy = 1;
            this.scrollpaneDegrade.setSize(new Dimension(470, 220));
            this.scrollpaneDegrade.setPreferredSize(new Dimension(470, 220));
            this.scrollpaneDegrade.setMinimumSize(new Dimension(470, 220));
            this.painelCores.add(this.add(this.scrollpaneDegrade), cons1);
            cons1.gridy = 2;
            this.scrollpaneFixo.setSize(new Dimension(470, 230));
            this.scrollpaneFixo.setPreferredSize(new Dimension(470, 230));
            this.scrollpaneFixo.setMinimumSize(new Dimension(470, 230));
            this.painelCores.add(this.add(this.scrollpaneFixo), cons1);
            this.scrollpaneFixo.setVisible(false);
            JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
            this.setTitle("Configura\u00e7\u00e3o da r\u00e9gua");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)panel, "South");
            panel.add(this.buttonOk);
            panel.add(this.buttonCancelar);
            panel = new JPanel(new GridBagLayout());
            this.getContentPane().add((Component)panel, "North");
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 0;
            cons.gridx = 0;
            cons.gridy = 0;
            panel.add((Component)painelInfo, cons);
            this.configurePainelConfiguracao();
            cons.gridy = 1;
            panel.add((Component)this.painelConfiguracao, cons);
            this.configurePainelCoresDegrade();
            cons.gridy = 2;
            panel.add((Component)this.painelCores, cons);
            this.comboTipoPreenchimento.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (comboTipoPreenchimento.getSelectedItem().toString().equalsIgnoreCase("Degrad\u00ea")) {
                        auxCamposCoresDegrade.setVisible(true);
                        scrollpaneDegrade.setVisible(true);
                        scrollpaneFixo.setVisible(false);
                        auxCamposCoresFixo.setVisible(false);
                    } else {
                        auxCamposCoresDegrade.setVisible(false);
                        auxCamposCoresFixo.setVisible(true);
                        scrollpaneDegrade.setVisible(false);
                        scrollpaneFixo.setVisible(true);
                    }
                }
            });
            this.pack();
            ScreenUtil.centralizar(this);
        }

        private void configureInfoValor(JPanel painelInfoValor) {
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.fill = 0;
            cons1.anchor = 17;
            cons1.gridx = 0;
            cons1.gridy = 0;
            cons1.weightx = 0.0;
            cons1.weighty = 0.0;
            painelInfoValor.add((Component)ComponenteFactory.novoJLabel("M\u00ednimo: ", new Dimension(200, 20)), cons1);
            cons1.gridx = 1;
            cons1.weightx = 1.0;
            cons1.anchor = 13;
            Dimension dimensaoPadrao = new Dimension(95, 20);
            this.textMinimo.setPreferredSize(dimensaoPadrao);
            this.textMinimo.setSize(dimensaoPadrao);
            this.textMinimo.setMinimumSize(dimensaoPadrao);
            painelInfoValor.add((Component)this.textMinimo, cons1);
            cons1.gridx = 0;
            cons1.gridy = 1;
            cons1.anchor = 17;
            painelInfoValor.add((Component)ComponenteFactory.novoJLabel("M\u00e1ximo: ", new Dimension(200, 20)), cons1);
            cons1.gridx = 1;
            cons1.anchor = 13;
            this.textMaximo.setPreferredSize(dimensaoPadrao);
            this.textMaximo.setSize(dimensaoPadrao);
            this.textMaximo.setMinimumSize(dimensaoPadrao);
            painelInfoValor.add((Component)this.textMaximo, cons1);
        }

        private void configurePainelCursorMedia(JPanel painelCursorMedia) {
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.fill = 0;
            cons1.anchor = 17;
            painelCursorMedia.setSize(new Dimension(230, 70));
            painelCursorMedia.setPreferredSize(new Dimension(230, 70));
            painelCursorMedia.setMinimumSize(new Dimension(230, 70));
            painelCursorMedia.setBorder(new TitledBorder("Cursor de m\u00e9dia"));
            painelCursorMedia.add((Component)ComponenteFactory.novoJLabel("Largura: ", new Dimension(180, 20)), cons1);
            cons1.gridx = 1;
            cons1.weightx = 0.5;
            cons1.anchor = 13;
            this.textLargura.setPreferredSize(new Dimension(110, 20));
            this.textLargura.setSize(new Dimension(110, 20));
            this.textLargura.setMinimumSize(new Dimension(110, 20));
            painelCursorMedia.add((Component)this.textLargura, cons1);
            cons1.gridx = 0;
            cons1.gridy = 1;
            cons1.weightx = 0.0;
            cons1.weighty = 0.5;
            cons1.anchor = 17;
            painelCursorMedia.add((Component)ComponenteFactory.novoJLabel("Cor: ", new Dimension(130, 20)), cons1);
            cons1.gridx = 1;
            cons1.weightx = 0.5;
            cons1.anchor = 13;
            this.comboLinha.setRenderer(new StrokeComboBoxRenderer());
            this.comboCorMedia.setPreferredSize(new Dimension(110, 20));
            this.comboCorMedia.setSize(new Dimension(110, 20));
            this.comboCorMedia.setMinimumSize(new Dimension(110, 20));
            this.comboCorMedia.setCorSelecionada(Color.black);
            painelCursorMedia.add((Component)this.comboCorMedia, cons1);
        }

        private void configurePainelCoresDegrade() {
            this.aux1.add((Component)this.buttonCor, "Center");
            this.aux1.add((Component)this.buttonCorOkFixa, "East");
            this.painelCores.setBorder(new TitledBorder("Cores"));
            this.painelCores.setSize(new Dimension(460, 280));
            this.painelCores.setPreferredSize(new Dimension(460, 280));
            this.painelCores.setMinimumSize(new Dimension(460, 280));
            this.auxCamposCoresDegrade.setSize(new Dimension(450, 25));
            this.auxCamposCoresDegrade.setPreferredSize(new Dimension(450, 25));
            this.auxCamposCoresDegrade.setMinimumSize(new Dimension(450, 25));
            this.auxCamposCoresFixo.setSize(new Dimension(450, 70));
            this.auxCamposCoresFixo.setPreferredSize(new Dimension(450, 70));
            this.auxCamposCoresFixo.setMinimumSize(new Dimension(450, 70));
            this.configurarCampoCoresDegrade();
            this.configurarCampoCoresFixo();
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.fill = 11;
            cons1.anchor = 11;
            cons1.insets = new Insets(3, 1, 3, 1);
            cons1.gridx = 0;
            cons1.gridy = 0;
            cons1.gridwidth = 0;
            cons1.gridheight = 1;
            cons1.weighty = 1.0;
            cons1.weightx = 0.5;
            this.painelCores.add((Component)this.auxCamposCoresDegrade, cons1);
            this.painelCores.add((Component)this.auxCamposCoresFixo, cons1);
            this.auxCamposCoresFixo.setVisible(false);
        }

        private void configurarCampoCoresFixo() {
            this.tableCoresFixo.setModel(this.modeloCoresFixo);
            this.modeloCoresFixo.setColumnSize(new int[]{60, 30, 0, 70, 70}, this.tableCoresFixo);
            this.configurarListeners();
            this.buttonCorOkFixa.setPreferredSize(new Dimension(35, 20));
            this.buttonCorOkFixa.setSize(new Dimension(35, 20));
            this.buttonCorOkFixa.setMinimumSize(new Dimension(35, 20));
            this.buttonCor.setPreferredSize(new Dimension(23, 20));
            this.buttonCor.setSize(new Dimension(23, 20));
            this.buttonCor.setMinimumSize(new Dimension(23, 20));
            this.comboCorFixo.setPreferredSize(new Dimension(180, 20));
            this.comboCorFixo.setSize(new Dimension(180, 20));
            this.comboCorFixo.setMinimumSize(new Dimension(180, 20));
            this.textPosicao.setPreferredSize(new Dimension(50, 20));
            this.textPosicao.setSize(new Dimension(50, 20));
            this.textPosicao.setMinimumSize(new Dimension(50, 20));
            this.textValorInicial.setPreferredSize(new Dimension(80, 20));
            this.textValorInicial.setSize(new Dimension(80, 20));
            this.textValorInicial.setMinimumSize(new Dimension(80, 20));
            this.textValorFinal.setPreferredSize(new Dimension(80, 20));
            this.textValorFinal.setSize(new Dimension(80, 20));
            this.textValorFinal.setMinimumSize(new Dimension(80, 20));
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 17;
            cons.gridx = 0;
            cons.gridy = 0;
            this.auxCamposCoresFixo.add((Component)this.labelPosicao, cons);
            cons.gridx = 1;
            this.auxCamposCoresFixo.add((Component)this.labelCor, cons);
            cons.gridx = 3;
            this.auxCamposCoresFixo.add((Component)this.labelValorInicial, cons);
            cons.gridx = 4;
            this.auxCamposCoresFixo.add((Component)this.labelValorFinal, cons);
            cons.gridx = 0;
            cons.gridy = 1;
            this.auxCamposCoresFixo.add((Component)this.textPosicao, cons);
            this.textPosicao.setEditable(false);
            this.textPosicao.setEnabled(false);
            this.posicaoMax = 1;
            cons.gridx = 1;
            this.auxCamposCoresFixo.add((Component)this.comboCorFixo, cons);
            cons.gridx = 2;
            this.auxCamposCoresFixo.add((Component)this.buttonCor, cons);
            cons.gridx = 3;
            this.auxCamposCoresFixo.add((Component)this.textValorInicial, cons);
            cons.gridx = 4;
            this.auxCamposCoresFixo.add((Component)this.textValorFinal, cons);
            cons.gridx = 5;
            this.auxCamposCoresFixo.add((Component)this.buttonCorOkFixa, cons);
        }

        private void configurarListeners() {
            this.textMinimo.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    boolean isCancelar;
                    boolean bl = isCancelar = e.getOppositeComponent() instanceof JButton && ((JButton)e.getOppositeComponent()).getText().equalsIgnoreCase("Cancelar");
                    if (!isCancelar && comboTipoPreenchimento.getSelectedItem().toString().equalsIgnoreCase("Fixo") && !textMinimo.getText().equalsIgnoreCase(valorMinimo) && tableCoresFixo.getRowCount() > 0) {
                        validandoValor = true;
                        if (Funcoes.mensagem(null, "Ao alterar os valores m\u00ednimo ou m\u00e1ximo, as cores configuradas ser\u00e3o perdidas. Deseja continuar?", 4) == 1) {
                            textMinimo.setText(valorMinimo.replace(".", ","));
                        } else {
                            modeloCoresFixo.clear();
                            posicaoMax = 1;
                        }
                        validandoValor = false;
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.textMaximo.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    boolean isCancelar;
                    boolean bl = isCancelar = e.getOppositeComponent() instanceof JButton && ((JButton)e.getOppositeComponent()).getText().equalsIgnoreCase("Cancelar");
                    if (!isCancelar && comboTipoPreenchimento.getSelectedItem().toString().equalsIgnoreCase("Fixo") && !textMaximo.getText().equalsIgnoreCase(valorMaximo) && tableCoresFixo.getRowCount() > 0) {
                        validandoValor = true;
                        if (Funcoes.mensagem(null, "Ao alterar os valores m\u00ednimo ou m\u00e1ximo, as cores configuradas ser\u00e3o perdidas. Deseja continuar?", 4) == 1) {
                            textMaximo.setText(valorMaximo.replace(".", ","));
                        } else {
                            modeloCoresFixo.clear();
                            posicaoMax = 1;
                        }
                        validandoValor = false;
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.tableCoresFixo.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127 && tableCoresFixo.getSelectedRow() > -1 && Funcoes.mensagem(null, "Deseja excluir a cor selecionada?", 4) == 0) {
                        int linhaRemovida = tableCoresFixo.getSelectedRow();
                        int posicao = 0;
                        if (tableCoresFixo.getRowCount() == 1) {
                            posicaoMax = 1;
                        } else {
                            for (int i = 0; i < modeloCoresFixo.getRowCount(); ++i) {
                                if (i > linhaRemovida) {
                                    modeloCoresFixo.setValueAt(posicao, i, 0);
                                    ++posicao;
                                    continue;
                                }
                                posicao = Integer.valueOf(String.valueOf(modeloCoresFixo.getValueAt(i, 0)));
                            }
                            posicaoMax = posicao + 1;
                        }
                        modeloCoresFixo.removeLine(linhaRemovida);
                        posicaoMax--;
                    }
                    if (e.getKeyCode() == 32 && tableCoresFixo.getSelectedRow() > -1) {
                        selecao = tableCoresFixo.getSelectedRow();
                        this.atualizarCor(false);
                    }
                }
            });
            this.tableCoresFixo.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && tableCoresFixo.getSelectedRow() > -1) {
                        selecao = tableCoresFixo.getSelectedRow();
                        this.atualizarCor(false);
                    }
                }
            });
        }

        private void configurarCampoCoresDegrade() {
            this.tableCoresDegrade.setModel(this.modeloCoresDegrade);
            this.tableCoresDegrade.setTableHeader(null);
            this.modeloCoresDegrade.setColumnSize(new int[]{30, 0}, this.tableCoresDegrade);
            this.tableCoresDegrade.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127 && tableCoresDegrade.getSelectedRow() > -1 && Funcoes.mensagem(null, "Deseja excluir a cor selecionada?", 4) == 0) {
                        modeloCoresDegrade.removeLine(tableCoresDegrade.getSelectedRow());
                    }
                    if (e.getKeyCode() == 32 && tableCoresDegrade.getSelectedRow() > -1) {
                        selecao = tableCoresDegrade.getSelectedRow();
                        this.atualizarCor(true);
                    }
                }
            });
            this.tableCoresDegrade.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && tableCoresDegrade.getSelectedRow() > -1) {
                        selecao = tableCoresDegrade.getSelectedRow();
                        this.atualizarCor(true);
                    }
                }
            });
            this.buttonCorOkDegrade.setPreferredSize(new Dimension(35, 20));
            this.buttonCorOkDegrade.setSize(new Dimension(35, 20));
            this.buttonCorOkDegrade.setMinimumSize(new Dimension(35, 20));
            this.buttonCorDegrade.setPreferredSize(new Dimension(23, 20));
            this.buttonCorDegrade.setSize(new Dimension(23, 20));
            this.buttonCorDegrade.setMinimumSize(new Dimension(23, 20));
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.anchor = 17;
            cons1.gridx = 0;
            cons1.gridy = 0;
            this.comboCorDegrede.setPreferredSize(new Dimension(390, 20));
            this.comboCorDegrede.setSize(new Dimension(390, 20));
            this.comboCorDegrede.setMinimumSize(new Dimension(390, 20));
            this.auxCamposCoresDegrade.add((Component)this.comboCorDegrede, cons1);
            cons1.gridx = 1;
            this.auxCamposCoresDegrade.add((Component)this.buttonCorDegrade, cons1);
            cons1.gridx = 2;
            this.auxCamposCoresDegrade.add((Component)this.buttonCorOkDegrade, cons1);
        }

        private void configurePainelConfiguracao() {
            this.painelConfiguracao.setBorder(new TitledBorder("R\u00e9gua"));
            this.painelConfiguracao.setSize(new Dimension(460, 50));
            this.painelConfiguracao.setPreferredSize(new Dimension(460, 50));
            this.painelConfiguracao.setMinimumSize(new Dimension(460, 50));
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.fill = 11;
            cons1.anchor = 17;
            cons1.insets = new Insets(3, 1, 3, 1);
            cons1.gridx = 0;
            cons1.gridy = 1;
            cons1.gridwidth = 1;
            cons1.gridheight = 1;
            cons1.weightx = 0.0;
            cons1.weighty = 0.5;
            this.painelConfiguracao.add((Component)ComponenteFactory.novoJLabel("Tipo preenchimento: ", new Dimension(50, 20)), cons1);
            cons1.gridx = 1;
            cons1.weightx = 0.5;
            this.comboTipoPreenchimento.setPreferredSize(new Dimension(200, 20));
            this.comboTipoPreenchimento.setSize(new Dimension(200, 20));
            this.comboTipoPreenchimento.setMinimumSize(new Dimension(200, 20));
            cons1.anchor = 13;
            this.painelConfiguracao.add((Component)this.comboTipoPreenchimento, cons1);
        }

        private void atualizarCor(boolean isDegrade) {
            if (isDegrade) {
                this.comboCorDegrede.setCorSelecionada((Color)this.modeloCoresDegrade.getValueAt(this.tableCoresDegrade.getSelectedRow(), 0));
            } else {
                this.textPosicao.setText(this.modeloCoresFixo.getValueAt(this.tableCoresFixo.getSelectedRow(), 0).toString());
                this.comboCorFixo.setCorSelecionada((Color)this.modeloCoresFixo.getValueAt(this.tableCoresFixo.getSelectedRow(), 1));
                this.textValorInicial.setText(this.modeloCoresFixo.getValueAt(this.tableCoresFixo.getSelectedRow(), 3).toString());
                this.textValorFinal.setText(this.modeloCoresFixo.getValueAt(this.tableCoresFixo.getSelectedRow(), 4).toString());
                this.comboTipoPreenchimento.setEnabled(false);
            }
        }
    }
}

