/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.configurador.AtributosRegua;
import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.propriedade.Editor;
import jalis.util.CorComboBox;
import jalis.util.DialogoCor;
import jalis.util.ScreenUtil;
import jalis.util.StrokeComboBoxRenderer;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EditorAtributosRegua
extends Editor {
    private JLabel label = new JLabel("[ ]");
    private JButton button = new JButton("...");
    private AtributosRegua atributos;

    public EditorAtributosRegua() {
        this.add((Component)this.label, "Center");
        this.add((Component)this.button, "East");
        this.button.setPreferredSize(new Dimension(20, 20));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoAtributos da = DialogoAtributos.novaInstancia(EditorAtributosRegua.this.getTopLevelAncestor());
                if (da != null) {
                    da.setAtributos(EditorAtributosRegua.this.atributos);
                    da.setVisible(true);
                    if (da.ok()) {
                        EditorAtributosRegua.this.atributos = da.getAtributos();
                        EditorAtributosRegua.this.fireChangeListener();
                    }
                }
            }
        });
    }

    @Override
    public void setValor(Object valor) {
        if (valor instanceof AtributosRegua) {
            this.atributos = (AtributosRegua)valor;
        }
    }

    @Override
    public Object getValor() {
        return this.atributos;
    }

    @Override
    public Object getValorUsuario() {
        return this.label.getText();
    }

    private static class DialogoAtributos
    extends JDialog
    implements ActionListener,
    DisposeListener {
        private JComboBox comboLinha = new JComboBox<Object>(new Object[]{Constantes.SOLIDO, Constantes.TRACEJADO, Constantes.PONTILHADO});
        private CorComboBox comboCor = new CorComboBox();
        private JButton buttonOk = ComponenteFactory.novoJButton("Ok", 'O', this, null, null);
        private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
        private JButton buttonCor = ComponenteFactory.novoJButton("...", '\u0000', this, null, new Dimension(20, 20));
        private boolean ok;

        public static DialogoAtributos novaInstancia(Object pai) {
            if (pai instanceof Dialog) {
                return new DialogoAtributos((Dialog)pai);
            }
            if (pai instanceof Frame) {
                return new DialogoAtributos((Frame)pai);
            }
            return null;
        }

        public DialogoAtributos(Frame pai) {
            super(pai, "Atributos", true);
            this.iniciar();
        }

        public DialogoAtributos(Dialog pai) {
            super(pai, "Atributos", true);
            this.iniciar();
        }

        public void setAtributos(AtributosRegua atributos) {
            this.comboLinha.setSelectedItem(atributos == null ? null : atributos.getLinha());
            this.comboCor.setCorSelecionada(atributos == null ? null : atributos.getCor());
        }

        public AtributosRegua getAtributos() {
            return new AtributosRegua((Stroke)this.comboLinha.getSelectedItem(), this.comboCor.getCorSelecionada());
        }

        public boolean ok() {
            return this.ok;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogoCor dc;
            Object o = e.getSource();
            if (o == this.buttonOk || o == this.buttonCancelar) {
                this.ok = o == this.buttonOk;
                this.dispose();
            } else if (o == this.buttonCor && (dc = DialogoCor.novaInstancia(this, "Configura\u00e7\u00e3o de Cor")) != null) {
                dc.setCor(this.comboCor.getCorSelecionada());
                dc.setVisible(true);
                if (dc.ok()) {
                    this.comboCor.setCorPersonalizada(dc.getCor());
                    this.comboCor.setCorSelecionada(dc.getCor());
                }
            }
        }

        private void iniciar() {
            JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)panel, "South");
            panel.add(this.buttonOk);
            panel.add(this.buttonCancelar);
            panel = new JPanel(new GridBagLayout());
            this.getContentPane().add((Component)panel, "Center");
            GridBagConstraints cons = new GridBagConstraints();
            cons.fill = 1;
            cons.insets = new Insets(3, 1, 3, 1);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            cons.weightx = 0.0;
            cons.weighty = 0.5;
            panel.add((Component)ComponenteFactory.novoJLabel("Linha: ", new Dimension(70, 20)), cons);
            cons.gridx = 1;
            cons.weightx = 0.5;
            panel.add((Component)this.comboLinha, cons);
            cons.gridx = 0;
            cons.gridy = 1;
            cons.weightx = 0.0;
            panel.add((Component)ComponenteFactory.novoJLabel("Cor: ", new Dimension(70, 20)), cons);
            cons.gridx = 1;
            cons.weightx = 0.5;
            JPanel aux = new JPanel(new BorderLayout());
            aux.add((Component)this.comboCor, "Center");
            aux.add((Component)this.buttonCor, "East");
            aux.setPreferredSize(new Dimension(200, 25));
            panel.add((Component)aux, cons);
            this.comboLinha.setRenderer(new StrokeComboBoxRenderer());
            this.pack();
            ScreenUtil.centralizar(this);
        }
    }
}

