/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.propriedade.ObjetoRotuloReferencia;
import jalis.util.DocumentoNumero;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class DialogoRotulosReferencia
extends JDialog
implements ActionListener {
    private JTextField textTitulo = new JTextField();
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("Adicionar", 'A', this);
    private DefaultListModel modelTitulos = new DefaultListModel();
    private JList listTitulos = new JList(this.modelTitulos);
    private JTextField textInicial = new JTextField();
    private JTextField textFinal = new JTextField();
    private JButton buttonDefinir = ComponenteFactory.novoJButton("Definir", 'D', this);
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private boolean ok;

    public static DialogoRotulosReferencia novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoRotulosReferencia((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoRotulosReferencia((Dialog)pai);
        }
        return null;
    }

    public DialogoRotulosReferencia(Frame pai) {
        super(pai, "R\u00f3tulos", true);
        this.iniciar();
    }

    public DialogoRotulosReferencia(Dialog pai) {
        super(pai, "R\u00f3tulos", true);
        this.iniciar();
    }

    public void setItens(List<String> itens) {
        if (itens != null) {
            for (String xml : itens) {
                this.modelTitulos.addElement(ObjetoRotuloReferencia.newFromXML(xml));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.dispose();
        } else if (o == this.buttonAdicionar) {
            if (this.textTitulo.getText().trim().length() > 0) {
                boolean podeAdicionar = true;
                for (int i = 0; i < this.modelTitulos.getSize(); ++i) {
                    if (!((ObjetoRotuloReferencia)this.modelTitulos.get(i)).getTitulo().equalsIgnoreCase(this.textTitulo.getText().trim())) continue;
                    podeAdicionar = false;
                    break;
                }
                if (podeAdicionar) {
                    this.modelTitulos.addElement(new ObjetoRotuloReferencia(this.textTitulo.getText().trim()));
                }
                this.textTitulo.setText("");
                this.textTitulo.grabFocus();
            }
        } else if (o == this.buttonDefinir && this.listTitulos.getSelectedIndex() > -1) {
            ObjetoRotuloReferencia of = (ObjetoRotuloReferencia)this.modelTitulos.get(this.listTitulos.getSelectedIndex());
            of.setValorInicial(Integer.parseInt(this.textInicial.getText()));
            of.setValorFinal(Integer.parseInt(this.textFinal.getText()));
        }
    }

    public List<String> getItens() {
        ArrayList<String> retorno = new ArrayList<String>();
        for (int i = 0; i < this.modelTitulos.getSize(); ++i) {
            ObjetoRotuloReferencia of = (ObjetoRotuloReferencia)this.modelTitulos.get(i);
            StringBuilder b = new StringBuilder();
            b.append("<rotuloreferencia>");
            b.append("<titulo>").append(of.titulo).append("</titulo>");
            b.append("<inicial>").append(of.valorInicial).append("</inicial>");
            b.append("<final>").append(of.valorFinal).append("</final>");
            b.append("</rotuloreferencia>");
            retorno.add(b.toString());
        }
        return retorno;
    }

    public boolean ok() {
        return this.ok;
    }

    private void iniciar() {
        JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "South");
        panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.textTitulo.setPreferredSize(new Dimension(200, 20));
        this.buttonAdicionar.setPreferredSize(new Dimension(100, 20));
        this.listTitulos.setPreferredSize(new Dimension(80, 50));
        JScrollPane scrollTitulos = new JScrollPane(this.listTitulos);
        scrollTitulos.setPreferredSize(new Dimension(160, 190));
        panel.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 1, 1, new JLabel("T\u00edtulo:"), this.textTitulo, this.buttonAdicionar), "North");
        JPanel jPanel = panel;
        panel = ComponenteFactory.novoJPanel(null, new TitledBorder("Pontos"));
        jPanel.add((Component)ComponenteFactory.novoJPanelBorderLayout(panel, null, null, null, scrollTitulos), "Center");
        panel.setLayout(null);
        JLabel labelInicial = new JLabel("Inicial");
        JLabel labelFinal = new JLabel("Final");
        this.textInicial.setDocument(new DocumentoNumero());
        this.textFinal.setDocument(new DocumentoNumero());
        labelInicial.setBounds(5, 15, 40, 20);
        labelFinal.setBounds(65, 15, 40, 20);
        this.textInicial.setBounds(5, 35, 60, 20);
        this.textFinal.setBounds(65, 35, 60, 20);
        this.buttonDefinir.setBounds(5, 56, 125, 20);
        panel.add(labelInicial);
        panel.add(labelFinal);
        panel.add(this.textInicial);
        panel.add(this.textFinal);
        panel.add(this.buttonDefinir);
        this.listTitulos.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DialogoRotulosReferencia.this.modelTitulos.getSize() > 0 && DialogoRotulosReferencia.this.listTitulos.getSelectedIndex() > -1 && DialogoRotulosReferencia.this.modelTitulos.get(DialogoRotulosReferencia.this.listTitulos.getSelectedIndex()) != null) {
                    ObjetoRotuloReferencia o = (ObjetoRotuloReferencia)DialogoRotulosReferencia.this.modelTitulos.get(DialogoRotulosReferencia.this.listTitulos.getSelectedIndex());
                    DialogoRotulosReferencia.this.textInicial.setText(String.valueOf(o.getValorInicial()));
                    DialogoRotulosReferencia.this.textFinal.setText(String.valueOf(o.getValorFinal()));
                }
            }
        });
        this.listTitulos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && DialogoRotulosReferencia.this.listTitulos.getSelectedIndex() > -1) {
                    DialogoRotulosReferencia.this.modelTitulos.remove(DialogoRotulosReferencia.this.listTitulos.getSelectedIndex());
                    DialogoRotulosReferencia.this.textInicial.setText("");
                    DialogoRotulosReferencia.this.textFinal.setText("");
                    if (DialogoRotulosReferencia.this.modelTitulos.getSize() > 0) {
                        DialogoRotulosReferencia.this.listTitulos.setSelectedIndex(0);
                    }
                }
            }
        });
        this.textInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DialogoRotulosReferencia.this.buttonDefinir.setEnabled(DialogoRotulosReferencia.this.textInicial.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && DialogoRotulosReferencia.this.textFinal.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?"));
            }
        });
        this.textFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DialogoRotulosReferencia.this.buttonDefinir.setEnabled(DialogoRotulosReferencia.this.textInicial.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && DialogoRotulosReferencia.this.textFinal.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?"));
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.centralizar(this);
    }
}

