/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class DialogoRotulos
extends JDialog
implements ActionListener {
    private JTextArea textCampos = new JTextArea();
    private JTextArea textRotulos = new JTextArea();
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private boolean ok;

    public static DialogoRotulos novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoRotulos((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoRotulos((Dialog)pai);
        }
        return null;
    }

    public DialogoRotulos(Frame pai) {
        super(pai, "R\u00f3tulos", true);
        this.iniciar();
    }

    public DialogoRotulos(Dialog pai) {
        super(pai, "R\u00f3tulos", true);
        this.iniciar();
    }

    public void setCampos(List<String> campos) {
        if (campos != null) {
            this.textCampos.setText(StringUtil.concatenarLinhas(campos.toArray(new String[campos.size()])));
        }
    }

    public void setItens(List<String> itens) {
        if (itens != null) {
            this.textRotulos.setText(StringUtil.concatenarLinhas(itens.toArray(new String[itens.size()])));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.dispose();
        }
    }

    public List<String> getItens() {
        ArrayList<String> itens = new ArrayList<String>();
        for (String str : StringUtil.separarLinhas(this.textRotulos.getText())) {
            itens.add(str);
        }
        return itens;
    }

    public boolean ok() {
        return this.ok;
    }

    private void iniciar() {
        JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "South");
        panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        panel.add((Component)this.textCampos, "West");
        panel.add((Component)this.textRotulos, "Center");
        this.textCampos.setPreferredSize(new Dimension(120, 250));
        this.textCampos.setEditable(false);
        this.textCampos.setBorder(BorderFactory.createTitledBorder(""));
        this.textRotulos.setPreferredSize(new Dimension(150, 250));
        this.textRotulos.setBorder(BorderFactory.createTitledBorder(""));
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.centralizar(this);
    }
}

