/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.DisposeListener;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogoRelacionamento
extends JDialog
implements DisposeListener,
ActionListener,
ListSelectionListener {
    private DefaultListModel modeloPossiveis = new DefaultListModel();
    private DefaultListModel modeloRelacionados = new DefaultListModel();
    private JList listPossiveis = ComponenteFactory.novoJList(this.modeloPossiveis, this, null, null);
    private JList listRelacionados = ComponenteFactory.novoJList(this.modeloRelacionados, this, null, null);
    private JButton buttonDir = ComponenteFactory.novoJButton("  -->", '\u0000', this, null, new Dimension(100, 25), false);
    private JButton buttonEsq = ComponenteFactory.novoJButton("<--  ", '\u0000', this, null, new Dimension(100, 25), false);
    private JButton buttonCima = ComponenteFactory.novoJButton("Para cima", '\u0000', this, null, new Dimension(100, 25), false);
    private JButton buttonBaixo = ComponenteFactory.novoJButton("Para baixo", '\u0000', this, null, new Dimension(100, 25), false);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private ArrayList<String> relacionados = new ArrayList();
    private boolean selecionando;

    public static DialogoRelacionamento novaInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new DialogoRelacionamento((Frame)pai, titulo, true);
        }
        if (pai instanceof Dialog) {
            return new DialogoRelacionamento((Dialog)pai, titulo, true);
        }
        return null;
    }

    public DialogoRelacionamento(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar();
    }

    public DialogoRelacionamento(Dialog pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            if (o == this.buttonOk) {
                this.relacionados.clear();
                for (int i = 0; i < this.modeloRelacionados.getSize(); ++i) {
                    this.relacionados.add((String)this.modeloRelacionados.getElementAt(i));
                }
            }
            this.dispose();
        } else if (o == this.buttonDir) {
            for (Object item : this.listPossiveis.getSelectedValues()) {
                if (!this.modeloRelacionados.contains(item)) {
                    this.modeloRelacionados.addElement(item);
                }
                this.modeloPossiveis.removeElement(item);
            }
            this.habilitarDesabilitarBotoes(this.listPossiveis);
        } else if (o == this.buttonEsq) {
            for (Object item : this.listRelacionados.getSelectedValues()) {
                if (!this.modeloPossiveis.contains(item)) {
                    this.modeloPossiveis.addElement(item);
                }
                this.modeloRelacionados.removeElement(item);
            }
            this.habilitarDesabilitarBotoes(this.listRelacionados);
        } else if (o == this.buttonCima || o == this.buttonBaixo) {
            int indice = this.listRelacionados.getSelectedIndex();
            Object item = this.modeloRelacionados.remove(indice);
            this.modeloRelacionados.add(o == this.buttonCima ? indice - 1 : indice + 1, item);
            this.listRelacionados.setSelectedIndex(o == this.buttonCima ? indice - 1 : indice + 1);
            this.habilitarDesabilitarBotoes(this.listRelacionados);
        }
    }

    public List<String> getComponentesRelacionados() {
        return this.relacionados;
    }

    public void setComponentesRelacionados(List<String> itens) {
        this.relacionados.clear();
        this.relacionados.addAll(itens);
        this.modeloRelacionados.clear();
        for (String item : itens) {
            if (this.modeloPossiveis.contains(item)) {
                this.modeloPossiveis.removeElement(item);
            }
            this.modeloRelacionados.addElement(item);
        }
    }

    public void setPossiveis(List<String> itens) {
        this.modeloPossiveis.removeAllElements();
        for (String item : itens) {
            if (this.modeloRelacionados.contains(item)) continue;
            this.modeloPossiveis.addElement(item);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.selecionando) {
            this.selecionando = true;
            this.habilitarDesabilitarBotoes((JList)e.getSource());
            this.selecionando = false;
        }
    }

    private void habilitarDesabilitarBotoes(JList lista) {
        int indice = lista.getSelectedIndex();
        this.buttonDir.setEnabled(this.listPossiveis.getSelectedIndex() != -1);
        this.buttonEsq.setEnabled(this.listRelacionados.getSelectedIndex() != -1);
        this.buttonCima.setEnabled(lista == this.listRelacionados && indice != -1 && indice > 0);
        this.buttonBaixo.setEnabled(lista == this.listRelacionados && indice != -1 && indice < this.modeloRelacionados.getSize() - 1);
        if (lista == this.listPossiveis) {
            this.listRelacionados.getSelectionModel().clearSelection();
        } else {
            this.listPossiveis.getSelectionModel().clearSelection();
        }
    }

    private void iniciar() {
        JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
        JScrollPane scroll = new JScrollPane(this.listPossiveis);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "South");
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        JPanel aux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Campos do laudo"));
        panel.add((Component)aux, "West");
        aux.add((Component)scroll, "Center");
        scroll.setPreferredSize(new Dimension(200, 250));
        aux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Campos selecionados"));
        panel.add((Component)aux, "East");
        scroll = new JScrollPane(this.listRelacionados);
        aux.add((Component)scroll, "Center");
        scroll.setPreferredSize(new Dimension(200, 250));
        JPanel jPanel = panel;
        panel = new JPanel(new GridBagLayout());
        jPanel.add(panel);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 10;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 0, 1, 0);
        panel.add((Component)this.buttonDir, cons);
        cons.gridy = 1;
        panel.add((Component)this.buttonEsq, cons);
        cons.gridy = 2;
        panel.add((Component)ComponenteFactory.novoJPanel(new Dimension(100, 25)), cons);
        cons.gridy = 3;
        panel.add((Component)this.buttonCima, cons);
        cons.gridy = 4;
        panel.add((Component)this.buttonBaixo, cons);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(new Dimension(dim.width + 20, dim.height));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }
}

