/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.AtributosPosicaoQuadrante;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class DialogoPosicaoQuadrante
extends JDialog
implements ActionListener {
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JTextField textIdentificacao = new JTextField();
    private JTextField textPosicaoX = new JTextField();
    private JTextField textPosicaoY = new JTextField();
    private JButton buttonAdicionar = new JButton("Adicionar");
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private boolean ok = false;

    public static DialogoPosicaoQuadrante novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new DialogoPosicaoQuadrante((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new DialogoPosicaoQuadrante((Frame)pai);
        }
        return null;
    }

    public DialogoPosicaoQuadrante(Dialog pai) {
        super(pai, "Posi\u00e7\u00e3o quadrante", true);
        this.iniciar(pai);
    }

    public DialogoPosicaoQuadrante(Frame pai) {
        super(pai, "Posi\u00e7\u00e3o quadrante", true);
        this.iniciar(pai);
    }

    private void iniciar(Container pai) {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(380, 300));
        this.setLocationRelativeTo(pai);
        this.buttonAdicionar.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.textPosicaoX.setHorizontalAlignment(4);
        this.textPosicaoY.setHorizontalAlignment(4);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        JPanel panelTopo = new JPanel(new GridBagLayout());
        panelTopo.add((Component)new JLabel("Identifica\u00e7\u00e3o"), c);
        ++c.gridx;
        panelTopo.add((Component)new JLabel("Pos. X"), c);
        ++c.gridx;
        panelTopo.add((Component)new JLabel("Pos. Y"), c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        panelTopo.add((Component)this.textIdentificacao, c);
        ++c.gridx;
        panelTopo.add((Component)this.textPosicaoX, c);
        ++c.gridx;
        panelTopo.add((Component)this.textPosicaoY, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        panelTopo.add((Component)this.buttonAdicionar, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonOK);
        panelBotoes.add(this.buttonCancelar);
        this.add((Component)panelTopo, "North");
        this.add((Component)panelBotoes, "South");
        this.add((Component)new JScrollPane(this.list), "Center");
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && DialogoPosicaoQuadrante.this.list.getSelectedIndex() > -1) {
                    DialogoPosicaoQuadrante.this.model.remove(DialogoPosicaoQuadrante.this.list.getSelectedIndex());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.ok = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCancelar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonAdicionar) {
            if (this.textIdentificacao.getText().trim().length() > 0 && this.textPosicaoX.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && this.textPosicaoY.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
                AtributosPosicaoQuadrante at = new AtributosPosicaoQuadrante(this.textIdentificacao.getText().trim());
                at.setPosicao(Double.parseDouble(this.textPosicaoX.getText()), Double.parseDouble(this.textPosicaoY.getText()));
                this.model.addElement(at);
            }
            this.textIdentificacao.setText("");
            this.textPosicaoX.setText("");
            this.textPosicaoY.setText("");
            this.textIdentificacao.grabFocus();
        }
    }

    public void setValores(ArrayList<AtributosPosicaoQuadrante> itens) {
        this.model.clear();
        for (AtributosPosicaoQuadrante at : itens) {
            this.model.addElement(at);
        }
    }

    public ArrayList<AtributosPosicaoQuadrante> getValores() {
        ArrayList<AtributosPosicaoQuadrante> retorno = null;
        if (this.model.getSize() > 0) {
            retorno = new ArrayList<AtributosPosicaoQuadrante>();
            for (int i = 0; i < this.model.getSize(); ++i) {
                AtributosPosicaoQuadrante at = (AtributosPosicaoQuadrante)this.model.get(i);
                retorno.add(at);
            }
        }
        return retorno;
    }

    public boolean getOK() {
        return this.ok;
    }
}

