/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.exame.DeltaCheckService;
import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DialogoPercentualVariacao
extends AbstractDialogoOKCancelar
implements ActionListener,
DisposeListener {
    JLabel labelIntraIndividual = new JLabel("<html> Intra-Individual (CV<sub>l</sub>) </html>");
    JLabel labelInterIndividualG = new JLabel("<html> Inter-Individual (CV<sub>G</sub>)</html>");
    JLabel labelAnalitico = new JLabel("<html> Anal\u00edtico(CV<sub>A</sub> ou I%)</html>");
    JTextField textIntraIndividual = new TTextField(5, 2);
    JTextField textInterIndividualG = new TTextField(5, 2);
    JTextField textAnalitico = new TTextField(5, 2);
    JPanel panelSelecionarPercentual = new JPanel();
    JButton buttonOk = new JButton("OK");
    JLabel labelZ95 = new JLabel("Z = 1,96 (Signific\u00e2ncia 95%): ");
    JLabel labelZ99 = new JLabel("Z = 2,58 (Signific\u00e2ncia 99%): ");
    JLabel labelRCVI = new JLabel("RCV I (%)");
    JLabel labelRCVII = new JLabel("RCV II (%) ");
    String textZ95RCVI = "0";
    JRadioButton checkZ95RCVI = new JRadioButton(this.textZ95RCVI);
    String textZ95RCVII = "0";
    JRadioButton checkZ95RCVII = new JRadioButton(this.textZ95RCVII);
    String textZ99RCVI = "0";
    JRadioButton checkZ99RCVI = new JRadioButton(this.textZ99RCVI);
    String textZ99RCVII = "0";
    JRadioButton checkZ99RCVII = new JRadioButton(this.textZ99RCVII);
    private ValoresPercentualDeltaCheck valores;

    public DialogoPercentualVariacao(Dialog pai, String titulo, ValoresPercentualDeltaCheck valores) {
        super(pai, titulo);
        if (valores != null && valores.getIntraIndividual() != null) {
            this.valores = valores;
            this.textIntraIndividual.setText(Funcoes.formataDecimal(valores.getIntraIndividual()));
            this.textInterIndividualG.setText(Funcoes.formataDecimal(valores.getInterIndividual()));
            this.textAnalitico.setText(Funcoes.formataDecimal(valores.getAnalitico()));
            this.checkZ95RCVI.setSelected(valores.getRcvI95());
            this.checkZ99RCVI.setSelected(valores.getRcvI99());
            this.checkZ95RCVII.setSelected(valores.getRcvII95());
            this.checkZ99RCVII.setSelected(valores.getRcvII99());
            this.textZ95RCVI = DeltaCheckService.calculaZ196RCVI(new BigDecimal(this.textAnalitico.getText().replace(",", ".")), new BigDecimal(this.textIntraIndividual.getText().replace(",", "."))).toString();
            this.checkZ95RCVI.setText(Funcoes.formataDecimal(Double.parseDouble(this.textZ95RCVI)));
            this.textZ99RCVI = DeltaCheckService.calculaZ258RCVI(new BigDecimal(this.textAnalitico.getText().replace(",", ".")), new BigDecimal(this.textIntraIndividual.getText().replace(",", "."))).toString();
            this.checkZ99RCVI.setText(Funcoes.formataDecimal(Double.parseDouble(this.textZ99RCVI)));
            this.textZ95RCVII = DeltaCheckService.calculaZ196RCVII(new BigDecimal(this.textIntraIndividual.getText().replace(",", ".")), new BigDecimal(this.textInterIndividualG.getText().replace(",", "."))).toString();
            this.checkZ95RCVII.setText(Funcoes.formataDecimal(Double.parseDouble(this.textZ95RCVII)));
            this.textZ99RCVII = DeltaCheckService.calculaZ258RCVII(new BigDecimal(this.textIntraIndividual.getText().replace(",", ".")), new BigDecimal(this.textInterIndividualG.getText().replace(",", "."))).toString();
            this.checkZ99RCVII.setText(Funcoes.formataDecimal(Double.parseDouble(this.textZ99RCVII)));
        } else {
            this.valores = new ValoresPercentualDeltaCheck();
        }
    }

    private void montaListeners() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DialogoPercentualVariacao.this.checkZ95RCVI && DialogoPercentualVariacao.this.checkZ95RCVI.isSelected()) {
                    DialogoPercentualVariacao.this.checkZ99RCVI.setSelected(false);
                    DialogoPercentualVariacao.this.checkZ95RCVII.setSelected(false);
                    DialogoPercentualVariacao.this.checkZ99RCVII.setSelected(false);
                } else if (e.getSource() == DialogoPercentualVariacao.this.checkZ99RCVI && DialogoPercentualVariacao.this.checkZ99RCVI.isSelected()) {
                    DialogoPercentualVariacao.this.checkZ95RCVI.setSelected(false);
                    DialogoPercentualVariacao.this.checkZ95RCVII.setSelected(false);
                    DialogoPercentualVariacao.this.checkZ99RCVII.setSelected(false);
                } else if (e.getSource() == DialogoPercentualVariacao.this.checkZ95RCVII && DialogoPercentualVariacao.this.checkZ95RCVII.isSelected()) {
                    DialogoPercentualVariacao.this.checkZ95RCVI.setSelected(false);
                    DialogoPercentualVariacao.this.checkZ99RCVI.setSelected(false);
                    DialogoPercentualVariacao.this.checkZ99RCVII.setSelected(false);
                } else if (e.getSource() == DialogoPercentualVariacao.this.checkZ99RCVII && DialogoPercentualVariacao.this.checkZ99RCVII.isSelected()) {
                    DialogoPercentualVariacao.this.checkZ95RCVI.setSelected(false);
                    DialogoPercentualVariacao.this.checkZ99RCVI.setSelected(false);
                    DialogoPercentualVariacao.this.checkZ95RCVII.setSelected(false);
                }
            }
        };
        this.checkZ95RCVI.addActionListener(actionListener);
        this.checkZ99RCVI.addActionListener(actionListener);
        this.checkZ95RCVII.addActionListener(actionListener);
        this.checkZ99RCVII.addActionListener(actionListener);
    }

    public ValoresPercentualDeltaCheck getValores() {
        return this.valores;
    }

    public void setValores(ValoresPercentualDeltaCheck valores) {
        this.valores = valores;
    }

    public void montaTela() {
        this.setSize(new Dimension(500, 220));
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.setTitle("Percentual de varia\u00e7\u00e3o - Delta Check");
        this.setLocationRelativeTo(Laboratorio.getInstancia());
        this.panelSelecionarPercentual.setBorder(new TitledBorder("Selecione um percentual de varia\u00e7\u00e3o:"));
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        JPanel panelCampos = new JPanel();
        panelCampos.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        panelCampos.add((Component)this.labelIntraIndividual, c);
        c.gridx = 1;
        panelCampos.add((Component)this.labelInterIndividualG, c);
        c.gridx = 2;
        panelCampos.add((Component)this.labelAnalitico, c);
        c.gridx = 0;
        c.gridy = 1;
        panelCampos.add((Component)this.textIntraIndividual, c);
        c.gridx = 1;
        panelCampos.add((Component)this.textInterIndividualG, c);
        c.gridx = 2;
        panelCampos.add((Component)this.textAnalitico, c);
        this.panelSelecionarPercentual.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 1;
        this.panelSelecionarPercentual.add((Component)this.labelRCVI, c);
        c.gridx = 2;
        this.panelSelecionarPercentual.add((Component)this.labelRCVII, c);
        c.gridy = 1;
        c.gridx = 0;
        this.panelSelecionarPercentual.add((Component)this.labelZ95, c);
        c.gridx = 1;
        this.panelSelecionarPercentual.add((Component)this.checkZ95RCVI, c);
        c.gridx = 2;
        this.panelSelecionarPercentual.add((Component)this.checkZ95RCVII, c);
        c.gridy = 2;
        c.gridx = 0;
        this.panelSelecionarPercentual.add((Component)this.labelZ99, c);
        c.gridx = 1;
        this.panelSelecionarPercentual.add((Component)this.checkZ99RCVI, c);
        c.gridx = 2;
        this.panelSelecionarPercentual.add((Component)this.checkZ99RCVII, c);
        panel.add((Component)panelCampos, "North");
        panel.add((Component)this.panelSelecionarPercentual, "South");
        this.montaListeners();
        this.textIntraIndividual.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!DialogoPercentualVariacao.this.textIntraIndividual.getText().isEmpty() && !DialogoPercentualVariacao.this.textInterIndividualG.getText().isEmpty()) {
                    DialogoPercentualVariacao.this.textZ95RCVII = DeltaCheckService.calculaZ196RCVII(new BigDecimal(DialogoPercentualVariacao.this.textIntraIndividual.getText().replace(",", ".")), new BigDecimal(DialogoPercentualVariacao.this.textInterIndividualG.getText().replace(",", "."))).toString();
                    DialogoPercentualVariacao.this.checkZ95RCVII.setText(Funcoes.formataDecimal(Double.parseDouble(DialogoPercentualVariacao.this.textZ95RCVII)));
                    DialogoPercentualVariacao.this.textZ99RCVII = DeltaCheckService.calculaZ258RCVII(new BigDecimal(DialogoPercentualVariacao.this.textIntraIndividual.getText().replace(",", ".")), new BigDecimal(DialogoPercentualVariacao.this.textInterIndividualG.getText().replace(",", "."))).toString();
                    DialogoPercentualVariacao.this.checkZ99RCVII.setText(Funcoes.formataDecimal(Double.parseDouble(DialogoPercentualVariacao.this.textZ99RCVII)));
                    DialogoPercentualVariacao.this.revalidate();
                    DialogoPercentualVariacao.this.repaint();
                }
                if (!DialogoPercentualVariacao.this.textAnalitico.getText().isEmpty() && !DialogoPercentualVariacao.this.textIntraIndividual.getText().isEmpty()) {
                    DialogoPercentualVariacao.this.textZ95RCVI = DeltaCheckService.calculaZ196RCVI(new BigDecimal(DialogoPercentualVariacao.this.textAnalitico.getText().replace(",", ".")), new BigDecimal(DialogoPercentualVariacao.this.textIntraIndividual.getText().replace(",", "."))).toString();
                    DialogoPercentualVariacao.this.checkZ95RCVI.setText(Funcoes.formataDecimal(Double.parseDouble(DialogoPercentualVariacao.this.textZ95RCVI)));
                    DialogoPercentualVariacao.this.textZ99RCVI = DeltaCheckService.calculaZ258RCVI(new BigDecimal(DialogoPercentualVariacao.this.textAnalitico.getText().replace(",", ".")), new BigDecimal(DialogoPercentualVariacao.this.textIntraIndividual.getText().replace(",", "."))).toString();
                    DialogoPercentualVariacao.this.checkZ99RCVI.setText(Funcoes.formataDecimal(Double.parseDouble(DialogoPercentualVariacao.this.textZ99RCVI)));
                    DialogoPercentualVariacao.this.revalidate();
                    DialogoPercentualVariacao.this.repaint();
                }
            }
        });
        this.textAnalitico.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!DialogoPercentualVariacao.this.textAnalitico.getText().isEmpty() && !DialogoPercentualVariacao.this.textIntraIndividual.getText().isEmpty()) {
                    DialogoPercentualVariacao.this.textZ95RCVI = DeltaCheckService.calculaZ196RCVI(new BigDecimal(DialogoPercentualVariacao.this.textAnalitico.getText().replace(",", ".")), new BigDecimal(DialogoPercentualVariacao.this.textIntraIndividual.getText().replace(",", "."))).toString();
                    DialogoPercentualVariacao.this.checkZ95RCVI.setText(Funcoes.formataDecimal(Double.parseDouble(DialogoPercentualVariacao.this.textZ95RCVI)));
                    DialogoPercentualVariacao.this.textZ99RCVI = DeltaCheckService.calculaZ258RCVI(new BigDecimal(DialogoPercentualVariacao.this.textAnalitico.getText().replace(",", ".")), new BigDecimal(DialogoPercentualVariacao.this.textIntraIndividual.getText().replace(",", "."))).toString();
                    DialogoPercentualVariacao.this.checkZ99RCVI.setText(Funcoes.formataDecimal(Double.parseDouble(DialogoPercentualVariacao.this.textZ99RCVI)));
                    DialogoPercentualVariacao.this.revalidate();
                    DialogoPercentualVariacao.this.repaint();
                }
            }
        });
        this.textInterIndividualG.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!DialogoPercentualVariacao.this.textIntraIndividual.getText().isEmpty() && !DialogoPercentualVariacao.this.textInterIndividualG.getText().isEmpty()) {
                    DialogoPercentualVariacao.this.textZ95RCVII = DeltaCheckService.calculaZ196RCVII(new BigDecimal(DialogoPercentualVariacao.this.textIntraIndividual.getText().replace(",", ".")), new BigDecimal(DialogoPercentualVariacao.this.textInterIndividualG.getText().replace(",", "."))).toString();
                    DialogoPercentualVariacao.this.checkZ95RCVII.setText(Funcoes.formataDecimal(Double.parseDouble(DialogoPercentualVariacao.this.textZ95RCVII)));
                    DialogoPercentualVariacao.this.textZ99RCVII = DeltaCheckService.calculaZ258RCVII(new BigDecimal(DialogoPercentualVariacao.this.textIntraIndividual.getText().replace(",", ".")), new BigDecimal(DialogoPercentualVariacao.this.textInterIndividualG.getText().replace(",", "."))).toString();
                    DialogoPercentualVariacao.this.checkZ99RCVII.setText(Funcoes.formataDecimal(Double.parseDouble(DialogoPercentualVariacao.this.textZ99RCVII)));
                    DialogoPercentualVariacao.this.revalidate();
                    DialogoPercentualVariacao.this.repaint();
                }
            }
        });
    }

    public String getValorPercentualVariacao() {
        if (this.checkZ95RCVI.isSelected()) {
            return this.textZ95RCVI;
        }
        if (this.checkZ95RCVII.isSelected()) {
            return this.textZ95RCVII;
        }
        if (this.checkZ99RCVI.isSelected()) {
            return this.textZ99RCVI;
        }
        return this.textZ99RCVII;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOK;
            if (!this.ok) {
                this.acaoCancelar();
                this.revalidate();
                this.repaint();
                this.dispose();
            } else if (this.ok && this.acaoOk()) {
                if (this.textIntraIndividual.getText().isEmpty() || this.textInterIndividualG.getText().isEmpty() || this.textAnalitico.getText().isEmpty() || !this.checkZ95RCVI.isSelected() && !this.checkZ99RCVI.isSelected() && !this.checkZ95RCVII.isSelected() && !this.checkZ99RCVII.isSelected()) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "\u00c9 obrigat\u00f3rio informar todos os campos/coeficientes e selecionar um dos percentuais de varia\u00e7\u00e3o.", 2);
                } else {
                    this.gravarValoresDeltaCheck();
                    this.dispose();
                }
            }
        }
    }

    public void gravarValoresDeltaCheck() {
        this.valores = new ValoresPercentualDeltaCheck();
        this.valores.setPercentualVariacao(this.getValorPercentualVariacao());
        this.valores.setIntraIndividual(Double.valueOf(this.textIntraIndividual.getText()));
        this.valores.setInterIndividual(Double.valueOf(this.textInterIndividualG.getText()));
        this.valores.setAnalitico(Double.valueOf(this.textAnalitico.getText()));
        this.valores.setRcvI95(this.checkZ95RCVI.isSelected());
        this.valores.setRcvI99(this.checkZ99RCVI.isSelected());
        this.valores.setRcvII95(this.checkZ95RCVII.isSelected());
        this.valores.setRcvII99(this.checkZ99RCVII.isSelected());
    }

    public void setAtributos(String atr) {
        this.valores.setAtributos(atr);
    }
}

