/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.propriedade.ObjetoLinhaFixa;
import jalis.laboratorio.configurador.propriedade.RenderListLinhas;
import jalis.laboratorio.configurador.propriedade.TipoLinha;
import jalis.laboratorio.configurador.propriedade.TipoPonto;
import jalis.util.CorComboBox;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class DialogoLinhasFixas
extends JDialog
implements ActionListener {
    private JTextField textLinha = new JTextField();
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("Adicionar", 'A', this);
    private DefaultListModel modelLinhas = new DefaultListModel();
    private JList listLinhas = new JList(this.modelLinhas);
    private CorComboBox comboCor = new CorComboBox(true);
    private JTextArea textRotulos = new JTextArea();
    private JTextArea textValores = new JTextArea();
    private JButton buttonDefinir = ComponenteFactory.novoJButton("Definir", 'D', this);
    private JComboBox comboTipoLinha = new JComboBox<TipoLinha>(TipoLinha.getTipos());
    private JComboBox comboPonto = new JComboBox<TipoPonto>(TipoPonto.getTipos());
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private boolean ok;

    public static DialogoLinhasFixas novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoLinhasFixas((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoLinhasFixas((Dialog)pai);
        }
        return null;
    }

    public DialogoLinhasFixas(Frame pai) {
        super(pai, "Linhas fixas", true);
        this.iniciar();
    }

    public DialogoLinhasFixas(Dialog pai) {
        super(pai, "Linhas fixas", true);
        this.iniciar();
    }

    public void setItens(List<String> itens) {
        if (itens != null) {
            for (String xml : itens) {
                ObjetoLinhaFixa o = ObjetoLinhaFixa.newFromXML(xml);
                if (o == null) continue;
                this.modelLinhas.addElement(o);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.dispose();
        } else if (o == this.buttonAdicionar) {
            if (this.textLinha.getText().trim().length() > 0) {
                boolean podeAdicionar = true;
                for (int i = 0; i < this.modelLinhas.getSize(); ++i) {
                    if (!((ObjetoLinhaFixa)this.modelLinhas.get(i)).getTitulo().equalsIgnoreCase(this.textLinha.getText().trim())) continue;
                    podeAdicionar = false;
                    break;
                }
                if (podeAdicionar) {
                    this.modelLinhas.addElement(new ObjetoLinhaFixa(this.textLinha.getText().trim()));
                }
                this.textLinha.setText("");
                this.textLinha.grabFocus();
            }
        } else if (o == this.buttonDefinir) {
            if (this.listLinhas.getSelectedIndex() > -1) {
                ObjetoLinhaFixa ol = (ObjetoLinhaFixa)this.modelLinhas.get(this.listLinhas.getSelectedIndex());
                ol.setCor(this.comboCor.getCorSelecionada());
                ol.setTipoLinha((TipoLinha)((Object)this.comboTipoLinha.getSelectedItem()));
                ol.setTipoPonto((TipoPonto)((Object)this.comboPonto.getSelectedItem()));
                ol.limparValores();
                for (String s : this.textValores.getText().split("\n")) {
                    ol.adicionarValor(s);
                }
            }
            this.textValores.setText("");
            this.comboCor.setCorSelecionada(Color.BLACK);
        }
    }

    public List<String> getItens() {
        ArrayList<String> retorno = new ArrayList<String>();
        for (int i = 0; i < this.modelLinhas.getSize(); ++i) {
            ObjetoLinhaFixa of = (ObjetoLinhaFixa)this.modelLinhas.get(i);
            retorno.add(of.getXML());
        }
        return retorno;
    }

    public boolean ok() {
        return this.ok;
    }

    private void iniciar() {
        JPanel panel = ComponenteFactory.novoJPanel(new FlowLayout(2, 3, 3), BorderFactory.createEtchedBorder());
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "South");
        panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.textLinha.setPreferredSize(new Dimension(247, 20));
        this.buttonAdicionar.setPreferredSize(new Dimension(100, 20));
        this.listLinhas.setPreferredSize(new Dimension(100, 50));
        JScrollPane scrollTitulos = new JScrollPane(this.listLinhas);
        scrollTitulos.setPreferredSize(new Dimension(160, 220));
        panel.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 1, 1, new JLabel("T\u00edtulo:"), this.textLinha, this.buttonAdicionar), "North");
        JPanel jPanel = panel;
        panel = ComponenteFactory.novoJPanel(null, new TitledBorder("Propriedades da linha"));
        jPanel.add((Component)ComponenteFactory.novoJPanelBorderLayout(panel, null, null, null, scrollTitulos), "Center");
        panel.setLayout(null);
        JLabel labelCor = new JLabel("Cor da linha:");
        labelCor.setBounds(5, 20, 80, 20);
        this.comboCor.setBounds(85, 20, 142, 20);
        JLabel labelTipoLinha = new JLabel("Tipo:");
        labelTipoLinha.setBounds(5, 41, 80, 20);
        this.comboTipoLinha.setBounds(85, 41, 142, 20);
        JLabel labelPonto = new JLabel("Ponto:");
        labelPonto.setBounds(5, 62, 80, 20);
        this.comboPonto.setBounds(85, 62, 142, 20);
        this.comboCor.setCorSelecionada(Color.BLACK);
        this.listLinhas.setCellRenderer(new RenderListLinhas());
        JPanel p2 = new JPanel();
        p2.setLayout(null);
        p2.setBorder(new TitledBorder("Pontos"));
        p2.setBounds(3, 83, 226, 100);
        JScrollPane sp = new JScrollPane(this.textRotulos);
        sp.setBounds(4, 16, 108, 80);
        p2.add(sp);
        JScrollPane sp2 = new JScrollPane(this.textValores);
        sp2.setBounds(115, 16, 108, 80);
        p2.add(sp2);
        this.buttonDefinir.setBounds(103, 190, 125, 22);
        panel.add(labelCor);
        panel.add(this.comboCor);
        panel.add(labelTipoLinha);
        panel.add(this.comboTipoLinha);
        panel.add(labelPonto);
        panel.add(this.comboPonto);
        panel.add(p2);
        panel.add(this.buttonDefinir);
        this.textRotulos.setEditable(false);
        this.textValores.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str.equals(".")) {
                    super.insertString(offset, ",", attr);
                } else {
                    super.insertString(offset, str, attr);
                }
            }
        });
        this.listLinhas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DialogoLinhasFixas.this.modelLinhas.getSize() > 0 && DialogoLinhasFixas.this.listLinhas.getSelectedIndex() > -1 && DialogoLinhasFixas.this.modelLinhas.get(DialogoLinhasFixas.this.listLinhas.getSelectedIndex()) != null) {
                    DialogoLinhasFixas.this.textValores.setText("");
                    ObjetoLinhaFixa o = (ObjetoLinhaFixa)DialogoLinhasFixas.this.modelLinhas.get(DialogoLinhasFixas.this.listLinhas.getSelectedIndex());
                    DialogoLinhasFixas.this.comboCor.setCorSelecionada(o.getCor());
                    DialogoLinhasFixas.this.comboTipoLinha.setSelectedItem((Object)o.getTipoLinha());
                    DialogoLinhasFixas.this.comboPonto.setSelectedItem((Object)o.getTipoPonto());
                    for (String s : o.getValores()) {
                        DialogoLinhasFixas.this.textValores.append(DialogoLinhasFixas.this.textValores.getText().trim().length() > 0 ? "\n" + s : s);
                    }
                }
            }
        });
        this.listLinhas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && DialogoLinhasFixas.this.listLinhas.getSelectedIndex() > -1) {
                    DialogoLinhasFixas.this.modelLinhas.remove(DialogoLinhasFixas.this.listLinhas.getSelectedIndex());
                    if (DialogoLinhasFixas.this.modelLinhas.getSize() > 0) {
                        DialogoLinhasFixas.this.listLinhas.setSelectedIndex(0);
                    }
                }
            }
        });
        this.textValores.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String s;
                String[] texto;
                boolean todosNumeros = false;
                String[] stringArray = texto = DialogoLinhasFixas.this.textValores.getText().split("\n");
                int n = stringArray.length;
                for (int i = 0; i < n && (todosNumeros = (s = stringArray[i]).matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")); ++i) {
                }
                DialogoLinhasFixas.this.buttonDefinir.setEnabled(todosNumeros && DialogoLinhasFixas.this.textRotulos.getLineCount() == DialogoLinhasFixas.this.textValores.getLineCount());
            }
        });
        this.pack();
        this.setSize(400, this.getPreferredSize().height);
        ScreenUtil.centralizar(this);
    }

    public void setRotulos(List<String> rotulos) {
        for (String xml : rotulos) {
            String titulo = StringUtil.getValor(xml, "titulo");
            if (titulo.trim().length() <= 0) continue;
            if (this.textRotulos.getText().length() > 0) {
                this.textRotulos.append("\n" + titulo);
                continue;
            }
            this.textRotulos.append(titulo);
        }
    }
}

