/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class DialogoItens
extends JDialog
implements ActionListener,
DisposeListener {
    private JTextArea areaItens = new JTextArea();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2, 3, 3));
    private JButton buttonOk = new JButton("Ok");
    private JButton buttonCancelar = new JButton("Cancelar");
    private boolean ok = false;

    public static DialogoItens novaInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new DialogoItens((Frame)pai, titulo);
        }
        if (pai instanceof Dialog) {
            return new DialogoItens((Dialog)pai, titulo);
        }
        return null;
    }

    public DialogoItens(Frame pai, String titulo) {
        super(pai, titulo, true);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public DialogoItens(Dialog pai, String titulo) {
        super(pai, titulo, true);
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public boolean ok() {
        return this.ok;
    }

    public String[] getItens() {
        return StringUtil.separarLinhas(this.areaItens.getText());
    }

    public void setItens(String[] itens) {
        if (itens != null) {
            this.areaItens.setText(StringUtil.concatenarLinhas(itens));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.dispose();
        }
    }

    private void iniciar() {
        this.setSize(new Dimension(300, 200));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.areaItens), "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.panelBotoes.setBorder(BorderFactory.createEtchedBorder());
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
    }
}

