/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.configurador.AtributosHachuradoQuadrante;
import jalis.util.CorComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DialogoHachuradoQuadrante
extends JDialog
implements ActionListener {
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private CorComboBox combo = new CorComboBox();
    private JTextField textPosicaoXInicial = new JTextField();
    private JTextField textPosicaoXFinal = new JTextField();
    private JTextField textPosicaoYInicial = new JTextField();
    private JTextField textPosicaoYFinal = new JTextField();
    private boolean ok = false;

    public static DialogoHachuradoQuadrante novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new DialogoHachuradoQuadrante((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new DialogoHachuradoQuadrante((Frame)pai);
        }
        return null;
    }

    public DialogoHachuradoQuadrante(Dialog pai) {
        super(pai, "Hachurado quadrante", true);
        this.iniciar(pai);
    }

    public DialogoHachuradoQuadrante(Frame pai) {
        super(pai, "Hachurado quadrante", true);
        this.iniciar(pai);
    }

    private void iniciar(Container pai) {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(250, 130));
        this.setLocationRelativeTo(pai);
        this.buttonOK.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.textPosicaoXInicial.setHorizontalAlignment(4);
        this.textPosicaoYInicial.setHorizontalAlignment(4);
        this.textPosicaoXFinal.setHorizontalAlignment(4);
        this.textPosicaoYFinal.setHorizontalAlignment(4);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        JPanel panelTopo = new JPanel(new GridBagLayout());
        panelTopo.add((Component)new JLabel("X inicial:"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelTopo.add((Component)this.textPosicaoXInicial, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        panelTopo.add((Component)new JLabel("   X final:"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelTopo.add((Component)this.textPosicaoXFinal, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        panelTopo.add((Component)new JLabel("Y inicial:"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelTopo.add((Component)this.textPosicaoYInicial, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        panelTopo.add((Component)new JLabel("   Y final:"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelTopo.add((Component)this.textPosicaoYFinal, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        panelTopo.add((Component)new JLabel("Cor:"), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 1.0;
        panelTopo.add((Component)this.combo, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonOK);
        panelBotoes.add(this.buttonCancelar);
        this.add((Component)panelTopo, "Center");
        this.add((Component)panelBotoes, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.ok = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCancelar) {
            this.setVisible(false);
        }
    }

    public void setValor(AtributosHachuradoQuadrante valor) {
        this.combo.setCorSelecionada(valor.getCor());
        this.textPosicaoXInicial.setText(String.valueOf(valor.getPosicaoXInicial()));
        this.textPosicaoXFinal.setText(String.valueOf(valor.getPosicaoXFinal()));
        this.textPosicaoYInicial.setText(String.valueOf(valor.getPosicaoYInicial()));
        this.textPosicaoYFinal.setText(String.valueOf(valor.getPosicaoYFinal()));
    }

    public AtributosHachuradoQuadrante getValor() {
        AtributosHachuradoQuadrante retorno = new AtributosHachuradoQuadrante();
        retorno.setCor(this.combo.getCorSelecionada());
        if (this.textPosicaoXInicial.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            retorno.setPosicaoXInicial(Double.parseDouble(this.textPosicaoXInicial.getText()));
        } else {
            retorno.setPosicaoXInicial(0.0);
        }
        if (this.textPosicaoXFinal.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            retorno.setPosicaoXFinal(Double.parseDouble(this.textPosicaoXFinal.getText()));
        } else {
            retorno.setPosicaoXFinal(0.0);
        }
        if (this.textPosicaoYInicial.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            retorno.setPosicaoYInicial(Double.parseDouble(this.textPosicaoYInicial.getText()));
        } else {
            retorno.setPosicaoYInicial(0.0);
        }
        if (this.textPosicaoYFinal.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            retorno.setPosicaoYFinal(Double.parseDouble(this.textPosicaoYFinal.getText()));
        } else {
            retorno.setPosicaoYFinal(0.0);
        }
        return retorno;
    }

    public boolean getOK() {
        return this.ok;
    }
}

