/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.propriedade.ModeloEditorHistorico;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class DialogoEditorHistorico
extends JDialog
implements ActionListener,
DisposeListener {
    public static final int COLUNA_CODIGO = 70;
    ModeloEditorHistorico modEsq = new ModeloEditorHistorico();
    ModeloEditorHistorico modDir = new ModeloEditorHistorico();
    JTable tableEsq = new JTable(this.modEsq);
    JTable tableDir = new JTable(this.modDir);
    JScrollPane scrollEsq = new JScrollPane(this.tableEsq);
    JScrollPane scrollDir = new JScrollPane(this.tableDir);
    JPanel panelArea = new JPanel(new BorderLayout());
    JPanel panelCentral = new JPanel(new FlowLayout(1));
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonParaDir = new JButton(">");
    JButton buttonParaEsq = new JButton("<");
    JButton buttonTudoParaDir = new JButton(">>");
    JButton buttonTudoParaEsq = new JButton("<<");
    JButton buttonOk = new JButton("Ok");
    JButton buttonCancelar = new JButton("Cancelar");
    private boolean ok = false;

    public static DialogoEditorHistorico novaInstancia(Object pai, String titulo, boolean modal) {
        if (pai instanceof Frame) {
            return new DialogoEditorHistorico((Frame)pai, titulo, modal);
        }
        return new DialogoEditorHistorico((Dialog)pai, titulo, modal);
    }

    public DialogoEditorHistorico(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        try {
            this.jbInit();
            this.setLocationRelativeTo(pai);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(pai, e.getMessage(), e.getStackTrace(), "EditorHistorico: 142");
        }
    }

    public DialogoEditorHistorico(Dialog pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        try {
            this.jbInit();
            this.setLocationRelativeTo(pai);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(pai, e.getMessage(), e.getStackTrace(), "EditorHistorico: 159");
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public void setHistoricos(Map<String, String> historicos, List<String> selecionados) {
        this.modEsq.limpar();
        this.modDir.limpar();
        this.modEsq.adicionarHistoricos(historicos);
        this.modDir.adicionarHistoricos(this.modEsq.removerHistoricos(selecionados));
    }

    public List<String> getHistoricosSelecionados() {
        return this.modDir.getCodigoHistoricos();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonParaDir) {
            this.modDir.adicionarHistoricos(this.modEsq.removerHistoricos(this.tableEsq.getSelectedRows()));
        } else if (o == this.buttonParaEsq) {
            this.modEsq.adicionarHistoricos(this.modDir.removerHistoricos(this.tableDir.getSelectedRows()));
        } else if (o == this.buttonTudoParaDir) {
            this.modDir.adicionarHistoricos(this.modEsq.removerHistoricos());
        } else if (o == this.buttonTudoParaEsq) {
            this.modEsq.adicionarHistoricos(this.modDir.removerHistoricos());
        } else if (o == this.buttonOk || o == this.buttonCancelar) {
            if (o == this.buttonOk) {
                this.ok = true;
            }
            this.dispose();
        }
        this.modDir.fireTableDataChanged();
        this.modEsq.fireTableDataChanged();
    }

    private void jbInit() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelArea, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.panelArea.add((Component)this.scrollEsq, "West");
        this.panelArea.add((Component)this.scrollDir, "East");
        this.panelArea.add((Component)this.panelCentral, "Center");
        this.panelBotoes.setBorder(BorderFactory.createEtchedBorder());
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.scrollEsq.setPreferredSize(new Dimension(310, 10));
        this.scrollDir.setPreferredSize(new Dimension(310, 10));
        this.panelCentral.add(this.buttonParaDir);
        this.panelCentral.add(this.buttonParaEsq);
        this.panelCentral.add(this.buttonTudoParaDir);
        this.panelCentral.add(this.buttonTudoParaEsq);
        this.buttonParaDir.addActionListener(this);
        this.buttonParaDir.setPreferredSize(new Dimension(60, 40));
        this.buttonParaEsq.addActionListener(this);
        this.buttonParaEsq.setPreferredSize(new Dimension(60, 40));
        this.buttonTudoParaDir.addActionListener(this);
        this.buttonTudoParaDir.setPreferredSize(new Dimension(60, 40));
        this.buttonTudoParaEsq.addActionListener(this);
        this.buttonTudoParaEsq.setPreferredSize(new Dimension(60, 40));
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.tableEsq.getTableHeader().setReorderingAllowed(false);
        this.tableEsq.getTableHeader().addMouseListener(this.modEsq);
        this.tableDir.getTableHeader().setReorderingAllowed(false);
        this.tableDir.getTableHeader().addMouseListener(this.modDir);
        this.setSize(new Dimension(700, 400));
        this.setResizable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Funcoes.setTamanhoColunas(DialogoEditorHistorico.this.tableEsq.getColumnModel(), new int[]{70, DialogoEditorHistorico.this.tableEsq.getWidth() - 70});
                Funcoes.setTamanhoColunas(DialogoEditorHistorico.this.tableDir.getColumnModel(), new int[]{70, DialogoEditorHistorico.this.tableDir.getWidth() - 70});
            }
        });
    }
}

