/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.propriedade;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class DialogoDecimais
extends JDialog
implements ActionListener {
    private JTextField edit = new JTextField();
    private JButton buttonAdicionar = new JButton("Adicionar");
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private boolean ok = false;

    public static DialogoDecimais novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoDecimais((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoDecimais((Dialog)pai);
        }
        return null;
    }

    public DialogoDecimais(Frame pai) {
        super(pai, "Decimais", true);
        this.iniciar(pai);
    }

    public DialogoDecimais(Dialog pai) {
        super(pai, "Decimais", true);
        this.iniciar(pai);
    }

    private void iniciar(Container pai) {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(200, 300));
        this.setLocationRelativeTo(pai);
        this.edit.setHorizontalAlignment(4);
        JPanel panelTopo = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        panelTopo.add((Component)this.edit, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        panelTopo.add((Component)this.buttonAdicionar, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonOK);
        panelBotoes.add(this.buttonCancelar);
        this.add((Component)panelTopo, "North");
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add((Component)panelBotoes, "South");
        this.buttonOK.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonAdicionar.addActionListener(this);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && DialogoDecimais.this.list.getSelectedIndex() > -1) {
                    DialogoDecimais.this.model.remove(DialogoDecimais.this.list.getSelectedIndex());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.ok = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCancelar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonAdicionar) {
            if (this.edit.getText().matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
                this.model.addElement(this.edit.getText().replaceAll("[.]", ","));
            }
            this.edit.setText("");
            this.edit.grabFocus();
        }
    }

    public void setValores(ArrayList<String> valores) {
        this.model.clear();
        if (valores != null) {
            for (String s : valores) {
                this.model.addElement(s);
            }
        }
    }

    public ArrayList<String> getValores() {
        ArrayList<String> retorno = new ArrayList<String>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            retorno.add(this.model.get(i).toString());
        }
        return retorno;
    }

    public boolean getOK() {
        return this.ok;
    }
}

