/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.pagina;

import jalis.laboratorio.configurador.pagina.LinhaGuia;
import jalis.laboratorio.configurador.pagina.Margem;
import jalis.laboratorio.configurador.pagina.Pagina;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;

public class Regua
extends JComponent
implements Margem,
MouseListener,
MouseMotionListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int MARGEM_EXTERNA = 15;
    public static final int ESPACO_MINIMO = 10;
    public static final Cursor CURSOR_HORIZ = new Cursor(11);
    public static final Cursor CURSOR_VERTI = new Cursor(8);
    public static final Cursor CURSOR_DEFAULT = new Cursor(0);
    public static final int PONTOS_POR_CENTIMETRO = 28;
    public static final BasicStroke SOLIDO = new BasicStroke();
    public static final BasicStroke TRACEJADO = new BasicStroke(1.0f, 0, 0, 4.5f, new float[]{4.5f}, 0.0f);
    private int EXPESSURA = 25;
    private int INFERIOR = 0;
    private int SUPERIOR = 1;
    private int margemAlterada;
    private int comprimento;
    private int orientacao;
    private int margemInferior;
    private int margemSuperior;
    private int xOffset;
    private int yOffset;
    private int margemInfOffset;
    private int margemSupOffset;
    private boolean redimensionando;
    private boolean redimensionavel;
    private Pagina pagina;
    private ArrayList<LinhaGuia> linhasGuias;
    private boolean exibirLinhasGuias = true;

    public Regua(int orientacao, Pagina pagina) {
        this.orientacao = orientacao;
        this.comprimento = 0;
        this.pagina = pagina;
        this.margemAlterada = 0;
        this.margemSuperior = 0;
        this.margemInferior = 0;
        this.margemInfOffset = 0;
        this.margemSupOffset = 0;
        this.xOffset = 0;
        this.yOffset = 0;
        this.redimensionando = false;
        this.redimensionavel = true;
        this.linhasGuias = new ArrayList();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setRedimensionavel(boolean redimensionavel) {
        this.redimensionavel = redimensionavel;
    }

    public void setComprimento(int comprimento) {
        this.comprimento = comprimento;
        if (this.orientacao == 0) {
            this.setPreferredSize(new Dimension(comprimento + 30, this.EXPESSURA));
        } else {
            this.setPreferredSize(new Dimension(this.EXPESSURA, comprimento + 30));
        }
        this.revalidate();
        this.repaint();
    }

    public void setComprimento(double comprimento) {
        this.setComprimento((int)(28.0 * comprimento));
    }

    public void setExibirLinhasGuias(boolean mostrar) {
        this.exibirLinhasGuias = mostrar;
    }

    @Override
    public void setMargem(int margem, int pos) {
        switch (pos) {
            case 2: {
                this.margemSuperior = margem;
                break;
            }
            case 3: {
                this.margemInferior = margem;
            }
        }
        this.repaint();
    }

    @Override
    public void setMargem(double margem, int pos) {
        this.setMargem((int)(28.0 * margem), pos);
    }

    @Override
    public int getMargem(int pos) {
        switch (pos) {
            case 2: {
                return this.margemSuperior;
            }
            case 3: {
                return this.margemInferior;
            }
        }
        return 0;
    }

    @Override
    public double getMargemCentimetros(int pos) {
        switch (pos) {
            case 2: {
                return this.margemSuperior / 28;
            }
            case 3: {
                return this.margemInferior / 28;
            }
        }
        return 0.0;
    }

    public void adicionarLinhaGuia(LinhaGuia linha) {
        if (linha != null && !this.linhasGuias.contains(linha)) {
            this.linhasGuias.add(linha);
        }
    }

    public void removerLinhaGuia(LinhaGuia linha) {
        this.linhasGuias.remove(linha);
        if (linha.horizontal()) {
            this.repaint(0, linha.getPosicao(), this.getWidth(), 1);
        } else {
            this.repaint(linha.getPosicao(), 0, 1, this.getHeight());
        }
    }

    @Override
    public void paint(Graphics g) {
        Rectangle area = g.getClipBounds();
        g.setColor(Color.lightGray);
        g.fillRect(area.x, area.y, area.width, area.height);
        this.desenharRegua(g);
        this.escreverNumeros(g);
        if (this.exibirLinhasGuias) {
            this.desenharLinhasGuias(g);
        }
    }

    private void desenharRegua(Graphics g) {
        int diferenca = this.margemInferior + this.margemSuperior;
        g.setColor(Color.white);
        if (this.orientacao == 0) {
            g.fillRect(15 + this.margemInferior, 5, this.comprimento - diferenca, 15);
        } else {
            g.fillRect(5, 15 + this.margemSuperior, 15, this.comprimento - diferenca);
        }
        g.setColor(Color.gray);
        if (this.orientacao == 0) {
            g.drawRect(15, 5, this.margemInferior, 15);
            g.drawRect(15 + this.comprimento - this.margemSuperior, 5, this.margemSuperior, 15);
        } else {
            g.drawRect(5, 15, 15, this.margemSuperior);
            g.drawRect(5, 15 + this.comprimento - this.margemInferior, 15, this.margemInferior);
        }
    }

    private void escreverNumeros(Graphics g) {
        block15: {
            int contador;
            int numero;
            double umQuarto;
            block14: {
                umQuarto = 7.0;
                numero = 0;
                contador = 0;
                g.setFont(new Font("SansSerif", 0, 9));
                g.setColor(Color.black);
                if (this.orientacao != 0) break block14;
                block12: for (double i = 15.0; i < (double)(15 + this.comprimento); i += umQuarto) {
                    switch (contador) {
                        case 0: {
                            g.drawString(Integer.toString(numero), numero < 10 ? (int)i - 3 : (int)i - 6, 16);
                            ++contador;
                            ++numero;
                            continue block12;
                        }
                        case 1: {
                            g.drawLine((int)i - 1, 12, (int)i, 12);
                            ++contador;
                            continue block12;
                        }
                        case 2: {
                            g.drawLine((int)i, 10, (int)i, 14);
                            ++contador;
                            continue block12;
                        }
                        case 3: {
                            g.drawLine((int)i - 1, 12, (int)i, 12);
                            contador = 0;
                        }
                    }
                }
                break block15;
            }
            if (this.orientacao != 1) break block15;
            block13: for (double i = 15.0; i < (double)(15 + this.comprimento); i += umQuarto) {
                switch (contador) {
                    case 0: {
                        g.drawString(Integer.toString(numero), numero < 10 ? 10 : 7, (int)i + 4);
                        ++contador;
                        ++numero;
                        continue block13;
                    }
                    case 1: {
                        g.drawLine(12, (int)i - 1, 12, (int)i);
                        ++contador;
                        continue block13;
                    }
                    case 2: {
                        g.drawLine(10, (int)i, 14, (int)i);
                        ++contador;
                        continue block13;
                    }
                    case 3: {
                        g.drawLine(12, (int)i - 1, 12, (int)i);
                        contador = 0;
                    }
                }
            }
        }
    }

    private void desenharLinhasGuias(Graphics g) {
        Rectangle area = g.getClipBounds();
        for (LinhaGuia linha : this.linhasGuias) {
            g.setColor(linha.getCor());
            if (linha.getPosicao() <= 15) continue;
            if (this.orientacao == 0) {
                g.drawLine(linha.getPosicao(), area.y, linha.getPosicao(), area.y + area.height);
                continue;
            }
            g.drawLine(area.x, linha.getPosicao(), area.x + area.width, linha.getPosicao());
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.redimensionavel) {
            if (this.orientacao == 0) {
                int limiteInf = 15 + this.margemInferior;
                int limiteSup = 15 + this.comprimento - this.margemSuperior;
                int x = me.getX();
                if (x >= limiteInf - 1 && x <= limiteInf + 1) {
                    this.setCursor(CURSOR_HORIZ);
                    this.margemAlterada = this.INFERIOR;
                } else if (x >= limiteSup - 1 && x <= limiteSup + 1) {
                    this.setCursor(CURSOR_HORIZ);
                    this.margemAlterada = this.SUPERIOR;
                } else {
                    this.setCursor(CURSOR_DEFAULT);
                }
            } else {
                int limiteInf = 15 + this.comprimento - this.margemInferior;
                int limiteSup = 15 + this.margemSuperior;
                int y = me.getY();
                if (y >= limiteInf - 1 && y <= limiteInf + 1) {
                    this.setCursor(CURSOR_VERTI);
                    this.margemAlterada = this.INFERIOR;
                } else if (y >= limiteSup - 1 && y <= limiteSup + 1) {
                    this.setCursor(CURSOR_VERTI);
                    this.margemAlterada = this.SUPERIOR;
                } else {
                    this.setCursor(CURSOR_DEFAULT);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.getCursor() == CURSOR_HORIZ || this.getCursor() == CURSOR_VERTI) {
            this.redimensionando = true;
            this.xOffset = me.getX();
            this.yOffset = me.getY();
            this.margemInfOffset = this.margemInferior;
            this.margemSupOffset = this.margemSuperior;
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.redimensionando) {
            int espacoHoriz = this.pagina.getLarguraOcupada();
            int espacoVerti = this.pagina.getAlturaOcupada();
            if (this.orientacao == 0) {
                if (this.margemAlterada == this.INFERIOR) {
                    int margem = this.margemInfOffset + me.getX() - this.xOffset;
                    if (this.comprimento - this.margemSuperior - margem < espacoHoriz) {
                        margem = this.comprimento - this.margemSuperior - espacoHoriz;
                    } else if (margem < 0) {
                        margem = 0;
                    }
                    this.setMargem(margem, 3);
                    this.pagina.setMargem(margem, 0);
                } else {
                    int margem = this.margemSupOffset - me.getX() + this.xOffset;
                    if (this.comprimento - this.margemInferior - margem < espacoHoriz) {
                        margem = this.comprimento - this.margemInferior - espacoHoriz;
                    } else if (margem < 0) {
                        margem = 0;
                    }
                    this.setMargem(margem, 2);
                    this.pagina.setMargem(margem, 1);
                }
            } else if (this.margemAlterada == this.INFERIOR) {
                int margem = this.margemInfOffset - me.getY() + this.yOffset;
                if (this.comprimento - this.margemSuperior - margem < espacoVerti) {
                    margem = this.comprimento - this.margemSuperior - espacoVerti;
                } else if (margem < 0) {
                    margem = 0;
                }
                this.setMargem(margem, 3);
                this.pagina.setMargem(margem, 3);
            } else {
                int margem = this.margemSupOffset + me.getY() - this.yOffset;
                if (this.comprimento - this.margemInferior - margem < espacoVerti) {
                    margem = this.comprimento - this.margemInferior - espacoVerti;
                } else if (margem < 0) {
                    margem = 0;
                }
                this.setMargem(margem, 2);
                this.pagina.setMargem(margem, 2);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.redimensionando = false;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }
}

