/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.pagina;

import jalis.laboratorio.configurador.pagina.DimensoesAssinaturaDigitalDTO;
import jalis.laboratorio.impressao.CampoAssinaturaLaudo;
import jalis.util.StringUtil;
import java.awt.Font;
import java.io.Serializable;

public class ParametrosAssinatura
implements Serializable {
    public static final int INTERNO = 0;
    public static final int EXTERNO = 1;
    private static final String TAG_IMPRIMIR_ASSINATURA_ELETRONICA = "imprime_assinatura_eletronica";
    private static final String TAG_MARGEM_ASSINATURA_DIGITAL = "margem_assinatura_eletronica";
    private static final String TAG_LARGURA_ASSINATURA_DIGITAL = "largura_assinatura_eletronica";
    private static final String TAG_ALTURA_IMAGEM_ASSINATURA_DIGITAL = "altura_imagem_assinatura_eletronica";
    private static final String TAG_LARGURA_IMAGEM_ASSINATURA_DIGITAL = "largura_imagem_assinatura_eletronica";
    private static final String TAG_ESTENDER_IMAGEM_ASSINATURA_DIGITAL = "estender_imagem_assinatura_eletronica";
    private boolean exibir = false;
    private CampoAssinaturaLaudo campoBanco = CampoAssinaturaLaudo.USUARIO_CONFERENCIA;
    private CampoAssinaturaLaudo assinaturaEletronica = CampoAssinaturaLaudo.USUARIO_CONFERENCIA;
    private int quantidade = 5;
    private int alinhamento = 4;
    private int altura = 75;
    private int posicao = 3;
    private int tipo = 0;
    private int posicaoAbsoluto = 0;
    private boolean exibirReferencia = false;
    private boolean isImprimirAssinaturaEletronica = false;
    private float margemAssinaturaDigital = 0.0f;
    private transient DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital;

    private ParametrosAssinatura() {
    }

    private ParametrosAssinatura(String atributos) {
        if (atributos != null && atributos.length() > 0) {
            boolean imprimeAssinaturaEletronica;
            this.exibir = StringUtil.getBoolean(atributos, "exibir");
            this.exibirReferencia = StringUtil.getBoolean(atributos, "exibirReferencia");
            for (CampoAssinaturaLaudo campo : CampoAssinaturaLaudo.values()) {
                if (!campo.getIdParaXML().equalsIgnoreCase(StringUtil.getValor(atributos, "campoBanco"))) continue;
                this.campoBanco = campo;
                break;
            }
            for (CampoAssinaturaLaudo campo : CampoAssinaturaLaudo.values()) {
                if (!campo.getIdParaXML().equalsIgnoreCase(StringUtil.getValor(atributos, "assinatura"))) continue;
                this.assinaturaEletronica = campo;
                break;
            }
            this.quantidade = StringUtil.getInt(atributos, "quantidade");
            this.alinhamento = StringUtil.getInt(atributos, "alinhamento");
            this.altura = StringUtil.getInt(atributos, "altura");
            this.posicao = StringUtil.getInt(atributos, "posicao");
            this.tipo = StringUtil.getInt(atributos, "tipo");
            this.posicaoAbsoluto = StringUtil.getInt(atributos, "absoluto");
            this.isImprimirAssinaturaEletronica = imprimeAssinaturaEletronica = StringUtil.getBoolean(atributos, TAG_IMPRIMIR_ASSINATURA_ELETRONICA);
            this.margemAssinaturaDigital = StringUtil.getFloat(atributos, TAG_MARGEM_ASSINATURA_DIGITAL);
            int larguraAssDigital = StringUtil.getInt(atributos, TAG_LARGURA_ASSINATURA_DIGITAL);
            int alturaImagemAssDigital = StringUtil.getInt(atributos, TAG_ALTURA_IMAGEM_ASSINATURA_DIGITAL);
            int larguraImagemAssDigital = StringUtil.getInt(atributos, TAG_LARGURA_IMAGEM_ASSINATURA_DIGITAL);
            boolean estenderImagemAssDigital = StringUtil.getBoolean(atributos, TAG_ESTENDER_IMAGEM_ASSINATURA_DIGITAL);
            Font fonte = StringUtil.getFonte(StringUtil.getValor(atributos, "fonte"));
            this.dimensoesAssinaturaDigital = new DimensoesAssinaturaDigitalDTO.Builder().alturaImagem(alturaImagemAssDigital).estenderImagem(estenderImagemAssDigital).fonte(fonte).larguraAssinatura(larguraAssDigital).larguraImagem(larguraImagemAssDigital).build();
        }
    }

    public static ParametrosAssinatura novaInstancia(String atr) {
        return new ParametrosAssinatura(atr);
    }

    public static ParametrosAssinatura novaInstanciaLimpa() {
        return new ParametrosAssinatura();
    }

    public String getAtributos() {
        StringBuilder bui = new StringBuilder(StringUtil.getTag("exibir", String.valueOf(this.exibir)));
        bui.append(StringUtil.getTag("exibirReferencia", String.valueOf(this.exibirReferencia)));
        bui.append(StringUtil.getTag("campoBanco", this.campoBanco == null ? "" : this.campoBanco.getIdParaXML()));
        bui.append(StringUtil.getTag("assinatura", this.assinaturaEletronica == null ? "" : this.assinaturaEletronica.getIdParaXML()));
        bui.append(StringUtil.getTag("quantidade", String.valueOf(this.quantidade)));
        bui.append(StringUtil.getTag("alinhamento", String.valueOf(this.alinhamento)));
        bui.append(StringUtil.getTag("altura", String.valueOf(this.altura)));
        bui.append(StringUtil.getTag("posicao", String.valueOf(this.posicao)));
        bui.append(StringUtil.getTag("tipo", String.valueOf(this.tipo)));
        bui.append(StringUtil.getTag("absoluto", String.valueOf(this.posicaoAbsoluto)));
        bui.append(StringUtil.getTag(TAG_IMPRIMIR_ASSINATURA_ELETRONICA, String.valueOf(this.isImprimirAssinaturaEletronica)));
        bui.append(StringUtil.getTag(TAG_MARGEM_ASSINATURA_DIGITAL, String.valueOf(this.margemAssinaturaDigital)));
        bui.append(StringUtil.getTag(TAG_LARGURA_ASSINATURA_DIGITAL, this.isImprimirAssinaturaEletronica ? String.valueOf(this.dimensoesAssinaturaDigital.getLarguraAssinatura()) : "0"));
        bui.append(StringUtil.getTag(TAG_ALTURA_IMAGEM_ASSINATURA_DIGITAL, this.isImprimirAssinaturaEletronica ? String.valueOf(this.dimensoesAssinaturaDigital.getAlturaImagem()) : "0"));
        bui.append(StringUtil.getTag(TAG_LARGURA_IMAGEM_ASSINATURA_DIGITAL, this.isImprimirAssinaturaEletronica ? String.valueOf(this.dimensoesAssinaturaDigital.getLarguraImagem()) : "0"));
        bui.append(StringUtil.getTag(TAG_ESTENDER_IMAGEM_ASSINATURA_DIGITAL, this.isImprimirAssinaturaEletronica ? String.valueOf(this.dimensoesAssinaturaDigital.isEstenderImagem()) : "false"));
        if (this.isImprimirAssinaturaEletronica) {
            bui.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.dimensoesAssinaturaDigital.getFonte())));
        }
        return bui.toString();
    }

    public void setMargemAssinaturaDigital(float margemAssinaturaDigital) {
        this.margemAssinaturaDigital = margemAssinaturaDigital;
    }

    public float getMargemAssinaturaDigital() {
        return this.margemAssinaturaDigital;
    }

    public void setImprimirAssinaturaEletronica(boolean imprimirAssinaturaEletronica) {
        this.isImprimirAssinaturaEletronica = imprimirAssinaturaEletronica;
    }

    public boolean isImprimirAssinaturaEletronica() {
        return this.isImprimirAssinaturaEletronica;
    }

    public boolean exibir() {
        return this.exibir;
    }

    public void setExibir(boolean exibir) {
        this.exibir = exibir;
    }

    public boolean exibirReferencia() {
        return this.exibirReferencia;
    }

    public void setExibirReferencia(boolean b) {
        this.exibirReferencia = b;
    }

    public CampoAssinaturaLaudo getCampoBanco() {
        return this.campoBanco;
    }

    public void setCampoBanco(CampoAssinaturaLaudo campo) {
        this.campoBanco = campo;
    }

    public int getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(int quantidade) {
        this.quantidade = quantidade;
    }

    public int getAlinhamento() {
        return this.alinhamento;
    }

    public void setAlinhamento(int alinhamento) {
        this.alinhamento = alinhamento;
    }

    public int getAltura() {
        return this.altura;
    }

    public void setAltura(int altura) {
        this.altura = altura;
    }

    public int getPosicao() {
        return this.posicao;
    }

    public void setPosicao(int posicao) {
        this.posicao = posicao;
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    public int getPosicaoAbsoluto() {
        return this.posicaoAbsoluto;
    }

    public void setPosicaoAbsoluto(int absoluto) {
        this.posicaoAbsoluto = absoluto;
    }

    public void setAssinaturaEletronica(CampoAssinaturaLaudo assinatura) {
        this.assinaturaEletronica = assinatura;
    }

    public CampoAssinaturaLaudo getAssinaturaEletronica() {
        return this.assinaturaEletronica;
    }

    public DimensoesAssinaturaDigitalDTO getDimensoesAssinaturaDigital() {
        return this.dimensoesAssinaturaDigital;
    }

    public void setDimensoesAssinaturaDigital(DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital) {
        this.dimensoesAssinaturaDigital = dimensoesAssinaturaDigital;
    }
}

