/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.pagina;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.pagina.AcaoPaginasListener;
import jalis.laboratorio.configurador.pagina.DialogoInserirNovaPagina;
import jalis.util.Funcoes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelControlePagina
extends JPanel {
    private static final String TEXTO_PAGINA_ANTERIOR = "\u25c4 ";
    private static final String TEXTO_PAGINA_PROXIMO = " \u25ba";
    private static final String TEXTO_NOVA_PAGINA = " +";
    private static final String TEXTO_REMOVER_PAGINA = "\u2212 ";
    private Map<Integer, List<Componente>> paginas;
    private int contador = 1;
    private int totalPaginas = 1;
    private JLabel labelPaginas = new JLabel();
    private boolean resultadoCampo;
    private ArrayList<AcaoPaginasListener> listener = new ArrayList();
    private JLabel adicionar;
    private JLabel remover;

    public PanelControlePagina() {
        super(new GridBagLayout());
        this.iniciar();
        this.atualizarLabelPaginas();
    }

    public void setPaginas(Map<Integer, List<Componente>> paginas) {
        this.paginas = paginas;
    }

    private void iniciar() {
        this.setPreferredSize(new Dimension(150, 15));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 1, 0, 1);
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)new JPanel(), c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.add(this.novoJLabelComCursor(TEXTO_PAGINA_ANTERIOR, this.getAcaoAnterior()));
        ++c.gridx;
        this.remover = this.novoJLabelComCursor(TEXTO_REMOVER_PAGINA, this.getAcaoRemover());
        this.add(this.remover);
        ++c.gridx;
        this.add((Component)this.labelPaginas, c);
        ++c.gridx;
        this.adicionar = this.novoJLabelComCursor(TEXTO_NOVA_PAGINA, this.getAcaoAdicionar());
        this.add(this.adicionar);
        ++c.gridx;
        this.add(this.novoJLabelComCursor(TEXTO_PAGINA_PROXIMO, this.getAcaoProximo()));
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)new JPanel(), c);
    }

    private JLabel novoJLabelComCursor(String texto, final Action acao) {
        JLabel label = new JLabel(texto);
        label.setCursor(Cursor.getPredefinedCursor(12));
        if (acao != null) {
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    acao.actionPerformed(null);
                }
            });
        }
        return label;
    }

    private void atualizarLabelPaginas() {
        this.labelPaginas.setText("P\u00e1gina " + String.valueOf(this.contador) + " de " + String.valueOf(this.totalPaginas));
    }

    private Action getAcaoProximo() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (++PanelControlePagina.this.contador > PanelControlePagina.this.totalPaginas) {
                    PanelControlePagina.this.contador = PanelControlePagina.this.totalPaginas;
                }
                PanelControlePagina.this.atualizarLabelPaginas();
                PanelControlePagina.this.fireProximaPagina();
            }
        };
    }

    private Action getAcaoAnterior() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (--PanelControlePagina.this.contador < 1) {
                    PanelControlePagina.this.contador = 1;
                }
                PanelControlePagina.this.atualizarLabelPaginas();
                PanelControlePagina.this.firePaginaAnterior();
            }
        };
    }

    private Action getAcaoRemover() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window comp = this.castToWindow(PanelControlePagina.this.getParent());
                if (0 == Funcoes.showPerguntaSimNao(comp, "Excluir P\u00e1gina", "Deseja realmente fazer a exclus\u00e3o da P\u00e1gina atual do Laudo?")) {
                    int paginaRemovida = PanelControlePagina.this.contador;
                    PanelControlePagina.this.firePaginaRemovida(paginaRemovida);
                    if (--PanelControlePagina.this.totalPaginas < 1) {
                        PanelControlePagina.this.totalPaginas = 1;
                    }
                    if (--PanelControlePagina.this.contador < 1) {
                        PanelControlePagina.this.contador = 1;
                    }
                    PanelControlePagina.this.atualizarLabelPaginas();
                }
            }

            private Window castToWindow(Container parent) {
                Window comp = null;
                if (parent instanceof Frame) {
                    comp = (Frame)parent;
                } else if (parent instanceof Dialog) {
                    comp = (Dialog)parent;
                } else if (parent instanceof JPanel && ((JPanel)parent).getTopLevelAncestor() != null) {
                    comp = null;
                    if (((JPanel)parent).getTopLevelAncestor() instanceof Frame) {
                        comp = (Frame)((JPanel)parent).getTopLevelAncestor();
                    } else if (((JPanel)parent).getTopLevelAncestor() instanceof Dialog) {
                        comp = (Dialog)((JPanel)parent).getTopLevelAncestor();
                    }
                }
                return comp;
            }
        };
    }

    private Action getAcaoAdicionar() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoInserirNovaPagina inserirNovaPaginaModelo = DialogoInserirNovaPagina.novaInstancia(PanelControlePagina.this.getTopLevelAncestor());
                inserirNovaPaginaModelo.setVisible(true);
                if (inserirNovaPaginaModelo.getOK()) {
                    PanelControlePagina.this.totalPaginas++;
                    int paginaAnterior = PanelControlePagina.this.contador;
                    switch (inserirNovaPaginaModelo.getNovoTipoPosicao()) {
                        case 1: {
                            PanelControlePagina.this.contador++;
                            break;
                        }
                        case 2: {
                            PanelControlePagina.this.contador = PanelControlePagina.this.totalPaginas;
                        }
                    }
                    PanelControlePagina.this.atualizarLabelPaginas();
                    PanelControlePagina.this.fireNovaPaginaAdicionada(paginaAnterior);
                }
            }
        };
    }

    private void fireProximaPagina() {
        for (AcaoPaginasListener l : this.listener) {
            l.proximaPagina();
        }
    }

    private void firePaginaAnterior() {
        for (AcaoPaginasListener l : this.listener) {
            l.paginaAnterior();
        }
    }

    private void fireNovaPaginaAdicionada(int paginaAnterior) {
        for (AcaoPaginasListener l : this.listener) {
            l.paginaAdicionada(paginaAnterior, this.contador);
        }
    }

    private void firePaginaRemovida(int paginaRemovida) {
        for (AcaoPaginasListener l : this.listener) {
            l.paginaRemovida(paginaRemovida, this.contador);
        }
    }

    public void addAcaoPaginasListener(AcaoPaginasListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void removeAcaoPaginasListener(AcaoPaginasListener l) {
        if (this.listener.contains(l)) {
            this.listener.remove(l);
        }
    }

    public int getPaginaAtual() {
        return this.contador;
    }

    public void setTotalPaginas(int totalPaginas) {
        this.totalPaginas = totalPaginas;
        this.atualizarLabelPaginas();
    }

    public int getTotalPaginas() {
        return this.totalPaginas;
    }

    public void setPermitirPaginacao(boolean resultadoCampo) {
        if (resultadoCampo) {
            this.adicionar.setVisible(false);
            this.remover.setVisible(false);
        }
    }
}

